
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_details` text COLLATE utf8mb4_unicode_ci,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=339 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-01-29 13:54:00','2025-01-29 13:54:00'),(2,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-29 13:55:02','2025-01-29 13:55:02'),(3,'default','added',20,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":45}}','2025-01-29 14:36:17','2025-01-29 14:36:17'),(4,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-01-29 14:49:09','2025-01-29 14:49:09'),(5,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-29 15:31:22','2025-01-29 15:31:22'),(6,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-30 02:05:34','2025-01-30 02:05:34'),(7,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-01-30 02:05:49','2025-01-30 02:05:49'),(8,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-30 06:46:09','2025-01-30 06:46:09'),(9,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-30 10:50:53','2025-01-30 10:50:53'),(10,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-30 11:25:08','2025-01-30 11:25:08'),(11,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-01-30 11:25:19','2025-01-30 11:25:19'),(12,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-31 07:18:33','2025-01-31 07:18:33'),(13,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-31 08:28:48','2025-01-31 08:28:48'),(14,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-31 18:07:06','2025-01-31 18:07:06'),(15,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 02:57:27','2025-02-01 02:57:27'),(16,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 05:11:46','2025-02-01 05:11:46'),(17,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 05:12:13','2025-02-01 05:12:13'),(18,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 05:28:25','2025-02-01 05:28:25'),(19,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 09:42:39','2025-02-01 09:42:39'),(20,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 12:32:18','2025-02-01 12:32:18'),(21,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 20:59:12','2025-02-01 20:59:12'),(22,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-02 00:10:37','2025-02-02 00:10:37'),(23,'default','added',1505,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}','2025-02-02 01:30:55','2025-02-02 01:30:55'),(24,'default','edited',1505,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"33.0000\"}}','2025-02-02 01:31:44','2025-02-02 01:31:44'),(25,'default','added',1506,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}','2025-02-02 02:39:03','2025-02-02 02:39:03'),(26,'default','added',1507,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}','2025-02-02 02:39:42','2025-02-02 02:39:42'),(27,'default','added',1508,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2025-02-02 02:45:21','2025-02-02 02:45:21'),(28,'default','added',1509,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}','2025-02-02 02:46:58','2025-02-02 02:46:58'),(29,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-02 02:47:47','2025-02-02 02:47:47'),(30,'default','added',1510,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":242}}','2025-02-02 02:50:40','2025-02-02 02:50:40'),(31,'default','added',1511,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":339}}','2025-02-02 02:50:42','2025-02-02 02:50:42'),(32,'default','added',1512,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":181}}','2025-02-02 02:52:46','2025-02-02 02:52:46'),(33,'default','added',1513,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88}}','2025-02-02 02:54:36','2025-02-02 02:54:36'),(34,'default','added',1514,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":274}}','2025-02-02 02:56:03','2025-02-02 02:56:03'),(35,'default','added',1515,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2025-02-02 03:00:18','2025-02-02 03:00:18'),(36,'default','added',1516,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":993}}','2025-02-02 03:03:42','2025-02-02 03:03:42'),(37,'default','added',1518,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1610}}','2025-02-02 03:08:33','2025-02-02 03:08:33'),(38,'default','added',1519,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":692}}','2025-02-02 03:09:21','2025-02-02 03:09:21'),(39,'default','added',1520,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":564}}','2025-02-02 03:14:29','2025-02-02 03:14:29'),(40,'default','added',1521,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}','2025-02-02 03:16:09','2025-02-02 03:16:09'),(41,'default','added',1522,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}','2025-02-02 03:17:26','2025-02-02 03:17:26'),(42,'default','added',1523,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1245}}','2025-02-02 03:19:56','2025-02-02 03:19:56'),(43,'default','added',1524,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":196}}','2025-02-02 03:20:50','2025-02-02 03:20:50'),(44,'default','added',1525,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2025-02-02 03:21:59','2025-02-02 03:21:59'),(45,'default','added',1526,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1531}}','2025-02-02 03:23:29','2025-02-02 03:23:29'),(46,'default','added',1527,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":334}}','2025-02-02 03:23:54','2025-02-02 03:23:54'),(47,'default','added',1528,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":306}}','2025-02-02 03:24:16','2025-02-02 03:24:16'),(48,'default','added',1529,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}','2025-02-02 03:24:42','2025-02-02 03:24:42'),(49,'default','added',1530,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":765}}','2025-02-02 03:28:19','2025-02-02 03:28:19'),(50,'default','added',1531,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":646}}','2025-02-02 03:28:22','2025-02-02 03:28:22'),(51,'default','added',1532,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":543}}','2025-02-02 03:29:46','2025-02-02 03:29:46'),(52,'default','added',1533,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":161}}','2025-02-02 03:30:53','2025-02-02 03:30:53'),(53,'default','added',1534,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}','2025-02-02 03:31:21','2025-02-02 03:31:21'),(54,'default','added',1535,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":457}}','2025-02-02 03:32:06','2025-02-02 03:32:06'),(55,'default','added',1536,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":329}}','2025-02-02 03:32:31','2025-02-02 03:32:31'),(56,'default','added',1538,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}','2025-02-02 03:34:48','2025-02-02 03:34:48'),(57,'default','added',1539,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":421}}','2025-02-02 03:35:58','2025-02-02 03:35:58'),(58,'default','added',1540,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1070}}','2025-02-02 03:36:32','2025-02-02 03:36:32'),(59,'default','added',1541,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":363}}','2025-02-02 03:38:10','2025-02-02 03:38:10'),(60,'default','added',1542,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":485}}','2025-02-02 03:40:58','2025-02-02 03:40:58'),(61,'default','added',1543,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":392}}','2025-02-02 03:43:24','2025-02-02 03:43:24'),(62,'default','added',1544,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":681}}','2025-02-02 03:45:25','2025-02-02 03:45:25'),(63,'default','added',1546,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1884}}','2025-02-02 03:47:22','2025-02-02 03:47:22'),(64,'default','added',1547,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":873}}','2025-02-02 03:49:18','2025-02-02 03:49:18'),(65,'default','added',1548,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2068}}','2025-02-02 03:55:21','2025-02-02 03:55:21'),(66,'default','added',1549,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2298}}','2025-02-02 03:55:23','2025-02-02 03:55:23'),(67,'default','added',1550,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":654}}','2025-02-02 03:57:25','2025-02-02 03:57:25'),(68,'default','added',1551,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":178}}','2025-02-02 03:59:12','2025-02-02 03:59:12'),(69,'default','added',1552,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1880}}','2025-02-02 04:00:46','2025-02-02 04:00:46'),(70,'default','added',1553,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1139}}','2025-02-02 04:01:22','2025-02-02 04:01:22'),(71,'default','added',1554,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":147}}','2025-02-02 04:03:57','2025-02-02 04:03:57'),(72,'default','added',1555,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":657}}','2025-02-02 04:06:19','2025-02-02 04:06:19'),(73,'default','added',1556,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1596}}','2025-02-02 04:06:56','2025-02-02 04:06:56'),(74,'default','added',1557,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47}}','2025-02-02 04:08:44','2025-02-02 04:08:44'),(75,'default','added',1560,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":167}}','2025-02-02 04:11:51','2025-02-02 04:11:51'),(76,'default','added',1561,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2025-02-02 04:12:57','2025-02-02 04:12:57'),(77,'default','added',1562,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":884}}','2025-02-02 04:21:43','2025-02-02 04:21:43'),(78,'default','added',1563,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":694}}','2025-02-02 04:23:43','2025-02-02 04:23:43'),(79,'default','added',1564,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":245}}','2025-02-02 04:24:33','2025-02-02 04:24:33'),(80,'default','added',1568,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2169}}','2025-02-02 04:27:27','2025-02-02 04:27:27'),(81,'default','added',1570,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1349}}','2025-02-02 04:28:47','2025-02-02 04:28:47'),(82,'default','added',1571,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":85}}','2025-02-02 04:29:40','2025-02-02 04:29:40'),(83,'default','added',1572,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2610}}','2025-02-02 04:31:06','2025-02-02 04:31:06'),(84,'default','added',1573,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":558}}','2025-02-02 04:31:44','2025-02-02 04:31:44'),(85,'default','added',1575,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1549}}','2025-02-02 04:33:27','2025-02-02 04:33:27'),(86,'default','added',1576,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":892}}','2025-02-02 04:40:02','2025-02-02 04:40:02'),(87,'default','added',1577,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":591}}','2025-02-02 04:41:06','2025-02-02 04:41:06'),(88,'default','added',1580,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":468}}','2025-02-02 04:43:03','2025-02-02 04:43:03'),(89,'default','added',1581,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1188}}','2025-02-02 04:44:12','2025-02-02 04:44:12'),(90,'default','added',1582,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":528}}','2025-02-02 04:45:23','2025-02-02 04:45:23'),(91,'default','added',1583,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":371}}','2025-02-02 04:45:27','2025-02-02 04:45:27'),(92,'default','added',1586,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1880}}','2025-02-02 04:47:05','2025-02-02 04:47:05'),(93,'default','added',1587,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}','2025-02-02 04:48:14','2025-02-02 04:48:14'),(94,'default','added',1588,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1104}}','2025-02-02 04:48:16','2025-02-02 04:48:16'),(95,'default','added',1589,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":777}}','2025-02-02 04:51:21','2025-02-02 04:51:21'),(96,'default','added',1591,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":340}}','2025-02-02 04:54:06','2025-02-02 04:54:06'),(97,'default','added',1592,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":533}}','2025-02-02 04:54:24','2025-02-02 04:54:24'),(98,'default','added',1593,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":298}}','2025-02-02 04:55:17','2025-02-02 04:55:17'),(99,'default','added',1595,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}','2025-02-02 04:57:16','2025-02-02 04:57:16'),(100,'default','added',1598,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1782}}','2025-02-02 05:00:24','2025-02-02 05:00:24'),(101,'default','added',1599,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":458}}','2025-02-02 05:00:30','2025-02-02 05:00:30'),(102,'default','added',1601,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}','2025-02-02 05:04:03','2025-02-02 05:04:03'),(103,'default','added',1602,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":199}}','2025-02-02 05:06:41','2025-02-02 05:06:41'),(104,'default','added',1603,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}','2025-02-02 05:07:17','2025-02-02 05:07:17'),(105,'default','added',1604,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88}}','2025-02-02 05:08:14','2025-02-02 05:08:14'),(106,'default','added',1605,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":218}}','2025-02-02 05:08:15','2025-02-02 05:08:15'),(107,'default','added',1606,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":216}}','2025-02-02 05:10:05','2025-02-02 05:10:05'),(108,'default','added',1608,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":369}}','2025-02-02 05:10:29','2025-02-02 05:10:29'),(109,'default','added',1609,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":345}}','2025-02-02 05:10:41','2025-02-02 05:10:41'),(110,'default','added',1610,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":74}}','2025-02-02 05:13:16','2025-02-02 05:13:16'),(111,'default','added',1612,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":194}}','2025-02-02 05:17:08','2025-02-02 05:17:08'),(112,'default','added',1613,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}','2025-02-02 05:18:48','2025-02-02 05:18:48'),(113,'default','added',1614,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49}}','2025-02-02 05:25:21','2025-02-02 05:25:21'),(114,'default','added',1615,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}','2025-02-02 05:27:38','2025-02-02 05:27:38'),(115,'default','added',1616,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}','2025-02-02 05:32:25','2025-02-02 05:32:25'),(116,'default','added',1617,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":294}}','2025-02-02 05:36:33','2025-02-02 05:36:33'),(117,'default','added',1618,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}','2025-02-02 05:43:32','2025-02-02 05:43:32'),(118,'default','added',1620,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1011}}','2025-02-02 05:44:33','2025-02-02 05:44:33'),(119,'default','added',1621,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1028}}','2025-02-02 05:46:07','2025-02-02 05:46:07'),(120,'default','added',1622,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53}}','2025-02-02 05:48:31','2025-02-02 05:48:31'),(121,'default','edited',1622,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":58},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"53.0000\"}}','2025-02-02 05:49:24','2025-02-02 05:49:24'),(122,'default','added',1623,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4}}','2025-02-02 05:55:49','2025-02-02 05:55:49'),(123,'default','sell_deleted',1623,'App\\Transaction',1,1,'App\\User','{\"id\":1623,\"invoice_no\":\"0097\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4.0000\"}}','2025-02-02 05:56:03','2025-02-02 05:56:03'),(124,'default','added',1624,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1470}}','2025-02-02 06:02:39','2025-02-02 06:02:39'),(125,'default','sell_deleted',1624,'App\\Transaction',1,1,'App\\User','{\"id\":1624,\"invoice_no\":\"0098\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1470.0000\"}}','2025-02-02 06:04:20','2025-02-02 06:04:20'),(126,'default','added',1626,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1268}}','2025-02-02 06:05:24','2025-02-02 06:05:24'),(127,'default','added',1627,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":275}}','2025-02-02 06:06:12','2025-02-02 06:06:12'),(128,'default','added',1628,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}','2025-02-02 06:08:35','2025-02-02 06:08:35'),(129,'default','added',1629,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":445}}','2025-02-02 06:08:46','2025-02-02 06:08:46'),(130,'default','added',1630,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":65}}','2025-02-02 06:09:02','2025-02-02 06:09:02'),(131,'default','edited',1630,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":668},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"65.0000\"}}','2025-02-02 06:16:14','2025-02-02 06:16:14'),(132,'default','edited',1630,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"668.0000\"}}','2025-02-02 06:19:26','2025-02-02 06:19:26'),(133,'default','added',1631,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}','2025-02-02 06:21:03','2025-02-02 06:21:03'),(134,'default','added',1632,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":205}}','2025-02-02 06:26:14','2025-02-02 06:26:14'),(135,'default','edited',1631,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":945},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"180.0000\"}}','2025-02-02 06:27:54','2025-02-02 06:27:54'),(136,'default','added',1633,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":145}}','2025-02-02 06:30:51','2025-02-02 06:30:51'),(137,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-02 06:31:14','2025-02-02 06:31:14'),(138,'default','added',1634,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":245}}','2025-02-02 06:33:16','2025-02-02 06:33:16'),(139,'default','added',1636,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":619}}','2025-02-02 06:40:08','2025-02-02 06:40:08'),(140,'default','added',1637,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":115}}','2025-02-02 06:41:24','2025-02-02 06:41:24'),(141,'default','added',1638,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}','2025-02-02 06:41:37','2025-02-02 06:41:37'),(142,'default','added',1639,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":287}}','2025-02-02 06:44:12','2025-02-02 06:44:12'),(143,'default','added',1640,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":806}}','2025-02-02 06:46:12','2025-02-02 06:46:12'),(144,'default','added',1641,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":204}}','2025-02-02 06:47:23','2025-02-02 06:47:23'),(145,'default','added',1642,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1107}}','2025-02-02 06:52:21','2025-02-02 06:52:21'),(146,'default','added',1643,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":476}}','2025-02-02 06:52:44','2025-02-02 06:52:44'),(147,'default','added',1644,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2025-02-02 06:58:55','2025-02-02 06:58:55'),(148,'default','added',1645,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2025-02-02 06:59:23','2025-02-02 06:59:23'),(149,'default','sell_deleted',1645,'App\\Transaction',1,1,'App\\User','{\"id\":1645,\"invoice_no\":\"0116\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}','2025-02-02 06:59:36','2025-02-02 06:59:36'),(150,'default','added',1646,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":894}}','2025-02-02 07:04:48','2025-02-02 07:04:48'),(151,'default','added',1647,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":78}}','2025-02-02 07:05:42','2025-02-02 07:05:42'),(152,'default','added',1648,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1848}}','2025-02-02 07:11:54','2025-02-02 07:11:54'),(153,'default','added',1649,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":262}}','2025-02-02 07:14:32','2025-02-02 07:14:32'),(154,'default','added',1650,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2025-02-02 07:16:22','2025-02-02 07:16:22'),(155,'default','added',1651,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":547}}','2025-02-02 07:18:18','2025-02-02 07:18:18'),(156,'default','added',1652,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":247}}','2025-02-02 07:21:13','2025-02-02 07:21:13'),(157,'default','added',1653,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3645}}','2025-02-02 07:23:03','2025-02-02 07:23:03'),(158,'default','edited',1653,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1075},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3645.0000\"}}','2025-02-02 07:25:30','2025-02-02 07:25:30'),(159,'default','added',1654,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}','2025-02-02 07:27:48','2025-02-02 07:27:48'),(160,'default','added',1655,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":551}}','2025-02-02 07:45:53','2025-02-02 07:45:53'),(161,'default','added',1656,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":454}}','2025-02-02 07:50:10','2025-02-02 07:50:10'),(162,'default','added',1657,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2025-02-02 07:52:08','2025-02-02 07:52:08'),(163,'default','added',1658,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}','2025-02-02 07:53:29','2025-02-02 07:53:29'),(164,'default','added',1659,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":512}}','2025-02-02 07:54:33','2025-02-02 07:54:33'),(165,'default','added',1662,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370}}','2025-02-02 08:06:41','2025-02-02 08:06:41'),(166,'default','added',1663,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}','2025-02-02 08:09:57','2025-02-02 08:09:57'),(167,'default','sell_deleted',1663,'App\\Transaction',1,1,'App\\User','{\"id\":1663,\"invoice_no\":\"0132\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"28.0000\"}}','2025-02-02 08:10:21','2025-02-02 08:10:21'),(168,'default','added',1664,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}','2025-02-02 08:10:55','2025-02-02 08:10:55'),(169,'default','added',1665,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":411}}','2025-02-02 08:18:28','2025-02-02 08:18:28'),(170,'default','added',1666,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1330}}','2025-02-02 08:22:25','2025-02-02 08:22:25'),(171,'default','added',1667,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":402}}','2025-02-02 08:25:30','2025-02-02 08:25:30'),(172,'default','added',1668,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}','2025-02-02 08:27:13','2025-02-02 08:27:13'),(173,'default','edited',1667,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"402.0000\"}}','2025-02-02 08:27:47','2025-02-02 08:27:47'),(174,'default','added',1669,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1490}}','2025-02-02 08:34:37','2025-02-02 08:34:37'),(175,'default','added',1670,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}','2025-02-02 08:39:53','2025-02-02 08:39:53'),(176,'default','added',1671,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}','2025-02-02 08:46:59','2025-02-02 08:46:59'),(177,'default','added',1672,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2025-02-02 08:48:46','2025-02-02 08:48:46'),(178,'default','sell_deleted',1671,'App\\Transaction',1,1,'App\\User','{\"id\":1671,\"invoice_no\":\"0140\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"56.0000\"}}','2025-02-02 08:50:49','2025-02-02 08:50:49'),(179,'default','added',1673,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":81}}','2025-02-02 08:51:21','2025-02-02 08:51:21'),(180,'default','added',1675,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":498}}','2025-02-02 09:05:42','2025-02-02 09:05:42'),(181,'default','added',1676,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2025-02-02 09:09:09','2025-02-02 09:09:09'),(182,'default','added',1677,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":288}}','2025-02-02 09:10:53','2025-02-02 09:10:53'),(183,'default','added',1678,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31}}','2025-02-02 09:13:13','2025-02-02 09:13:13'),(184,'default','sell_deleted',1677,'App\\Transaction',1,1,'App\\User','{\"id\":1677,\"invoice_no\":\"0145\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"288.0000\"}}','2025-02-02 09:14:33','2025-02-02 09:14:33'),(185,'default','added',1679,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":540}}','2025-02-02 09:19:28','2025-02-02 09:19:28'),(186,'default','added',1680,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":86}}','2025-02-02 09:21:58','2025-02-02 09:21:58'),(187,'default','added',1681,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}','2025-02-02 09:24:54','2025-02-02 09:24:54'),(188,'default','added',1683,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":346}}','2025-02-02 09:27:06','2025-02-02 09:27:06'),(189,'default','added',1684,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":101}}','2025-02-02 09:28:09','2025-02-02 09:28:09'),(190,'default','added',1685,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":127}}','2025-02-02 09:29:28','2025-02-02 09:29:28'),(191,'default','added',1687,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":409}}','2025-02-02 09:39:32','2025-02-02 09:39:32'),(192,'default','added',1691,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":439}}','2025-02-02 09:58:02','2025-02-02 09:58:02'),(193,'default','added',1692,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}','2025-02-02 09:58:33','2025-02-02 09:58:33'),(194,'default','added',1693,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2025-02-02 10:17:30','2025-02-02 10:17:30'),(195,'default','added',1694,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2025-02-02 10:19:53','2025-02-02 10:19:53'),(196,'default','added',2,'App\\Contact',1,1,'App\\User','[]','2025-02-02 10:28:53','2025-02-02 10:28:53'),(197,'default','added',1695,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":281}}','2025-02-02 10:34:21','2025-02-02 10:34:21'),(198,'default','added',1696,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}','2025-02-02 10:38:53','2025-02-02 10:38:53'),(199,'default','added',1697,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2025-02-02 10:47:18','2025-02-02 10:47:18'),(200,'default','added',1699,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}','2025-02-02 10:53:11','2025-02-02 10:53:11'),(201,'default','added',1701,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2025-02-02 10:54:09','2025-02-02 10:54:09'),(202,'default','added',1702,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":385}}','2025-02-02 10:59:13','2025-02-02 10:59:13'),(203,'default','added',1703,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1317}}','2025-02-02 11:01:13','2025-02-02 11:01:13'),(204,'default','added',1704,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":402}}','2025-02-02 11:01:15','2025-02-02 11:01:15'),(205,'default','edited',1704,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":402},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"402.0000\"}}','2025-02-02 11:07:11','2025-02-02 11:07:11'),(206,'default','added',1705,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":117}}','2025-02-02 11:07:58','2025-02-02 11:07:58'),(207,'default','added',1707,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":870}}','2025-02-02 11:28:15','2025-02-02 11:28:15'),(208,'default','added',3,'App\\Contact',1,1,'App\\User','[]','2025-02-02 11:34:56','2025-02-02 11:34:56'),(209,'default','added',1709,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":354}}','2025-02-02 11:36:01','2025-02-02 11:36:01'),(210,'default','added',1710,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}','2025-02-02 11:37:07','2025-02-02 11:37:07'),(211,'default','added',1711,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}','2025-02-02 11:37:28','2025-02-02 11:37:28'),(212,'default','added',1713,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1189}}','2025-02-02 11:55:48','2025-02-02 11:55:48'),(213,'default','added',1714,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":380}}','2025-02-02 12:06:07','2025-02-02 12:06:07'),(214,'default','added',1715,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}','2025-02-02 12:17:28','2025-02-02 12:17:28'),(215,'default','added',1716,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1707}}','2025-02-02 12:22:42','2025-02-02 12:22:42'),(216,'default','added',1717,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}','2025-02-02 12:24:07','2025-02-02 12:24:07'),(217,'default','added',1718,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":135}}','2025-02-02 12:25:07','2025-02-02 12:25:07'),(218,'default','added',1719,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97}}','2025-02-02 12:25:15','2025-02-02 12:25:15'),(219,'default','added',1720,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":129}}','2025-02-02 12:33:45','2025-02-02 12:33:45'),(220,'default','added',1721,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2025-02-02 12:36:13','2025-02-02 12:36:13'),(221,'default','added',1723,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}','2025-02-02 12:39:49','2025-02-02 12:39:49'),(222,'default','added',1726,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":84}}','2025-02-02 12:42:17','2025-02-02 12:42:17'),(223,'default','added',1728,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":184}}','2025-02-02 12:43:06','2025-02-02 12:43:06'),(224,'default','added',1729,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1270}}','2025-02-02 12:48:25','2025-02-02 12:48:25'),(225,'default','added',1730,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1220}}','2025-02-02 12:49:26','2025-02-02 12:49:26'),(226,'default','added',1731,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}','2025-02-02 12:49:55','2025-02-02 12:49:55'),(227,'default','added',1732,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":573}}','2025-02-02 12:51:47','2025-02-02 12:51:47'),(228,'default','added',1733,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1323}}','2025-02-02 12:55:25','2025-02-02 12:55:25'),(229,'default','added',1734,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":369}}','2025-02-02 13:01:15','2025-02-02 13:01:15'),(230,'default','edited',1733,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2588},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1323.0000\"}}','2025-02-02 13:04:47','2025-02-02 13:04:47'),(231,'default','added',1735,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}','2025-02-02 13:05:11','2025-02-02 13:05:11'),(232,'default','added',1736,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":664}}','2025-02-02 13:06:45','2025-02-02 13:06:45'),(233,'default','added',1738,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":215}}','2025-02-02 13:07:58','2025-02-02 13:07:58'),(234,'default','added',1739,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2025-02-02 13:08:06','2025-02-02 13:08:06'),(235,'default','added',1740,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}','2025-02-02 13:09:21','2025-02-02 13:09:21'),(236,'default','added',1741,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":816}}','2025-02-02 13:14:12','2025-02-02 13:14:12'),(237,'default','added',1742,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1269}}','2025-02-02 13:14:21','2025-02-02 13:14:21'),(238,'default','added',1747,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}','2025-02-02 13:18:18','2025-02-02 13:18:18'),(239,'default','added',1749,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":348}}','2025-02-02 13:30:42','2025-02-02 13:30:42'),(240,'default','added',1750,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":281}}','2025-02-02 13:32:10','2025-02-02 13:32:10'),(241,'default','added',1751,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":294}}','2025-02-02 13:41:49','2025-02-02 13:41:49'),(242,'default','added',1752,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":58}}','2025-02-02 13:43:12','2025-02-02 13:43:12'),(243,'default','added',1753,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1358}}','2025-02-02 13:43:47','2025-02-02 13:43:47'),(244,'default','edited',1753,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1358},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1358.0000\"}}','2025-02-02 13:44:56','2025-02-02 13:44:56'),(245,'default','added',1754,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":409}}','2025-02-02 13:47:31','2025-02-02 13:47:31'),(246,'default','added',1755,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":215}}','2025-02-02 13:49:54','2025-02-02 13:49:54'),(247,'default','added',1756,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":441}}','2025-02-02 13:54:07','2025-02-02 13:54:07'),(248,'default','added',1757,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":998}}','2025-02-02 13:54:56','2025-02-02 13:54:56'),(249,'default','added',1758,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":67}}','2025-02-02 13:57:57','2025-02-02 13:57:57'),(250,'default','edited',1758,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":67},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"67.0000\"}}','2025-02-02 13:58:45','2025-02-02 13:58:45'),(251,'default','added',1759,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2025-02-02 14:00:39','2025-02-02 14:00:39'),(252,'default','added',1760,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":245}}','2025-02-02 14:03:14','2025-02-02 14:03:14'),(253,'default','added',1761,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1224}}','2025-02-02 14:16:09','2025-02-02 14:16:09'),(254,'default','added',1762,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":149}}','2025-02-02 14:19:18','2025-02-02 14:19:18'),(255,'default','added',1763,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":485}}','2025-02-02 14:22:04','2025-02-02 14:22:04'),(256,'default','added',1766,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2025-02-02 14:35:25','2025-02-02 14:35:25'),(257,'default','edited',1766,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":233},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"250.0000\"}}','2025-02-02 14:36:09','2025-02-02 14:36:09'),(258,'default','edited',1766,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"233.0000\"}}','2025-02-02 14:36:30','2025-02-02 14:36:30'),(259,'default','added',1767,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":334}}','2025-02-02 14:37:37','2025-02-02 14:37:37'),(260,'default','added',1769,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":222}}','2025-02-02 14:46:56','2025-02-02 14:46:56'),(261,'default','added',1770,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}','2025-02-02 14:48:22','2025-02-02 14:48:22'),(262,'default','added',1772,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":898}}','2025-02-02 14:51:16','2025-02-02 14:51:16'),(263,'default','added',1773,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}','2025-02-02 14:52:39','2025-02-02 14:52:39'),(264,'default','added',1774,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":355}}','2025-02-02 14:56:17','2025-02-02 14:56:17'),(265,'default','added',1775,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97}}','2025-02-02 15:04:11','2025-02-02 15:04:11'),(266,'default','added',1776,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}','2025-02-02 15:06:23','2025-02-02 15:06:23'),(267,'default','added',1777,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":205}}','2025-02-02 15:13:40','2025-02-02 15:13:40'),(268,'default','added',1778,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}','2025-02-02 15:22:45','2025-02-02 15:22:45'),(269,'default','added',1779,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":818}}','2025-02-02 15:33:57','2025-02-02 15:33:57'),(270,'default','added',1780,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}','2025-02-02 15:34:53','2025-02-02 15:34:53'),(271,'default','added',1781,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2263}}','2025-02-02 15:36:05','2025-02-02 15:36:05'),(272,'default','added',1782,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}','2025-02-02 15:38:05','2025-02-02 15:38:05'),(273,'default','added',1783,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":871}}','2025-02-02 15:44:20','2025-02-02 15:44:20'),(274,'default','added',1784,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":58}}','2025-02-02 15:51:31','2025-02-02 15:51:31'),(275,'default','added',1785,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":238}}','2025-02-02 15:54:30','2025-02-02 15:54:30'),(276,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-02 16:57:29','2025-02-02 16:57:29'),(277,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-02-02 17:31:03','2025-02-02 17:31:03'),(278,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-03 02:13:33','2025-02-03 02:13:33'),(279,'default','added',1786,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":344}}','2025-02-03 02:34:25','2025-02-03 02:34:25'),(280,'default','added',1787,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":843}}','2025-02-03 03:03:20','2025-02-03 03:03:20'),(281,'default','added',1788,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}','2025-02-03 03:05:10','2025-02-03 03:05:10'),(282,'default','edited',1787,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":976},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"843.0000\"}}','2025-02-03 03:05:52','2025-02-03 03:05:52'),(283,'default','added',1789,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":471}}','2025-02-03 03:08:44','2025-02-03 03:08:44'),(284,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-03 03:32:05','2025-02-03 03:32:05'),(285,'default','added',1790,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}','2025-02-03 03:45:10','2025-02-03 03:45:10'),(286,'default','added',1791,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":98}}','2025-02-03 03:52:50','2025-02-03 03:52:50'),(287,'default','added',1792,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":299}}','2025-02-03 03:56:54','2025-02-03 03:56:54'),(288,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-03 04:27:47','2025-02-03 04:27:47'),(289,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-02-03 04:28:00','2025-02-03 04:28:00'),(290,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-03 04:32:24','2025-02-03 04:32:24'),(291,'default','added',1793,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":213}}','2025-02-03 04:49:47','2025-02-03 04:49:47'),(292,'default','added',1794,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":1}}','2025-02-03 04:51:01','2025-02-03 04:51:01'),(293,'default','added',4,'App\\Contact',1,1,'App\\User','[]','2025-02-03 04:57:53','2025-02-03 04:57:53'),(294,'default','added',1795,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2760}}','2025-02-03 05:00:32','2025-02-03 05:00:32'),(295,'default','edited',1795,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5540},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"2760.0000\"}}','2025-02-03 05:04:10','2025-02-03 05:04:10'),(296,'default','edited',1795,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5560},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"5540.0000\"}}','2025-02-03 05:06:23','2025-02-03 05:06:23'),(297,'default','edited',1795,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5540},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"5560.0000\"}}','2025-02-03 05:07:01','2025-02-03 05:07:01'),(298,'default','payment_edited',1795,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"5540.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"5540.0000\"}}','2025-02-03 05:07:08','2025-02-03 05:07:08'),(299,'default','added',1796,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":625}}','2025-02-03 05:19:06','2025-02-03 05:19:06'),(300,'default','added',1797,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}','2025-02-03 05:45:13','2025-02-03 05:45:13'),(301,'default','added',5,'App\\Contact',1,1,'App\\User','[]','2025-02-03 05:46:34','2025-02-03 05:46:34'),(302,'default','added',1798,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":822}}','2025-02-03 05:56:11','2025-02-03 05:56:11'),(303,'default','added',1799,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}','2025-02-03 05:57:10','2025-02-03 05:57:10'),(304,'default','added',1801,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":432}}','2025-02-03 06:17:13','2025-02-03 06:17:13'),(305,'default','edited',1801,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":886},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"432.0000\"}}','2025-02-03 06:23:04','2025-02-03 06:23:04'),(306,'default','added',1804,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}','2025-02-03 06:57:19','2025-02-03 06:57:19'),(307,'default','sell_deleted',1804,'App\\Transaction',1,1,'App\\User','{\"id\":1804,\"invoice_no\":\"0243\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10.0000\"}}','2025-02-03 06:58:02','2025-02-03 06:58:02'),(308,'default','added',1816,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":272}}','2025-02-03 07:55:38','2025-02-03 07:55:38'),(309,'default','added',1821,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":642}}','2025-02-03 08:45:53','2025-02-03 08:45:53'),(310,'default','added',1822,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":253}}','2025-02-03 08:49:53','2025-02-03 08:49:53'),(311,'default','edited',1822,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":444},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"253.0000\"}}','2025-02-03 08:52:37','2025-02-03 08:52:37'),(312,'default','edited',1822,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":444},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"444.0000\"}}','2025-02-03 08:53:30','2025-02-03 08:53:30'),(313,'default','added',6,'App\\Contact',1,1,'App\\User','[]','2025-02-03 09:25:36','2025-02-03 09:25:36'),(314,'default','added',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":325}}','2025-02-03 09:36:31','2025-02-03 09:36:31'),(315,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":916},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"325.0000\"}}','2025-02-03 09:38:54','2025-02-03 09:38:54'),(316,'default','added',1824,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}','2025-02-03 09:42:06','2025-02-03 09:42:06'),(317,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1004},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"916.0000\"}}','2025-02-03 09:45:07','2025-02-03 09:45:07'),(318,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1213},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1004.0000\"}}','2025-02-03 09:47:54','2025-02-03 09:47:54'),(319,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1261},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1213.0000\"}}','2025-02-03 09:49:41','2025-02-03 09:49:41'),(320,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1365},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1261.0000\"}}','2025-02-03 09:51:18','2025-02-03 09:51:18'),(321,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1422},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1365.0000\"}}','2025-02-03 10:00:03','2025-02-03 10:00:03'),(322,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1602},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1422.0000\"}}','2025-02-03 10:06:48','2025-02-03 10:06:48'),(323,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1895},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1602.0000\"}}','2025-02-03 10:12:50','2025-02-03 10:12:50'),(324,'default','added',1828,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":603}}','2025-02-03 10:20:16','2025-02-03 10:20:16'),(325,'default','added',1829,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1880}}','2025-02-03 10:28:34','2025-02-03 10:28:34'),(326,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2611},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1895.0000\"}}','2025-02-03 10:35:25','2025-02-03 10:35:25'),(327,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3030},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"2611.0000\"}}','2025-02-03 10:39:06','2025-02-03 10:39:06'),(328,'default','edited',1823,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3368},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"3030.0000\"}}','2025-02-03 10:42:35','2025-02-03 10:42:35'),(329,'default','added',1830,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":431}}','2025-02-03 10:52:05','2025-02-03 10:52:05'),(330,'default','added',1831,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":235}}','2025-02-03 10:57:02','2025-02-03 10:57:02'),(331,'default','added',1832,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":123}}','2025-02-03 11:00:22','2025-02-03 11:00:22'),(332,'default','added',1833,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}','2025-02-03 11:00:35','2025-02-03 11:00:35'),(333,'default','added',1834,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}','2025-02-03 11:00:39','2025-02-03 11:00:39'),(334,'default','added',1836,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2025-02-03 11:50:47','2025-02-03 11:50:47'),(335,'default','added',1841,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2752}}','2025-02-03 12:14:20','2025-02-03 12:14:20'),(336,'default','edited',1841,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2758},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2752.0000\"}}','2025-02-03 12:15:13','2025-02-03 12:15:13'),(337,'default','edited',1841,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2818},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2758.0000\"}}','2025-02-03 12:17:59','2025-02-03 12:17:59'),(338,'default','added',1842,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":125}}','2025-02-03 12:18:38','2025-02-03 12:18:38');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 00:43:44','2017-12-18 00:43:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 00:34:39','2017-12-18 00:40:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 00:25:40','2017-12-18 00:25:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 00:28:40','2017-12-18 00:28:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10'),(7,'2 nd 2 Lable Print',NULL,1.9685,0.9448,3.9960,0.0000,0.0000,0.0000,0.0000,0.0000,2,0,1,28,1,'2022-11-23 11:09:36','2024-03-16 07:45:33'),(8,'2X3',NULL,1.3779,0.9800,4.3307,0.0000,0.0000,0.0000,0.0000,0.0000,3,1,1,28,1,'2024-03-16 07:45:28','2025-01-24 14:25:48');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'Sakthi Masala',NULL,1,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(2,1,'Cavinkare',NULL,1,NULL,'2025-02-01 11:15:55','2025-02-01 11:15:55'),(3,1,'RE',NULL,1,NULL,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(4,1,'Rev',NULL,1,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(5,1,'Aachi',NULL,1,NULL,'2025-02-01 17:29:25','2025-02-01 17:29:25'),(6,1,'Mr.Ground',NULL,1,NULL,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(7,1,'Anil',NULL,1,NULL,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(8,1,'Colgate',NULL,1,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(9,1,'Annam',NULL,1,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(10,1,'Britania',NULL,1,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(16,1,'S',NULL,1,NULL,'2025-02-01 19:19:08','2025-02-01 19:19:08'),(17,1,'HUL',NULL,1,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(18,1,'ITC',NULL,1,NULL,'2025-02-01 21:16:06','2025-02-01 21:16:06');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `weighing_scale_setting` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT '0',
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT '2',
  `quantity_precision` tinyint(4) NOT NULL DEFAULT '2',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text COLLATE utf8mb4_unicode_ci,
  `sms_settings` text COLLATE utf8mb4_unicode_ci,
  `custom_labels` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'SVM SMART HYPER MARKET',53,'2025-01-24',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00,1,'Asia/Kolkata',4,'lifo',0.00,'includes','1708173603_logo1 (1).png','202500',1,'add_manufacturing','stop_selling',7,1,0,NULL,1.000,180,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":\"1\",\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"hide_product_suggestion\":\"1\",\"show_pricing_on_product_sugesstion\":\"1\",\"cash_denominations\":\"500,200,100,50,20,10,5,2,1\",\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',0,0,0,1,1,0,1,0,0,0,1,1,NULL,1,1,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','d-m-Y','12',0,0,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}','blue-light',NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":\"G-PAY\",\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":\"Product Discount\",\"custom_field_2\":\"Size\",\"custom_field_3\":\"Design\",\"custom_field_4\":\"HSN CODE\"},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"enable_secondary_unit\":\"1\",\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2022-10-20 06:14:39','2025-02-03 12:05:57');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured_products` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `default_payment_accounts` text COLLATE utf8mb4_unicode_ci,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'0001','SVM SMART HYPER MARKET','NEAR TMB BANK, THARAMANGALAM MAIN ROAD, OMALUR','INDIA','TAMILNADU','SALEM','636455',1,1,1,0,1,'browser',NULL,'9566211543',NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"cheque\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,'2022-10-20 06:14:39','2025-01-24 13:45:39');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pay_method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=284 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,33.0000,'cash','credit','sell',1505,'2025-02-02 01:30:55','2025-02-02 01:30:55'),(2,1,60.0000,'cash','credit','sell',1506,'2025-02-02 02:39:03','2025-02-02 02:39:03'),(3,1,10.0000,'cash','credit','sell',1507,'2025-02-02 02:39:42','2025-02-02 02:39:42'),(4,1,75.0000,'cash','credit','sell',1508,'2025-02-02 02:45:21','2025-02-02 02:45:21'),(5,1,10.0000,'cash','credit','sell',1509,'2025-02-02 02:46:58','2025-02-02 02:46:58'),(6,1,242.0000,'cash','credit','sell',1510,'2025-02-02 02:50:40','2025-02-02 02:50:40'),(7,1,339.0000,'cash','credit','sell',1511,'2025-02-02 02:50:42','2025-02-02 02:50:42'),(8,1,181.0000,'cash','credit','sell',1512,'2025-02-02 02:52:46','2025-02-02 02:52:46'),(9,1,88.0000,'cash','credit','sell',1513,'2025-02-02 02:54:36','2025-02-02 02:54:36'),(10,1,274.0000,'cash','credit','sell',1514,'2025-02-02 02:56:03','2025-02-02 02:56:03'),(11,1,20.0000,'cash','credit','sell',1515,'2025-02-02 03:00:18','2025-02-02 03:00:18'),(12,1,993.0000,'cash','credit','sell',1516,'2025-02-02 03:03:42','2025-02-02 03:03:42'),(13,1,1610.0000,'cash','credit','sell',1518,'2025-02-02 03:08:32','2025-02-02 03:08:32'),(14,1,692.0000,'cash','credit','sell',1519,'2025-02-02 03:09:21','2025-02-02 03:09:21'),(15,1,564.0000,'cash','credit','sell',1520,'2025-02-02 03:14:29','2025-02-02 03:14:29'),(16,1,55.0000,'cash','credit','sell',1521,'2025-02-02 03:16:09','2025-02-02 03:16:09'),(17,1,55.0000,'cash','credit','sell',1522,'2025-02-02 03:17:26','2025-02-02 03:17:26'),(18,1,1245.0000,'cash','credit','sell',1523,'2025-02-02 03:19:56','2025-02-02 03:19:56'),(19,1,196.0000,'cash','credit','sell',1524,'2025-02-02 03:20:50','2025-02-02 03:20:50'),(20,1,150.0000,'cash','credit','sell',1525,'2025-02-02 03:21:59','2025-02-02 03:21:59'),(21,1,1531.0000,'cash','credit','sell',1526,'2025-02-02 03:23:29','2025-02-02 03:23:29'),(22,1,334.0000,'cash','credit','sell',1527,'2025-02-02 03:23:54','2025-02-02 03:23:54'),(23,1,306.0000,'cash','credit','sell',1528,'2025-02-02 03:24:16','2025-02-02 03:24:16'),(24,1,22.0000,'cash','credit','sell',1529,'2025-02-02 03:24:42','2025-02-02 03:24:42'),(25,1,765.0000,'cash','credit','sell',1530,'2025-02-02 03:28:19','2025-02-02 03:28:19'),(26,1,646.0000,'cash','credit','sell',1531,'2025-02-02 03:28:22','2025-02-02 03:28:22'),(27,1,543.0000,'cash','credit','sell',1532,'2025-02-02 03:29:46','2025-02-02 03:29:46'),(28,1,161.0000,'cash','credit','sell',1533,'2025-02-02 03:30:53','2025-02-02 03:30:53'),(29,1,240.0000,'cash','credit','sell',1534,'2025-02-02 03:31:21','2025-02-02 03:31:21'),(30,1,457.0000,'cash','credit','sell',1535,'2025-02-02 03:32:06','2025-02-02 03:32:06'),(31,1,329.0000,'cash','credit','sell',1536,'2025-02-02 03:32:31','2025-02-02 03:32:31'),(32,1,1480.0000,'cash','credit','sell',1538,'2025-02-02 03:34:48','2025-02-02 03:34:48'),(33,1,421.0000,'cash','credit','sell',1539,'2025-02-02 03:35:58','2025-02-02 03:35:58'),(34,1,1070.0000,'cash','credit','sell',1540,'2025-02-02 03:36:32','2025-02-02 03:36:32'),(35,1,363.0000,'cash','credit','sell',1541,'2025-02-02 03:38:10','2025-02-02 03:38:10'),(36,1,485.0000,'cash','credit','sell',1542,'2025-02-02 03:40:58','2025-02-02 03:40:58'),(37,1,392.0000,'cash','credit','sell',1543,'2025-02-02 03:43:24','2025-02-02 03:43:24'),(38,1,681.0000,'cash','credit','sell',1544,'2025-02-02 03:45:25','2025-02-02 03:45:25'),(39,1,1884.0000,'cash','credit','sell',1546,'2025-02-02 03:47:22','2025-02-02 03:47:22'),(40,1,873.0000,'cash','credit','sell',1547,'2025-02-02 03:49:18','2025-02-02 03:49:18'),(41,1,2068.0000,'cash','credit','sell',1548,'2025-02-02 03:55:21','2025-02-02 03:55:21'),(42,1,2298.0000,'cash','credit','sell',1549,'2025-02-02 03:55:23','2025-02-02 03:55:23'),(43,1,654.0000,'cash','credit','sell',1550,'2025-02-02 03:57:25','2025-02-02 03:57:25'),(44,1,178.0000,'cash','credit','sell',1551,'2025-02-02 03:59:12','2025-02-02 03:59:12'),(45,1,1880.0000,'cash','credit','sell',1552,'2025-02-02 04:00:46','2025-02-02 04:00:46'),(46,1,1139.0000,'cash','credit','sell',1553,'2025-02-02 04:01:22','2025-02-02 04:01:22'),(47,1,147.0000,'cash','credit','sell',1554,'2025-02-02 04:03:57','2025-02-02 04:03:57'),(48,1,657.0000,'cash','credit','sell',1555,'2025-02-02 04:06:19','2025-02-02 04:06:19'),(49,1,1000.0000,'cash','credit','sell',1556,'2025-02-02 04:06:56','2025-02-02 04:06:56'),(50,1,596.0000,'card','credit','sell',1556,'2025-02-02 04:06:56','2025-02-02 04:06:56'),(51,1,47.0000,'cash','credit','sell',1557,'2025-02-02 04:08:44','2025-02-02 04:08:44'),(52,1,167.0000,'cash','credit','sell',1560,'2025-02-02 04:11:51','2025-02-02 04:11:51'),(53,1,400.0000,'cash','credit','sell',1561,'2025-02-02 04:12:57','2025-02-02 04:12:57'),(54,1,884.0000,'cash','credit','sell',1562,'2025-02-02 04:21:43','2025-02-02 04:21:43'),(55,1,694.0000,'cash','credit','sell',1563,'2025-02-02 04:23:43','2025-02-02 04:23:43'),(56,1,245.0000,'cash','credit','sell',1564,'2025-02-02 04:24:33','2025-02-02 04:24:33'),(57,1,2169.0000,'cash','credit','sell',1568,'2025-02-02 04:27:27','2025-02-02 04:27:27'),(58,1,1349.0000,'cash','credit','sell',1570,'2025-02-02 04:28:46','2025-02-02 04:28:46'),(59,1,85.0000,'cash','credit','sell',1571,'2025-02-02 04:29:40','2025-02-02 04:29:40'),(60,1,2610.0000,'cash','credit','sell',1572,'2025-02-02 04:31:06','2025-02-02 04:31:06'),(61,1,558.0000,'cash','credit','sell',1573,'2025-02-02 04:31:44','2025-02-02 04:31:44'),(62,1,1549.0000,'cash','credit','sell',1575,'2025-02-02 04:33:27','2025-02-02 04:33:27'),(63,1,892.0000,'cash','credit','sell',1576,'2025-02-02 04:40:02','2025-02-02 04:40:02'),(64,1,591.0000,'cash','credit','sell',1577,'2025-02-02 04:41:06','2025-02-02 04:41:06'),(65,1,468.0000,'cash','credit','sell',1580,'2025-02-02 04:43:03','2025-02-02 04:43:03'),(66,1,1188.0000,'cash','credit','sell',1581,'2025-02-02 04:44:12','2025-02-02 04:44:12'),(67,1,528.0000,'cash','credit','sell',1582,'2025-02-02 04:45:23','2025-02-02 04:45:23'),(68,1,371.0000,'cash','credit','sell',1583,'2025-02-02 04:45:27','2025-02-02 04:45:27'),(69,1,1880.0000,'cash','credit','sell',1586,'2025-02-02 04:47:05','2025-02-02 04:47:05'),(70,1,40.0000,'cash','credit','sell',1587,'2025-02-02 04:48:14','2025-02-02 04:48:14'),(71,1,1104.0000,'cash','credit','sell',1588,'2025-02-02 04:48:16','2025-02-02 04:48:16'),(72,1,777.0000,'cash','credit','sell',1589,'2025-02-02 04:51:21','2025-02-02 04:51:21'),(73,1,340.0000,'cash','credit','sell',1591,'2025-02-02 04:54:06','2025-02-02 04:54:06'),(74,1,533.0000,'cash','credit','sell',1592,'2025-02-02 04:54:24','2025-02-02 04:54:24'),(75,1,298.0000,'cash','credit','sell',1593,'2025-02-02 04:55:17','2025-02-02 04:55:17'),(76,1,60.0000,'cash','credit','sell',1595,'2025-02-02 04:57:16','2025-02-02 04:57:16'),(77,1,1782.0000,'cash','credit','sell',1598,'2025-02-02 05:00:24','2025-02-02 05:00:24'),(78,1,458.0000,'cash','credit','sell',1599,'2025-02-02 05:00:30','2025-02-02 05:00:30'),(79,1,60.0000,'cash','credit','sell',1601,'2025-02-02 05:04:03','2025-02-02 05:04:03'),(80,1,199.0000,'cash','credit','sell',1602,'2025-02-02 05:06:41','2025-02-02 05:06:41'),(81,1,60.0000,'cash','credit','sell',1603,'2025-02-02 05:07:17','2025-02-02 05:07:17'),(82,1,88.0000,'cash','credit','sell',1604,'2025-02-02 05:08:14','2025-02-02 05:08:14'),(83,1,218.0000,'cash','credit','sell',1605,'2025-02-02 05:08:15','2025-02-02 05:08:15'),(84,1,216.0000,'cash','credit','sell',1606,'2025-02-02 05:10:05','2025-02-02 05:10:05'),(85,1,369.0000,'cash','credit','sell',1608,'2025-02-02 05:10:29','2025-02-02 05:10:29'),(86,1,345.0000,'cash','credit','sell',1609,'2025-02-02 05:10:41','2025-02-02 05:10:41'),(87,1,74.0000,'cash','credit','sell',1610,'2025-02-02 05:13:16','2025-02-02 05:13:16'),(88,1,194.0000,'cash','credit','sell',1612,'2025-02-02 05:17:08','2025-02-02 05:17:08'),(89,1,45.0000,'cash','credit','sell',1613,'2025-02-02 05:18:48','2025-02-02 05:18:48'),(90,1,49.0000,'cash','credit','sell',1614,'2025-02-02 05:25:21','2025-02-02 05:25:21'),(91,1,10.0000,'cash','credit','sell',1615,'2025-02-02 05:27:38','2025-02-02 05:27:38'),(92,1,40.0000,'cash','credit','sell',1616,'2025-02-02 05:32:25','2025-02-02 05:32:25'),(93,1,294.0000,'cash','credit','sell',1617,'2025-02-02 05:36:33','2025-02-02 05:36:33'),(94,1,90.0000,'cash','credit','sell',1618,'2025-02-02 05:43:32','2025-02-02 05:43:32'),(95,1,1011.0000,'cash','credit','sell',1620,'2025-02-02 05:44:32','2025-02-02 05:44:32'),(96,1,1028.0000,'cash','credit','sell',1621,'2025-02-02 05:46:07','2025-02-02 05:46:07'),(97,1,53.0000,'cash','credit','sell',1622,'2025-02-02 05:48:31','2025-02-02 05:48:31'),(98,1,5.0000,'cash','credit','sell',1622,'2025-02-02 05:49:24','2025-02-02 05:49:24'),(101,1,1268.0000,'cash','credit','sell',1626,'2025-02-02 06:05:24','2025-02-02 06:05:24'),(102,1,275.0000,'cash','credit','sell',1627,'2025-02-02 06:06:12','2025-02-02 06:06:12'),(103,1,80.0000,'cash','credit','sell',1628,'2025-02-02 06:08:35','2025-02-02 06:08:35'),(104,1,445.0000,'cash','credit','sell',1629,'2025-02-02 06:08:46','2025-02-02 06:08:46'),(105,1,65.0000,'cash','credit','sell',1630,'2025-02-02 06:09:02','2025-02-02 06:09:02'),(106,1,603.0000,'cash','credit','sell',1630,'2025-02-02 06:16:14','2025-02-02 06:16:14'),(107,1,478.0000,'cash','debit','refund',1630,'2025-02-02 06:19:26','2025-02-02 06:19:26'),(108,1,500.0000,'cash','credit','sell',1631,'2025-02-02 06:21:03','2025-02-02 06:21:03'),(109,1,-320.0000,'cash','credit','sell',1631,'2025-02-02 06:21:03','2025-02-02 06:21:03'),(110,1,205.0000,'cash','credit','sell',1632,'2025-02-02 06:26:14','2025-02-02 06:26:14'),(111,1,765.0000,'cash','credit','sell',1631,'2025-02-02 06:27:54','2025-02-02 06:27:54'),(112,1,145.0000,'cash','credit','sell',1633,'2025-02-02 06:30:50','2025-02-02 06:30:50'),(113,1,245.0000,'cash','credit','sell',1634,'2025-02-02 06:33:16','2025-02-02 06:33:16'),(114,1,619.0000,'cash','credit','sell',1636,'2025-02-02 06:40:08','2025-02-02 06:40:08'),(115,1,10.0000,'cash','credit','sell',1638,'2025-02-02 06:41:37','2025-02-02 06:41:37'),(116,1,287.0000,'cash','credit','sell',1639,'2025-02-02 06:44:12','2025-02-02 06:44:12'),(117,1,806.0000,'cash','credit','sell',1640,'2025-02-02 06:46:12','2025-02-02 06:46:12'),(118,1,204.0000,'cash','credit','sell',1641,'2025-02-02 06:47:23','2025-02-02 06:47:23'),(119,1,1107.0000,'cash','credit','sell',1642,'2025-02-02 06:52:21','2025-02-02 06:52:21'),(120,1,476.0000,'cash','credit','sell',1643,'2025-02-02 06:52:44','2025-02-02 06:52:44'),(121,1,2000.0000,'cash','credit','sell',1644,'2025-02-02 06:58:55','2025-02-02 06:58:55'),(123,1,894.0000,'cash','credit','sell',1646,'2025-02-02 07:04:48','2025-02-02 07:04:48'),(124,1,78.0000,'cash','credit','sell',1647,'2025-02-02 07:05:42','2025-02-02 07:05:42'),(125,1,1848.0000,'cash','credit','sell',1648,'2025-02-02 07:11:54','2025-02-02 07:11:54'),(126,1,262.0000,'cash','credit','sell',1649,'2025-02-02 07:14:32','2025-02-02 07:14:32'),(127,1,200.0000,'cash','credit','sell',1650,'2025-02-02 07:16:22','2025-02-02 07:16:22'),(128,1,547.0000,'cash','credit','sell',1651,'2025-02-02 07:18:18','2025-02-02 07:18:18'),(129,1,247.0000,'cash','credit','sell',1652,'2025-02-02 07:21:13','2025-02-02 07:21:13'),(130,1,3645.0000,'cash','credit','sell',1653,'2025-02-02 07:23:03','2025-02-02 07:23:03'),(131,1,2570.0000,'cash','debit','refund',1653,'2025-02-02 07:25:30','2025-02-02 07:25:30'),(132,1,90.0000,'cash','credit','sell',1654,'2025-02-02 07:27:48','2025-02-02 07:27:48'),(133,1,551.0000,'cash','credit','sell',1655,'2025-02-02 07:45:53','2025-02-02 07:45:53'),(134,1,454.0000,'cash','credit','sell',1656,'2025-02-02 07:50:10','2025-02-02 07:50:10'),(135,1,50.0000,'cash','credit','sell',1657,'2025-02-02 07:52:08','2025-02-02 07:52:08'),(136,1,40.0000,'cash','credit','sell',1658,'2025-02-02 07:53:29','2025-02-02 07:53:29'),(137,1,512.0000,'cash','credit','sell',1659,'2025-02-02 07:54:33','2025-02-02 07:54:33'),(138,1,370.0000,'cash','credit','sell',1662,'2025-02-02 08:06:41','2025-02-02 08:06:41'),(140,1,33.0000,'cash','credit','sell',1664,'2025-02-02 08:10:55','2025-02-02 08:10:55'),(141,1,411.0000,'cash','credit','sell',1665,'2025-02-02 08:18:28','2025-02-02 08:18:28'),(142,1,1330.0000,'cash','credit','sell',1666,'2025-02-02 08:22:25','2025-02-02 08:22:25'),(143,1,402.0000,'cash','credit','sell',1667,'2025-02-02 08:25:30','2025-02-02 08:25:30'),(144,1,1600.0000,'cash','credit','sell',1668,'2025-02-02 08:27:13','2025-02-02 08:27:13'),(145,1,2.0000,'cash','debit','refund',1667,'2025-02-02 08:27:47','2025-02-02 08:27:47'),(146,1,1490.0000,'cash','credit','sell',1669,'2025-02-02 08:34:37','2025-02-02 08:34:37'),(147,1,55.0000,'cash','credit','sell',1670,'2025-02-02 08:39:53','2025-02-02 08:39:53'),(149,1,200.0000,'cash','credit','sell',1672,'2025-02-02 08:48:46','2025-02-02 08:48:46'),(150,1,81.0000,'cash','credit','sell',1673,'2025-02-02 08:51:21','2025-02-02 08:51:21'),(151,1,498.0000,'cash','credit','sell',1675,'2025-02-02 09:05:42','2025-02-02 09:05:42'),(152,1,50.0000,'cash','credit','sell',1676,'2025-02-02 09:09:09','2025-02-02 09:09:09'),(154,1,31.0000,'cash','credit','sell',1678,'2025-02-02 09:13:13','2025-02-02 09:13:13'),(155,1,540.0000,'cash','credit','sell',1679,'2025-02-02 09:19:28','2025-02-02 09:19:28'),(156,1,86.0000,'cash','credit','sell',1680,'2025-02-02 09:21:58','2025-02-02 09:21:58'),(157,1,70.0000,'cash','credit','sell',1681,'2025-02-02 09:24:54','2025-02-02 09:24:54'),(158,1,346.0000,'cash','credit','sell',1683,'2025-02-02 09:27:06','2025-02-02 09:27:06'),(159,1,101.0000,'cash','credit','sell',1684,'2025-02-02 09:28:09','2025-02-02 09:28:09'),(160,1,127.0000,'cash','credit','sell',1685,'2025-02-02 09:29:28','2025-02-02 09:29:28'),(161,1,409.0000,'cash','credit','sell',1687,'2025-02-02 09:39:32','2025-02-02 09:39:32'),(162,1,439.0000,'cash','credit','sell',1691,'2025-02-02 09:58:02','2025-02-02 09:58:02'),(163,1,18.0000,'cash','credit','sell',1692,'2025-02-02 09:58:32','2025-02-02 09:58:32'),(164,1,20.0000,'cash','credit','sell',1693,'2025-02-02 10:17:30','2025-02-02 10:17:30'),(165,1,20.0000,'cash','credit','sell',1694,'2025-02-02 10:19:53','2025-02-02 10:19:53'),(166,1,281.0000,'cash','credit','sell',1695,'2025-02-02 10:34:21','2025-02-02 10:34:21'),(167,1,30.0000,'cash','credit','sell',1696,'2025-02-02 10:38:53','2025-02-02 10:38:53'),(168,1,20.0000,'cash','credit','sell',1697,'2025-02-02 10:47:18','2025-02-02 10:47:18'),(169,1,80.0000,'cash','credit','sell',1699,'2025-02-02 10:53:11','2025-02-02 10:53:11'),(170,1,100.0000,'cash','credit','sell',1701,'2025-02-02 10:54:09','2025-02-02 10:54:09'),(171,1,385.0000,'cash','credit','sell',1702,'2025-02-02 10:59:13','2025-02-02 10:59:13'),(172,1,1317.0000,'cash','credit','sell',1703,'2025-02-02 11:01:13','2025-02-02 11:01:13'),(173,1,402.0000,'cash','credit','sell',1704,'2025-02-02 11:01:15','2025-02-02 11:01:15'),(174,1,117.0000,'cash','credit','sell',1705,'2025-02-02 11:07:58','2025-02-02 11:07:58'),(175,1,870.0000,'cash','credit','sell',1707,'2025-02-02 11:28:15','2025-02-02 11:28:15'),(176,1,354.0000,'cash','credit','sell',1709,'2025-02-02 11:36:01','2025-02-02 11:36:01'),(177,1,1400.0000,'cash','credit','sell',1710,'2025-02-02 11:37:07','2025-02-02 11:37:07'),(178,1,40.0000,'cash','credit','sell',1711,'2025-02-02 11:37:28','2025-02-02 11:37:28'),(179,1,1189.0000,'cash','credit','sell',1713,'2025-02-02 11:55:48','2025-02-02 11:55:48'),(180,1,380.0000,'cash','credit','sell',1714,'2025-02-02 12:06:07','2025-02-02 12:06:07'),(181,1,32.0000,'cash','credit','sell',1715,'2025-02-02 12:17:28','2025-02-02 12:17:28'),(182,1,1707.0000,'cash','credit','sell',1716,'2025-02-02 12:22:42','2025-02-02 12:22:42'),(183,1,80.0000,'cash','credit','sell',1717,'2025-02-02 12:24:07','2025-02-02 12:24:07'),(184,1,135.0000,'cash','credit','sell',1718,'2025-02-02 12:25:07','2025-02-02 12:25:07'),(185,1,97.0000,'cash','credit','sell',1719,'2025-02-02 12:25:15','2025-02-02 12:25:15'),(186,1,129.0000,'cash','credit','sell',1720,'2025-02-02 12:33:45','2025-02-02 12:33:45'),(187,1,75.0000,'cash','credit','sell',1721,'2025-02-02 12:36:13','2025-02-02 12:36:13'),(188,1,160.0000,'cash','credit','sell',1723,'2025-02-02 12:39:49','2025-02-02 12:39:49'),(189,1,84.0000,'cash','credit','sell',1726,'2025-02-02 12:42:17','2025-02-02 12:42:17'),(190,1,184.0000,'cash','credit','sell',1728,'2025-02-02 12:43:06','2025-02-02 12:43:06'),(191,1,1270.0000,'cash','credit','sell',1729,'2025-02-02 12:48:25','2025-02-02 12:48:25'),(192,1,1220.0000,'cash','credit','sell',1730,'2025-02-02 12:49:26','2025-02-02 12:49:26'),(193,1,40.0000,'cash','credit','sell',1731,'2025-02-02 12:49:55','2025-02-02 12:49:55'),(194,1,573.0000,'cash','credit','sell',1732,'2025-02-02 12:51:47','2025-02-02 12:51:47'),(195,1,1323.0000,'cash','credit','sell',1733,'2025-02-02 12:55:25','2025-02-02 12:55:25'),(196,1,369.0000,'cash','credit','sell',1734,'2025-02-02 13:01:15','2025-02-02 13:01:15'),(197,1,1265.0000,'cash','credit','sell',1733,'2025-02-02 13:04:47','2025-02-02 13:04:47'),(198,1,280.0000,'cash','credit','sell',1735,'2025-02-02 13:05:11','2025-02-02 13:05:11'),(199,1,664.0000,'cash','credit','sell',1736,'2025-02-02 13:06:45','2025-02-02 13:06:45'),(200,1,215.0000,'cash','credit','sell',1738,'2025-02-02 13:07:58','2025-02-02 13:07:58'),(201,1,20.0000,'cash','credit','sell',1739,'2025-02-02 13:08:06','2025-02-02 13:08:06'),(202,1,5.0000,'cash','credit','sell',1740,'2025-02-02 13:09:21','2025-02-02 13:09:21'),(203,1,816.0000,'cash','credit','sell',1741,'2025-02-02 13:14:11','2025-02-02 13:14:11'),(204,1,1269.0000,'cash','credit','sell',1742,'2025-02-02 13:14:21','2025-02-02 13:14:21'),(205,1,180.0000,'cash','credit','sell',1747,'2025-02-02 13:18:18','2025-02-02 13:18:18'),(206,1,348.0000,'cash','credit','sell',1749,'2025-02-02 13:30:42','2025-02-02 13:30:42'),(207,1,281.0000,'cash','credit','sell',1750,'2025-02-02 13:32:10','2025-02-02 13:32:10'),(208,1,294.0000,'cash','credit','sell',1751,'2025-02-02 13:41:49','2025-02-02 13:41:49'),(209,1,58.0000,'cash','credit','sell',1752,'2025-02-02 13:43:12','2025-02-02 13:43:12'),(210,1,1358.0000,'cash','credit','sell',1753,'2025-02-02 13:43:47','2025-02-02 13:43:47'),(211,1,500.0000,'cash','credit','sell',1754,'2025-02-02 13:47:31','2025-02-02 13:47:31'),(212,1,-91.0000,'cash','credit','sell',1754,'2025-02-02 13:47:31','2025-02-02 13:47:31'),(213,1,500.0000,'cash','credit','sell',1755,'2025-02-02 13:49:54','2025-02-02 13:49:54'),(214,1,-285.0000,'cash','credit','sell',1755,'2025-02-02 13:49:54','2025-02-02 13:49:54'),(215,1,441.0000,'cash','credit','sell',1756,'2025-02-02 13:54:07','2025-02-02 13:54:07'),(216,1,998.0000,'cash','credit','sell',1757,'2025-02-02 13:54:56','2025-02-02 13:54:56'),(217,1,67.0000,'cash','credit','sell',1758,'2025-02-02 13:57:57','2025-02-02 13:57:57'),(218,1,20.0000,'cash','credit','sell',1759,'2025-02-02 14:00:39','2025-02-02 14:00:39'),(219,1,245.0000,'custom_pay_1','credit','sell',1760,'2025-02-02 14:03:14','2025-02-02 14:03:14'),(220,1,1500.0000,'cash','credit','sell',1761,'2025-02-02 14:16:09','2025-02-02 14:16:09'),(221,1,-276.0000,'cash','credit','sell',1761,'2025-02-02 14:16:09','2025-02-02 14:16:09'),(222,1,149.0000,'cash','credit','sell',1762,'2025-02-02 14:19:18','2025-02-02 14:19:18'),(223,1,500.0000,'cash','credit','sell',1763,'2025-02-02 14:22:04','2025-02-02 14:22:04'),(224,1,-15.0000,'cash','credit','sell',1763,'2025-02-02 14:22:04','2025-02-02 14:22:04'),(225,1,250.0000,'cash','credit','sell',1766,'2025-02-02 14:35:25','2025-02-02 14:35:25'),(226,1,17.0000,'cash','debit','refund',1766,'2025-02-02 14:36:09','2025-02-02 14:36:09'),(227,1,7.0000,'cash','credit','sell',1766,'2025-02-02 14:36:30','2025-02-02 14:36:30'),(228,1,334.0000,'cash','credit','sell',1767,'2025-02-02 14:37:37','2025-02-02 14:37:37'),(229,1,222.0000,'cash','credit','sell',1769,'2025-02-02 14:46:56','2025-02-02 14:46:56'),(230,1,60.0000,'cash','credit','sell',1770,'2025-02-02 14:48:22','2025-02-02 14:48:22'),(231,1,898.0000,'cash','credit','sell',1772,'2025-02-02 14:51:16','2025-02-02 14:51:16'),(232,1,29.0000,'cash','credit','sell',1773,'2025-02-02 14:52:39','2025-02-02 14:52:39'),(233,1,500.0000,'cash','credit','sell',1774,'2025-02-02 14:56:17','2025-02-02 14:56:17'),(234,1,-145.0000,'cash','credit','sell',1774,'2025-02-02 14:56:17','2025-02-02 14:56:17'),(235,1,97.0000,'cash','credit','sell',1775,'2025-02-02 15:04:11','2025-02-02 15:04:11'),(236,1,100.0000,'cash','credit','sell',1776,'2025-02-02 15:06:23','2025-02-02 15:06:23'),(237,1,-44.0000,'cash','credit','sell',1776,'2025-02-02 15:06:23','2025-02-02 15:06:23'),(238,1,205.0000,'cash','credit','sell',1777,'2025-02-02 15:13:40','2025-02-02 15:13:40'),(239,1,100.0000,'cash','credit','sell',1778,'2025-02-02 15:22:45','2025-02-02 15:22:45'),(240,1,-71.0000,'cash','credit','sell',1778,'2025-02-02 15:22:45','2025-02-02 15:22:45'),(241,1,818.0000,'cash','credit','sell',1779,'2025-02-02 15:33:57','2025-02-02 15:33:57'),(242,1,45.0000,'cash','credit','sell',1780,'2025-02-02 15:34:53','2025-02-02 15:34:53'),(243,1,2263.0000,'cash','credit','sell',1781,'2025-02-02 15:36:05','2025-02-02 15:36:05'),(244,1,48.0000,'cash','credit','sell',1782,'2025-02-02 15:38:05','2025-02-02 15:38:05'),(245,1,871.0000,'cash','credit','sell',1783,'2025-02-02 15:44:20','2025-02-02 15:44:20'),(246,1,58.0000,'cash','credit','sell',1784,'2025-02-02 15:51:31','2025-02-02 15:51:31'),(247,1,238.0000,'custom_pay_1','credit','sell',1785,'2025-02-02 15:54:30','2025-02-02 15:54:30'),(248,1,500.0000,'cash','credit','sell',1786,'2025-02-03 02:34:25','2025-02-03 02:34:25'),(249,1,-156.0000,'cash','credit','sell',1786,'2025-02-03 02:34:25','2025-02-03 02:34:25'),(250,1,843.0000,'custom_pay_1','credit','sell',1787,'2025-02-03 03:03:20','2025-02-03 03:03:20'),(251,1,22.0000,'cash','credit','sell',1788,'2025-02-03 03:05:10','2025-02-03 03:05:10'),(252,1,976.0000,'cash','credit','sell',1787,'2025-02-03 03:05:52','2025-02-03 03:05:52'),(253,1,843.0000,'custom_pay_1','debit','refund',1787,'2025-02-03 03:05:52','2025-02-03 03:05:52'),(254,1,471.0000,'cash','credit','sell',1789,'2025-02-03 03:08:44','2025-02-03 03:08:44'),(255,1,95.0000,'bank_transfer','credit','sell',1790,'2025-02-03 03:45:10','2025-02-03 03:45:10'),(256,1,98.0000,'cash','credit','sell',1791,'2025-02-03 03:52:50','2025-02-03 03:52:50'),(257,1,299.0000,'cash','credit','sell',1792,'2025-02-03 03:56:54','2025-02-03 03:56:54'),(258,1,213.0000,'cash','credit','sell',1793,'2025-02-03 04:49:47','2025-02-03 04:49:47'),(259,1,625.0000,'cash','credit','sell',1796,'2025-02-03 05:19:06','2025-02-03 05:19:06'),(260,1,360.0000,'cash','credit','sell',1797,'2025-02-03 05:45:13','2025-02-03 05:45:13'),(261,1,822.0000,'cash','credit','sell',1798,'2025-02-03 05:56:11','2025-02-03 05:56:11'),(262,1,55.0000,'cash','credit','sell',1799,'2025-02-03 05:57:10','2025-02-03 05:57:10'),(263,1,432.0000,'cash','credit','sell',1801,'2025-02-03 06:17:13','2025-02-03 06:17:13'),(264,1,454.0000,'cash','credit','sell',1801,'2025-02-03 06:23:04','2025-02-03 06:23:04'),(266,1,500.0000,'cash','credit','sell',1816,'2025-02-03 07:55:38','2025-02-03 07:55:38'),(267,1,-228.0000,'cash','credit','sell',1816,'2025-02-03 07:55:38','2025-02-03 07:55:38'),(268,1,642.0000,'cash','credit','sell',1821,'2025-02-03 08:45:53','2025-02-03 08:45:53'),(269,1,253.0000,'cash','credit','sell',1822,'2025-02-03 08:49:53','2025-02-03 08:49:53'),(270,1,191.0000,'cash','credit','sell',1822,'2025-02-03 08:52:37','2025-02-03 08:52:37'),(271,1,56.0000,'cash','credit','sell',1824,'2025-02-03 09:42:06','2025-02-03 09:42:06'),(272,1,603.0000,'cash','credit','sell',1828,'2025-02-03 10:20:16','2025-02-03 10:20:16'),(273,1,1880.0000,'cash','credit','sell',1829,'2025-02-03 10:28:34','2025-02-03 10:28:34'),(274,1,431.0000,'cash','credit','sell',1830,'2025-02-03 10:52:05','2025-02-03 10:52:05'),(275,1,235.0000,'cash','credit','sell',1831,'2025-02-03 10:57:02','2025-02-03 10:57:02'),(276,1,123.0000,'cash','credit','sell',1832,'2025-02-03 11:00:22','2025-02-03 11:00:22'),(277,1,32.0000,'cash','credit','sell',1833,'2025-02-03 11:00:35','2025-02-03 11:00:35'),(278,1,400.0000,'cash','credit','sell',1834,'2025-02-03 11:00:39','2025-02-03 11:00:39'),(279,1,-70.0000,'cash','credit','sell',1834,'2025-02-03 11:00:39','2025-02-03 11:00:39'),(280,1,800.0000,'cash','credit','sell',1836,'2025-02-03 11:50:47','2025-02-03 11:50:47'),(281,1,2752.0000,'cash','credit','sell',1841,'2025-02-03 12:14:20','2025-02-03 12:14:20'),(282,1,6.0000,'cash','credit','sell',1841,'2025-02-03 12:15:13','2025-02-03 12:15:13'),(283,1,60.0000,'cash','credit','sell',1841,'2025-02-03 12:17:59','2025-02-03 12:17:59');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_card_slips` int(11) NOT NULL DEFAULT '0',
  `total_cheques` int(11) NOT NULL DEFAULT '0',
  `denominations` text COLLATE utf8mb4_unicode_ci,
  `closing_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2025-01-29 13:55:00','2025-01-29 13:55:10');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Chocolet',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(2,'Masala & Flour',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(3,'Rava & Maida',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(4,'Soap',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(5,'General',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(6,'Soap & Spray',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(7,'Rice & Millets',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `middle_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_line_1` text COLLATE utf8mb4_unicode_ci,
  `address_line_2` text COLLATE utf8mb4_unicode_ci,
  `zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_rp` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `shipping_address` text COLLATE utf8mb4_unicode_ci,
  `shipping_custom_field_details` longtext COLLATE utf8mb4_unicode_ci,
  `is_export` tinyint(1) NOT NULL DEFAULT '0',
  `export_custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_6` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field6` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field7` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field8` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field9` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field10` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-20 06:14:39','2023-09-26 15:48:20'),(2,1,'customer','arivu','arivu',NULL,'arivu',NULL,NULL,NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'9597523525',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 10:28:53','2025-02-02 10:28:53'),(3,1,'customer',NULL,'RAJA',NULL,'RAJA',NULL,NULL,NULL,'CO0003','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'8807692974',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 11:34:56','2025-02-02 11:34:56'),(4,1,'supplier','Jai Agencies','Jai',NULL,'Jai',NULL,NULL,NULL,'CO0004','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'9698957116',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-03 04:57:53','2025-02-03 04:57:53'),(5,1,'customer',NULL,'kuppusamy',NULL,'kuppusamy',NULL,NULL,NULL,'CO0005','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'7010080039',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-03 05:46:34','2025-02-03 05:46:34'),(6,1,'supplier','Cholaimalai Enterprises','Cholaimalai Enterprises',NULL,'Cholaimalai Enterprises',NULL,NULL,NULL,'CO0006','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'-',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-03 09:25:36','2025-02-03 09:25:36');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `spg` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
INSERT INTO `group_sub_taxes` VALUES (4,2),(4,3),(8,6),(8,7),(11,9),(11,10),(15,13),(16,13),(16,14);
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `round_off_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_time_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `show_lot` tinyint(1) NOT NULL DEFAULT '0',
  `show_image` tinyint(1) NOT NULL DEFAULT '0',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commission_agent_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT '0',
  `show_reward_point` tinyint(1) NOT NULL DEFAULT '0',
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `module_info` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int(10) unsigned NOT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT '0',
  `qr_code_fields` text COLLATE utf8mb4_unicode_ci,
  `design` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text COLLATE utf8mb4_unicode_ci,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT '0',
  `prev_bal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `change_return_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `contact_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `location_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Bill No',NULL,'BILL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Total','Your Saving Amt','Tax','Net Amount','Round Off',NULL,NULL,0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,'Billed By',1,'Item','Qty','MRP','Amt',NULL,'1709016977_1708939915_logo.png',0,0,1,1,1,0,1,0,1,1,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','<p style=\"text-align: center;\"><strong style=\"text-align: center;\"><strong>!!!நன்றி மீண்டும் வருக!!!</strong></strong></p>',NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":\"Disc\",\"discounted_unit_price_label\":null,\"total_items_label\":\"Total Qty\",\"num_to_word_format\":\"international\",\"tax_summary_label\":\"Tax Details\"}',1,1,0,NULL,'slim','Return Inv No','Return No','Return Total Amount',NULL,0,NULL,NULL,NULL,NULL,NULL,'2022-10-20 06:14:39','2025-02-03 05:00:15');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT '0',
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'SVM SMART HYPER MARKET','blank','',1,256,4,1,'2022-10-20 06:14:39','2025-02-03 12:14:20');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_media_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
INSERT INTO `media` VALUES (2,1,'1708173548_1426502851_logo1 (1).png',NULL,1,'App\\User',NULL,1,'2024-02-17 12:39:08','2024-02-17 12:39:08');
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (80,'App\\User',1),(83,'App\\User',2),(82,'App\\User',3);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(3,'App\\User',2),(4,'App\\User',3);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci,
  `sms_body` text COLLATE utf8mb4_unicode_ci,
  `whatsapp_text` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bcc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
INSERT INTO `password_resets` VALUES ('ARKTRADERS9981@GMAIL.COM','$2y$10$fDS8/9VzR/QVJdq9E9ZA3.IbPKkZLlpFN4Ne1ectboox5eoDUMIm.','2024-04-16 11:18:27');
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2022-10-20 06:12:40',NULL),(2,'direct_sell.access','web','2022-10-20 06:12:40',NULL),(3,'product.opening_stock','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(4,'crud_all_bookings','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(5,'crud_own_bookings','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(6,'access_default_selling_price','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(7,'purchase.payments','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(8,'sell.payments','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(9,'edit_product_price_from_sale_screen','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(10,'edit_product_discount_from_sale_screen','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(11,'roles.view','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(12,'roles.create','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(13,'roles.update','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(14,'roles.delete','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(15,'account.access','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(16,'discount.access','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(17,'view_purchase_price','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(18,'view_own_sell_only','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(19,'edit_product_discount_from_pos_screen','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(20,'edit_product_price_from_pos_screen','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(21,'access_shipping','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(22,'purchase.update_status','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(23,'list_drafts','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(24,'list_quotations','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(25,'view_cash_register','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(26,'close_cash_register','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(27,'print_invoice','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(28,'user.view','web','2022-10-20 06:12:41',NULL),(29,'user.create','web','2022-10-20 06:12:41',NULL),(30,'user.update','web','2022-10-20 06:12:41',NULL),(31,'user.delete','web','2022-10-20 06:12:41',NULL),(32,'supplier.view','web','2022-10-20 06:12:41',NULL),(33,'supplier.create','web','2022-10-20 06:12:41',NULL),(34,'supplier.update','web','2022-10-20 06:12:41',NULL),(35,'supplier.delete','web','2022-10-20 06:12:41',NULL),(36,'customer.view','web','2022-10-20 06:12:41',NULL),(37,'customer.create','web','2022-10-20 06:12:41',NULL),(38,'customer.update','web','2022-10-20 06:12:41',NULL),(39,'customer.delete','web','2022-10-20 06:12:41',NULL),(40,'product.view','web','2022-10-20 06:12:41',NULL),(41,'product.create','web','2022-10-20 06:12:41',NULL),(42,'product.update','web','2022-10-20 06:12:41',NULL),(43,'product.delete','web','2022-10-20 06:12:41',NULL),(44,'purchase.view','web','2022-10-20 06:12:41',NULL),(45,'purchase.create','web','2022-10-20 06:12:41',NULL),(46,'purchase.update','web','2022-10-20 06:12:41',NULL),(47,'purchase.delete','web','2022-10-20 06:12:41',NULL),(48,'sell.view','web','2022-10-20 06:12:41',NULL),(49,'sell.create','web','2022-10-20 06:12:41',NULL),(50,'sell.update','web','2022-10-20 06:12:41',NULL),(51,'sell.delete','web','2022-10-20 06:12:41',NULL),(52,'purchase_n_sell_report.view','web','2022-10-20 06:12:41',NULL),(53,'contacts_report.view','web','2022-10-20 06:12:41',NULL),(54,'stock_report.view','web','2022-10-20 06:12:41',NULL),(55,'tax_report.view','web','2022-10-20 06:12:41',NULL),(56,'trending_product_report.view','web','2022-10-20 06:12:41',NULL),(57,'register_report.view','web','2022-10-20 06:12:41',NULL),(58,'sales_representative.view','web','2022-10-20 06:12:41',NULL),(59,'expense_report.view','web','2022-10-20 06:12:41',NULL),(60,'business_settings.access','web','2022-10-20 06:12:41',NULL),(61,'barcode_settings.access','web','2022-10-20 06:12:41',NULL),(62,'invoice_settings.access','web','2022-10-20 06:12:41',NULL),(63,'brand.view','web','2022-10-20 06:12:41',NULL),(64,'brand.create','web','2022-10-20 06:12:41',NULL),(65,'brand.update','web','2022-10-20 06:12:41',NULL),(66,'brand.delete','web','2022-10-20 06:12:41',NULL),(67,'tax_rate.view','web','2022-10-20 06:12:41',NULL),(68,'tax_rate.create','web','2022-10-20 06:12:41',NULL),(69,'tax_rate.update','web','2022-10-20 06:12:41',NULL),(70,'tax_rate.delete','web','2022-10-20 06:12:41',NULL),(71,'unit.view','web','2022-10-20 06:12:41',NULL),(72,'unit.create','web','2022-10-20 06:12:41',NULL),(73,'unit.update','web','2022-10-20 06:12:41',NULL),(74,'unit.delete','web','2022-10-20 06:12:41',NULL),(75,'category.view','web','2022-10-20 06:12:41',NULL),(76,'category.create','web','2022-10-20 06:12:41',NULL),(77,'category.update','web','2022-10-20 06:12:41',NULL),(78,'category.delete','web','2022-10-20 06:12:41',NULL),(79,'expense.access','web','2022-10-20 06:12:41',NULL),(80,'access_all_locations','web','2022-10-20 06:12:41',NULL),(81,'dashboard.data','web','2022-10-20 06:12:41',NULL),(82,'location.1','web','2022-10-20 06:14:39','2022-10-20 06:14:39'),(83,'location.2','web','2023-01-26 07:31:07','2023-01-26 07:31:07'),(84,'location.3','web','2023-10-14 11:19:44','2023-10-14 11:19:44'),(85,'location.4','web','2024-02-27 06:54:11','2024-02-27 06:54:11'),(86,'view_product_stock_value','web','2024-03-21 12:30:38','2024-03-21 12:30:38'),(87,'expense.add','web','2024-03-21 12:30:38','2024-03-21 12:30:38'),(88,'view_own_expense','web','2024-03-21 12:30:38','2024-03-21 12:30:38'),(89,'expense.edit','web','2024-04-16 07:15:55','2024-04-16 07:15:55'),(90,'customer_irrespective_of_sell','web','2024-04-16 07:15:55','2024-04-16 07:15:55'),(91,'direct_sell.view','web','2024-04-16 07:15:55','2024-04-16 07:15:55'),(92,'all_expense.access','web','2024-04-16 07:15:55','2024-04-16 07:15:55'),(93,'view_paid_sells_only','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(94,'view_due_sells_only','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(95,'view_partial_sells_only','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(96,'view_overdue_sells_only','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(97,'direct_sell.update','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(98,'edit_sell_payment','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(99,'access_printers','web','2024-04-16 09:24:59','2024-04-16 09:24:59');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
INSERT INTO `printers` VALUES (1,1,'TVS RECEIPT PRINTER','windows','default','60','','','COM1',1,'2022-10-20 16:02:33','2022-11-19 10:44:22');
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(93,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(126,1),(127,1),(128,1),(129,1),(130,1),(131,1),(132,1),(133,1),(134,1),(135,1),(136,1),(137,1),(138,1),(139,1),(140,1),(141,1),(142,1),(143,1),(144,1),(145,1),(146,1),(147,1),(148,1),(149,1),(150,1),(151,1),(152,1),(153,1),(154,1),(155,1),(156,1),(157,1),(158,1),(159,1),(160,1),(161,1),(162,1),(163,1),(164,1),(165,1),(166,1),(167,1),(168,1),(169,1),(170,1),(171,1),(172,1),(173,1),(174,1),(175,1),(176,1),(177,1),(178,1),(179,1),(180,1),(181,1),(182,1),(183,1),(184,1),(185,1),(186,1),(187,1),(188,1),(189,1),(190,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(201,1),(202,1),(203,1),(204,1),(205,1),(206,1),(207,1),(208,1),(209,1),(210,1),(211,1),(212,1),(213,1),(214,1),(215,1),(216,1),(217,1),(218,1),(219,1),(220,1),(221,1),(222,1),(223,1),(224,1),(225,1),(226,1),(227,1),(228,1),(229,1),(230,1),(231,1),(232,1),(233,1),(234,1),(235,1),(236,1),(237,1),(238,1),(239,1),(240,1),(241,1),(242,1),(243,1),(244,1),(245,1),(246,1),(247,1),(248,1),(249,1),(250,1),(251,1),(252,1),(253,1),(254,1),(255,1),(256,1),(257,1),(258,1),(259,1),(260,1),(261,1),(262,1),(263,1),(264,1),(265,1),(266,1),(267,1),(268,1),(269,1),(270,1),(271,1),(272,1),(273,1),(274,1),(275,1),(276,1),(277,1),(278,1),(279,1),(280,1),(281,1),(282,1),(283,1),(284,1),(285,1),(286,1),(287,1),(288,1),(289,1),(290,1),(291,1),(292,1),(293,1),(294,1),(295,1),(296,1),(297,1),(298,1),(299,1),(300,1),(301,1),(302,1),(303,1),(304,1),(305,1),(306,1),(307,1),(308,1),(309,1),(310,1),(311,1),(312,1),(313,1),(314,1),(315,1),(316,1),(317,1),(318,1),(319,1),(320,1),(321,1),(322,1),(323,1),(324,1),(325,1),(326,1),(327,1),(328,1),(329,1),(330,1),(331,1),(332,1),(333,1),(334,1),(335,1),(336,1),(337,1),(338,1),(339,1),(340,1),(341,1),(342,1),(343,1),(344,1),(345,1),(346,1),(347,1),(348,1),(349,1),(350,1),(351,1),(352,1),(353,1),(354,1),(355,1),(356,1),(357,1),(358,1),(359,1),(360,1),(361,1),(362,1),(363,1),(364,1),(365,1),(366,1),(367,1),(368,1),(369,1),(370,1),(371,1),(372,1),(373,1),(374,1),(375,1),(376,1),(377,1),(378,1),(379,1),(380,1),(381,1),(382,1),(383,1),(384,1),(385,1),(386,1),(387,1),(388,1),(389,1),(390,1),(391,1),(392,1),(393,1),(394,1),(395,1),(396,1),(397,1),(398,1),(399,1),(400,1),(401,1),(402,1),(403,1),(404,1),(405,1),(406,1),(407,1),(408,1),(409,1),(410,1),(411,1),(412,1),(413,1),(414,1),(415,1),(416,1),(417,1),(418,1),(419,1),(420,1),(421,1),(422,1),(423,1),(424,1),(425,1),(426,1),(427,1),(428,1),(429,1),(430,1),(431,1),(432,1),(433,1),(434,1),(435,1),(436,1),(437,1),(438,1),(439,1),(440,1),(441,1),(442,1),(443,1),(444,1),(445,1),(446,1),(447,1),(448,1),(449,1),(450,1),(451,1),(452,1),(453,1),(454,1),(455,1),(456,1),(457,1),(458,1),(459,1),(460,1),(461,1),(462,1),(463,1),(464,1),(465,1),(466,1),(467,1),(468,1),(469,1),(470,1),(471,1),(472,1),(473,1),(474,1),(475,1),(476,1),(477,1),(478,1),(479,1),(480,1),(481,1),(482,1),(483,1),(484,1),(485,1),(486,1),(487,1),(488,1),(489,1),(490,1),(491,1),(492,1),(493,1),(494,1),(495,1),(496,1),(497,1),(498,1),(499,1),(500,1),(501,1),(502,1),(503,1),(504,1),(505,1),(506,1),(507,1),(508,1),(509,1),(510,1),(511,1),(512,1),(513,1),(514,1),(515,1),(516,1),(517,1),(518,1),(519,1),(520,1),(521,1),(522,1),(523,1),(524,1),(525,1),(526,1),(527,1),(528,1),(529,1),(530,1),(531,1),(532,1),(533,1),(534,1),(535,1),(536,1),(537,1),(538,1),(539,1),(540,1),(541,1),(542,1),(543,1),(544,1),(545,1),(546,1),(547,1),(548,1),(549,1),(550,1),(551,1),(552,1),(553,1),(554,1),(555,1),(556,1),(557,1),(558,1),(559,1),(560,1),(561,1),(562,1),(563,1),(564,1),(565,1),(566,1),(567,1),(568,1),(569,1),(570,1),(571,1),(572,1),(573,1),(574,1),(575,1),(576,1),(577,1),(578,1),(579,1),(580,1),(581,1),(582,1),(583,1),(584,1),(585,1),(586,1),(587,1),(588,1),(589,1),(590,1),(591,1),(592,1),(593,1),(594,1),(595,1),(596,1),(597,1),(598,1),(599,1),(600,1),(601,1),(602,1),(603,1),(604,1),(605,1),(606,1),(607,1),(608,1),(609,1),(610,1),(611,1),(612,1),(613,1),(614,1),(615,1),(616,1),(617,1),(618,1),(619,1),(620,1),(621,1),(622,1),(623,1),(624,1),(625,1),(626,1),(627,1),(628,1),(629,1),(630,1),(631,1),(632,1),(633,1),(634,1),(635,1),(636,1),(637,1),(638,1),(639,1),(640,1),(641,1),(642,1),(643,1),(644,1),(645,1),(646,1),(647,1),(648,1),(649,1),(650,1),(651,1),(652,1),(653,1),(654,1),(655,1),(656,1),(657,1),(658,1),(659,1),(660,1),(661,1),(662,1),(663,1),(664,1),(665,1),(666,1),(667,1),(668,1),(669,1),(670,1),(671,1),(672,1),(673,1),(674,1),(675,1),(676,1),(677,1),(678,1),(679,1),(680,1),(681,1),(682,1),(683,1),(684,1),(685,1),(686,1),(687,1),(688,1),(689,1),(690,1),(691,1),(692,1),(693,1),(694,1),(695,1),(696,1),(697,1),(698,1),(699,1),(700,1),(701,1),(702,1),(703,1),(704,1),(705,1),(706,1),(707,1),(708,1),(709,1),(710,1),(711,1),(712,1),(713,1),(714,1),(715,1),(716,1),(717,1),(718,1),(719,1),(720,1),(721,1),(722,1),(723,1),(724,1),(725,1),(726,1),(727,1),(728,1),(729,1),(730,1),(731,1),(732,1),(733,1),(734,1),(735,1),(736,1),(737,1),(738,1),(739,1),(740,1),(741,1),(742,1),(743,1),(744,1),(745,1),(746,1),(747,1),(748,1),(749,1),(750,1),(751,1),(752,1),(753,1),(754,1),(755,1),(756,1),(757,1),(758,1),(759,1),(760,1),(761,1),(762,1),(763,1),(764,1),(765,1),(766,1),(767,1),(768,1),(769,1),(770,1),(771,1),(772,1),(773,1),(774,1),(775,1),(776,1),(777,1),(778,1),(779,1),(780,1),(781,1),(782,1),(783,1),(784,1),(785,1),(786,1),(787,1),(788,1),(789,1),(790,1),(791,1),(792,1),(793,1),(794,1),(795,1),(796,1),(797,1),(798,1),(799,1),(800,1),(801,1),(802,1),(803,1),(804,1),(805,1),(806,1),(807,1),(808,1),(809,1),(810,1),(811,1),(812,1),(813,1),(814,1),(815,1),(816,1),(817,1),(818,1),(819,1),(820,1),(821,1),(822,1),(823,1),(824,1),(825,1),(826,1),(827,1),(828,1),(829,1),(830,1),(831,1),(832,1),(833,1),(834,1),(835,1),(836,1),(837,1),(838,1),(839,1),(840,1),(841,1),(842,1),(843,1),(844,1),(845,1),(846,1),(847,1),(848,1),(849,1),(850,1),(851,1),(852,1),(853,1),(854,1),(855,1),(856,1),(857,1),(858,1),(859,1),(860,1),(861,1),(862,1),(863,1),(864,1),(865,1),(866,1),(867,1),(868,1),(869,1),(870,1),(871,1),(872,1),(873,1),(874,1),(875,1),(876,1),(877,1),(878,1),(879,1),(880,1),(881,1),(882,1),(883,1),(884,1),(885,1),(886,1),(887,1),(888,1),(889,1),(890,1),(891,1),(892,1),(893,1),(894,1),(895,1),(896,1),(897,1),(898,1),(899,1),(900,1),(901,1),(902,1),(903,1),(904,1),(905,1),(906,1),(907,1),(908,1),(909,1),(910,1),(911,1),(912,1),(913,1),(914,1),(915,1),(916,1),(917,1),(918,1),(919,1),(920,1),(921,1),(922,1),(923,1),(924,1),(925,1),(926,1),(927,1),(928,1),(929,1),(930,1),(931,1),(932,1),(933,1),(934,1),(935,1),(936,1),(937,1),(938,1),(939,1),(940,1),(941,1),(942,1),(943,1),(944,1),(945,1),(946,1),(947,1),(948,1),(949,1),(950,1),(951,1),(952,1),(953,1),(954,1),(955,1),(956,1),(957,1),(958,1),(959,1),(960,1),(961,1),(962,1),(963,1),(964,1),(965,1),(966,1),(967,1),(968,1),(969,1),(970,1),(971,1),(972,1),(973,1),(974,1),(975,1),(976,1),(977,1),(978,1),(979,1),(980,1),(981,1),(982,1),(983,1),(984,1),(985,1),(986,1),(987,1),(988,1),(989,1),(990,1),(991,1),(992,1),(993,1),(994,1),(995,1),(996,1),(997,1),(998,1),(999,1),(1000,1),(1001,1),(1002,1),(1003,1),(1004,1),(1005,1),(1006,1),(1007,1),(1008,1),(1009,1),(1010,1),(1011,1),(1012,1),(1013,1),(1014,1),(1015,1),(1016,1),(1017,1),(1018,1),(1019,1),(1020,1),(1021,1),(1022,1),(1023,1),(1024,1),(1025,1),(1026,1),(1027,1),(1028,1),(1029,1),(1030,1),(1031,1),(1032,1),(1033,1),(1034,1),(1035,1),(1036,1),(1037,1),(1038,1),(1039,1),(1040,1),(1041,1),(1042,1),(1043,1),(1044,1),(1045,1),(1046,1),(1047,1),(1048,1),(1049,1),(1050,1),(1051,1),(1052,1),(1053,1),(1054,1),(1055,1),(1056,1),(1057,1),(1058,1),(1059,1),(1060,1),(1061,1),(1062,1),(1063,1),(1064,1),(1065,1),(1066,1),(1067,1),(1068,1),(1069,1),(1070,1),(1071,1),(1072,1),(1073,1),(1074,1),(1075,1),(1076,1),(1077,1),(1078,1),(1079,1),(1080,1),(1081,1),(1082,1),(1083,1),(1084,1),(1085,1),(1086,1),(1087,1),(1088,1),(1089,1),(1090,1),(1091,1),(1092,1),(1093,1),(1094,1),(1095,1),(1096,1),(1097,1),(1098,1),(1099,1),(1100,1),(1101,1),(1102,1),(1103,1),(1104,1),(1105,1),(1106,1),(1107,1),(1108,1),(1109,1),(1110,1),(1111,1),(1112,1),(1113,1),(1114,1),(1115,1),(1116,1),(1117,1),(1118,1),(1119,1),(1120,1),(1121,1),(1122,1),(1123,1),(1124,1),(1125,1),(1126,1),(1127,1),(1128,1),(1129,1),(1130,1),(1131,1),(1132,1),(1133,1),(1134,1),(1135,1),(1136,1),(1137,1),(1138,1),(1139,1),(1140,1),(1141,1),(1142,1),(1143,1),(1144,1),(1145,1),(1146,1),(1147,1),(1148,1),(1149,1),(1150,1),(1151,1),(1152,1),(1153,1),(1154,1),(1155,1),(1156,1),(1157,1),(1158,1),(1159,1),(1160,1),(1161,1),(1162,1),(1163,1),(1164,1),(1165,1),(1166,1),(1167,1),(1168,1),(1169,1),(1170,1),(1171,1),(1172,1),(1173,1),(1174,1),(1175,1),(1176,1),(1177,1),(1178,1),(1179,1),(1180,1),(1181,1),(1182,1),(1183,1),(1184,1),(1185,1),(1186,1),(1187,1),(1188,1),(1189,1),(1190,1),(1191,1),(1192,1),(1193,1),(1194,1),(1195,1),(1196,1),(1197,1),(1198,1),(1199,1),(1200,1),(1201,1),(1202,1),(1203,1),(1204,1),(1205,1),(1206,1),(1207,1),(1208,1),(1209,1),(1210,1),(1211,1),(1212,1),(1213,1),(1214,1),(1215,1),(1216,1),(1217,1),(1218,1),(1219,1),(1220,1),(1221,1),(1222,1),(1223,1),(1224,1),(1225,1),(1226,1),(1227,1),(1228,1),(1229,1),(1230,1),(1231,1),(1232,1),(1233,1),(1234,1),(1235,1),(1236,1),(1237,1),(1238,1),(1239,1),(1240,1),(1241,1),(1242,1),(1243,1),(1244,1),(1245,1),(1246,1),(1247,1),(1248,1),(1249,1),(1250,1),(1251,1),(1252,1),(1253,1),(1254,1),(1255,1),(1256,1),(1257,1),(1258,1),(1259,1),(1260,1),(1261,1),(1262,1),(1263,1),(1264,1),(1265,1),(1266,1),(1267,1),(1268,1),(1269,1),(1270,1),(1271,1),(1272,1),(1273,1),(1274,1),(1275,1),(1276,1),(1277,1),(1278,1),(1279,1),(1280,1),(1281,1),(1282,1),(1283,1),(1284,1),(1285,1),(1286,1),(1287,1),(1288,1),(1289,1),(1290,1),(1291,1),(1292,1),(1293,1),(1294,1),(1295,1),(1296,1),(1297,1),(1298,1),(1299,1),(1300,1),(1301,1),(1302,1),(1303,1),(1304,1),(1305,1),(1306,1),(1307,1),(1308,1),(1309,1),(1310,1),(1311,1),(1312,1),(1313,1),(1314,1),(1315,1),(1316,1),(1317,1),(1318,1),(1319,1),(1320,1),(1321,1),(1322,1),(1323,1),(1324,1),(1325,1),(1326,1),(1327,1),(1328,1),(1329,1),(1330,1),(1331,1),(1332,1),(1333,1),(1334,1),(1335,1),(1336,1),(1337,1),(1338,1),(1339,1),(1340,1),(1341,1),(1342,1),(1343,1),(1344,1),(1345,1),(1346,1),(1347,1),(1348,1),(1349,1),(1350,1),(1351,1),(1352,1),(1353,1),(1354,1),(1355,1),(1356,1),(1357,1),(1358,1),(1359,1),(1360,1),(1361,1),(1362,1),(1363,1),(1364,1),(1365,1),(1366,1),(1367,1),(1368,1),(1369,1),(1370,1),(1371,1),(1372,1),(1373,1),(1374,1),(1375,1),(1376,1),(1377,1),(1378,1),(1379,1),(1380,1),(1381,1),(1382,1),(1383,1),(1384,1),(1385,1),(1386,1),(1387,1),(1388,1),(1389,1),(1390,1),(1391,1),(1392,1),(1393,1),(1394,1),(1395,1),(1396,1),(1397,1),(1398,1),(1399,1),(1400,1),(1401,1),(1402,1),(1403,1),(1404,1),(1405,1),(1406,1),(1407,1),(1408,1),(1409,1),(1410,1),(1411,1),(1412,1),(1413,1),(1414,1),(1415,1),(1416,1),(1417,1),(1418,1),(1419,1),(1420,1),(1421,1),(1422,1),(1423,1),(1424,1),(1425,1),(1426,1),(1427,1),(1428,1),(1429,1),(1430,1),(1431,1),(1432,1),(1433,1),(1434,1),(1435,1),(1436,1),(1437,1),(1438,1),(1439,1),(1440,1),(1441,1),(1442,1),(1443,1),(1444,1),(1445,1),(1446,1),(1447,1),(1448,1),(1449,1),(1450,1),(1451,1),(1452,1),(1453,1),(1454,1),(1455,1),(1456,1),(1457,1),(1458,1),(1459,1),(1460,1),(1461,1),(1462,1),(1463,1),(1464,1),(1465,1),(1466,1),(1467,1),(1468,1),(1469,1),(1470,1),(1471,1),(1472,1),(1473,1),(1474,1),(1475,1),(1476,1),(1477,1),(1478,1),(1479,1),(1480,1),(1481,1),(1482,1),(1483,1),(1484,1),(1485,1),(1486,1),(1487,1),(1488,1),(1489,1),(1490,1),(1491,1),(1492,1),(1493,1),(1494,1),(1495,1),(1496,1),(1497,1),(1498,1),(1499,1),(1500,1),(1501,1),(1502,1),(1503,1),(1504,1),(1505,1),(1506,1),(1507,1),(1508,1),(1509,1),(1510,1),(1511,1),(1512,1),(1513,1),(1514,1),(1515,1),(1516,1),(1517,1),(1518,1),(1519,1),(1520,1),(1521,1),(1522,1),(1523,1),(1524,1),(1525,1),(1526,1),(1527,1),(1528,1),(1529,1),(1530,1),(1531,1),(1532,1),(1533,1),(1534,1),(1535,1),(1536,1),(1537,1),(1538,1),(1539,1),(1540,1),(1541,1),(1542,1),(1543,1),(1544,1),(1545,1),(1546,1),(1547,1),(1548,1),(1549,1),(1550,1),(1551,1),(1552,1),(1553,1),(1554,1),(1555,1),(1556,1),(1557,1),(1558,1),(1559,1),(1560,1),(1561,1),(1562,1),(1563,1),(1564,1),(1565,1),(1566,1),(1567,1),(1568,1),(1569,1),(1570,1),(1571,1),(1572,1),(1573,1),(1574,1),(1575,1),(1576,1),(1577,1),(1578,1),(1579,1),(1580,1),(1581,1),(1582,1),(1583,1),(1584,1),(1585,1),(1586,1),(1587,1),(1588,1),(1589,1),(1590,1),(1591,1),(1592,1),(1593,1),(1594,1),(1595,1),(1596,1),(1597,1),(1598,1),(1599,1),(1600,1),(1601,1),(1602,1),(1603,1),(1604,1),(1605,1);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=292 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
INSERT INTO `product_racks` VALUES (1,1,1,19,NULL,NULL,NULL,'2025-01-29 13:57:37','2025-01-29 13:57:37'),(2,1,1,8,NULL,NULL,NULL,'2025-01-29 14:35:38','2025-01-29 14:35:38'),(3,1,1,65,NULL,NULL,NULL,'2025-01-31 10:15:01','2025-01-31 10:17:37'),(4,1,1,66,NULL,NULL,NULL,'2025-01-31 10:15:53','2025-02-03 03:07:03'),(5,1,1,60,NULL,NULL,NULL,'2025-01-31 10:44:49','2025-01-31 10:44:49'),(6,1,1,61,NULL,NULL,NULL,'2025-01-31 10:45:15','2025-01-31 10:45:15'),(7,1,1,64,NULL,NULL,NULL,'2025-01-31 10:47:22','2025-01-31 10:47:22'),(8,1,1,62,NULL,NULL,NULL,'2025-01-31 10:47:47','2025-01-31 10:47:47'),(9,1,1,63,NULL,NULL,NULL,'2025-01-31 10:48:16','2025-01-31 10:48:16'),(10,1,1,25,NULL,NULL,NULL,'2025-01-31 10:51:40','2025-01-31 10:51:40'),(11,1,1,23,NULL,NULL,NULL,'2025-01-31 10:52:33','2025-01-31 10:52:33'),(12,1,1,24,NULL,NULL,NULL,'2025-01-31 10:53:10','2025-01-31 10:53:10'),(13,1,1,67,NULL,NULL,NULL,'2025-01-31 12:20:16','2025-01-31 12:20:16'),(14,1,1,68,NULL,NULL,NULL,'2025-01-31 12:21:22','2025-01-31 12:21:22'),(15,1,1,69,NULL,NULL,NULL,'2025-01-31 12:22:00','2025-01-31 12:22:00'),(16,1,1,70,NULL,NULL,NULL,'2025-01-31 13:19:44','2025-01-31 18:08:25'),(17,1,1,71,NULL,NULL,NULL,'2025-01-31 13:20:58','2025-01-31 18:09:36'),(18,1,1,72,NULL,NULL,NULL,'2025-01-31 13:23:57','2025-01-31 18:09:01'),(19,1,1,73,NULL,NULL,NULL,'2025-01-31 13:53:28','2025-01-31 13:53:28'),(20,1,1,74,NULL,NULL,NULL,'2025-01-31 13:54:22','2025-01-31 13:54:22'),(21,1,1,75,NULL,NULL,NULL,'2025-01-31 13:56:19','2025-01-31 13:56:19'),(22,1,1,76,NULL,NULL,NULL,'2025-01-31 13:56:53','2025-01-31 13:56:53'),(23,1,1,77,NULL,NULL,NULL,'2025-01-31 13:58:58','2025-01-31 13:58:58'),(24,1,1,78,NULL,NULL,NULL,'2025-01-31 13:59:27','2025-01-31 13:59:27'),(25,1,1,79,NULL,NULL,NULL,'2025-01-31 14:03:12','2025-01-31 14:03:12'),(26,1,1,80,NULL,NULL,NULL,'2025-01-31 14:03:52','2025-01-31 14:03:52'),(27,1,1,81,NULL,NULL,NULL,'2025-01-31 14:06:31','2025-01-31 14:06:31'),(28,1,1,82,NULL,NULL,NULL,'2025-01-31 14:07:21','2025-01-31 14:07:21'),(29,1,1,56,NULL,NULL,NULL,'2025-01-31 14:51:28','2025-01-31 14:51:28'),(30,1,1,54,NULL,NULL,NULL,'2025-01-31 14:51:53','2025-01-31 14:51:53'),(31,1,1,55,NULL,NULL,NULL,'2025-01-31 14:52:43','2025-01-31 14:52:43'),(32,1,1,39,NULL,NULL,NULL,'2025-01-31 14:57:59','2025-01-31 14:57:59'),(33,1,1,40,NULL,NULL,NULL,'2025-01-31 14:58:23','2025-01-31 14:58:23'),(34,1,1,41,NULL,NULL,NULL,'2025-01-31 14:58:50','2025-01-31 14:58:50'),(35,1,1,42,NULL,NULL,NULL,'2025-01-31 15:07:14','2025-01-31 15:07:14'),(36,1,1,43,NULL,NULL,NULL,'2025-01-31 15:07:36','2025-01-31 15:07:36'),(37,1,1,44,NULL,NULL,NULL,'2025-01-31 15:08:19','2025-01-31 15:08:19'),(38,1,1,45,NULL,NULL,NULL,'2025-01-31 15:09:12','2025-01-31 15:09:12'),(39,1,1,31,NULL,NULL,NULL,'2025-01-31 15:19:29','2025-01-31 15:19:29'),(40,1,1,30,NULL,NULL,NULL,'2025-01-31 15:19:46','2025-01-31 15:19:46'),(41,1,1,46,NULL,NULL,NULL,'2025-01-31 15:21:36','2025-01-31 15:21:36'),(42,1,1,47,NULL,NULL,NULL,'2025-01-31 15:22:10','2025-01-31 15:22:10'),(43,1,1,83,NULL,NULL,NULL,'2025-02-01 06:58:51','2025-02-01 09:46:43'),(44,1,1,84,NULL,NULL,NULL,'2025-02-01 06:59:23','2025-02-01 09:48:58'),(45,1,1,85,NULL,NULL,NULL,'2025-02-01 07:00:12','2025-02-01 09:47:50'),(46,1,1,86,NULL,NULL,NULL,'2025-02-01 07:00:36','2025-02-01 09:48:22'),(47,1,1,87,NULL,NULL,NULL,'2025-02-01 07:00:56','2025-02-01 09:47:11'),(48,1,1,88,NULL,NULL,NULL,'2025-02-01 07:01:16','2025-02-01 09:49:29'),(49,1,1,21,NULL,NULL,NULL,'2025-02-01 09:52:12','2025-02-01 09:52:12'),(50,1,1,22,NULL,NULL,NULL,'2025-02-01 09:52:35','2025-02-01 09:52:35'),(51,1,1,20,NULL,NULL,NULL,'2025-02-01 09:52:56','2025-02-01 09:52:56'),(52,1,1,29,NULL,NULL,NULL,'2025-02-01 09:53:27','2025-02-01 09:53:27'),(53,1,1,26,NULL,NULL,NULL,'2025-02-01 09:54:00','2025-02-01 09:54:00'),(54,1,1,27,NULL,NULL,NULL,'2025-02-01 09:54:25','2025-02-01 09:54:25'),(55,1,1,28,NULL,NULL,NULL,'2025-02-01 09:54:50','2025-02-01 09:54:50'),(56,1,1,95,NULL,NULL,NULL,'2025-02-01 10:10:32','2025-02-01 10:10:32'),(57,1,1,229,NULL,NULL,NULL,'2025-02-01 12:36:21','2025-02-01 12:36:21'),(58,1,1,230,NULL,NULL,NULL,'2025-02-01 12:37:28','2025-02-01 12:37:28'),(59,1,1,231,NULL,NULL,NULL,'2025-02-01 14:29:32','2025-02-01 14:30:23'),(60,1,1,232,NULL,NULL,NULL,'2025-02-01 14:31:40','2025-02-01 14:32:14'),(61,1,1,233,NULL,NULL,NULL,'2025-02-01 14:35:06','2025-02-01 14:35:06'),(62,1,1,234,NULL,NULL,NULL,'2025-02-01 14:36:18','2025-02-01 14:36:18'),(63,1,1,235,NULL,NULL,NULL,'2025-02-01 14:37:45','2025-02-01 14:37:45'),(64,1,1,236,NULL,NULL,NULL,'2025-02-01 14:43:37','2025-02-01 14:45:04'),(65,1,1,237,NULL,NULL,NULL,'2025-02-01 14:44:10','2025-02-03 03:00:47'),(66,1,1,238,NULL,NULL,NULL,'2025-02-01 14:44:43','2025-02-01 14:44:43'),(67,1,1,239,NULL,NULL,NULL,'2025-02-01 14:49:52','2025-02-01 14:49:52'),(68,1,1,240,NULL,NULL,NULL,'2025-02-01 14:50:26','2025-02-01 14:50:26'),(69,1,1,241,NULL,NULL,NULL,'2025-02-01 14:50:48','2025-02-01 14:50:48'),(70,1,1,242,NULL,NULL,NULL,'2025-02-01 14:53:40','2025-02-01 14:54:31'),(71,1,1,243,NULL,NULL,NULL,'2025-02-01 14:54:02','2025-02-01 14:54:02'),(72,1,1,244,NULL,NULL,NULL,'2025-02-01 14:57:17','2025-02-01 14:57:17'),(73,1,1,245,NULL,NULL,NULL,'2025-02-01 14:57:53','2025-02-01 14:57:53'),(74,1,1,246,NULL,NULL,NULL,'2025-02-01 14:58:17','2025-02-01 14:58:17'),(75,1,1,247,NULL,NULL,NULL,'2025-02-01 15:04:27','2025-02-01 15:04:27'),(76,1,1,248,NULL,NULL,NULL,'2025-02-01 15:04:51','2025-02-01 15:04:51'),(77,1,1,249,NULL,NULL,NULL,'2025-02-01 15:05:25','2025-02-01 15:05:25'),(78,1,1,250,NULL,NULL,NULL,'2025-02-01 15:08:32','2025-02-01 15:08:32'),(79,1,1,251,NULL,NULL,NULL,'2025-02-01 15:08:57','2025-02-01 15:08:57'),(80,1,1,252,NULL,NULL,NULL,'2025-02-01 15:09:28','2025-02-01 15:09:28'),(81,1,1,253,NULL,NULL,NULL,'2025-02-01 16:42:45','2025-02-02 04:01:46'),(82,1,1,254,NULL,NULL,NULL,'2025-02-01 16:45:49','2025-02-01 16:45:49'),(83,1,1,255,NULL,NULL,NULL,'2025-02-01 16:46:50','2025-02-01 16:46:50'),(84,1,1,256,NULL,NULL,NULL,'2025-02-01 17:07:27','2025-02-01 17:07:27'),(85,1,1,648,NULL,NULL,NULL,'2025-02-01 19:03:16','2025-02-01 19:03:16'),(86,1,1,649,NULL,NULL,NULL,'2025-02-01 19:03:38','2025-02-01 19:03:38'),(87,1,1,650,NULL,NULL,NULL,'2025-02-01 19:03:59','2025-02-01 19:03:59'),(88,1,1,651,NULL,NULL,NULL,'2025-02-01 19:04:30','2025-02-01 19:04:30'),(89,1,1,652,NULL,NULL,NULL,'2025-02-01 19:04:54','2025-02-02 12:05:14'),(90,1,1,653,NULL,NULL,NULL,'2025-02-01 19:05:15','2025-02-01 19:05:15'),(91,1,1,815,NULL,NULL,NULL,'2025-02-01 19:25:53','2025-02-01 19:26:21'),(92,1,1,816,NULL,NULL,NULL,'2025-02-01 19:26:58','2025-02-01 19:26:58'),(93,1,1,1350,NULL,NULL,NULL,'2025-02-02 00:11:26','2025-02-02 00:11:26'),(94,1,1,1351,NULL,NULL,NULL,'2025-02-02 00:12:10','2025-02-02 00:14:01'),(95,1,1,1352,NULL,NULL,NULL,'2025-02-02 00:19:56','2025-02-02 06:05:19'),(96,1,1,1507,NULL,NULL,NULL,'2025-02-02 01:20:07','2025-02-02 01:20:45'),(97,1,1,194,NULL,NULL,NULL,'2025-02-02 03:00:30','2025-02-02 03:00:30'),(98,1,1,727,NULL,NULL,NULL,'2025-02-02 03:03:20','2025-02-02 03:03:20'),(99,1,1,1509,NULL,NULL,NULL,'2025-02-02 03:08:14','2025-02-02 03:08:14'),(100,1,1,1510,NULL,NULL,NULL,'2025-02-02 03:34:17','2025-02-02 03:34:17'),(101,1,1,192,NULL,NULL,NULL,'2025-02-02 03:43:03','2025-02-02 03:43:03'),(102,1,1,1511,NULL,NULL,NULL,'2025-02-02 03:46:56','2025-02-02 03:46:56'),(103,1,1,1512,NULL,NULL,NULL,'2025-02-02 04:09:37','2025-02-02 04:09:37'),(104,1,1,1525,NULL,NULL,NULL,'2025-02-02 04:52:37','2025-02-02 04:52:37'),(105,1,1,1526,NULL,NULL,NULL,'2025-02-02 04:55:42','2025-02-02 04:55:42'),(106,1,1,1527,NULL,NULL,NULL,'2025-02-02 04:57:47','2025-02-02 04:57:47'),(107,1,1,1528,NULL,NULL,NULL,'2025-02-02 04:58:48','2025-02-02 04:58:48'),(108,1,1,1530,NULL,NULL,NULL,'2025-02-02 05:10:02','2025-02-02 05:10:02'),(109,1,1,1042,NULL,NULL,NULL,'2025-02-02 05:16:05','2025-02-02 05:16:05'),(110,1,1,11,NULL,NULL,NULL,'2025-02-02 05:27:02','2025-02-02 05:27:02'),(111,1,1,381,NULL,NULL,NULL,'2025-02-02 06:02:39','2025-02-03 03:28:28'),(112,1,1,1533,NULL,NULL,NULL,'2025-02-02 06:34:42','2025-02-03 02:55:13'),(113,1,1,605,NULL,NULL,NULL,'2025-02-02 06:40:16','2025-02-02 06:40:16'),(114,1,1,1534,NULL,NULL,NULL,'2025-02-02 07:59:04','2025-02-02 08:01:47'),(115,1,1,1535,NULL,NULL,NULL,'2025-02-02 08:01:15','2025-02-02 08:01:15'),(116,1,1,1536,NULL,NULL,NULL,'2025-02-02 09:08:50','2025-02-02 09:08:50'),(117,1,1,1532,NULL,NULL,NULL,'2025-02-02 09:16:42','2025-02-02 09:16:42'),(118,1,1,1537,NULL,NULL,NULL,'2025-02-02 09:26:50','2025-02-02 09:26:50'),(119,1,1,1538,NULL,NULL,NULL,'2025-02-02 09:38:50','2025-02-02 09:38:50'),(120,1,1,1539,NULL,NULL,NULL,'2025-02-02 09:40:04','2025-02-02 09:40:04'),(121,1,1,1540,NULL,NULL,NULL,'2025-02-02 09:41:35','2025-02-02 09:41:35'),(122,1,1,1541,NULL,NULL,NULL,'2025-02-02 09:56:19','2025-02-02 09:56:19'),(123,1,1,1542,NULL,NULL,NULL,'2025-02-02 10:51:48','2025-02-02 10:51:48'),(124,1,1,1543,NULL,NULL,NULL,'2025-02-02 10:53:03','2025-02-02 10:53:03'),(125,1,1,1544,NULL,NULL,NULL,'2025-02-02 11:19:32','2025-02-02 11:19:32'),(126,1,1,1545,NULL,NULL,NULL,'2025-02-02 11:29:03','2025-02-02 11:29:03'),(127,1,1,1546,NULL,NULL,NULL,'2025-02-02 11:54:54','2025-02-02 11:55:29'),(128,1,1,1547,NULL,NULL,NULL,'2025-02-02 12:37:11','2025-02-02 12:37:11'),(129,1,1,1548,NULL,NULL,NULL,'2025-02-02 12:40:49','2025-02-02 12:40:49'),(130,1,1,1549,NULL,NULL,NULL,'2025-02-02 12:41:38','2025-02-02 12:41:38'),(131,1,1,1550,NULL,NULL,NULL,'2025-02-02 12:41:50','2025-02-02 12:41:50'),(132,1,1,35,NULL,NULL,NULL,'2025-02-02 13:06:15','2025-02-02 13:06:15'),(133,1,1,1551,NULL,NULL,NULL,'2025-02-02 13:07:20','2025-02-02 13:07:20'),(134,1,1,1552,NULL,NULL,NULL,'2025-02-02 13:15:41','2025-02-02 13:15:41'),(135,1,1,1553,NULL,NULL,NULL,'2025-02-02 13:17:00','2025-02-02 13:17:00'),(136,1,1,1554,NULL,NULL,NULL,'2025-02-02 13:18:06','2025-02-02 13:18:06'),(137,1,1,1555,NULL,NULL,NULL,'2025-02-02 13:18:09','2025-02-02 13:18:09'),(138,1,1,811,NULL,NULL,NULL,'2025-02-02 13:37:56','2025-02-02 13:37:56'),(139,1,1,1279,NULL,NULL,NULL,'2025-02-02 14:17:30','2025-02-02 14:17:30'),(140,1,1,1557,NULL,NULL,NULL,'2025-02-02 14:24:43','2025-02-02 14:24:43'),(141,1,1,1559,NULL,NULL,NULL,'2025-02-02 14:46:52','2025-02-02 14:46:52'),(142,1,1,1560,NULL,NULL,NULL,'2025-02-02 14:50:29','2025-02-02 14:50:29'),(143,1,1,694,NULL,NULL,NULL,'2025-02-02 15:34:25','2025-02-02 15:34:25'),(144,1,1,1047,NULL,NULL,NULL,'2025-02-03 02:19:32','2025-02-03 04:15:29'),(145,1,1,373,NULL,NULL,NULL,'2025-02-03 02:21:57','2025-02-03 02:21:57'),(146,1,1,370,NULL,NULL,NULL,'2025-02-03 02:23:32','2025-02-03 02:28:14'),(147,1,1,369,NULL,NULL,NULL,'2025-02-03 02:23:57','2025-02-03 02:27:51'),(148,1,1,371,NULL,NULL,NULL,'2025-02-03 02:24:27','2025-02-03 02:28:38'),(149,1,1,388,NULL,NULL,NULL,'2025-02-03 02:24:53','2025-02-03 02:27:24'),(150,1,1,379,NULL,NULL,NULL,'2025-02-03 02:25:28','2025-02-03 02:26:04'),(151,1,1,378,NULL,NULL,NULL,'2025-02-03 02:29:19','2025-02-03 02:29:19'),(152,1,1,376,NULL,NULL,NULL,'2025-02-03 02:29:41','2025-02-03 02:29:41'),(153,1,1,375,NULL,NULL,NULL,'2025-02-03 02:30:11','2025-02-03 02:30:11'),(154,1,1,374,NULL,NULL,NULL,'2025-02-03 02:30:40','2025-02-03 02:30:40'),(155,1,1,372,NULL,NULL,NULL,'2025-02-03 02:31:08','2025-02-03 02:31:28'),(156,1,1,981,NULL,NULL,NULL,'2025-02-03 02:33:18','2025-02-03 02:45:58'),(157,1,1,759,NULL,NULL,NULL,'2025-02-03 03:06:28','2025-02-03 03:06:28'),(158,1,1,1010,NULL,NULL,NULL,'2025-02-03 03:10:31','2025-02-03 03:11:15'),(159,1,1,1173,NULL,NULL,NULL,'2025-02-03 03:10:53','2025-02-03 03:10:53'),(160,1,1,1046,NULL,NULL,NULL,'2025-02-03 03:23:45','2025-02-03 03:23:45'),(161,1,1,1045,NULL,NULL,NULL,'2025-02-03 03:24:21','2025-02-03 03:24:21'),(162,1,1,864,NULL,NULL,NULL,'2025-02-03 03:24:47','2025-02-03 03:24:47'),(163,1,1,382,NULL,NULL,NULL,'2025-02-03 03:30:40','2025-02-03 03:32:47'),(164,1,1,865,NULL,NULL,NULL,'2025-02-03 03:31:33','2025-02-03 03:32:26'),(165,1,1,387,NULL,NULL,NULL,'2025-02-03 03:33:30','2025-02-03 03:33:30'),(166,1,1,386,NULL,NULL,NULL,'2025-02-03 03:35:00','2025-02-03 03:49:54'),(167,1,1,494,NULL,NULL,NULL,'2025-02-03 03:45:55','2025-02-03 03:45:55'),(168,1,1,665,NULL,NULL,NULL,'2025-02-03 03:46:29','2025-02-03 03:46:29'),(169,1,1,10,NULL,NULL,NULL,'2025-02-03 03:46:51','2025-02-03 03:48:04'),(170,1,1,1167,NULL,NULL,NULL,'2025-02-03 03:49:03','2025-02-03 03:49:15'),(171,1,1,368,NULL,NULL,NULL,'2025-02-03 03:50:22','2025-02-03 03:50:47'),(172,1,1,384,NULL,NULL,NULL,'2025-02-03 03:51:34','2025-02-03 03:51:34'),(173,1,1,385,NULL,NULL,NULL,'2025-02-03 03:52:04','2025-02-03 03:52:04'),(174,1,1,383,NULL,NULL,NULL,'2025-02-03 04:14:02','2025-02-03 04:14:02'),(175,1,1,377,NULL,NULL,NULL,'2025-02-03 04:14:52','2025-02-03 04:14:52'),(176,1,1,848,NULL,NULL,NULL,'2025-02-03 04:49:09','2025-02-03 08:51:15'),(177,1,1,673,NULL,NULL,NULL,'2025-02-03 05:46:20','2025-02-03 06:04:55'),(178,1,1,616,NULL,NULL,NULL,'2025-02-03 05:52:04','2025-02-03 05:52:16'),(179,1,1,980,NULL,NULL,NULL,'2025-02-03 05:54:42','2025-02-03 05:54:42'),(180,1,1,678,NULL,NULL,NULL,'2025-02-03 06:00:33','2025-02-03 06:00:33'),(181,1,1,677,NULL,NULL,NULL,'2025-02-03 06:00:56','2025-02-03 06:01:13'),(182,1,1,679,NULL,NULL,NULL,'2025-02-03 06:03:07','2025-02-03 06:03:07'),(183,1,1,674,NULL,NULL,NULL,'2025-02-03 06:03:41','2025-02-03 06:04:01'),(184,1,1,675,NULL,NULL,NULL,'2025-02-03 06:04:14','2025-02-03 06:04:14'),(185,1,1,1376,NULL,NULL,NULL,'2025-02-03 06:06:06','2025-02-03 06:06:31'),(186,1,1,1378,NULL,NULL,NULL,'2025-02-03 06:07:00','2025-02-03 06:07:00'),(187,1,1,1561,NULL,NULL,NULL,'2025-02-03 06:10:52','2025-02-03 06:11:02'),(188,1,1,617,NULL,NULL,NULL,'2025-02-03 06:19:21','2025-02-03 11:01:29'),(189,1,1,555,NULL,NULL,NULL,'2025-02-03 06:36:53','2025-02-03 06:36:53'),(190,1,1,1562,NULL,NULL,NULL,'2025-02-03 06:46:22','2025-02-03 06:46:22'),(191,1,1,601,NULL,NULL,NULL,'2025-02-03 06:48:01','2025-02-03 06:48:01'),(192,1,1,604,NULL,NULL,NULL,'2025-02-03 06:49:03','2025-02-03 06:49:03'),(193,1,1,1203,NULL,NULL,NULL,'2025-02-03 06:49:25','2025-02-03 06:49:25'),(194,1,1,609,NULL,NULL,NULL,'2025-02-03 06:49:57','2025-02-03 06:49:57'),(195,1,1,1206,NULL,NULL,NULL,'2025-02-03 06:50:47','2025-02-03 06:50:47'),(196,1,1,1207,NULL,NULL,NULL,'2025-02-03 06:51:27','2025-02-03 06:51:27'),(197,1,1,606,NULL,NULL,NULL,'2025-02-03 06:51:47','2025-02-03 06:51:47'),(198,1,1,608,NULL,NULL,NULL,'2025-02-03 06:53:08','2025-02-03 06:53:08'),(199,1,1,1563,NULL,NULL,NULL,'2025-02-03 06:55:35','2025-02-03 06:55:35'),(200,1,1,1211,NULL,NULL,NULL,'2025-02-03 06:58:28','2025-02-03 06:58:28'),(201,1,1,1564,NULL,NULL,NULL,'2025-02-03 07:00:26','2025-02-03 07:00:53'),(202,1,1,1210,NULL,NULL,NULL,'2025-02-03 07:02:04','2025-02-03 07:02:04'),(203,1,1,1565,NULL,NULL,NULL,'2025-02-03 07:04:25','2025-02-03 07:21:27'),(204,1,1,1566,NULL,NULL,NULL,'2025-02-03 07:05:27','2025-02-03 07:05:27'),(205,1,1,1208,NULL,NULL,NULL,'2025-02-03 07:08:20','2025-02-03 07:08:20'),(206,1,1,598,NULL,NULL,NULL,'2025-02-03 07:09:07','2025-02-03 07:09:07'),(207,1,1,1567,NULL,NULL,NULL,'2025-02-03 07:11:02','2025-02-03 07:11:02'),(208,1,1,602,NULL,NULL,NULL,'2025-02-03 07:11:52','2025-02-03 07:11:52'),(209,1,1,1568,NULL,NULL,NULL,'2025-02-03 07:13:07','2025-02-03 07:13:26'),(210,1,1,1569,NULL,NULL,NULL,'2025-02-03 07:15:02','2025-02-03 07:19:44'),(211,1,1,603,NULL,NULL,NULL,'2025-02-03 07:15:48','2025-02-03 07:15:48'),(212,1,1,600,NULL,NULL,NULL,'2025-02-03 07:16:13','2025-02-03 07:16:13'),(213,1,1,1570,NULL,NULL,NULL,'2025-02-03 07:17:54','2025-02-03 07:17:54'),(214,1,1,512,NULL,NULL,NULL,'2025-02-03 07:20:50','2025-02-03 07:20:50'),(215,1,1,1571,NULL,NULL,NULL,'2025-02-03 07:23:36','2025-02-03 07:23:36'),(216,1,1,1572,NULL,NULL,NULL,'2025-02-03 07:24:20','2025-02-03 07:24:20'),(217,1,1,1573,NULL,NULL,NULL,'2025-02-03 07:25:38','2025-02-03 07:25:38'),(218,1,1,516,NULL,NULL,NULL,'2025-02-03 07:28:38','2025-02-03 07:28:38'),(219,1,1,1495,NULL,NULL,NULL,'2025-02-03 07:28:58','2025-02-03 07:47:38'),(220,1,1,1497,NULL,NULL,NULL,'2025-02-03 07:29:24','2025-02-03 07:31:36'),(221,1,1,1074,NULL,NULL,NULL,'2025-02-03 07:29:56','2025-02-03 07:29:56'),(222,1,1,1076,NULL,NULL,NULL,'2025-02-03 07:30:16','2025-02-03 07:30:16'),(223,1,1,1075,NULL,NULL,NULL,'2025-02-03 07:30:40','2025-02-03 07:30:40'),(224,1,1,1499,NULL,NULL,NULL,'2025-02-03 07:31:18','2025-02-03 07:31:18'),(225,1,1,1501,NULL,NULL,NULL,'2025-02-03 07:32:22','2025-02-03 07:32:22'),(226,1,1,513,NULL,NULL,NULL,'2025-02-03 07:32:48','2025-02-03 07:32:48'),(227,1,1,514,NULL,NULL,NULL,'2025-02-03 07:45:22','2025-02-03 07:45:22'),(228,1,1,517,NULL,NULL,NULL,'2025-02-03 07:46:26','2025-02-03 07:46:26'),(229,1,1,515,NULL,NULL,NULL,'2025-02-03 07:46:44','2025-02-03 07:46:44'),(230,1,1,1490,NULL,NULL,NULL,'2025-02-03 07:47:11','2025-02-03 07:47:11'),(231,1,1,821,NULL,NULL,NULL,'2025-02-03 07:48:07','2025-02-03 07:48:07'),(232,1,1,1493,NULL,NULL,NULL,'2025-02-03 07:48:35','2025-02-03 07:48:35'),(233,1,1,1489,NULL,NULL,NULL,'2025-02-03 07:49:27','2025-02-03 07:49:27'),(234,1,1,522,NULL,NULL,NULL,'2025-02-03 07:49:57','2025-02-03 07:49:57'),(235,1,1,838,NULL,NULL,NULL,'2025-02-03 07:50:17','2025-02-03 07:50:17'),(236,1,1,834,NULL,NULL,NULL,'2025-02-03 07:50:48','2025-02-03 07:50:48'),(237,1,1,933,NULL,NULL,NULL,'2025-02-03 07:52:53','2025-02-03 07:52:53'),(238,1,1,1574,NULL,NULL,NULL,'2025-02-03 07:53:24','2025-02-03 07:53:24'),(239,1,1,829,NULL,NULL,NULL,'2025-02-03 07:57:42','2025-02-03 07:57:42'),(240,1,1,819,NULL,NULL,NULL,'2025-02-03 08:00:55','2025-02-03 08:00:55'),(241,1,1,1502,NULL,NULL,NULL,'2025-02-03 08:01:16','2025-02-03 08:01:16'),(242,1,1,833,NULL,NULL,NULL,'2025-02-03 08:01:34','2025-02-03 08:01:34'),(243,1,1,225,NULL,NULL,NULL,'2025-02-03 08:02:02','2025-02-03 08:02:02'),(244,1,1,1494,NULL,NULL,NULL,'2025-02-03 08:02:23','2025-02-03 08:02:23'),(245,1,1,1034,NULL,NULL,NULL,'2025-02-03 08:02:50','2025-02-03 08:02:50'),(246,1,1,1488,NULL,NULL,NULL,'2025-02-03 08:03:11','2025-02-03 08:03:11'),(247,1,1,837,NULL,NULL,NULL,'2025-02-03 08:03:34','2025-02-03 08:03:34'),(248,1,1,1575,NULL,NULL,NULL,'2025-02-03 08:23:43','2025-02-03 08:23:43'),(249,1,1,1576,NULL,NULL,NULL,'2025-02-03 08:24:36','2025-02-03 08:24:36'),(250,1,1,1577,NULL,NULL,NULL,'2025-02-03 08:25:00','2025-02-03 08:25:00'),(251,1,1,836,NULL,NULL,NULL,'2025-02-03 08:33:36','2025-02-03 08:33:36'),(252,1,1,223,NULL,NULL,NULL,'2025-02-03 08:34:16','2025-02-03 08:34:16'),(253,1,1,1473,NULL,NULL,NULL,'2025-02-03 08:34:30','2025-02-03 08:34:30'),(254,1,1,222,NULL,NULL,NULL,'2025-02-03 08:34:54','2025-02-03 08:34:54'),(255,1,1,835,NULL,NULL,NULL,'2025-02-03 08:35:13','2025-02-03 08:35:13'),(256,1,1,828,NULL,NULL,NULL,'2025-02-03 08:35:35','2025-02-03 08:35:35'),(257,1,1,1335,NULL,NULL,NULL,'2025-02-03 08:38:22','2025-02-03 08:38:22'),(258,1,1,1482,NULL,NULL,NULL,'2025-02-03 08:38:50','2025-02-03 08:38:50'),(259,1,1,839,NULL,NULL,NULL,'2025-02-03 08:45:32','2025-02-03 08:45:32'),(260,1,1,854,NULL,NULL,NULL,'2025-02-03 08:50:59','2025-02-03 08:50:59'),(261,1,1,822,NULL,NULL,NULL,'2025-02-03 09:09:14','2025-02-03 09:09:14'),(262,1,1,224,NULL,NULL,NULL,'2025-02-03 09:14:37','2025-02-03 09:14:37'),(263,1,1,1483,NULL,NULL,NULL,'2025-02-03 09:15:06','2025-02-03 09:15:29'),(264,1,1,1028,NULL,NULL,NULL,'2025-02-03 09:15:52','2025-02-03 09:15:52'),(265,1,1,1475,NULL,NULL,NULL,'2025-02-03 09:16:38','2025-02-03 09:16:38'),(266,1,1,1476,NULL,NULL,NULL,'2025-02-03 09:17:27','2025-02-03 09:17:27'),(267,1,1,1492,NULL,NULL,NULL,'2025-02-03 09:17:44','2025-02-03 09:17:44'),(268,1,1,1487,NULL,NULL,NULL,'2025-02-03 09:18:01','2025-02-03 09:18:01'),(269,1,1,1474,NULL,NULL,NULL,'2025-02-03 09:18:38','2025-02-03 09:18:38'),(270,1,1,218,NULL,NULL,NULL,'2025-02-03 09:19:21','2025-02-03 09:19:21'),(271,1,1,1031,NULL,NULL,NULL,'2025-02-03 09:19:37','2025-02-03 09:19:37'),(272,1,1,464,NULL,NULL,NULL,'2025-02-03 10:19:50','2025-02-03 10:19:50'),(273,1,1,755,NULL,NULL,NULL,'2025-02-03 11:08:19','2025-02-03 11:08:19'),(274,1,1,334,NULL,NULL,NULL,'2025-02-03 11:08:36','2025-02-03 11:08:36'),(275,1,1,1601,NULL,NULL,NULL,'2025-02-03 11:20:14','2025-02-03 11:20:14'),(276,1,1,354,NULL,NULL,NULL,'2025-02-03 11:21:03','2025-02-03 11:21:03'),(277,1,1,336,NULL,NULL,NULL,'2025-02-03 11:21:24','2025-02-03 11:21:24'),(278,1,1,756,NULL,NULL,NULL,'2025-02-03 11:21:55','2025-02-03 11:21:55'),(279,1,1,747,NULL,NULL,NULL,'2025-02-03 11:22:46','2025-02-03 11:22:46'),(280,1,1,335,NULL,NULL,NULL,'2025-02-03 11:23:01','2025-02-03 11:23:01'),(281,1,1,342,NULL,NULL,NULL,'2025-02-03 11:23:28','2025-02-03 11:23:28'),(282,1,1,344,NULL,NULL,NULL,'2025-02-03 11:24:17','2025-02-03 11:24:17'),(283,1,1,341,NULL,NULL,NULL,'2025-02-03 11:24:51','2025-02-03 11:24:51'),(284,1,1,337,NULL,NULL,NULL,'2025-02-03 11:25:16','2025-02-03 11:25:16'),(285,1,1,339,NULL,NULL,NULL,'2025-02-03 11:52:42','2025-02-03 11:52:42'),(286,1,1,748,NULL,NULL,NULL,'2025-02-03 11:55:35','2025-02-03 11:55:35'),(287,1,1,1051,NULL,NULL,NULL,'2025-02-03 11:59:21','2025-02-03 11:59:58'),(288,1,1,1602,NULL,NULL,NULL,'2025-02-03 12:07:16','2025-02-03 12:07:16'),(289,1,1,1603,NULL,NULL,NULL,'2025-02-03 12:09:12','2025-02-03 12:09:12'),(290,1,1,1604,NULL,NULL,NULL,'2025-02-03 12:11:16','2025-02-03 12:11:16'),(291,1,1,1605,NULL,NULL,NULL,'2025-02-03 12:13:26','2025-02-03 12:13:26');
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1606 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(2,NULL,'DUMMY',2,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(3,NULL,'DUMMY',3,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(4,NULL,'DUMMY',4,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(5,NULL,'DUMMY',5,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(6,NULL,'DUMMY',6,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(7,NULL,'DUMMY',7,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(8,NULL,'DUMMY',8,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(9,NULL,'DUMMY',9,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(10,NULL,'DUMMY',10,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(11,NULL,'DUMMY',11,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(12,NULL,'DUMMY',12,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(13,NULL,'DUMMY',13,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(14,NULL,'DUMMY',14,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(15,NULL,'DUMMY',15,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(16,NULL,'DUMMY',16,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(17,NULL,'DUMMY',17,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(18,NULL,'DUMMY',18,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(19,NULL,'DUMMY',19,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(20,NULL,'DUMMY',20,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(21,NULL,'DUMMY',21,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(22,NULL,'DUMMY',22,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(23,NULL,'DUMMY',23,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(24,NULL,'DUMMY',24,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(25,NULL,'DUMMY',25,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(26,NULL,'DUMMY',26,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(27,NULL,'DUMMY',27,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(28,NULL,'DUMMY',28,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(29,NULL,'DUMMY',29,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(30,NULL,'DUMMY',30,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(31,NULL,'DUMMY',31,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(32,NULL,'DUMMY',32,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(33,NULL,'DUMMY',33,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(34,NULL,'DUMMY',34,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(35,NULL,'DUMMY',35,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(36,NULL,'DUMMY',36,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(37,NULL,'DUMMY',37,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(38,NULL,'DUMMY',38,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(39,NULL,'DUMMY',39,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(40,NULL,'DUMMY',40,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(41,NULL,'DUMMY',41,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(42,NULL,'DUMMY',42,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(43,NULL,'DUMMY',43,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(44,NULL,'DUMMY',44,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(45,NULL,'DUMMY',45,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(46,NULL,'DUMMY',46,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(47,NULL,'DUMMY',47,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(48,NULL,'DUMMY',48,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(49,NULL,'DUMMY',49,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(50,NULL,'DUMMY',50,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(51,NULL,'DUMMY',51,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(52,NULL,'DUMMY',52,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(53,NULL,'DUMMY',53,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(54,NULL,'DUMMY',54,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(55,NULL,'DUMMY',55,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(56,NULL,'DUMMY',56,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(57,NULL,'DUMMY',57,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(58,NULL,'DUMMY',58,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(59,NULL,'DUMMY',59,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(60,NULL,'DUMMY',60,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(61,NULL,'DUMMY',61,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(62,NULL,'DUMMY',62,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(63,NULL,'DUMMY',63,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(64,NULL,'DUMMY',64,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(65,NULL,'DUMMY',65,1,'2025-01-31 10:15:01','2025-01-31 10:15:01'),(66,NULL,'DUMMY',66,1,'2025-01-31 10:15:53','2025-01-31 10:15:53'),(67,NULL,'DUMMY',67,1,'2025-01-31 12:20:16','2025-01-31 12:20:16'),(68,NULL,'DUMMY',68,1,'2025-01-31 12:21:22','2025-01-31 12:21:22'),(69,NULL,'DUMMY',69,1,'2025-01-31 12:22:00','2025-01-31 12:22:00'),(70,NULL,'DUMMY',70,1,'2025-01-31 13:19:44','2025-01-31 13:19:44'),(71,NULL,'DUMMY',71,1,'2025-01-31 13:20:58','2025-01-31 13:20:58'),(72,NULL,'DUMMY',72,1,'2025-01-31 13:23:57','2025-01-31 13:23:57'),(73,NULL,'DUMMY',73,1,'2025-01-31 13:53:28','2025-01-31 13:53:28'),(74,NULL,'DUMMY',74,1,'2025-01-31 13:54:22','2025-01-31 13:54:22'),(75,NULL,'DUMMY',75,1,'2025-01-31 13:56:19','2025-01-31 13:56:19'),(76,NULL,'DUMMY',76,1,'2025-01-31 13:56:53','2025-01-31 13:56:53'),(77,NULL,'DUMMY',77,1,'2025-01-31 13:58:58','2025-01-31 13:58:58'),(78,NULL,'DUMMY',78,1,'2025-01-31 13:59:27','2025-01-31 13:59:27'),(79,NULL,'DUMMY',79,1,'2025-01-31 14:03:12','2025-01-31 14:03:12'),(80,NULL,'DUMMY',80,1,'2025-01-31 14:03:52','2025-01-31 14:03:52'),(81,NULL,'DUMMY',81,1,'2025-01-31 14:06:31','2025-01-31 14:06:31'),(82,NULL,'DUMMY',82,1,'2025-01-31 14:07:21','2025-01-31 14:07:21'),(83,NULL,'DUMMY',83,1,'2025-02-01 06:58:51','2025-02-01 06:58:51'),(84,NULL,'DUMMY',84,1,'2025-02-01 06:59:23','2025-02-01 06:59:23'),(85,NULL,'DUMMY',85,1,'2025-02-01 07:00:12','2025-02-01 07:00:12'),(86,NULL,'DUMMY',86,1,'2025-02-01 07:00:36','2025-02-01 07:00:36'),(87,NULL,'DUMMY',87,1,'2025-02-01 07:00:56','2025-02-01 07:00:56'),(88,NULL,'DUMMY',88,1,'2025-02-01 07:01:16','2025-02-01 07:01:16'),(140,NULL,'DUMMY',140,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(141,NULL,'DUMMY',141,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(142,NULL,'DUMMY',142,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(143,NULL,'DUMMY',143,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(144,NULL,'DUMMY',144,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(145,NULL,'DUMMY',145,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(146,NULL,'DUMMY',146,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(147,NULL,'DUMMY',147,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(148,NULL,'DUMMY',148,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(149,NULL,'DUMMY',149,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(150,NULL,'DUMMY',150,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(151,NULL,'DUMMY',151,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(152,NULL,'DUMMY',152,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(153,NULL,'DUMMY',153,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(154,NULL,'DUMMY',154,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(155,NULL,'DUMMY',155,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(156,NULL,'DUMMY',156,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(157,NULL,'DUMMY',157,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(158,NULL,'DUMMY',158,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(159,NULL,'DUMMY',159,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(160,NULL,'DUMMY',160,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(161,NULL,'DUMMY',161,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(162,NULL,'DUMMY',162,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(163,NULL,'DUMMY',163,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(164,NULL,'DUMMY',164,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(165,NULL,'DUMMY',165,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(166,NULL,'DUMMY',166,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(167,NULL,'DUMMY',167,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(168,NULL,'DUMMY',168,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(169,NULL,'DUMMY',169,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(170,NULL,'DUMMY',170,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(171,NULL,'DUMMY',171,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(172,NULL,'DUMMY',172,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(173,NULL,'DUMMY',173,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(174,NULL,'DUMMY',174,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(175,NULL,'DUMMY',175,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(176,NULL,'DUMMY',176,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(177,NULL,'DUMMY',177,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(178,NULL,'DUMMY',178,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(179,NULL,'DUMMY',179,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(180,NULL,'DUMMY',180,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(181,NULL,'DUMMY',181,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(182,NULL,'DUMMY',182,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(183,NULL,'DUMMY',183,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(184,NULL,'DUMMY',184,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(185,NULL,'DUMMY',185,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(186,NULL,'DUMMY',186,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(187,NULL,'DUMMY',187,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(188,NULL,'DUMMY',188,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(189,NULL,'DUMMY',189,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(190,NULL,'DUMMY',190,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(191,NULL,'DUMMY',191,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(192,NULL,'DUMMY',192,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(193,NULL,'DUMMY',193,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(194,NULL,'DUMMY',194,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(195,NULL,'DUMMY',195,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(196,NULL,'DUMMY',196,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(197,NULL,'DUMMY',197,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(198,NULL,'DUMMY',198,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(199,NULL,'DUMMY',199,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(200,NULL,'DUMMY',200,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(201,NULL,'DUMMY',201,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(202,NULL,'DUMMY',202,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(203,NULL,'DUMMY',203,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(204,NULL,'DUMMY',204,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(205,NULL,'DUMMY',205,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(206,NULL,'DUMMY',206,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(207,NULL,'DUMMY',207,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(208,NULL,'DUMMY',208,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(209,NULL,'DUMMY',209,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(210,NULL,'DUMMY',210,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(211,NULL,'DUMMY',211,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(212,NULL,'DUMMY',212,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(213,NULL,'DUMMY',213,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(214,NULL,'DUMMY',214,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(215,NULL,'DUMMY',215,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(216,NULL,'DUMMY',216,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(217,NULL,'DUMMY',217,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(218,NULL,'DUMMY',218,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(219,NULL,'DUMMY',219,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(220,NULL,'DUMMY',220,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(221,NULL,'DUMMY',221,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(222,NULL,'DUMMY',222,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(223,NULL,'DUMMY',223,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(224,NULL,'DUMMY',224,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(225,NULL,'DUMMY',225,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(226,NULL,'DUMMY',226,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(227,NULL,'DUMMY',227,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(228,NULL,'DUMMY',228,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(229,NULL,'DUMMY',229,1,'2025-02-01 12:36:21','2025-02-01 12:36:21'),(230,NULL,'DUMMY',230,1,'2025-02-01 12:37:28','2025-02-01 12:37:28'),(231,NULL,'DUMMY',231,1,'2025-02-01 14:29:32','2025-02-01 14:29:32'),(232,NULL,'DUMMY',232,1,'2025-02-01 14:31:40','2025-02-01 14:31:40'),(233,NULL,'DUMMY',233,1,'2025-02-01 14:35:06','2025-02-01 14:35:06'),(234,NULL,'DUMMY',234,1,'2025-02-01 14:36:18','2025-02-01 14:36:18'),(235,NULL,'DUMMY',235,1,'2025-02-01 14:37:45','2025-02-01 14:37:45'),(236,NULL,'DUMMY',236,1,'2025-02-01 14:43:37','2025-02-01 14:43:37'),(237,NULL,'DUMMY',237,1,'2025-02-01 14:44:10','2025-02-01 14:44:10'),(238,NULL,'DUMMY',238,1,'2025-02-01 14:44:43','2025-02-01 14:44:43'),(239,NULL,'DUMMY',239,1,'2025-02-01 14:49:52','2025-02-01 14:49:52'),(240,NULL,'DUMMY',240,1,'2025-02-01 14:50:26','2025-02-01 14:50:26'),(241,NULL,'DUMMY',241,1,'2025-02-01 14:50:48','2025-02-01 14:50:48'),(242,NULL,'DUMMY',242,1,'2025-02-01 14:53:40','2025-02-01 14:53:40'),(243,NULL,'DUMMY',243,1,'2025-02-01 14:54:02','2025-02-01 14:54:02'),(244,NULL,'DUMMY',244,1,'2025-02-01 14:57:17','2025-02-01 14:57:17'),(245,NULL,'DUMMY',245,1,'2025-02-01 14:57:53','2025-02-01 14:57:53'),(246,NULL,'DUMMY',246,1,'2025-02-01 14:58:17','2025-02-01 14:58:17'),(247,NULL,'DUMMY',247,1,'2025-02-01 15:04:27','2025-02-01 15:04:27'),(248,NULL,'DUMMY',248,1,'2025-02-01 15:04:51','2025-02-01 15:04:51'),(249,NULL,'DUMMY',249,1,'2025-02-01 15:05:25','2025-02-01 15:05:25'),(250,NULL,'DUMMY',250,1,'2025-02-01 15:08:32','2025-02-01 15:08:32'),(251,NULL,'DUMMY',251,1,'2025-02-01 15:08:57','2025-02-01 15:08:57'),(252,NULL,'DUMMY',252,1,'2025-02-01 15:09:28','2025-02-01 15:09:28'),(253,NULL,'DUMMY',253,1,'2025-02-01 16:42:45','2025-02-01 16:42:45'),(254,NULL,'DUMMY',254,1,'2025-02-01 16:45:49','2025-02-01 16:45:49'),(255,NULL,'DUMMY',255,1,'2025-02-01 16:46:50','2025-02-01 16:46:50'),(256,NULL,'DUMMY',256,1,'2025-02-01 17:07:27','2025-02-01 17:07:27'),(257,NULL,'DUMMY',257,1,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(258,NULL,'DUMMY',258,1,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(259,NULL,'DUMMY',259,1,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(260,NULL,'DUMMY',260,1,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(261,NULL,'DUMMY',261,1,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(262,NULL,'DUMMY',262,1,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(263,NULL,'DUMMY',263,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(264,NULL,'DUMMY',264,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(265,NULL,'DUMMY',265,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(266,NULL,'DUMMY',266,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(267,NULL,'DUMMY',267,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(268,NULL,'DUMMY',268,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(269,NULL,'DUMMY',269,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(270,NULL,'DUMMY',270,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(271,NULL,'DUMMY',271,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(272,NULL,'DUMMY',272,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(273,NULL,'DUMMY',273,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(274,NULL,'DUMMY',274,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(275,NULL,'DUMMY',275,1,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(276,NULL,'DUMMY',276,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(277,NULL,'DUMMY',277,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(278,NULL,'DUMMY',278,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(279,NULL,'DUMMY',279,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(280,NULL,'DUMMY',280,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(281,NULL,'DUMMY',281,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(282,NULL,'DUMMY',282,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(283,NULL,'DUMMY',283,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(284,NULL,'DUMMY',284,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(285,NULL,'DUMMY',285,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(286,NULL,'DUMMY',286,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(287,NULL,'DUMMY',287,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(288,NULL,'DUMMY',288,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(289,NULL,'DUMMY',289,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(290,NULL,'DUMMY',290,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(291,NULL,'DUMMY',291,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(292,NULL,'DUMMY',292,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(293,NULL,'DUMMY',293,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(294,NULL,'DUMMY',294,1,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(295,NULL,'DUMMY',295,1,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(296,NULL,'DUMMY',296,1,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(297,NULL,'DUMMY',297,1,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(298,NULL,'DUMMY',298,1,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(299,NULL,'DUMMY',299,1,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(300,NULL,'DUMMY',300,1,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(301,NULL,'DUMMY',301,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(302,NULL,'DUMMY',302,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(303,NULL,'DUMMY',303,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(304,NULL,'DUMMY',304,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(305,NULL,'DUMMY',305,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(306,NULL,'DUMMY',306,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(307,NULL,'DUMMY',307,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(308,NULL,'DUMMY',308,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(309,NULL,'DUMMY',309,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(310,NULL,'DUMMY',310,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(311,NULL,'DUMMY',311,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(312,NULL,'DUMMY',312,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(313,NULL,'DUMMY',313,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(314,NULL,'DUMMY',314,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(315,NULL,'DUMMY',315,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(316,NULL,'DUMMY',316,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(317,NULL,'DUMMY',317,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(318,NULL,'DUMMY',318,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(319,NULL,'DUMMY',319,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(320,NULL,'DUMMY',320,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(321,NULL,'DUMMY',321,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(322,NULL,'DUMMY',322,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(323,NULL,'DUMMY',323,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(324,NULL,'DUMMY',324,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(325,NULL,'DUMMY',325,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(326,NULL,'DUMMY',326,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(327,NULL,'DUMMY',327,1,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(328,NULL,'DUMMY',328,1,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(329,NULL,'DUMMY',329,1,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(330,NULL,'DUMMY',330,1,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(331,NULL,'DUMMY',331,1,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(332,NULL,'DUMMY',332,1,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(333,NULL,'DUMMY',333,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(334,NULL,'DUMMY',334,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(335,NULL,'DUMMY',335,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(336,NULL,'DUMMY',336,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(337,NULL,'DUMMY',337,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(338,NULL,'DUMMY',338,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(339,NULL,'DUMMY',339,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(340,NULL,'DUMMY',340,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(341,NULL,'DUMMY',341,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(342,NULL,'DUMMY',342,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(343,NULL,'DUMMY',343,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(344,NULL,'DUMMY',344,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(345,NULL,'DUMMY',345,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(346,NULL,'DUMMY',346,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(347,NULL,'DUMMY',347,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(348,NULL,'DUMMY',348,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(349,NULL,'DUMMY',349,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(350,NULL,'DUMMY',350,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(351,NULL,'DUMMY',351,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(352,NULL,'DUMMY',352,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(353,NULL,'DUMMY',353,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(354,NULL,'DUMMY',354,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(355,NULL,'DUMMY',355,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(356,NULL,'DUMMY',356,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(357,NULL,'DUMMY',357,1,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(358,NULL,'DUMMY',358,1,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(359,NULL,'DUMMY',359,1,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(360,NULL,'DUMMY',360,1,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(361,NULL,'DUMMY',361,1,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(362,NULL,'DUMMY',362,1,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(363,NULL,'DUMMY',363,1,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(364,NULL,'DUMMY',364,1,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(365,NULL,'DUMMY',365,1,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(366,NULL,'DUMMY',366,1,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(367,NULL,'DUMMY',367,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(368,NULL,'DUMMY',368,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(369,NULL,'DUMMY',369,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(370,NULL,'DUMMY',370,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(371,NULL,'DUMMY',371,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(372,NULL,'DUMMY',372,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(373,NULL,'DUMMY',373,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(374,NULL,'DUMMY',374,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(375,NULL,'DUMMY',375,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(376,NULL,'DUMMY',376,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(377,NULL,'DUMMY',377,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(378,NULL,'DUMMY',378,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(379,NULL,'DUMMY',379,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(380,NULL,'DUMMY',380,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(381,NULL,'DUMMY',381,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(382,NULL,'DUMMY',382,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(383,NULL,'DUMMY',383,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(384,NULL,'DUMMY',384,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(385,NULL,'DUMMY',385,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(386,NULL,'DUMMY',386,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(387,NULL,'DUMMY',387,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(388,NULL,'DUMMY',388,1,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(389,NULL,'DUMMY',389,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(390,NULL,'DUMMY',390,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(391,NULL,'DUMMY',391,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(392,NULL,'DUMMY',392,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(393,NULL,'DUMMY',393,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(394,NULL,'DUMMY',394,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(395,NULL,'DUMMY',395,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(396,NULL,'DUMMY',396,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(397,NULL,'DUMMY',397,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(398,NULL,'DUMMY',398,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(399,NULL,'DUMMY',399,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(400,NULL,'DUMMY',400,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(401,NULL,'DUMMY',401,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(402,NULL,'DUMMY',402,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(403,NULL,'DUMMY',403,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(404,NULL,'DUMMY',404,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(405,NULL,'DUMMY',405,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(406,NULL,'DUMMY',406,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(407,NULL,'DUMMY',407,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(408,NULL,'DUMMY',408,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(409,NULL,'DUMMY',409,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(410,NULL,'DUMMY',410,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(411,NULL,'DUMMY',411,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(412,NULL,'DUMMY',412,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(413,NULL,'DUMMY',413,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(414,NULL,'DUMMY',414,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(415,NULL,'DUMMY',415,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(416,NULL,'DUMMY',416,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(417,NULL,'DUMMY',417,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(418,NULL,'DUMMY',418,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(419,NULL,'DUMMY',419,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(420,NULL,'DUMMY',420,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(421,NULL,'DUMMY',421,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(422,NULL,'DUMMY',422,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(423,NULL,'DUMMY',423,1,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(424,NULL,'DUMMY',424,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(425,NULL,'DUMMY',425,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(426,NULL,'DUMMY',426,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(427,NULL,'DUMMY',427,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(428,NULL,'DUMMY',428,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(429,NULL,'DUMMY',429,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(430,NULL,'DUMMY',430,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(431,NULL,'DUMMY',431,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(432,NULL,'DUMMY',432,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(433,NULL,'DUMMY',433,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(434,NULL,'DUMMY',434,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(435,NULL,'DUMMY',435,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(436,NULL,'DUMMY',436,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(437,NULL,'DUMMY',437,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(438,NULL,'DUMMY',438,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(439,NULL,'DUMMY',439,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(440,NULL,'DUMMY',440,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(441,NULL,'DUMMY',441,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(442,NULL,'DUMMY',442,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(443,NULL,'DUMMY',443,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(444,NULL,'DUMMY',444,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(445,NULL,'DUMMY',445,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(446,NULL,'DUMMY',446,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(447,NULL,'DUMMY',447,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(448,NULL,'DUMMY',448,1,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(449,NULL,'DUMMY',449,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(450,NULL,'DUMMY',450,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(451,NULL,'DUMMY',451,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(452,NULL,'DUMMY',452,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(453,NULL,'DUMMY',453,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(454,NULL,'DUMMY',454,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(455,NULL,'DUMMY',455,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(456,NULL,'DUMMY',456,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(457,NULL,'DUMMY',457,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(458,NULL,'DUMMY',458,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(459,NULL,'DUMMY',459,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(460,NULL,'DUMMY',460,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(461,NULL,'DUMMY',461,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(462,NULL,'DUMMY',462,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(463,NULL,'DUMMY',463,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(464,NULL,'DUMMY',464,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(465,NULL,'DUMMY',465,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(466,NULL,'DUMMY',466,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(467,NULL,'DUMMY',467,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(468,NULL,'DUMMY',468,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(469,NULL,'DUMMY',469,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(470,NULL,'DUMMY',470,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(471,NULL,'DUMMY',471,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(472,NULL,'DUMMY',472,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(473,NULL,'DUMMY',473,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(474,NULL,'DUMMY',474,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(475,NULL,'DUMMY',475,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(476,NULL,'DUMMY',476,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(477,NULL,'DUMMY',477,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(478,NULL,'DUMMY',478,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(479,NULL,'DUMMY',479,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(480,NULL,'DUMMY',480,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(481,NULL,'DUMMY',481,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(482,NULL,'DUMMY',482,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(483,NULL,'DUMMY',483,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(484,NULL,'DUMMY',484,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(485,NULL,'DUMMY',485,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(486,NULL,'DUMMY',486,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(487,NULL,'DUMMY',487,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(488,NULL,'DUMMY',488,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(489,NULL,'DUMMY',489,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(490,NULL,'DUMMY',490,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(491,NULL,'DUMMY',491,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(492,NULL,'DUMMY',492,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(493,NULL,'DUMMY',493,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(494,NULL,'DUMMY',494,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(495,NULL,'DUMMY',495,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(496,NULL,'DUMMY',496,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(497,NULL,'DUMMY',497,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(498,NULL,'DUMMY',498,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(499,NULL,'DUMMY',499,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(500,NULL,'DUMMY',500,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(501,NULL,'DUMMY',501,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(502,NULL,'DUMMY',502,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(503,NULL,'DUMMY',503,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(504,NULL,'DUMMY',504,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(505,NULL,'DUMMY',505,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(506,NULL,'DUMMY',506,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(507,NULL,'DUMMY',507,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(508,NULL,'DUMMY',508,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(509,NULL,'DUMMY',509,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(510,NULL,'DUMMY',510,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(511,NULL,'DUMMY',511,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(512,NULL,'DUMMY',512,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(513,NULL,'DUMMY',513,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(514,NULL,'DUMMY',514,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(515,NULL,'DUMMY',515,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(516,NULL,'DUMMY',516,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(517,NULL,'DUMMY',517,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(518,NULL,'DUMMY',518,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(519,NULL,'DUMMY',519,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(520,NULL,'DUMMY',520,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(521,NULL,'DUMMY',521,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(522,NULL,'DUMMY',522,1,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(523,NULL,'DUMMY',523,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(524,NULL,'DUMMY',524,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(525,NULL,'DUMMY',525,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(526,NULL,'DUMMY',526,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(527,NULL,'DUMMY',527,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(528,NULL,'DUMMY',528,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(529,NULL,'DUMMY',529,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(530,NULL,'DUMMY',530,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(531,NULL,'DUMMY',531,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(532,NULL,'DUMMY',532,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(533,NULL,'DUMMY',533,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(534,NULL,'DUMMY',534,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(535,NULL,'DUMMY',535,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(536,NULL,'DUMMY',536,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(537,NULL,'DUMMY',537,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(538,NULL,'DUMMY',538,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(539,NULL,'DUMMY',539,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(540,NULL,'DUMMY',540,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(541,NULL,'DUMMY',541,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(542,NULL,'DUMMY',542,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(543,NULL,'DUMMY',543,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(544,NULL,'DUMMY',544,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(545,NULL,'DUMMY',545,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(546,NULL,'DUMMY',546,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(547,NULL,'DUMMY',547,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(548,NULL,'DUMMY',548,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(549,NULL,'DUMMY',549,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(550,NULL,'DUMMY',550,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(551,NULL,'DUMMY',551,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(552,NULL,'DUMMY',552,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(553,NULL,'DUMMY',553,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(554,NULL,'DUMMY',554,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(555,NULL,'DUMMY',555,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(556,NULL,'DUMMY',556,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(557,NULL,'DUMMY',557,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(558,NULL,'DUMMY',558,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(559,NULL,'DUMMY',559,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(560,NULL,'DUMMY',560,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(561,NULL,'DUMMY',561,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(562,NULL,'DUMMY',562,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(563,NULL,'DUMMY',563,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(564,NULL,'DUMMY',564,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(565,NULL,'DUMMY',565,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(566,NULL,'DUMMY',566,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(567,NULL,'DUMMY',567,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(568,NULL,'DUMMY',568,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(569,NULL,'DUMMY',569,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(570,NULL,'DUMMY',570,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(571,NULL,'DUMMY',571,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(572,NULL,'DUMMY',572,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(573,NULL,'DUMMY',573,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(574,NULL,'DUMMY',574,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(575,NULL,'DUMMY',575,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(576,NULL,'DUMMY',576,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(577,NULL,'DUMMY',577,1,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(578,NULL,'DUMMY',578,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(579,NULL,'DUMMY',579,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(580,NULL,'DUMMY',580,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(581,NULL,'DUMMY',581,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(582,NULL,'DUMMY',582,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(583,NULL,'DUMMY',583,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(584,NULL,'DUMMY',584,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(585,NULL,'DUMMY',585,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(586,NULL,'DUMMY',586,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(587,NULL,'DUMMY',587,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(588,NULL,'DUMMY',588,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(589,NULL,'DUMMY',589,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(590,NULL,'DUMMY',590,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(591,NULL,'DUMMY',591,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(592,NULL,'DUMMY',592,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(593,NULL,'DUMMY',593,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(594,NULL,'DUMMY',594,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(595,NULL,'DUMMY',595,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(596,NULL,'DUMMY',596,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(597,NULL,'DUMMY',597,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(598,NULL,'DUMMY',598,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(599,NULL,'DUMMY',599,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(600,NULL,'DUMMY',600,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(601,NULL,'DUMMY',601,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(602,NULL,'DUMMY',602,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(603,NULL,'DUMMY',603,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(604,NULL,'DUMMY',604,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(605,NULL,'DUMMY',605,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(606,NULL,'DUMMY',606,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(607,NULL,'DUMMY',607,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(608,NULL,'DUMMY',608,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(609,NULL,'DUMMY',609,1,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(610,NULL,'DUMMY',610,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(611,NULL,'DUMMY',611,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(612,NULL,'DUMMY',612,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(613,NULL,'DUMMY',613,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(614,NULL,'DUMMY',614,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(615,NULL,'DUMMY',615,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(616,NULL,'DUMMY',616,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(617,NULL,'DUMMY',617,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(618,NULL,'DUMMY',618,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(619,NULL,'DUMMY',619,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(620,NULL,'DUMMY',620,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(621,NULL,'DUMMY',621,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(622,NULL,'DUMMY',622,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(623,NULL,'DUMMY',623,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(624,NULL,'DUMMY',624,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(625,NULL,'DUMMY',625,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(626,NULL,'DUMMY',626,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(627,NULL,'DUMMY',627,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(628,NULL,'DUMMY',628,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(629,NULL,'DUMMY',629,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(630,NULL,'DUMMY',630,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(631,NULL,'DUMMY',631,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(632,NULL,'DUMMY',632,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(633,NULL,'DUMMY',633,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(634,NULL,'DUMMY',634,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(635,NULL,'DUMMY',635,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(636,NULL,'DUMMY',636,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(637,NULL,'DUMMY',637,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(638,NULL,'DUMMY',638,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(639,NULL,'DUMMY',639,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(640,NULL,'DUMMY',640,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(641,NULL,'DUMMY',641,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(642,NULL,'DUMMY',642,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(643,NULL,'DUMMY',643,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(644,NULL,'DUMMY',644,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(645,NULL,'DUMMY',645,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(646,NULL,'DUMMY',646,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(647,NULL,'DUMMY',647,1,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(648,NULL,'DUMMY',648,1,'2025-02-01 19:03:16','2025-02-01 19:03:16'),(649,NULL,'DUMMY',649,1,'2025-02-01 19:03:38','2025-02-01 19:03:38'),(650,NULL,'DUMMY',650,1,'2025-02-01 19:03:59','2025-02-01 19:03:59'),(651,NULL,'DUMMY',651,1,'2025-02-01 19:04:30','2025-02-01 19:04:30'),(652,NULL,'DUMMY',652,1,'2025-02-01 19:04:54','2025-02-01 19:04:54'),(653,NULL,'DUMMY',653,1,'2025-02-01 19:05:15','2025-02-01 19:05:15'),(654,NULL,'DUMMY',654,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(655,NULL,'DUMMY',655,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(656,NULL,'DUMMY',656,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(657,NULL,'DUMMY',657,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(658,NULL,'DUMMY',658,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(659,NULL,'DUMMY',659,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(660,NULL,'DUMMY',660,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(661,NULL,'DUMMY',661,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(662,NULL,'DUMMY',662,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(663,NULL,'DUMMY',663,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(664,NULL,'DUMMY',664,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(665,NULL,'DUMMY',665,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(666,NULL,'DUMMY',666,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(667,NULL,'DUMMY',667,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(668,NULL,'DUMMY',668,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(669,NULL,'DUMMY',669,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(670,NULL,'DUMMY',670,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(671,NULL,'DUMMY',671,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(672,NULL,'DUMMY',672,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(673,NULL,'DUMMY',673,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(674,NULL,'DUMMY',674,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(675,NULL,'DUMMY',675,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(676,NULL,'DUMMY',676,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(677,NULL,'DUMMY',677,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(678,NULL,'DUMMY',678,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(679,NULL,'DUMMY',679,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(680,NULL,'DUMMY',680,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(681,NULL,'DUMMY',681,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(682,NULL,'DUMMY',682,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(683,NULL,'DUMMY',683,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(684,NULL,'DUMMY',684,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(685,NULL,'DUMMY',685,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(686,NULL,'DUMMY',686,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(687,NULL,'DUMMY',687,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(688,NULL,'DUMMY',688,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(689,NULL,'DUMMY',689,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(690,NULL,'DUMMY',690,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(691,NULL,'DUMMY',691,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(692,NULL,'DUMMY',692,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(693,NULL,'DUMMY',693,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(694,NULL,'DUMMY',694,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(695,NULL,'DUMMY',695,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(696,NULL,'DUMMY',696,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(697,NULL,'DUMMY',697,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(698,NULL,'DUMMY',698,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(699,NULL,'DUMMY',699,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(700,NULL,'DUMMY',700,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(701,NULL,'DUMMY',701,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(702,NULL,'DUMMY',702,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(703,NULL,'DUMMY',703,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(704,NULL,'DUMMY',704,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(705,NULL,'DUMMY',705,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(706,NULL,'DUMMY',706,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(707,NULL,'DUMMY',707,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(708,NULL,'DUMMY',708,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(709,NULL,'DUMMY',709,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(710,NULL,'DUMMY',710,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(711,NULL,'DUMMY',711,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(712,NULL,'DUMMY',712,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(713,NULL,'DUMMY',713,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(714,NULL,'DUMMY',714,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(715,NULL,'DUMMY',715,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(716,NULL,'DUMMY',716,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(717,NULL,'DUMMY',717,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(718,NULL,'DUMMY',718,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(719,NULL,'DUMMY',719,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(720,NULL,'DUMMY',720,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(721,NULL,'DUMMY',721,1,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(722,NULL,'DUMMY',722,1,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(723,NULL,'DUMMY',723,1,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(724,NULL,'DUMMY',724,1,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(725,NULL,'DUMMY',725,1,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(726,NULL,'DUMMY',726,1,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(727,NULL,'DUMMY',727,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(728,NULL,'DUMMY',728,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(729,NULL,'DUMMY',729,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(730,NULL,'DUMMY',730,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(731,NULL,'DUMMY',731,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(732,NULL,'DUMMY',732,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(733,NULL,'DUMMY',733,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(734,NULL,'DUMMY',734,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(735,NULL,'DUMMY',735,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(736,NULL,'DUMMY',736,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(737,NULL,'DUMMY',737,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(738,NULL,'DUMMY',738,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(739,NULL,'DUMMY',739,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(740,NULL,'DUMMY',740,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(741,NULL,'DUMMY',741,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(742,NULL,'DUMMY',742,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(743,NULL,'DUMMY',743,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(744,NULL,'DUMMY',744,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(745,NULL,'DUMMY',745,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(746,NULL,'DUMMY',746,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(747,NULL,'DUMMY',747,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(748,NULL,'DUMMY',748,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(749,NULL,'DUMMY',749,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(750,NULL,'DUMMY',750,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(751,NULL,'DUMMY',751,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(752,NULL,'DUMMY',752,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(753,NULL,'DUMMY',753,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(754,NULL,'DUMMY',754,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(755,NULL,'DUMMY',755,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(756,NULL,'DUMMY',756,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(757,NULL,'DUMMY',757,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(758,NULL,'DUMMY',758,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(759,NULL,'DUMMY',759,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(760,NULL,'DUMMY',760,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(761,NULL,'DUMMY',761,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(762,NULL,'DUMMY',762,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(763,NULL,'DUMMY',763,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(764,NULL,'DUMMY',764,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(765,NULL,'DUMMY',765,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(766,NULL,'DUMMY',766,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(767,NULL,'DUMMY',767,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(768,NULL,'DUMMY',768,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(769,NULL,'DUMMY',769,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(770,NULL,'DUMMY',770,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(771,NULL,'DUMMY',771,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(772,NULL,'DUMMY',772,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(773,NULL,'DUMMY',773,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(774,NULL,'DUMMY',774,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(775,NULL,'DUMMY',775,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(776,NULL,'DUMMY',776,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(777,NULL,'DUMMY',777,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(778,NULL,'DUMMY',778,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(779,NULL,'DUMMY',779,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(780,NULL,'DUMMY',780,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(781,NULL,'DUMMY',781,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(782,NULL,'DUMMY',782,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(783,NULL,'DUMMY',783,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(784,NULL,'DUMMY',784,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(785,NULL,'DUMMY',785,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(786,NULL,'DUMMY',786,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(787,NULL,'DUMMY',787,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(788,NULL,'DUMMY',788,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(789,NULL,'DUMMY',789,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(790,NULL,'DUMMY',790,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(791,NULL,'DUMMY',791,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(792,NULL,'DUMMY',792,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(793,NULL,'DUMMY',793,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(794,NULL,'DUMMY',794,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(795,NULL,'DUMMY',795,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(796,NULL,'DUMMY',796,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(797,NULL,'DUMMY',797,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(798,NULL,'DUMMY',798,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(799,NULL,'DUMMY',799,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(800,NULL,'DUMMY',800,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(801,NULL,'DUMMY',801,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(802,NULL,'DUMMY',802,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(803,NULL,'DUMMY',803,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(804,NULL,'DUMMY',804,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(805,NULL,'DUMMY',805,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(806,NULL,'DUMMY',806,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(807,NULL,'DUMMY',807,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(808,NULL,'DUMMY',808,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(809,NULL,'DUMMY',809,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(810,NULL,'DUMMY',810,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(811,NULL,'DUMMY',811,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(812,NULL,'DUMMY',812,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(813,NULL,'DUMMY',813,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(814,NULL,'DUMMY',814,1,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(815,NULL,'DUMMY',815,1,'2025-02-01 19:25:53','2025-02-01 19:25:53'),(816,NULL,'DUMMY',816,1,'2025-02-01 19:26:58','2025-02-01 19:26:58'),(817,NULL,'DUMMY',817,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(818,NULL,'DUMMY',818,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(819,NULL,'DUMMY',819,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(820,NULL,'DUMMY',820,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(821,NULL,'DUMMY',821,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(822,NULL,'DUMMY',822,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(823,NULL,'DUMMY',823,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(824,NULL,'DUMMY',824,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(825,NULL,'DUMMY',825,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(826,NULL,'DUMMY',826,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(827,NULL,'DUMMY',827,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(828,NULL,'DUMMY',828,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(829,NULL,'DUMMY',829,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(830,NULL,'DUMMY',830,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(831,NULL,'DUMMY',831,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(832,NULL,'DUMMY',832,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(833,NULL,'DUMMY',833,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(834,NULL,'DUMMY',834,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(835,NULL,'DUMMY',835,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(836,NULL,'DUMMY',836,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(837,NULL,'DUMMY',837,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(838,NULL,'DUMMY',838,1,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(839,NULL,'DUMMY',839,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(840,NULL,'DUMMY',840,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(841,NULL,'DUMMY',841,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(842,NULL,'DUMMY',842,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(843,NULL,'DUMMY',843,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(844,NULL,'DUMMY',844,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(845,NULL,'DUMMY',845,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(846,NULL,'DUMMY',846,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(847,NULL,'DUMMY',847,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(848,NULL,'DUMMY',848,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(849,NULL,'DUMMY',849,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(850,NULL,'DUMMY',850,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(851,NULL,'DUMMY',851,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(852,NULL,'DUMMY',852,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(853,NULL,'DUMMY',853,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(854,NULL,'DUMMY',854,1,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(855,NULL,'DUMMY',855,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(856,NULL,'DUMMY',856,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(857,NULL,'DUMMY',857,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(858,NULL,'DUMMY',858,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(859,NULL,'DUMMY',859,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(860,NULL,'DUMMY',860,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(861,NULL,'DUMMY',861,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(862,NULL,'DUMMY',862,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(863,NULL,'DUMMY',863,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(864,NULL,'DUMMY',864,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(865,NULL,'DUMMY',865,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(866,NULL,'DUMMY',866,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(867,NULL,'DUMMY',867,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(868,NULL,'DUMMY',868,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(869,NULL,'DUMMY',869,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(870,NULL,'DUMMY',870,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(871,NULL,'DUMMY',871,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(872,NULL,'DUMMY',872,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(873,NULL,'DUMMY',873,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(874,NULL,'DUMMY',874,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(875,NULL,'DUMMY',875,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(876,NULL,'DUMMY',876,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(877,NULL,'DUMMY',877,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(878,NULL,'DUMMY',878,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(879,NULL,'DUMMY',879,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(880,NULL,'DUMMY',880,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(881,NULL,'DUMMY',881,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(882,NULL,'DUMMY',882,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(883,NULL,'DUMMY',883,1,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(884,NULL,'DUMMY',884,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(885,NULL,'DUMMY',885,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(886,NULL,'DUMMY',886,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(887,NULL,'DUMMY',887,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(888,NULL,'DUMMY',888,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(889,NULL,'DUMMY',889,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(890,NULL,'DUMMY',890,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(891,NULL,'DUMMY',891,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(892,NULL,'DUMMY',892,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(893,NULL,'DUMMY',893,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(894,NULL,'DUMMY',894,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(895,NULL,'DUMMY',895,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(896,NULL,'DUMMY',896,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(897,NULL,'DUMMY',897,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(898,NULL,'DUMMY',898,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(899,NULL,'DUMMY',899,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(900,NULL,'DUMMY',900,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(901,NULL,'DUMMY',901,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(902,NULL,'DUMMY',902,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(903,NULL,'DUMMY',903,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(904,NULL,'DUMMY',904,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(905,NULL,'DUMMY',905,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(906,NULL,'DUMMY',906,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(907,NULL,'DUMMY',907,1,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(908,NULL,'DUMMY',908,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(909,NULL,'DUMMY',909,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(910,NULL,'DUMMY',910,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(911,NULL,'DUMMY',911,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(912,NULL,'DUMMY',912,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(913,NULL,'DUMMY',913,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(914,NULL,'DUMMY',914,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(915,NULL,'DUMMY',915,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(916,NULL,'DUMMY',916,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(917,NULL,'DUMMY',917,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(918,NULL,'DUMMY',918,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(919,NULL,'DUMMY',919,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(920,NULL,'DUMMY',920,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(921,NULL,'DUMMY',921,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(922,NULL,'DUMMY',922,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(923,NULL,'DUMMY',923,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(924,NULL,'DUMMY',924,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(925,NULL,'DUMMY',925,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(926,NULL,'DUMMY',926,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(927,NULL,'DUMMY',927,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(928,NULL,'DUMMY',928,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(929,NULL,'DUMMY',929,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(930,NULL,'DUMMY',930,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(931,NULL,'DUMMY',931,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(932,NULL,'DUMMY',932,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(933,NULL,'DUMMY',933,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(934,NULL,'DUMMY',934,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(935,NULL,'DUMMY',935,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(936,NULL,'DUMMY',936,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(937,NULL,'DUMMY',937,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(938,NULL,'DUMMY',938,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(939,NULL,'DUMMY',939,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(940,NULL,'DUMMY',940,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(941,NULL,'DUMMY',941,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(942,NULL,'DUMMY',942,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(943,NULL,'DUMMY',943,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(944,NULL,'DUMMY',944,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(945,NULL,'DUMMY',945,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(946,NULL,'DUMMY',946,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(947,NULL,'DUMMY',947,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(948,NULL,'DUMMY',948,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(949,NULL,'DUMMY',949,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(950,NULL,'DUMMY',950,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(951,NULL,'DUMMY',951,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(952,NULL,'DUMMY',952,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(953,NULL,'DUMMY',953,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(954,NULL,'DUMMY',954,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(955,NULL,'DUMMY',955,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(956,NULL,'DUMMY',956,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(957,NULL,'DUMMY',957,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(958,NULL,'DUMMY',958,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(959,NULL,'DUMMY',959,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(960,NULL,'DUMMY',960,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(961,NULL,'DUMMY',961,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(962,NULL,'DUMMY',962,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(963,NULL,'DUMMY',963,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(964,NULL,'DUMMY',964,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(965,NULL,'DUMMY',965,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(966,NULL,'DUMMY',966,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(967,NULL,'DUMMY',967,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(968,NULL,'DUMMY',968,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(969,NULL,'DUMMY',969,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(970,NULL,'DUMMY',970,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(971,NULL,'DUMMY',971,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(972,NULL,'DUMMY',972,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(973,NULL,'DUMMY',973,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(974,NULL,'DUMMY',974,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(975,NULL,'DUMMY',975,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(976,NULL,'DUMMY',976,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(977,NULL,'DUMMY',977,1,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(978,NULL,'DUMMY',978,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(979,NULL,'DUMMY',979,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(980,NULL,'DUMMY',980,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(981,NULL,'DUMMY',981,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(982,NULL,'DUMMY',982,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(983,NULL,'DUMMY',983,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(984,NULL,'DUMMY',984,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(985,NULL,'DUMMY',985,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(986,NULL,'DUMMY',986,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(987,NULL,'DUMMY',987,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(988,NULL,'DUMMY',988,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(989,NULL,'DUMMY',989,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(990,NULL,'DUMMY',990,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(991,NULL,'DUMMY',991,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(992,NULL,'DUMMY',992,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(993,NULL,'DUMMY',993,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(994,NULL,'DUMMY',994,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(995,NULL,'DUMMY',995,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(996,NULL,'DUMMY',996,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(997,NULL,'DUMMY',997,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(998,NULL,'DUMMY',998,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(999,NULL,'DUMMY',999,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1000,NULL,'DUMMY',1000,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1001,NULL,'DUMMY',1001,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1002,NULL,'DUMMY',1002,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1003,NULL,'DUMMY',1003,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1004,NULL,'DUMMY',1004,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1005,NULL,'DUMMY',1005,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1006,NULL,'DUMMY',1006,1,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1007,NULL,'DUMMY',1007,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1008,NULL,'DUMMY',1008,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1009,NULL,'DUMMY',1009,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1010,NULL,'DUMMY',1010,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1011,NULL,'DUMMY',1011,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1012,NULL,'DUMMY',1012,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1013,NULL,'DUMMY',1013,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1014,NULL,'DUMMY',1014,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1015,NULL,'DUMMY',1015,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1016,NULL,'DUMMY',1016,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1017,NULL,'DUMMY',1017,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1018,NULL,'DUMMY',1018,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1019,NULL,'DUMMY',1019,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1020,NULL,'DUMMY',1020,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1021,NULL,'DUMMY',1021,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1022,NULL,'DUMMY',1022,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1023,NULL,'DUMMY',1023,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1024,NULL,'DUMMY',1024,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1025,NULL,'DUMMY',1025,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1026,NULL,'DUMMY',1026,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1027,NULL,'DUMMY',1027,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1028,NULL,'DUMMY',1028,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1029,NULL,'DUMMY',1029,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1030,NULL,'DUMMY',1030,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1031,NULL,'DUMMY',1031,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1032,NULL,'DUMMY',1032,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1033,NULL,'DUMMY',1033,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1034,NULL,'DUMMY',1034,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1035,NULL,'DUMMY',1035,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1036,NULL,'DUMMY',1036,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1037,NULL,'DUMMY',1037,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1038,NULL,'DUMMY',1038,1,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1039,NULL,'DUMMY',1039,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1040,NULL,'DUMMY',1040,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1041,NULL,'DUMMY',1041,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1042,NULL,'DUMMY',1042,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1043,NULL,'DUMMY',1043,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1044,NULL,'DUMMY',1044,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1045,NULL,'DUMMY',1045,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1046,NULL,'DUMMY',1046,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1047,NULL,'DUMMY',1047,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1048,NULL,'DUMMY',1048,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1049,NULL,'DUMMY',1049,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1050,NULL,'DUMMY',1050,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1051,NULL,'DUMMY',1051,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1052,NULL,'DUMMY',1052,1,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1053,NULL,'DUMMY',1053,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1054,NULL,'DUMMY',1054,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1055,NULL,'DUMMY',1055,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1056,NULL,'DUMMY',1056,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1057,NULL,'DUMMY',1057,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1058,NULL,'DUMMY',1058,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1059,NULL,'DUMMY',1059,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1060,NULL,'DUMMY',1060,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1061,NULL,'DUMMY',1061,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1062,NULL,'DUMMY',1062,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1063,NULL,'DUMMY',1063,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1064,NULL,'DUMMY',1064,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1065,NULL,'DUMMY',1065,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1066,NULL,'DUMMY',1066,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1067,NULL,'DUMMY',1067,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1068,NULL,'DUMMY',1068,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1069,NULL,'DUMMY',1069,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1070,NULL,'DUMMY',1070,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1071,NULL,'DUMMY',1071,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1072,NULL,'DUMMY',1072,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1073,NULL,'DUMMY',1073,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1074,NULL,'DUMMY',1074,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1075,NULL,'DUMMY',1075,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1076,NULL,'DUMMY',1076,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1077,NULL,'DUMMY',1077,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1078,NULL,'DUMMY',1078,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1079,NULL,'DUMMY',1079,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1080,NULL,'DUMMY',1080,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1081,NULL,'DUMMY',1081,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1082,NULL,'DUMMY',1082,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1083,NULL,'DUMMY',1083,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1084,NULL,'DUMMY',1084,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1085,NULL,'DUMMY',1085,1,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1086,NULL,'DUMMY',1086,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1087,NULL,'DUMMY',1087,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1088,NULL,'DUMMY',1088,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1089,NULL,'DUMMY',1089,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1090,NULL,'DUMMY',1090,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1091,NULL,'DUMMY',1091,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1092,NULL,'DUMMY',1092,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1093,NULL,'DUMMY',1093,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1094,NULL,'DUMMY',1094,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1095,NULL,'DUMMY',1095,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1096,NULL,'DUMMY',1096,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1097,NULL,'DUMMY',1097,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1098,NULL,'DUMMY',1098,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1099,NULL,'DUMMY',1099,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1100,NULL,'DUMMY',1100,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1101,NULL,'DUMMY',1101,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1102,NULL,'DUMMY',1102,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1103,NULL,'DUMMY',1103,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1104,NULL,'DUMMY',1104,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1105,NULL,'DUMMY',1105,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1106,NULL,'DUMMY',1106,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1107,NULL,'DUMMY',1107,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1108,NULL,'DUMMY',1108,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1109,NULL,'DUMMY',1109,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1110,NULL,'DUMMY',1110,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1111,NULL,'DUMMY',1111,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1112,NULL,'DUMMY',1112,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1113,NULL,'DUMMY',1113,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1114,NULL,'DUMMY',1114,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1115,NULL,'DUMMY',1115,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1116,NULL,'DUMMY',1116,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1117,NULL,'DUMMY',1117,1,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1118,NULL,'DUMMY',1118,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1119,NULL,'DUMMY',1119,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1120,NULL,'DUMMY',1120,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1121,NULL,'DUMMY',1121,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1122,NULL,'DUMMY',1122,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1123,NULL,'DUMMY',1123,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1124,NULL,'DUMMY',1124,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1125,NULL,'DUMMY',1125,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1126,NULL,'DUMMY',1126,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1127,NULL,'DUMMY',1127,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1128,NULL,'DUMMY',1128,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1129,NULL,'DUMMY',1129,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1130,NULL,'DUMMY',1130,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1131,NULL,'DUMMY',1131,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1132,NULL,'DUMMY',1132,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1133,NULL,'DUMMY',1133,1,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1134,NULL,'DUMMY',1134,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1135,NULL,'DUMMY',1135,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1136,NULL,'DUMMY',1136,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1137,NULL,'DUMMY',1137,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1138,NULL,'DUMMY',1138,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1139,NULL,'DUMMY',1139,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1140,NULL,'DUMMY',1140,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1141,NULL,'DUMMY',1141,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1142,NULL,'DUMMY',1142,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1143,NULL,'DUMMY',1143,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1144,NULL,'DUMMY',1144,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1145,NULL,'DUMMY',1145,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1146,NULL,'DUMMY',1146,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1147,NULL,'DUMMY',1147,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1148,NULL,'DUMMY',1148,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1149,NULL,'DUMMY',1149,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1150,NULL,'DUMMY',1150,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1151,NULL,'DUMMY',1151,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1152,NULL,'DUMMY',1152,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1153,NULL,'DUMMY',1153,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1154,NULL,'DUMMY',1154,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1155,NULL,'DUMMY',1155,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1156,NULL,'DUMMY',1156,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1157,NULL,'DUMMY',1157,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1158,NULL,'DUMMY',1158,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1159,NULL,'DUMMY',1159,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1160,NULL,'DUMMY',1160,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1161,NULL,'DUMMY',1161,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1162,NULL,'DUMMY',1162,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1163,NULL,'DUMMY',1163,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1164,NULL,'DUMMY',1164,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1165,NULL,'DUMMY',1165,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1166,NULL,'DUMMY',1166,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1167,NULL,'DUMMY',1167,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1168,NULL,'DUMMY',1168,1,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1169,NULL,'DUMMY',1169,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1170,NULL,'DUMMY',1170,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1171,NULL,'DUMMY',1171,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1172,NULL,'DUMMY',1172,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1173,NULL,'DUMMY',1173,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1174,NULL,'DUMMY',1174,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1175,NULL,'DUMMY',1175,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1176,NULL,'DUMMY',1176,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1177,NULL,'DUMMY',1177,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1178,NULL,'DUMMY',1178,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1179,NULL,'DUMMY',1179,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1180,NULL,'DUMMY',1180,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1181,NULL,'DUMMY',1181,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1182,NULL,'DUMMY',1182,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1183,NULL,'DUMMY',1183,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1184,NULL,'DUMMY',1184,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1185,NULL,'DUMMY',1185,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1186,NULL,'DUMMY',1186,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1187,NULL,'DUMMY',1187,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1188,NULL,'DUMMY',1188,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1189,NULL,'DUMMY',1189,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1190,NULL,'DUMMY',1190,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1191,NULL,'DUMMY',1191,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1192,NULL,'DUMMY',1192,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1193,NULL,'DUMMY',1193,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1194,NULL,'DUMMY',1194,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1195,NULL,'DUMMY',1195,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1196,NULL,'DUMMY',1196,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1197,NULL,'DUMMY',1197,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1198,NULL,'DUMMY',1198,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1199,NULL,'DUMMY',1199,1,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1200,NULL,'DUMMY',1200,1,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1201,NULL,'DUMMY',1201,1,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1202,NULL,'DUMMY',1202,1,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1203,NULL,'DUMMY',1203,1,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1204,NULL,'DUMMY',1204,1,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1205,NULL,'DUMMY',1205,1,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1206,NULL,'DUMMY',1206,1,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1207,NULL,'DUMMY',1207,1,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1208,NULL,'DUMMY',1208,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1209,NULL,'DUMMY',1209,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1210,NULL,'DUMMY',1210,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1211,NULL,'DUMMY',1211,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1212,NULL,'DUMMY',1212,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1213,NULL,'DUMMY',1213,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1214,NULL,'DUMMY',1214,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1215,NULL,'DUMMY',1215,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1216,NULL,'DUMMY',1216,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1217,NULL,'DUMMY',1217,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1218,NULL,'DUMMY',1218,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1219,NULL,'DUMMY',1219,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1220,NULL,'DUMMY',1220,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1221,NULL,'DUMMY',1221,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1222,NULL,'DUMMY',1222,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1223,NULL,'DUMMY',1223,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1224,NULL,'DUMMY',1224,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1225,NULL,'DUMMY',1225,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1226,NULL,'DUMMY',1226,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1227,NULL,'DUMMY',1227,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1228,NULL,'DUMMY',1228,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1229,NULL,'DUMMY',1229,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1230,NULL,'DUMMY',1230,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1231,NULL,'DUMMY',1231,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1232,NULL,'DUMMY',1232,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1233,NULL,'DUMMY',1233,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1234,NULL,'DUMMY',1234,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1235,NULL,'DUMMY',1235,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1236,NULL,'DUMMY',1236,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1237,NULL,'DUMMY',1237,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1238,NULL,'DUMMY',1238,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1239,NULL,'DUMMY',1239,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1240,NULL,'DUMMY',1240,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1241,NULL,'DUMMY',1241,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1242,NULL,'DUMMY',1242,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1243,NULL,'DUMMY',1243,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1244,NULL,'DUMMY',1244,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1245,NULL,'DUMMY',1245,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1246,NULL,'DUMMY',1246,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1247,NULL,'DUMMY',1247,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1248,NULL,'DUMMY',1248,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1249,NULL,'DUMMY',1249,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1250,NULL,'DUMMY',1250,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1251,NULL,'DUMMY',1251,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1252,NULL,'DUMMY',1252,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1253,NULL,'DUMMY',1253,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1254,NULL,'DUMMY',1254,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1255,NULL,'DUMMY',1255,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1256,NULL,'DUMMY',1256,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1257,NULL,'DUMMY',1257,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1258,NULL,'DUMMY',1258,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1259,NULL,'DUMMY',1259,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1260,NULL,'DUMMY',1260,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1261,NULL,'DUMMY',1261,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1262,NULL,'DUMMY',1262,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1263,NULL,'DUMMY',1263,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1264,NULL,'DUMMY',1264,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1265,NULL,'DUMMY',1265,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1266,NULL,'DUMMY',1266,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1267,NULL,'DUMMY',1267,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1268,NULL,'DUMMY',1268,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1269,NULL,'DUMMY',1269,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1270,NULL,'DUMMY',1270,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1271,NULL,'DUMMY',1271,1,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1272,NULL,'DUMMY',1272,1,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1273,NULL,'DUMMY',1273,1,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1274,NULL,'DUMMY',1274,1,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1275,NULL,'DUMMY',1275,1,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1276,NULL,'DUMMY',1276,1,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1277,NULL,'DUMMY',1277,1,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1278,NULL,'DUMMY',1278,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1279,NULL,'DUMMY',1279,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1280,NULL,'DUMMY',1280,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1281,NULL,'DUMMY',1281,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1282,NULL,'DUMMY',1282,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1283,NULL,'DUMMY',1283,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1284,NULL,'DUMMY',1284,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1285,NULL,'DUMMY',1285,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1286,NULL,'DUMMY',1286,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1287,NULL,'DUMMY',1287,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1288,NULL,'DUMMY',1288,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1289,NULL,'DUMMY',1289,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1290,NULL,'DUMMY',1290,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1291,NULL,'DUMMY',1291,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1292,NULL,'DUMMY',1292,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1293,NULL,'DUMMY',1293,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1294,NULL,'DUMMY',1294,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1295,NULL,'DUMMY',1295,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1296,NULL,'DUMMY',1296,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1297,NULL,'DUMMY',1297,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1298,NULL,'DUMMY',1298,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1299,NULL,'DUMMY',1299,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1300,NULL,'DUMMY',1300,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1301,NULL,'DUMMY',1301,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1302,NULL,'DUMMY',1302,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1303,NULL,'DUMMY',1303,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1304,NULL,'DUMMY',1304,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1305,NULL,'DUMMY',1305,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1306,NULL,'DUMMY',1306,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1307,NULL,'DUMMY',1307,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1308,NULL,'DUMMY',1308,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1309,NULL,'DUMMY',1309,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1310,NULL,'DUMMY',1310,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1311,NULL,'DUMMY',1311,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1312,NULL,'DUMMY',1312,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1313,NULL,'DUMMY',1313,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1314,NULL,'DUMMY',1314,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1315,NULL,'DUMMY',1315,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1316,NULL,'DUMMY',1316,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1317,NULL,'DUMMY',1317,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1318,NULL,'DUMMY',1318,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1319,NULL,'DUMMY',1319,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1320,NULL,'DUMMY',1320,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1321,NULL,'DUMMY',1321,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1322,NULL,'DUMMY',1322,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1323,NULL,'DUMMY',1323,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1324,NULL,'DUMMY',1324,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1325,NULL,'DUMMY',1325,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1326,NULL,'DUMMY',1326,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1327,NULL,'DUMMY',1327,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1328,NULL,'DUMMY',1328,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1329,NULL,'DUMMY',1329,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1330,NULL,'DUMMY',1330,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1331,NULL,'DUMMY',1331,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1332,NULL,'DUMMY',1332,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1333,NULL,'DUMMY',1333,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1334,NULL,'DUMMY',1334,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1335,NULL,'DUMMY',1335,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1336,NULL,'DUMMY',1336,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1337,NULL,'DUMMY',1337,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1338,NULL,'DUMMY',1338,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1339,NULL,'DUMMY',1339,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1340,NULL,'DUMMY',1340,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1341,NULL,'DUMMY',1341,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1342,NULL,'DUMMY',1342,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1343,NULL,'DUMMY',1343,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1344,NULL,'DUMMY',1344,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1345,NULL,'DUMMY',1345,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1346,NULL,'DUMMY',1346,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1347,NULL,'DUMMY',1347,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1348,NULL,'DUMMY',1348,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1349,NULL,'DUMMY',1349,1,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1350,NULL,'DUMMY',1350,1,'2025-02-02 00:11:26','2025-02-02 00:11:26'),(1351,NULL,'DUMMY',1351,1,'2025-02-02 00:12:10','2025-02-02 00:12:10'),(1352,NULL,'DUMMY',1352,1,'2025-02-02 00:19:56','2025-02-02 00:19:56'),(1353,NULL,'DUMMY',1353,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1354,NULL,'DUMMY',1354,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1355,NULL,'DUMMY',1355,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1356,NULL,'DUMMY',1356,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1357,NULL,'DUMMY',1357,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1358,NULL,'DUMMY',1358,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1359,NULL,'DUMMY',1359,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1360,NULL,'DUMMY',1360,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1361,NULL,'DUMMY',1361,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1362,NULL,'DUMMY',1362,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1363,NULL,'DUMMY',1363,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1364,NULL,'DUMMY',1364,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1365,NULL,'DUMMY',1365,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1366,NULL,'DUMMY',1366,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1367,NULL,'DUMMY',1367,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1368,NULL,'DUMMY',1368,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1369,NULL,'DUMMY',1369,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1370,NULL,'DUMMY',1370,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1371,NULL,'DUMMY',1371,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1372,NULL,'DUMMY',1372,1,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1373,NULL,'DUMMY',1373,1,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1374,NULL,'DUMMY',1374,1,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1375,NULL,'DUMMY',1375,1,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1376,NULL,'DUMMY',1376,1,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1377,NULL,'DUMMY',1377,1,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1378,NULL,'DUMMY',1378,1,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1379,NULL,'DUMMY',1379,1,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1380,NULL,'DUMMY',1380,1,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1381,NULL,'DUMMY',1381,1,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1382,NULL,'DUMMY',1382,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1383,NULL,'DUMMY',1383,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1384,NULL,'DUMMY',1384,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1385,NULL,'DUMMY',1385,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1386,NULL,'DUMMY',1386,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1387,NULL,'DUMMY',1387,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1388,NULL,'DUMMY',1388,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1389,NULL,'DUMMY',1389,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1390,NULL,'DUMMY',1390,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1391,NULL,'DUMMY',1391,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1392,NULL,'DUMMY',1392,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1393,NULL,'DUMMY',1393,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1394,NULL,'DUMMY',1394,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1395,NULL,'DUMMY',1395,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1396,NULL,'DUMMY',1396,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1397,NULL,'DUMMY',1397,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1398,NULL,'DUMMY',1398,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1399,NULL,'DUMMY',1399,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1400,NULL,'DUMMY',1400,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1401,NULL,'DUMMY',1401,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1402,NULL,'DUMMY',1402,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1403,NULL,'DUMMY',1403,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1404,NULL,'DUMMY',1404,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1405,NULL,'DUMMY',1405,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1406,NULL,'DUMMY',1406,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1407,NULL,'DUMMY',1407,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1408,NULL,'DUMMY',1408,1,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1409,NULL,'DUMMY',1409,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1410,NULL,'DUMMY',1410,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1411,NULL,'DUMMY',1411,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1412,NULL,'DUMMY',1412,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1413,NULL,'DUMMY',1413,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1414,NULL,'DUMMY',1414,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1415,NULL,'DUMMY',1415,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1416,NULL,'DUMMY',1416,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1417,NULL,'DUMMY',1417,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1418,NULL,'DUMMY',1418,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1419,NULL,'DUMMY',1419,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1420,NULL,'DUMMY',1420,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1421,NULL,'DUMMY',1421,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1422,NULL,'DUMMY',1422,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1423,NULL,'DUMMY',1423,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1424,NULL,'DUMMY',1424,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1425,NULL,'DUMMY',1425,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1426,NULL,'DUMMY',1426,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1427,NULL,'DUMMY',1427,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1428,NULL,'DUMMY',1428,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1429,NULL,'DUMMY',1429,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1430,NULL,'DUMMY',1430,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1431,NULL,'DUMMY',1431,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1432,NULL,'DUMMY',1432,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1433,NULL,'DUMMY',1433,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1434,NULL,'DUMMY',1434,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1435,NULL,'DUMMY',1435,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1436,NULL,'DUMMY',1436,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1437,NULL,'DUMMY',1437,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1438,NULL,'DUMMY',1438,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1439,NULL,'DUMMY',1439,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1440,NULL,'DUMMY',1440,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1441,NULL,'DUMMY',1441,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1442,NULL,'DUMMY',1442,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1443,NULL,'DUMMY',1443,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1444,NULL,'DUMMY',1444,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1445,NULL,'DUMMY',1445,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1446,NULL,'DUMMY',1446,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1447,NULL,'DUMMY',1447,1,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1448,NULL,'DUMMY',1448,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1449,NULL,'DUMMY',1449,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1450,NULL,'DUMMY',1450,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1451,NULL,'DUMMY',1451,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1452,NULL,'DUMMY',1452,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1453,NULL,'DUMMY',1453,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1454,NULL,'DUMMY',1454,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1455,NULL,'DUMMY',1455,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1456,NULL,'DUMMY',1456,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1457,NULL,'DUMMY',1457,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1458,NULL,'DUMMY',1458,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1459,NULL,'DUMMY',1459,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1460,NULL,'DUMMY',1460,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1461,NULL,'DUMMY',1461,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1462,NULL,'DUMMY',1462,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1463,NULL,'DUMMY',1463,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1464,NULL,'DUMMY',1464,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1465,NULL,'DUMMY',1465,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1466,NULL,'DUMMY',1466,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1467,NULL,'DUMMY',1467,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1468,NULL,'DUMMY',1468,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1469,NULL,'DUMMY',1469,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1470,NULL,'DUMMY',1470,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1471,NULL,'DUMMY',1471,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1472,NULL,'DUMMY',1472,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1473,NULL,'DUMMY',1473,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1474,NULL,'DUMMY',1474,1,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1475,NULL,'DUMMY',1475,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1476,NULL,'DUMMY',1476,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1477,NULL,'DUMMY',1477,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1478,NULL,'DUMMY',1478,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1479,NULL,'DUMMY',1479,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1480,NULL,'DUMMY',1480,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1481,NULL,'DUMMY',1481,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1482,NULL,'DUMMY',1482,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1483,NULL,'DUMMY',1483,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1484,NULL,'DUMMY',1484,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1485,NULL,'DUMMY',1485,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1486,NULL,'DUMMY',1486,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1487,NULL,'DUMMY',1487,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1488,NULL,'DUMMY',1488,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1489,NULL,'DUMMY',1489,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1490,NULL,'DUMMY',1490,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1491,NULL,'DUMMY',1491,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1492,NULL,'DUMMY',1492,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1493,NULL,'DUMMY',1493,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1494,NULL,'DUMMY',1494,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1495,NULL,'DUMMY',1495,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1496,NULL,'DUMMY',1496,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1497,NULL,'DUMMY',1497,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1498,NULL,'DUMMY',1498,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1499,NULL,'DUMMY',1499,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1500,NULL,'DUMMY',1500,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1501,NULL,'DUMMY',1501,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1502,NULL,'DUMMY',1502,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1503,NULL,'DUMMY',1503,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1504,NULL,'DUMMY',1504,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1505,NULL,'DUMMY',1505,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1506,NULL,'DUMMY',1506,1,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1507,NULL,'DUMMY',1507,1,'2025-02-02 01:20:07','2025-02-02 01:20:07'),(1508,NULL,'DUMMY',1508,1,'2025-02-02 02:49:56','2025-02-02 02:49:56'),(1509,NULL,'DUMMY',1509,1,'2025-02-02 03:08:02','2025-02-02 03:08:02'),(1510,NULL,'DUMMY',1510,1,'2025-02-02 03:34:17','2025-02-02 03:34:17'),(1511,NULL,'DUMMY',1511,1,'2025-02-02 03:46:56','2025-02-02 03:46:56'),(1512,NULL,'DUMMY',1512,1,'2025-02-02 04:09:37','2025-02-02 04:09:37'),(1513,NULL,'DUMMY',1513,1,'2025-02-02 04:11:17','2025-02-02 04:11:17'),(1514,NULL,'DUMMY',1514,1,'2025-02-02 04:23:28','2025-02-02 04:23:28'),(1515,NULL,'DUMMY',1515,1,'2025-02-02 04:24:31','2025-02-02 04:24:31'),(1516,NULL,'DUMMY',1516,1,'2025-02-02 04:25:38','2025-02-02 04:25:38'),(1517,NULL,'DUMMY',1517,1,'2025-02-02 04:26:06','2025-02-02 04:26:06'),(1518,NULL,'DUMMY',1518,1,'2025-02-02 04:26:53','2025-02-02 04:26:53'),(1519,NULL,'DUMMY',1519,1,'2025-02-02 04:27:36','2025-02-02 04:27:36'),(1520,NULL,'DUMMY',1520,1,'2025-02-02 04:32:58','2025-02-02 04:32:58'),(1521,NULL,'DUMMY',1521,1,'2025-02-02 04:41:48','2025-02-02 04:41:48'),(1522,NULL,'DUMMY',1522,1,'2025-02-02 04:43:01','2025-02-02 04:43:01'),(1523,NULL,'DUMMY',1523,1,'2025-02-02 04:45:56','2025-02-02 04:45:56'),(1524,NULL,'DUMMY',1524,1,'2025-02-02 04:46:32','2025-02-02 04:46:32'),(1525,NULL,'DUMMY',1525,1,'2025-02-02 04:52:37','2025-02-02 04:52:37'),(1526,NULL,'DUMMY',1526,1,'2025-02-02 04:55:42','2025-02-02 04:55:42'),(1527,NULL,'DUMMY',1527,1,'2025-02-02 04:57:47','2025-02-02 04:57:47'),(1528,NULL,'DUMMY',1528,1,'2025-02-02 04:58:48','2025-02-02 04:58:48'),(1529,NULL,'DUMMY',1529,1,'2025-02-02 05:03:56','2025-02-02 05:03:56'),(1530,NULL,'DUMMY',1530,1,'2025-02-02 05:10:02','2025-02-02 05:10:02'),(1531,NULL,'DUMMY',1531,1,'2025-02-02 05:16:03','2025-02-02 05:16:03'),(1532,NULL,'DUMMY',1532,1,'2025-02-02 05:44:08','2025-02-02 05:44:08'),(1533,NULL,'DUMMY',1533,1,'2025-02-02 06:34:42','2025-02-02 06:34:42'),(1534,NULL,'DUMMY',1534,1,'2025-02-02 07:59:04','2025-02-02 07:59:04'),(1535,NULL,'DUMMY',1535,1,'2025-02-02 08:01:15','2025-02-02 08:01:15'),(1536,NULL,'DUMMY',1536,1,'2025-02-02 09:03:57','2025-02-02 09:03:57'),(1537,NULL,'DUMMY',1537,1,'2025-02-02 09:26:50','2025-02-02 09:26:50'),(1538,NULL,'DUMMY',1538,1,'2025-02-02 09:38:50','2025-02-02 09:38:50'),(1539,NULL,'DUMMY',1539,1,'2025-02-02 09:40:04','2025-02-02 09:40:04'),(1540,NULL,'DUMMY',1540,1,'2025-02-02 09:41:35','2025-02-02 09:41:35'),(1541,NULL,'DUMMY',1541,1,'2025-02-02 09:56:19','2025-02-02 09:56:19'),(1542,NULL,'DUMMY',1542,1,'2025-02-02 10:51:48','2025-02-02 10:51:48'),(1543,NULL,'DUMMY',1543,1,'2025-02-02 10:53:03','2025-02-02 10:53:03'),(1544,NULL,'DUMMY',1544,1,'2025-02-02 11:19:32','2025-02-02 11:19:32'),(1545,NULL,'DUMMY',1545,1,'2025-02-02 11:29:03','2025-02-02 11:29:03'),(1546,NULL,'DUMMY',1546,1,'2025-02-02 11:54:54','2025-02-02 11:54:54'),(1547,NULL,'DUMMY',1547,1,'2025-02-02 12:37:11','2025-02-02 12:37:11'),(1548,NULL,'DUMMY',1548,1,'2025-02-02 12:40:49','2025-02-02 12:40:49'),(1549,NULL,'DUMMY',1549,1,'2025-02-02 12:41:38','2025-02-02 12:41:38'),(1550,NULL,'DUMMY',1550,1,'2025-02-02 12:41:50','2025-02-02 12:41:50'),(1551,NULL,'DUMMY',1551,1,'2025-02-02 13:07:20','2025-02-02 13:07:20'),(1552,NULL,'DUMMY',1552,1,'2025-02-02 13:15:41','2025-02-02 13:15:41'),(1553,NULL,'DUMMY',1553,1,'2025-02-02 13:17:00','2025-02-02 13:17:00'),(1554,NULL,'DUMMY',1554,1,'2025-02-02 13:18:06','2025-02-02 13:18:06'),(1555,NULL,'DUMMY',1555,1,'2025-02-02 13:18:09','2025-02-02 13:18:09'),(1556,NULL,'DUMMY',1556,1,'2025-02-02 13:30:23','2025-02-02 13:30:23'),(1557,NULL,'DUMMY',1557,1,'2025-02-02 14:24:43','2025-02-02 14:24:43'),(1558,NULL,'DUMMY',1558,1,'2025-02-02 14:34:59','2025-02-02 14:34:59'),(1559,NULL,'DUMMY',1559,1,'2025-02-02 14:46:52','2025-02-02 14:46:52'),(1560,NULL,'DUMMY',1560,1,'2025-02-02 14:50:29','2025-02-02 14:50:29'),(1561,NULL,'DUMMY',1561,1,'2025-02-03 06:10:52','2025-02-03 06:10:52'),(1562,NULL,'DUMMY',1562,1,'2025-02-03 06:46:22','2025-02-03 06:46:22'),(1563,NULL,'DUMMY',1563,1,'2025-02-03 06:55:35','2025-02-03 06:55:35'),(1564,NULL,'DUMMY',1564,1,'2025-02-03 07:00:26','2025-02-03 07:00:26'),(1565,NULL,'DUMMY',1565,1,'2025-02-03 07:04:25','2025-02-03 07:04:25'),(1566,NULL,'DUMMY',1566,1,'2025-02-03 07:05:27','2025-02-03 07:05:27'),(1567,NULL,'DUMMY',1567,1,'2025-02-03 07:11:02','2025-02-03 07:11:02'),(1568,NULL,'DUMMY',1568,1,'2025-02-03 07:13:07','2025-02-03 07:13:07'),(1569,NULL,'DUMMY',1569,1,'2025-02-03 07:15:02','2025-02-03 07:15:02'),(1570,NULL,'DUMMY',1570,1,'2025-02-03 07:17:54','2025-02-03 07:17:54'),(1571,NULL,'DUMMY',1571,1,'2025-02-03 07:23:36','2025-02-03 07:23:36'),(1572,NULL,'DUMMY',1572,1,'2025-02-03 07:24:20','2025-02-03 07:24:20'),(1573,NULL,'DUMMY',1573,1,'2025-02-03 07:25:38','2025-02-03 07:25:38'),(1574,NULL,'DUMMY',1574,1,'2025-02-03 07:53:24','2025-02-03 07:53:24'),(1575,NULL,'DUMMY',1575,1,'2025-02-03 08:23:43','2025-02-03 08:23:43'),(1576,NULL,'DUMMY',1576,1,'2025-02-03 08:24:36','2025-02-03 08:24:36'),(1577,NULL,'DUMMY',1577,1,'2025-02-03 08:25:00','2025-02-03 08:25:00'),(1578,NULL,'DUMMY',1578,1,'2025-02-03 08:43:03','2025-02-03 08:43:03'),(1579,NULL,'DUMMY',1579,1,'2025-02-03 09:27:21','2025-02-03 09:27:21'),(1580,NULL,'DUMMY',1580,1,'2025-02-03 09:29:25','2025-02-03 09:29:25'),(1581,NULL,'DUMMY',1581,1,'2025-02-03 09:31:04','2025-02-03 09:31:04'),(1582,NULL,'DUMMY',1582,1,'2025-02-03 09:33:49','2025-02-03 09:33:49'),(1583,NULL,'DUMMY',1583,1,'2025-02-03 09:44:41','2025-02-03 09:44:41'),(1584,NULL,'DUMMY',1584,1,'2025-02-03 09:47:09','2025-02-03 09:47:09'),(1585,NULL,'DUMMY',1585,1,'2025-02-03 09:49:10','2025-02-03 09:49:10'),(1586,NULL,'DUMMY',1586,1,'2025-02-03 09:51:13','2025-02-03 09:51:13'),(1587,NULL,'DUMMY',1587,1,'2025-02-03 09:55:58','2025-02-03 09:55:58'),(1588,NULL,'DUMMY',1588,1,'2025-02-03 09:57:09','2025-02-03 09:57:09'),(1589,NULL,'DUMMY',1589,1,'2025-02-03 09:57:56','2025-02-03 09:57:56'),(1590,NULL,'DUMMY',1590,1,'2025-02-03 09:59:58','2025-02-03 09:59:58'),(1591,NULL,'DUMMY',1591,1,'2025-02-03 10:01:37','2025-02-03 10:01:37'),(1592,NULL,'DUMMY',1592,1,'2025-02-03 10:04:11','2025-02-03 10:04:11'),(1593,NULL,'DUMMY',1593,1,'2025-02-03 10:27:02','2025-02-03 10:27:02'),(1594,NULL,'DUMMY',1594,1,'2025-02-03 10:33:26','2025-02-03 10:33:26'),(1595,NULL,'DUMMY',1595,1,'2025-02-03 10:35:15','2025-02-03 10:35:15'),(1596,NULL,'DUMMY',1596,1,'2025-02-03 10:36:34','2025-02-03 10:36:34'),(1597,NULL,'DUMMY',1597,1,'2025-02-03 10:37:36','2025-02-03 10:37:36'),(1598,NULL,'DUMMY',1598,1,'2025-02-03 10:38:51','2025-02-03 10:38:51'),(1599,NULL,'DUMMY',1599,1,'2025-02-03 10:40:17','2025-02-03 10:40:17'),(1600,NULL,'DUMMY',1600,1,'2025-02-03 10:41:24','2025-02-03 10:41:24'),(1601,NULL,'DUMMY',1601,1,'2025-02-03 11:20:14','2025-02-03 11:20:14'),(1602,NULL,'DUMMY',1602,1,'2025-02-03 12:07:16','2025-02-03 12:07:16'),(1603,NULL,'DUMMY',1603,1,'2025-02-03 12:09:12','2025-02-03 12:09:12'),(1604,NULL,'DUMMY',1604,1,'2025-02-03 12:11:16','2025-02-03 12:11:16'),(1605,NULL,'DUMMY',1605,1,'2025-02-03 12:13:26','2025-02-03 12:13:26');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text COLLATE utf8mb4_unicode_ci,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT '0',
  `not_for_selling` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1606 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'CAD.FIVE STAR MRP 5',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202238826','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(2,'CAD.FIVE STAR MRP 10',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202216145','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(3,'CAD.FIVE STAR MRP 20',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201808037','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(4,'CAD.DAIRYMILK MRP 10',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202272592','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(5,'CAD.DAIRYMILK MRP 20',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202272622','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(6,'CAD.DAIRYMILK MRP 45',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202245541','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(7,'CAD.DAIRYMILK MRP 100',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201762056','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(8,'CAD. ROAST ALMOND MRP 50',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201150143','C128',NULL,NULL,0,'percentage',NULL,NULL,NULL,'18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 14:35:38'),(9,'CAD. LOLLY MRP 5',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201463434','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(10,'CAD. GEMS MRP 10',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202216725','C128',NULL,NULL,0,'fixed','.5',NULL,NULL,'18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-02-03 03:48:04'),(11,'CAD. SHOTS MRP 5',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201150273','C128',NULL,NULL,0,'percentage',NULL,NULL,NULL,'18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-02-02 05:27:02'),(12,'CAD. GEMS BALL MRP 50',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201726218','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(13,'CAD. DAIRYMILK LICKABLES MRP 45',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202020650','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(14,'CAD. OREO VANNILA MRP 10',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202225512','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(15,'CAD. OREO RED VELVET MRP 20',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202252518','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(16,'CAD. OREO VANNILA MRP 30',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201757212','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(17,'CAD. CHOCOBAKES MRP 40',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201385088','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(18,'MALKIST CHOCO MRP 50',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'8996001312490','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(19,'MALKIST CHEESE MRP 50',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'8996001312506','C128',NULL,NULL,0,'fixed','0',NULL,NULL,'18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:37'),(20,'50g Seeragam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000020','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:52:56'),(21,'100g Seeragam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000021','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:52:12'),(22,'200g Seeragam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000022','C128',NULL,NULL,0,'fixed','8',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:52:35'),(23,'200g Big V.Sundal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000023','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:52:33'),(24,'500g Big V.Sundal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000024','C128',NULL,NULL,0,'fixed','8',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:53:10'),(25,'1 Kg Big V.Sundal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000025','C128',NULL,NULL,0,'fixed','17',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:51:40'),(26,'100g Pachai Pattani',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000026','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:54:00'),(27,'200g Pachai Pattani',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000027','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:54:25'),(28,'500g Pachai Pattani',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000028','C128',NULL,NULL,0,'fixed','10',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:54:50'),(29,'1 Kg Pachai Pattani',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000029','C128',NULL,NULL,0,'fixed','22',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:53:27'),(30,'50g Dry Grapes',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000030','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:19:46'),(31,'100g Dry Grapes',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000031','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:19:29'),(32,'Ulundhu 100g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000032','C128',NULL,NULL,0,'fixed','2','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(33,'Ulundhu 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000033','C128',NULL,NULL,0,'fixed','3','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(34,'Ulundhu 500g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000034','C128',NULL,NULL,0,'fixed','7','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(35,'Ulundhu 1Kg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000035','C128',NULL,NULL,0,'fixed','15',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-02 13:06:15'),(36,'Thuvaram Parupu 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000036','C128',NULL,NULL,0,'fixed','3','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(37,'Thuvaram Parupu 500g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000037','C128',NULL,NULL,0,'fixed','7','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(38,'Thuvaram Parupu 1Kg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000038','C128',NULL,NULL,0,'fixed','16','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(39,'100g Black Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000039','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:57:59'),(40,'200g Black Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000040','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:58:23'),(41,'250g Black Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000041','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:58:50'),(42,'100g Avara Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000042','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:07:14'),(43,'200g Avara Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000043','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:07:36'),(44,'250g Avara Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000044','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:08:19'),(45,'500g Avara Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000045','C128',NULL,NULL,0,'fixed','9',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:09:12'),(46,'200g Red Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000046','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:21:36'),(47,'500g Red Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000047','C128',NULL,NULL,0,'fixed','7',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:22:10'),(48,'Kadala Parupu 50g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000048','C128',NULL,NULL,0,'fixed','1','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(49,'Kadala Parupu 100g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000049','C128',NULL,NULL,0,'fixed','1','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(50,'Kadala Parupu 200g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000050','C128',NULL,NULL,0,'fixed','2','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(51,'Kadala Parupu 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000051','C128',NULL,NULL,0,'fixed','2','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(52,'Kadala Parupu 500g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000052','C128',NULL,NULL,0,'fixed','4','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(53,'Kadala Parupu 1Kg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000053','C128',NULL,NULL,0,'fixed','10','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(54,'250g Vella Sundal Small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000054','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:51:53'),(55,'500g vella Sundal Small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000055','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:52:43'),(56,'1Kg Vella Sundal Small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000056','C128',NULL,NULL,0,'fixed','11',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:51:28'),(57,'Soya Beans Small 50g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000057','C128',NULL,NULL,0,'fixed','1','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(58,'Soya Beans Small 100g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000058','C128',NULL,NULL,0,'fixed','1','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(59,'Soya Beans Small 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000059','C128',NULL,NULL,0,'fixed','2','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(60,'250g M.Samba',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000060','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:44:49'),(61,'500g M.Samba',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000061','C128',NULL,NULL,0,'fixed','15',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:45:15'),(62,'250g P.Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000062','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:47:47'),(63,'500g P.Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000063','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:48:16'),(64,'1Kg P.Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000064','C128',NULL,NULL,0,'fixed','12',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:47:22'),(65,'P.Kadalai 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000065','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 10:15:01','2025-01-31 10:17:37'),(66,'P.Kadalai 500g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000066','C128',NULL,NULL,0,'fixed','6',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 10:15:53','2025-02-03 03:07:03'),(67,'250g Pasi Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000067','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 12:20:16','2025-01-31 12:20:16'),(68,'500g Pasi Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000068','C128',NULL,NULL,0,'fixed','6',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 12:21:22','2025-01-31 12:21:22'),(69,'1 Kg Pasi Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000069','C128',NULL,NULL,0,'fixed','12',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 12:22:00','2025-01-31 12:22:00'),(70,'1 Kg Thatta Payaru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000070','C128',NULL,NULL,0,'fixed','12',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:19:44','2025-01-31 18:08:25'),(71,'500g Thatta Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000071','C128',NULL,NULL,0,'fixed','6',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:20:58','2025-01-31 18:09:36'),(72,'250g Thatta Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000072','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:23:57','2025-01-31 18:09:01'),(73,'250g Saamai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000073','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:53:28','2025-01-31 13:53:28'),(74,'500g Saamai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000074','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:54:22','2025-01-31 13:54:22'),(75,'250g Kuthiraivali',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000075','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:56:19','2025-01-31 13:56:19'),(76,'500g Kuthiraivali',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000076','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:56:53','2025-01-31 13:56:53'),(77,'250g Varagu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000077','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:58:58','2025-01-31 13:58:58'),(78,'500g varagu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000078','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:59:27','2025-01-31 13:59:27'),(79,'250g Thinai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000079','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 14:03:12','2025-01-31 14:03:12'),(80,'500g Thinai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000080','C128',NULL,NULL,0,'fixed','8',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 14:03:52','2025-01-31 14:03:52'),(81,'500g Sivapu Arisi',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000081','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 14:06:30','2025-01-31 14:06:31'),(82,'250g Sivapu arisi',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000082','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 14:07:21','2025-01-31 14:07:21'),(83,'Boondi Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000083','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 06:58:51','2025-02-01 09:46:43'),(84,'Poondu Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000084','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 06:59:23','2025-02-01 09:48:58'),(85,'Kaaram Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000085','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 07:00:12','2025-02-01 09:47:50'),(86,'Mixer Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000086','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 07:00:36','2025-02-01 09:48:22'),(87,'Dal Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000087','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 07:00:56','2025-02-01 09:47:11'),(88,'Sev Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000088','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 07:01:16','2025-02-01 09:49:29'),(140,'Turmeric powder 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080014','C128',NULL,NULL,0,'fixed','10','','','9103030','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(141,'Turmeric powder 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080021','C128',NULL,NULL,0,'fixed','19','','','9103030','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(142,'Tumeric powder 200G',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080038','C128',NULL,NULL,0,'fixed','30','','','9103030','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(143,'Tumeric powder 500G',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080045','C128',NULL,NULL,0,'fixed','77','','','9103030','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(144,'Corriander Powder 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080212','C128',NULL,NULL,0,'fixed','7','','','9092200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(145,'Corriander Powder 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080229','C128',NULL,NULL,0,'fixed','12','','','9092200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(146,'Corriander Powder 200GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080236','C128',NULL,NULL,0,'fixed','27','','','9092200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(147,'Corriander Powder 500GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080243','C128',NULL,NULL,0,'fixed','68','','','9092200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(148,'Chilli powder 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080113','C128',NULL,NULL,0,'fixed','16','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(149,'Chilli powder 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080120','C128',NULL,NULL,0,'fixed','32','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(150,'Chilli powder 200GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080137','C128',NULL,NULL,0,'fixed','63','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(151,'Chilli powder 500GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080144','C128',NULL,NULL,0,'fixed','135','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(152,'Curry masla 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080410','C128',NULL,NULL,0,'fixed','14','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(153,'Curry masla 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080427','C128',NULL,NULL,0,'fixed','28','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(154,'Curry masla 200GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080434','C128',NULL,NULL,0,'fixed','56','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(155,'Curry masla 500GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080441','C128',NULL,NULL,0,'fixed','112','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(156,'Sambar powder 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080311','C128',NULL,NULL,0,'fixed','11','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(157,'Sambar powder 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080328','C128',NULL,NULL,0,'fixed','23','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(158,'Sambar powder 200GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080335','C128',NULL,NULL,0,'fixed','45','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(159,'Sambar powder 500GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080342','C128',NULL,NULL,0,'fixed','113','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(160,'Rasam powder 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080618','C128',NULL,NULL,0,'fixed','16','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(161,'Rasam powder 100Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080625','C128',NULL,NULL,0,'fixed','32','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(162,'Chicken masala 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081516','C128',NULL,NULL,0,'fixed','10','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(163,'Chicken masala 100Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081523','C128',NULL,NULL,0,'fixed','20','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(164,'Chicken masala 200Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081561','C128',NULL,NULL,0,'fixed','31','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(165,'Chicken masala 500Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081585','C128',NULL,NULL,0,'fixed','78','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(166,'Mutton masal 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081417','C128',NULL,NULL,0,'fixed','13','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(167,'Mutton masal 100Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081424','C128',NULL,NULL,0,'fixed','26','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(168,'Mutton masal 200Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081486','C128',NULL,NULL,0,'fixed','40','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(169,'Mutton masal 500Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081462','C128',NULL,NULL,0,'fixed','102','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(170,'Pepper powder 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082117','C128',NULL,NULL,0,'fixed','28','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(171,'Garam masala  50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081813','C128',NULL,NULL,0,'fixed','15','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(172,'Chilli Chutney 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080519','C128',NULL,NULL,0,'fixed','7','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(173,'Fish curry 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081776','C128',NULL,NULL,0,'fixed','11','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(174,'Fish fry masala 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081714','C128',NULL,NULL,0,'fixed','15','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(175,'Chilli chicken 65 50gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082018','C128',NULL,NULL,0,'fixed','13','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(176,'Channa masala 50gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082711','C128',NULL,NULL,0,'fixed','10','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(177,'Dall rice powder 100gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080816','C128',NULL,NULL,0,'fixed','19','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(178,'Garlic rice powder 100gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080915','C128',NULL,NULL,0,'fixed','16','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(179,'Tamarind rice 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081011','C128',NULL,NULL,0,'fixed','10','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(180,'Kulambu milaki 50G',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082612','C128',NULL,NULL,0,'fixed','8','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(181,'Egg kurma masala 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081912','C128',NULL,NULL,0,'fixed','15.5','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(182,'Kasmir chilli 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002083725','C128',NULL,NULL,0,'fixed','30','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(183,'Vatha puli 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081318','C128',NULL,NULL,0,'fixed','11','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(184,'Biriyani masala 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081615','C128',NULL,NULL,0,'fixed','16','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(185,'Biriyani masala 200gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081684','C128',NULL,NULL,0,'fixed','48','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(186,'Cumin powder 50G',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082216','C128',NULL,NULL,0,'fixed','24','','','9093200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(187,'Ragi flour 500g',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082506','C128',NULL,NULL,0,'fixed','12','','','1105100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(188,'Baji bonda powder 200',1,'single',1,NULL,NULL,1,2,NULL,11,'inclusive',1,0.0000,'8906002082445','C128',NULL,NULL,0,'fixed','11','','','2106909','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(189,'Baji bonda powder 500',1,'single',1,NULL,NULL,1,2,NULL,11,'inclusive',1,0.0000,'8906002082452','C128',NULL,NULL,0,'fixed','27','','','2106909','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(190,'Country chicken gravy 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082957','C128',NULL,NULL,0,'fixed','13.5','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(191,'Chick Black 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979002035','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(192,'Chick White 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979025836','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,'3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-02 03:43:03'),(193,'Chick Green 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979002080','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(194,'Karthika Powder 2/-',1,'single',1,NULL,NULL,2,NULL,NULL,8,'inclusive',1,0.0000,'8902979000444','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,'3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-02 03:00:30'),(195,'Karthika Shamp BL 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979032865','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(196,'Karthika Shamp R 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979000826','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(197,'Karthika Shamp G 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979027069','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(198,'Meera Powder 4/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979023146','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(199,'Meera Sha Bad 2/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979022682','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(200,'Meera Sha Whi 2/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979029025','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(201,'Chick 80 Ml Black',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979002059','C128',NULL,NULL,0,'fixed','2','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(202,'Chick 180 Ml Black',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979002066','C128',NULL,NULL,0,'fixed','5','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(203,'Karthi 80 Ml Shamp',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979000833','C128',NULL,NULL,0,'fixed','1','','','3304991','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(204,'Karthi 175 Ml Shampoo',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979026727','C128',NULL,NULL,0,'fixed','5','','','3304991','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(205,'Meera 80Ml Sha Bad',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'2025000205','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(206,'Meera 80 Ml Sha Whi',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979029032','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(207,'Meera 180 Ml Sha Bad',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979022798','C128',NULL,NULL,0,'fixed','2','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(208,'Meera 180 Ml Sha Whi',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979029049','C128',NULL,NULL,0,'fixed','2','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(209,'Karthi Powder 10/-',1,'single',1,NULL,NULL,2,NULL,NULL,8,'inclusive',1,0.0000,'8902979026703','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(210,'Karthi 65/- Powder Jar',1,'single',1,NULL,NULL,2,NULL,NULL,8,'inclusive',1,0.0000,'8902979026710','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(211,'Meera 120g Powder',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979023177','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(212,'Meera 40g Powder',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979023153','C128',NULL,NULL,0,'fixed','0.5','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(213,'Meera 80g Powder',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979023160','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(214,'Nyil 90 Ml Green 52/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979053877','C128',NULL,NULL,0,'fixed','1.5','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(215,'Nyil 90 Ml Oran 52/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979053884','C128',NULL,NULL,0,'fixed','1.5','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(216,'Nyil 180 ml Greeen 125/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979053938','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(217,'Nyil 180 ml Oran 115',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979053945','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(218,'Spinz BB 35g 65/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979026871','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-03 09:19:21'),(219,'Spinz BB 70g 120/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979026888','C128',NULL,NULL,0,'fixed','1','','','3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(220,'Spinz Bb Cream 15g',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979005906','C128',NULL,NULL,0,'fixed','1','','','3304991','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(221,'Spinz BB Cream 29g',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979005937','C128',NULL,NULL,0,'fixed','1','','','3304991','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(222,'Spinz Rose 50g 55/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979020022','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-03 08:34:54'),(223,'Spinz Violet 50g 55/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979020060','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-03 08:34:16'),(224,'Spinz Rose 100g 105/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979020039','C128',NULL,NULL,0,'fixed','7',NULL,NULL,'3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-03 09:14:37'),(225,'Spinz Violet 100g 105/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979020077','C128',NULL,NULL,0,'fixed','6',NULL,NULL,'3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-03 08:02:02'),(226,'Indica 21/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979001953','C128',NULL,NULL,0,'fixed','0.5','','','3305904','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(227,'Indica Easy 15/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979011136','C128',NULL,NULL,0,'fixed','0.5','','','1905904','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(228,'Indica Easy 30/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979027137','C128',NULL,NULL,0,'fixed','1','','','3305904','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(229,'250g Kollu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000229','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 12:36:21','2025-02-01 12:36:21'),(230,'500g Kollu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000230','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 12:37:28','2025-02-01 12:37:28'),(231,'100g M.Maker big',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000231','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:29:32','2025-02-01 14:30:23'),(232,'250g M.Maker Big',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000232','C128',NULL,NULL,0,'fixed','1.5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:31:40','2025-02-01 14:32:14'),(233,'50g Vendayam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000233','C128',NULL,NULL,0,'fixed','.5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:35:06','2025-02-01 14:35:06'),(234,'100g vendayam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000234','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:36:18','2025-02-01 14:36:18'),(235,'200g vendayam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000235','C128',NULL,NULL,0,'fixed','2.5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:37:45','2025-02-01 14:37:45'),(236,'50g Kadugu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000236','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:43:37','2025-02-01 14:45:04'),(237,'100g Kadugu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000237','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:44:10','2025-02-03 03:00:47'),(238,'200g Kadugu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000238','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:44:43','2025-02-01 14:44:43'),(239,'10g Annachi Poo',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000239','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:49:52','2025-02-01 14:49:52'),(240,'20g Annachi Poo',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000240','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:50:26','2025-02-01 14:50:26'),(241,'30g Annachi Poo',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000241','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:50:48','2025-02-01 14:50:48'),(242,'10g Marathi Mooku',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000242','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:53:40','2025-02-01 14:54:31'),(243,'20g Marathi Mokku',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000243','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:54:02','2025-02-01 14:54:02'),(244,'10g Lavangam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000244','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:57:17','2025-02-01 14:57:17'),(245,'25g Lavangam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000245','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:57:53','2025-02-01 14:57:53'),(246,'50g Lavangam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000246','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 14:58:17','2025-02-01 14:58:17'),(247,'10g Elachi',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000247','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 15:04:27','2025-02-01 15:04:27'),(248,'20g Elachi',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000248','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 15:04:51','2025-02-01 15:04:51'),(249,'50g Elachi',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000249','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 15:05:25','2025-02-01 15:05:25'),(250,'10g Mundiri',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000250','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 15:08:32','2025-02-01 15:08:32'),(251,'20g Mundiri',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000251','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 15:08:57','2025-02-01 15:08:57'),(252,'50g Mundiri',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000252','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 15:09:28','2025-02-01 15:09:28'),(253,'1 Kg Sugar',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000253','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 16:42:45','2025-02-02 04:01:46'),(254,'500g Sugar',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000254','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 16:45:49','2025-02-01 16:45:49'),(255,'250g Sugar',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000255','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 16:46:50','2025-02-01 16:46:50'),(256,'50g Jadika',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000256','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 17:07:27','2025-02-01 17:07:27'),(257,'200 Ml Har Blu',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396152002','C128',NULL,NULL,0,'fixed','1','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(258,'250 Ml Har Red Flo',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396163107','C128',NULL,NULL,0,'fixed','1','','','3926','',NULL,1,NULL,0,0,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(259,'250 Ml Har Red Lim',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396161851','C128',NULL,NULL,0,'fixed','1','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(260,'200 ml Liz Cit',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396146001','C128',NULL,NULL,0,'fixed','1','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(261,'200 ml Liz Flo',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396147008','C128',NULL,NULL,0,'fixed','1','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(262,'200 ml Liz Jas',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396121503','C128',NULL,NULL,0,'fixed','1','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:56','2025-02-01 17:11:56'),(263,'200 ml Liz Neem',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396142201','C128',NULL,NULL,0,'fixed','1','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(264,'500 Ml Har Blu',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396151005','C128',NULL,NULL,0,'fixed','2','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(265,'500 Ml Har Red Flo',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396153108','C128',NULL,NULL,0,'fixed','5','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(266,'500 Ml Har Red Lim',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396153306','C128',NULL,NULL,0,'fixed','5','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(267,'500 ml Liz Cit',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396112006','C128',NULL,NULL,0,'fixed','3','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(268,'500 ml Liz Flo',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396113003','C128',NULL,NULL,0,'fixed','3','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(269,'500 ml Liz Jas',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396122500','C128',NULL,NULL,0,'fixed','6','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(270,'500 ml Liz Law',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396117407','C128',NULL,NULL,0,'fixed','6','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(271,'500 ml Liz San',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396112501','C128',NULL,NULL,0,'fixed','6','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(272,'500 ml Liz Pine',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396122005','C128',NULL,NULL,0,'fixed','6','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(273,'500 ml Liz Neem',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396142409','C128',NULL,NULL,0,'fixed','6','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(274,'1 ltr Har Blu',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396174400','C128',NULL,NULL,0,'fixed','10','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(275,'1 Ltr Liz Cit',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396139003','C128',NULL,NULL,0,'fixed','5','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(276,'Det Soap CO 100 Mg',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396602316','C128',NULL,NULL,0,'fixed','1','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(277,'Det Soap OR 100 Mg',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396602309','C128',NULL,NULL,0,'fixed','1','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(278,'Det Soap CO 150 Mg',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396602347','C128',NULL,NULL,0,'fixed','1','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(279,'Det Soap OR 150 Mg',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396602330','C128',NULL,NULL,0,'fixed','1','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(280,'Det Soap CO 4+1 100 Mg',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396602125','C128',NULL,NULL,0,'fixed','5','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(281,'Det Soap OR 3+1 100 Mg',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396602088','C128',NULL,NULL,0,'fixed','5','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(282,'Det Soap CO 3+1 150 Mg',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396602132','C128',NULL,NULL,0,'fixed','5','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(283,'Det Soap OR 3+1 150 Mg',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396602095','C128',NULL,NULL,0,'fixed','5','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(284,'Det Liq 125 Ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396350200','C128',NULL,NULL,0,'fixed','1','','','3004909','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(285,'Det Liq 60 Ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396350101','C128',NULL,NULL,0,'fixed','1','','','3004909','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(286,'Det Liq 250 Ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396350309','C128',NULL,NULL,0,'fixed','5','','','3004909','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(287,'Det Liq 550 Ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396354604','C128',NULL,NULL,0,'fixed','5','','','3004909','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(288,'Moov Crm 10g',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901177102509','C128',NULL,NULL,0,'fixed','1','','','3307410','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(289,'Moov Crm 20g',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396389460','C128',NULL,NULL,0,'fixed','5','','','3307410','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(290,'Moov Spray 15g',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901177104909','C128',NULL,NULL,0,'fixed','2','','','3004901','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(291,'Moov Spray 35g',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901177100352','C128',NULL,NULL,0,'fixed','2','','','3004901','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(292,'Drain powder',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396154914','C128',NULL,NULL,0,'fixed','1','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(293,'Har Flushmat',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396155720','C128',NULL,NULL,0,'fixed','2','','','3808940','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(294,'Colin 125 ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396460404','C128',NULL,NULL,0,'fixed','1','','','3402500','',NULL,1,NULL,0,0,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(295,'Colin 250 ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396465003','C128',NULL,NULL,0,'fixed','2','','','3402500','',NULL,1,NULL,0,0,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(296,'Colin 500 ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396476146','C128',NULL,NULL,0,'fixed','2','','','3402500','',NULL,1,NULL,0,0,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(297,'H.Was Lavn 200 ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396323549','C128',NULL,NULL,0,'fixed','2','','','1517','',NULL,1,NULL,0,0,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(298,'H.Was Orig 200 ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396324584','C128',NULL,NULL,0,'fixed','2','','','1517','',NULL,1,NULL,0,0,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(299,'H.Was Skin 200 ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396323372','C128',NULL,NULL,0,'fixed','2','','','1517','',NULL,1,NULL,0,0,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(300,'H.Was Ori 100 ml',1,'single',1,NULL,NULL,3,NULL,NULL,11,'inclusive',1,0.0000,'8901396315803','C128',NULL,NULL,0,'fixed','1','','','3402905','',NULL,1,NULL,0,0,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(301,'Power Sandal',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8906001232421','C128',NULL,NULL,0,'fixed','1','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(302,'Power Lime',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8906001232407','C128',NULL,NULL,0,'fixed','1','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(303,'Power Rose',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8906001232414','C128',NULL,NULL,0,'fixed','1','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(304,'Power Laven',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8906001232438','C128',NULL,NULL,0,'fixed','1','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(305,'Power Papaya',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8906001232384','C128',NULL,NULL,0,'fixed','1','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(306,'Power Jam 10/-',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8906001239826','C128',NULL,NULL,0,'fixed','','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(307,'Power Jambo 20/-',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8906001239727','C128',NULL,NULL,0,'fixed','','','','3401119','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(308,'Para Ayu 180 Ml',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901088207546','C128',NULL,NULL,0,'fixed','5','','','3305901','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(309,'Para Ayu 95 ml',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901088207553','C128',NULL,NULL,0,'fixed','2','','','3305901','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(310,'Para Oil 100 ml',1,'single',1,NULL,NULL,4,NULL,NULL,4,'inclusive',1,0.0000,'89002940','C128',NULL,NULL,0,'fixed','1','','','1513110','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(311,'Para Oil 175 ml',1,'single',1,NULL,NULL,4,NULL,NULL,4,'inclusive',1,0.0000,'8901088050586','C128',NULL,NULL,0,'fixed','1','','','1513110','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(312,'Para Oil 250 ml',1,'single',1,NULL,NULL,4,NULL,NULL,4,'inclusive',1,0.0000,'8901088047142','C128',NULL,NULL,0,'fixed','2','','','1513110','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(313,'Para Oil 25 ml',1,'single',1,NULL,NULL,4,NULL,NULL,4,'inclusive',1,0.0000,'89007426','C128',NULL,NULL,0,'fixed','','','','1513110','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(314,'Para Oil 500 ml',1,'single',1,NULL,NULL,4,NULL,NULL,4,'inclusive',1,0.0000,'8901088000451','C128',NULL,NULL,0,'fixed','4','','','1513110','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(315,'Para Oil 50 ml',1,'single',1,NULL,NULL,4,NULL,NULL,4,'inclusive',1,0.0000,'8901088182973','C128',NULL,NULL,0,'fixed','','','','1513110','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(316,'Para Jas 45 ml',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'89006542','C128',NULL,NULL,0,'fixed','','','','3305901','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(317,'Para Jas 90 ml',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901088076104','C128',NULL,NULL,0,'fixed','1','','','3305901','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(318,'Para Jas 190 ml',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901088045674','C128',NULL,NULL,0,'fixed','2','','','3305901','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(319,'Revive Liq 95 ml',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901088206303','C128',NULL,NULL,0,'fixed','','','','3505109','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(320,'Revive Liq 200 ml',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901088206280','C128',NULL,NULL,0,'fixed','2','','','3505109','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(321,'Revive Liq 400 ml',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901088206273','C128',NULL,NULL,0,'fixed','5','','','3505109','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(322,'Saf Oats 1 Kg',1,'single',1,NULL,NULL,4,NULL,NULL,4,'inclusive',1,0.0000,'8901088055772','C128',NULL,NULL,0,'fixed','5','','','1104120','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(323,'Saf Oats 500 g',1,'single',1,NULL,NULL,4,NULL,NULL,4,'inclusive',1,0.0000,'8901088155496','C128',NULL,NULL,0,'fixed','1','','','1104120','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(324,'Fair Andhan 10/-',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901248253529','C128',NULL,NULL,0,'fixed','','','','3401309','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(325,'Fair Andhan 40/-',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901248253536','C128',NULL,NULL,0,'fixed','','','','3401309','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(326,'Fair Andhan 90/-',1,'single',1,NULL,NULL,4,NULL,NULL,11,'inclusive',1,0.0000,'8901248253543','C128',NULL,NULL,0,'fixed','2','','','3401309','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(327,'Ment Plus 10/-',1,'single',1,NULL,NULL,4,NULL,NULL,8,'inclusive',1,0.0000,'8901248226158','C128',NULL,NULL,0,'fixed','','','','3004901','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(328,'Ment Plus 42/-',1,'single',1,NULL,NULL,4,NULL,NULL,8,'inclusive',1,0.0000,'8901248226189','C128',NULL,NULL,0,'fixed','1','','','3004901','',NULL,1,NULL,0,0,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(329,'Navrathna 45/-',1,'single',1,NULL,NULL,4,NULL,NULL,8,'inclusive',1,0.0000,'8901248104784','C128',NULL,NULL,0,'fixed','','','','3004901','',NULL,1,NULL,0,0,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(330,'Navrathna 85/-',1,'single',1,NULL,NULL,4,NULL,NULL,8,'inclusive',1,0.0000,'8901248104791','C128',NULL,NULL,0,'fixed','2','','','3004901','',NULL,1,NULL,0,0,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(331,'Zandu 8 ml',1,'single',1,NULL,NULL,4,NULL,NULL,8,'inclusive',1,0.0000,'8901248701105','C128',NULL,NULL,0,'fixed','','','','3004901','',NULL,1,NULL,0,0,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(332,'Zandu Ultra',1,'single',1,NULL,NULL,4,NULL,NULL,8,'inclusive',1,0.0000,'8901248701129','C128',NULL,NULL,0,'fixed','','','','3004901','',NULL,1,NULL,0,0,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(333,'Aachi 10/- Citran',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021129749','C128',NULL,NULL,0,'fixed','','','','2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(334,'Aachi 10/- CutMango',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021128599','C128',NULL,NULL,0,'fixed','.5',NULL,NULL,'2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-03 11:08:36'),(335,'Aachi 10/- Garlic',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021128612','C128',NULL,NULL,0,'fixed','0.5',NULL,NULL,'2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-03 11:23:01'),(336,'Aachi 10/- Lemon',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021128629','C128',NULL,NULL,0,'fixed','0.5',NULL,NULL,'2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-03 11:21:24'),(337,'Aachi 100 g Citran',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8904209301659','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-03 11:25:16'),(338,'Aachi 100 g CutMan',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8904209303783','C128',NULL,NULL,0,'fixed','','','','2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(339,'Aachi 100 g Lemon',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021122016','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-03 11:52:42'),(340,'Aachi 200 g CutMan',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8904209303783','C128',NULL,NULL,0,'fixed','5','','','2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(341,'Aachi 200 g Garlic',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8904209303806','C128',NULL,NULL,0,'fixed','10',NULL,NULL,'2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-03 11:24:51'),(342,'Aachi 200 g Lemon',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8904209303776','C128',NULL,NULL,0,'fixed','9',NULL,NULL,'2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-03 11:23:28'),(343,'Aachi 300 g Lemon',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021122023','C128',NULL,NULL,0,'fixed','5','','','2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(344,'Aachi 300 g CutMan',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021122108','C128',NULL,NULL,0,'fixed','12',NULL,NULL,'2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-03 11:24:17'),(345,'Aachi 300 g Garlic',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021121286','C128',NULL,NULL,0,'fixed','5','','','2001900','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(346,'Aachi Payasam 100g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021129107','C128',NULL,NULL,0,'fixed','5','','','2106909','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(347,'Aachi Payasam 175g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021122719','C128',NULL,NULL,0,'fixed','5','','','2106909','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(348,'Aachi GulabJam 160g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021127066','C128',NULL,NULL,0,'fixed','5','','','2106909','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(349,'Aachi Badam (M) 100g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021127981','C128',NULL,NULL,0,'fixed','5','','','2106909','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(350,'Aachi Badam (M) 180g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021120180','C128',NULL,NULL,0,'fixed','5','','','2202993','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(351,'Aachi Asaf 10g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021124416','C128',NULL,NULL,0,'fixed','','','','1310901','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(352,'Aachi Asaf 20g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021120128','C128',NULL,NULL,0,'fixed','2','','','1310901','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(353,'Aachi Asaf 50g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021120135','C128',NULL,NULL,0,'fixed','5','','','1310901','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(354,'Aachi Asaf 100g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021126168','C128',NULL,NULL,0,'fixed','45',NULL,NULL,'1310901','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-03 11:21:03'),(355,'Aachi Health 200g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021122665','C128',NULL,NULL,0,'fixed','8','','','1106109','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(356,'Aachi Health 500g',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8906021122672','C128',NULL,NULL,0,'fixed','20','','','1106109','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(357,'Aachi Panipuri',1,'single',1,NULL,NULL,5,NULL,NULL,4,'inclusive',1,0.0000,'8904209317339','C128',NULL,NULL,0,'fixed','5','','','1905904','',NULL,1,NULL,0,0,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(358,'Mr.SunFL 1 Ltr',1,'single',1,NULL,NULL,6,NULL,NULL,NULL,'inclusive',1,0.0000,'8908002396010','C128',NULL,NULL,0,'fixed','10','','','1512191','',NULL,1,NULL,0,0,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(359,'Mr.SunFL 500 Ml',1,'single',1,NULL,NULL,6,NULL,NULL,NULL,'inclusive',1,0.0000,'8908002396140','C128',NULL,NULL,0,'fixed','5','','','1512191','',NULL,1,NULL,0,0,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(360,'Mr.SunFL 5L',1,'single',1,NULL,NULL,6,NULL,NULL,NULL,'inclusive',1,0.0000,'8908002396379','C128',NULL,NULL,0,'fixed','25','','','1512191','',NULL,1,NULL,0,0,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(361,'Mr.Ground 1 Ltr',1,'single',1,NULL,NULL,6,NULL,NULL,NULL,'inclusive',1,0.0000,'8908002396959','C128',NULL,NULL,0,'fixed','10','','','1508100','',NULL,1,NULL,0,0,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(362,'Mr.Ground 500 ml',1,'single',1,NULL,NULL,6,NULL,NULL,NULL,'inclusive',1,0.0000,'8908002396966','C128',NULL,NULL,0,'fixed','5','','','1508100','',NULL,1,NULL,0,0,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(363,'Mr.Ground 5L',1,'single',1,NULL,NULL,6,NULL,NULL,NULL,'inclusive',1,0.0000,'8906125670161','C128',NULL,NULL,0,'fixed','25','','','1508100','',NULL,1,NULL,0,0,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(364,'Mr.Lamp 1 Ltr',1,'single',1,NULL,NULL,6,NULL,NULL,NULL,'inclusive',1,0.0000,'8908002396157','C128',NULL,NULL,0,'fixed','10','','','1518004','',NULL,1,NULL,0,0,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(365,'Mr.Lamp 500 ml',1,'single',1,NULL,NULL,6,NULL,NULL,NULL,'inclusive',1,0.0000,'8908002396164','C128',NULL,NULL,0,'fixed','5','','','1518004','',NULL,1,NULL,0,0,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(366,'Mr.Lamp 200 ml',1,'single',1,NULL,NULL,6,NULL,NULL,NULL,'inclusive',1,0.0000,'8908002396171','C128',NULL,NULL,0,'fixed','5','','','1518004','',NULL,1,NULL,0,0,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(367,'A Roasted Ver 180 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'2025000367','C128',NULL,NULL,0,'fixed','4','','','1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(368,'A Kambu Ver 180G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042150159','C128',NULL,NULL,0,'fixed','5',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 03:50:47'),(369,'A Varagu Ver 180 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042150173','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:27:51'),(370,'A Cholam Ver',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042150166','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:28:14'),(371,'A Thinai Ver 180 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042150197','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:28:38'),(372,'A Wheat Ver 180 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042150180','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:31:28'),(373,'A Rice Ver 200 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042151095','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:21:57'),(374,'A Tamarind Ver 200 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042150098','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:30:40'),(375,'A Lemon Ver 200 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042150104','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:30:11'),(376,'A Briyani Ver 200 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042151019','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:29:41'),(377,'A Surya Noodles 180 G',1,'single',1,NULL,NULL,7,3,NULL,8,'inclusive',1,0.0000,'8906019630073','C128',NULL,NULL,0,'fixed','1',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 04:14:52'),(378,'A Noodles 110 G',1,'single',1,NULL,NULL,7,3,NULL,8,'inclusive',1,0.0000,'8906042151132','C128',NULL,NULL,0,'fixed','0.5',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:29:19'),(379,'A Noodles 220 G',1,'single',1,NULL,NULL,7,3,NULL,8,'inclusive',1,0.0000,'8906042151149','C128',NULL,NULL,0,'fixed','1',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:26:04'),(380,'A Rava 1 KG',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'2025000380','C128',NULL,NULL,0,'fixed','1','','','110311','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(381,'A Rava 500 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042151569','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 03:28:28'),(382,'A Rava 200 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042151552','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'110311','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 03:32:47'),(383,'A Maida Refind 1 KG',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042151545','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'11010','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 04:14:02'),(384,'A Maida Refind 500 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042151538','C128',NULL,NULL,0,'fixed','1',NULL,NULL,'11010','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 03:51:34'),(385,'A Maida Refind 200 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042151668','C128',NULL,NULL,0,'fixed','0.5',NULL,NULL,'11010','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 03:52:04'),(386,'A Samba Rava 200 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042150517','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'11042900','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 03:49:54'),(387,'A Samba Rava 500 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'2025000387','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'11042900','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 03:33:30'),(388,'A Instant Idiyappam 150 G',1,'single',1,NULL,NULL,7,3,NULL,4,'inclusive',1,0.0000,'8906042150425','C128',NULL,NULL,0,'fixed','12',NULL,NULL,'1902','',NULL,1,NULL,0,0,'2025-02-01 17:42:21','2025-02-03 02:27:24'),(389,'Santoor Orange 44 G',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399023651','C128',NULL,NULL,0,'fixed','0','','','3401','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(390,'Santoor Orange 100 G',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399000591','C128',NULL,NULL,0,'fixed','0.5','','','3401','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(391,'Santoor White',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399010019','C128',NULL,NULL,0,'fixed','0.5','','','3401','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(392,'Santoor Orange 150g*4SSP',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399005442','C128',NULL,NULL,0,'fixed','3','','','3401','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(393,'Chandrika Original 75 g',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399009020','C128',NULL,NULL,0,'fixed','0.5','','','3401','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(394,'Chandrika Original 125 g',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399022012','C128',NULL,NULL,0,'fixed','1','','','3401','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(395,'Chandrika Set 75g*3 +1',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399024160','C128',NULL,NULL,0,'fixed','1','','','3401','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(396,'Chandrika Set 3 * 125 G',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399009037','C128',NULL,NULL,0,'fixed','2','','','3401','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(397,'Glucose Powder Glucovita 75 G',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399004087','C128',NULL,NULL,0,'fixed','0.5','','','1702','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(398,'Glucose Powder Glucovita 200 G',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399004100','C128',NULL,NULL,0,'fixed','1','','','1702','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(399,'Glucose Powder Glucovita 450 g',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399004124','C128',NULL,NULL,0,'fixed','2','','','1702','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(400,'Bolts Orange 18g',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399088131','C128',NULL,NULL,0,'fixed','0.5','','','1702','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(401,'Soft Blue 20 Ml',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399337512','C128',NULL,NULL,0,'fixed','0','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(402,'Soft Pink 20 Ml',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399335518','C128',NULL,NULL,0,'fixed','0','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(403,'Soft Green 20 Ml',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399031731','C128',NULL,NULL,0,'fixed','0','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(404,'Soft Black 20 Ml',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399339554','C128',NULL,NULL,0,'fixed','0','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(405,'Soft Purple 20 Ml',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399333552','C128',NULL,NULL,0,'fixed','0','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(406,'Softtouch Blue',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399017452','C128',NULL,NULL,0,'fixed','1','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(407,'Softtouch Black',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399017476','C128',NULL,NULL,0,'fixed','1','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(408,'Softtouch Purple',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399017483','C128',NULL,NULL,0,'fixed','1','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(409,'Softtouch Pink',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399017469','C128',NULL,NULL,0,'fixed','1','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(410,'Softtouch Fabcon Pink 860 + 40',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399334016','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(411,'Softtouch Fabcon Purple 860 +40',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399333170','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(412,'Softtouch Fabcon Blue 860 +40',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399336010','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(413,'Softtouch Fabcon Black 800 +20',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399339134','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(414,'Softtouch Black 400 Ml',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399339615','C128',NULL,NULL,0,'fixed','1','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(415,'Softtouch Blue 400 Ml',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399338014','C128',NULL,NULL,0,'fixed','1','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(416,'D Wash Giffy 750 Ml',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399191411','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(417,'D Wash Giffy 500 Ml 1+1',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399191213','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(418,'D Giffy Steel Scrub',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399024009','C128',NULL,NULL,0,'fixed','0','','','119703','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(419,'D Wash Giffy Scrub',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399194504','C128',NULL,NULL,0,'fixed','0','','','9603','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(420,'SafeWash FL 1L pouch',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399001833','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(421,'Safewash TL 1L Pouch',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399001840','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(422,'Safewash TL 1.5',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399078569','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(423,'Safewash FL 1L Jar',1,'single',1,NULL,NULL,NULL,4,NULL,11,'inclusive',1,0.0000,'8901399079702','C128',NULL,NULL,0,'fixed','2','','','7708','',NULL,1,NULL,0,0,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(424,'10.RS VVD RIGIT',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'8906009512020','C128',NULL,NULL,0,'fixed','0','','','1513','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(425,'40ML VVD RIGID MRP15',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'8906009512013','C128',NULL,NULL,0,'fixed','0','','','1513','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(426,'100ML. VVD RIGID MRP 45',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'8906009512112','C128',NULL,NULL,0,'fixed','2','','','1513','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(427,'175ML VVD RIGID MRP 78',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'8906009512303','C128',NULL,NULL,0,'fixed','2','','','1513','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(428,'250ML VVD RIGID MRP 110',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'8906009512310','C128',NULL,NULL,0,'fixed','5','','','1513','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(429,'500ML. VVD RIGIT MRP210',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'8906009512402','C128',NULL,NULL,0,'fixed','10','','','1513','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(430,'900ML VEDA LAMP MRP 230',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'8906009518008','C128',NULL,NULL,0,'fixed','15','','','1508','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(431,'LG 100G BOTTLE',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'840222000156','C128',NULL,NULL,0,'fixed','5','','','13019013','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(432,'LG 50G BOTTLE',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'840222000149','C128',NULL,NULL,0,'fixed','5','','','13019013','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(433,'LG MRP 25',1,'single',1,NULL,NULL,NULL,5,NULL,4,'inclusive',1,0.0000,'840222000002','C128',NULL,NULL,0,'fixed','0','','','13019013','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(434,'KINDERJOY 48',1,'single',1,NULL,NULL,NULL,5,NULL,11,'inclusive',1,0.0000,'80135890','C128',NULL,NULL,0,'fixed','0','','','1806','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(435,'KINDER CREA TO MRP 30',1,'single',1,NULL,NULL,NULL,5,NULL,11,'inclusive',1,0.0000,'80824107','C128',NULL,NULL,0,'fixed','0','','','1806','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(436,'Tic tac (stand)',1,'single',1,NULL,NULL,NULL,5,NULL,11,'inclusive',1,0.0000,'8000500366776','C128',NULL,NULL,0,'fixed','0','','','1704','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(437,'TIC TAC 16p MRP 10',1,'single',1,NULL,NULL,NULL,5,NULL,11,'inclusive',1,0.0000,'8000500416198','C128',NULL,NULL,0,'fixed','0','','','1704','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(438,'TIC TAC (9IG JAR) MRP 360',1,'single',1,NULL,NULL,NULL,5,NULL,11,'inclusive',1,0.0000,'8000500423127','C128',NULL,NULL,0,'fixed','0','','','1704','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(439,'Ukg Pouch MRP 20',1,'single',1,NULL,NULL,NULL,5,NULL,8,'inclusive',1,0.0000,'8908000655317','C128',NULL,NULL,0,'fixed','0','','','4059020','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(440,'Ukg 50ml jar',1,'single',1,NULL,NULL,NULL,5,NULL,8,'inclusive',1,0.0000,'8908000655188','C128',NULL,NULL,0,'fixed','2','','','4059020','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(441,'Ukg 100ml jar',1,'single',1,NULL,NULL,NULL,5,NULL,8,'inclusive',1,0.0000,'8908000655164','C128',NULL,NULL,0,'fixed','2','','','4059020','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(442,'Ukg 200ml jar',1,'single',1,NULL,NULL,NULL,5,NULL,8,'inclusive',1,0.0000,'8908000655140','C128',NULL,NULL,0,'fixed','6','','','4059020','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(443,'Ukg 500ml jar',1,'single',1,NULL,NULL,NULL,5,NULL,8,'inclusive',1,0.0000,'8908000655119','C128',NULL,NULL,0,'fixed','20','','','4059020','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(444,'Ukg 1lit jar',1,'single',1,NULL,NULL,NULL,5,NULL,8,'inclusive',1,0.0000,'8908000655096','C128',NULL,NULL,0,'fixed','20','','','4059020','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(445,'MAS BADAM MIX',1,'single',1,NULL,NULL,NULL,5,NULL,11,'inclusive',1,0.0000,'8908010488004','C128',NULL,NULL,0,'fixed','5','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(446,'SENSODENT K 125G MRP 175',1,'single',1,NULL,NULL,NULL,5,NULL,11,'inclusive',1,0.0000,'8902281614803','C128',NULL,NULL,0,'fixed','5','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(447,'SENSODENT KF 125G MRP 185',1,'single',1,NULL,NULL,NULL,5,NULL,11,'inclusive',1,0.0000,'8902281614810','C128',NULL,NULL,0,'fixed','5','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(448,'SENSODENT KF 75G MRP 123',1,'single',1,NULL,NULL,NULL,5,NULL,11,'inclusive',1,0.0000,'8902281614780','C128',NULL,NULL,0,'fixed','5','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(449,'AER O coolaqua 7.5g M99 PO60',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023029554','C128',NULL,NULL,0,'fixed','3','','','33079090','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(450,'AER O muskaftsmoke 7.5g M99 P060',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023029561','C128',NULL,NULL,0,'fixed','3','','','33070090','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(451,'AER O Roseblossom 7.5g M99 PO60',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023029578','C128',NULL,NULL,0,'fixed','3','','','33079090','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(452,'AER POWER POCKET BERRY RUSH 10G M65P120',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023025068','C128',NULL,NULL,0,'fixed','2','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(453,'AER POWER POCKET JASFLORDELI 10G M65P120',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023025846','C128',NULL,NULL,0,'fixed','2','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(454,'AER POWER POCKET LEMTANGYDEL 10G M65P120',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023028434','C128',NULL,NULL,0,'fixed','2','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(455,'AER POWERPOCKET SEABREEZE 10G M65P120',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023025082','C128',NULL,NULL,0,'fixed','2','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(456,'AER PWR POCKET LAV BLOOM 10G M65P120NP',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023025181','C128',NULL,NULL,0,'fixed','2','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(457,'AER PWRPOCKET ROSEFRBLOSSM 10G M65P120NP',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023025075','C128',NULL,NULL,0,'fixed','2','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(458,'AER SPRAY COOLSURFBLUE 220ML M99P24 NEW',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157045116','C128',NULL,NULL,0,'fixed','3','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(459,'AER SPRAY FRESHLUSHGREEN220ML M99P24NEW',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157045109','C128',NULL,NULL,0,'fixed','3','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(460,'AER SPRAY LAVENDERBLOOM 220ML M99P24',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023012884','C128',NULL,NULL,0,'fixed','3','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(461,'AER SPRAY MORNINGMISTY 220ML M99P24 NEW',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023012877','C128',NULL,NULL,0,'fixed','3','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(462,'AER SPRAY MUSKAFTER SMOKE 220ML M99P24',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157045147','C128',NULL,NULL,0,'fixed','3','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(463,'AER SPRAY ROSEBLOSSOM 220ML M99P24',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157045093','C128',NULL,NULL,0,'fixed','3','','','33074900','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(464,'CIN COOL 100G PO4 M160 P36 NEW',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023004599','C128',NULL,NULL,0,'fixed','5',NULL,NULL,'34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-03 10:19:50'),(465,'Cin Cool 100g Singles M50 P150 New',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023010415','C128',NULL,NULL,0,'fixed','0.5','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(466,'CIN COOL 40G OVERWRAP M10 P216',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023028519','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(467,'Cin Health+ 100g PO3 M150 P50 GT NEW',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023010453','C128',NULL,NULL,0,'fixed','3','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(468,'Cin Health+ 100g Singles M50 P150 NEW',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023022494','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(469,'Cin Health+ 40g NEW M10 P216 (Poly)',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023028526','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(470,'CIN LIME 100G SINGLES M44 P150 NEW',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023010484','C128',NULL,NULL,0,'fixed','0.5','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(471,'Cin Lime 40g sing M10 P216 (Sleevewrap)',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023028502','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(472,'CIN LIME 75G PO4 M115.00 P50ROI',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023003622','C128',NULL,NULL,0,'fixed','2','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(473,'Cin Org 100g PO4 M195 P36 New',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023009891','C128',NULL,NULL,0,'fixed','5','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(474,'CIN ORIGINAL 100G NP SINGLE M50.00 P160',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023000034','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(475,'CIN ORIGINAL 33G (OVERWRAP) M10P240',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023028779','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(476,'Cin Original 75g Singles M41 P200 New',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023007903','C128',NULL,NULL,0,'fixed','0.5','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(477,'Cin Original Singles 150g M78 P96 New',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023012105','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(478,'CIN SHAVING CREAM 20G LIME FRESH M27P72',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023001734','C128',NULL,NULL,0,'fixed','','','','33071010','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(479,'CIN SHAVING CREAM LIME FRESH 78G M85 P72',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023001789','C128',NULL,NULL,0,'fixed','1','','','33071010','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(480,'CIN SHAVING CREAM MENTHOL 78G M85 P72',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023001772','C128',NULL,NULL,0,'fixed','1','','','33071010','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(481,'ExpCrm 12g NBlk P240 M15',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023028748','C128',NULL,NULL,0,'fixed','','','','33059040','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(482,'ExpCm 20g P010 NBIK P240 M40',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023019876','C128',NULL,NULL,0,'fixed','1','','','33059040','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(483,'GENTEEL 1Kg Rfill MRP150 PK12 N',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023019357','C128',NULL,NULL,0,'fixed','5','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(484,'GK ACTIV+ REFILL M85.00 P240 RNF',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023019722','C128',NULL,NULL,0,'fixed','1','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(485,'GK Agarbatti M12 P288',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023029813','C128',NULL,NULL,0,'fixed','','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(486,'GK COIL 4FR MAHAJMB M43 P36 RNF',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023030314','C128',NULL,NULL,0,'fixed','1','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(487,'GK COIL ADV LOWSMOKE 12HR M45 P60',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157004342','C128',NULL,NULL,0,'fixed','1','','','36089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(488,'GK COIL GREENSHAKTI LSC12HR M45 P60',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023017254','C128',NULL,NULL,0,'fixed','1','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(489,'GK FLASH COMBI M105.00 P60 RNF',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023019715','C128',NULL,NULL,0,'fixed','2','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(490,'GK FLASH REFILL 45ML M85.00 P240 RNF',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023019722','C128',NULL,NULL,0,'fixed','2','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(491,'GK FLASH REFILL 60ML M100.00 P120 RNF',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023021701','C128',NULL,NULL,0,'fixed','2','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(492,'GK FLASH REFILL PO2 M165.00 P120 GTMTRNF',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023019739','C128',NULL,NULL,0,'fixed','2','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(493,'GK PW ACTIV+ PO2 REFILL M165.00 P120 RNF',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157021028','C128',NULL,NULL,0,'fixed','2','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(494,'Godrej Fab 1Ltr Pouch PK12 MRP99 NF',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023029721','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'34022010','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-03 03:45:55'),(495,'Godrej Fab 2Ltr Pouch PK6 MRP225-NF',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023030413','C128',NULL,NULL,0,'fixed','3','','','34022010','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(496,'GODREJ FAB 90ML SACHET M10 P72',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023029738','C128',NULL,NULL,0,'fixed','','','','34022010','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(497,'Godrej Selfie SHC 5ml+5ml P360 M15 NBick',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023029486','C128',NULL,NULL,0,'fixed','','','','33059040','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(498,'Godrej SelfieSHC 9ml+9ml P144 M30 NBick',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023018688','C128',NULL,NULL,0,'fixed','','','','33059040','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(499,'HIT ANTI ROACH 15G M99 P96',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023030802','C128',NULL,NULL,0,'fixed','2','','','38089199','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(500,'HIT CHALK M20 P360',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'7901172028003','C128',NULL,NULL,0,'fixed','','','','38089910','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(501,'HIT CIK 125ML MRP75 P90',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157025255','C128',NULL,NULL,0,'fixed','','','','38089199','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(502,'HIT CIK 200ML M105 P60 L',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157025071','C128',NULL,NULL,0,'fixed','2','','','38089199','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(503,'HIT CIK 320ML M210 P50 0.18 HT 20%',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157025057','C128',NULL,NULL,0,'fixed','2','','','38089199','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(504,'HIT CIK 320ML M210.00 P50 0.18',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157025057','C128',NULL,NULL,0,'fixed','2','','','38089199','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(505,'HIT FIK 125ML MRP85 P90 NEW L',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157025286','C128',NULL,NULL,0,'fixed','1','','','38089199','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(506,'HIT FIK 200ML M120 P60 Can 0.18mm NEW L',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157025033','C128',NULL,NULL,0,'fixed','2','','','38089199','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(507,'HIT FIK 320ML M210 P50 New L HT20% T0.18',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157025019','C128',NULL,NULL,0,'fixed','5','','','38089199','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(508,'HIT FIK LIME 200ML M140 P60 0.18 43%',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023014284','C128',NULL,NULL,0,'fixed','2','','','38089199','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(509,'HIT Rat Glue 25g MRP60 P100',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901157027020','C128',NULL,NULL,0,'fixed','2','','','38089990','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(510,'HIT Rat Glue 50g MRP120 P50',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023019388','C128',NULL,NULL,0,'fixed','5','','','38089990','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(511,'HIT RAT KILL M25 P360',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901023019371','C128',NULL,NULL,0,'fixed','','','','38089910','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(512,'KS BLAZE 150ML M99 P24 ACCESS PACK TN',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901216812895','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'33072000','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-03 07:20:50'),(513,'KS DARE 150ML M99 P24 ACCESSS PACK TN',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901216713024','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'33072000','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-03 07:32:48'),(514,'KS RUSH 150ML M99 P24',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901216812062','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'33072000','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-03 07:45:22'),(515,'KS SPARK 150ML M99P24 ACCESS PACK TN',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901216713017','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'33072000','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-03 07:46:44'),(516,'KS THRILL 150ML M99P24 ACCESS PACK TN',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901216812888','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'33072000','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-03 07:28:38'),(517,'KS URGE 150ML M99P24 ACCESS PACK TN',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901216713031','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'33072000','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-03 07:46:26'),(518,'PA SC Classic 84g M75 P144 GCPL',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901277012401','C128',NULL,NULL,0,'fixed','2','','','33071010','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(519,'PA SC Good Morning 84g M75 P144 GCPL',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901277012449','C128',NULL,NULL,0,'fixed','2','','','33071010','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(520,'PA SOAP GD MRNG 125G B3G1.240.00 P27 N',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901277012654','C128',NULL,NULL,0,'fixed','10','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(521,'PA SOAP PURE LXRY 125G B3G1.240.00 P27 N',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901277014573','C128',NULL,NULL,0,'fixed','10','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(522,'PREMIUM EDC GB 100ML M175P48',1,'single',1,NULL,NULL,NULL,6,NULL,11,'inclusive',1,0.0000,'8901277007445','C128',NULL,NULL,0,'fixed','25',NULL,NULL,'33030090','',NULL,1,NULL,0,0,'2025-02-01 18:01:42','2025-02-03 07:49:57'),(523,'Gopuram wp 26kg 1000',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000523','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(524,'Gopuram oldbpt 26kg 650',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000524','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(525,'Aksayagopuram kichadi 26kg 200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000525','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(526,'Gopuram kichadi 26kg 100',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000526','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(527,'AA wp 26kg 100',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000527','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(528,'Sr old wp 26kg 200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000528','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(529,'Rettaikilli oldbpt 26kg 400',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000529','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(530,'Rettaikilli kar 26kg 300',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000530','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(531,'Garuda kichadi 26kgtsb',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000531','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(532,'Bluerose kichadi 26kg 100',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000532','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(533,'Kalyanaspecial kichadi 26kg 20',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000533','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(534,'Amutham gold kichadi26 kg200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000534','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(535,'Dhivyamelite kichadi 26kg 100',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000535','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(536,'Krg gold kichadi 26kg 100',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000536','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(537,'Meenachi gopuram kichadi26kg15',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000537','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(538,'Meenachi gopuram obpt 26kg 200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000538','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(539,'Royal dlx 26kg 150',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000539','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(540,'Kamalam ir5026kg300',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000540','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(541,'Orangekar26kg 300',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000541','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(542,'AMK alayam kar26kg120',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000542','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(543,'Migold ponnipacha 26kg old',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000543','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(544,'Taj IR0pachai 26Kg old',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000544','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(545,'Nethiyam kichadi 26kg200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000545','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(546,'Sproyalbullet kolah 26kg 200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000546','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(547,'Gopuram wp 10kg 200 old',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000547','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(548,'Rettaikili bpt 10kg 200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000548','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(549,'Rettaikili bpt 5kg 300',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000549','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(550,'Garuda kichadi 05kg 200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000550','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(551,'Garuda kichadi 10kg 100',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000551','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(552,'Bluerose kdx 5kg10',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000552','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(553,'Bluerose kdx10kg 200 old',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000553','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(554,'Rettai killi kar 5kg 100',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000554','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(555,'Rettaikili Idly 10kg 250',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000555','C128',NULL,NULL,0,'percentage',NULL,NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-03 06:36:53'),(556,'Rose kar 5g 1200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000556','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(557,'Rose kar 10kg 200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000557','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(558,'Daawat pulay2kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000558','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(559,'Naazreen basmathi 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000559','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(560,'Indiagate dubar 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000560','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(561,'Indiagate classic 1kg 20',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000561','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(562,'India gate super 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000562','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(563,'Indiagate rozana basmathi 1KG',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000563','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(564,'Roseseeragam 1kg 6',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000564','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(565,'M karuppu kavuni rice 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000565','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(566,'M samai rice 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000566','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(567,'M thinai rice 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000567','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(568,'M varagu rice 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000568','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(569,'M kutgiraivali rice 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000569','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(570,'M kattuyanam rice 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000570','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(571,'M mappilai samba rice 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000571','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(572,'M red rice 1kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000572','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(573,'Nachiyar kdx 26kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000573','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(574,'Nachiyar kdx 10kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000574','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(575,'Nachiyar kdx 5kg',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000575','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(576,'Doubledeer basmathi 25kg10',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000576','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(577,'Malar kdx 26kg 200',1,'single',1,NULL,NULL,NULL,7,NULL,NULL,'inclusive',1,0.0000,'2025000577','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(578,'Col Tpw 50g',1,'single',1,NULL,NULL,8,NULL,NULL,8,'inclusive',1,0.0000,'8901314013798','C128',NULL,NULL,0,'fixed','1','','','33061010','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(579,'CDC 38GM 12+2 CD',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314717429','C128',NULL,NULL,0,'fixed','0.5','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(580,'CAS 36G B 6+1 RS.2',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314763686','C128',NULL,NULL,0,'fixed','0.5','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(581,'CMF 38G B6+1 RS.1',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314830289','C128',NULL,NULL,0,'fixed','0.5','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(582,'CDC 100GM FREE P',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314765352','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(583,'CDC 16G 12+1 RS.1',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314786043','C128',NULL,NULL,0,'fixed','0','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(584,'CAS 17G 12+1 RS.1',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314786241','C128',NULL,NULL,0,'fixed','0','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(585,'CDC 150 RL',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314765338','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(586,'CDC TP 200+100+T',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314765321','C128',NULL,NULL,0,'fixed','2','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(587,'CDC 200 RL',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314765314','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(588,'CDC 100+15% EXTRA',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314714299','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(589,'CAS 100G+15% EX',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314713759','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(590,'COLGATE MAX FRESH C',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314711434','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(591,'CIBACA 65G',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314644435','C128',NULL,NULL,0,'fixed','0.5','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(592,'CIBACA 175G',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314081018','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(593,'COL HERB TPST 100GM',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314021540','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(594,'CAS NEEM 100G',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314009333','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(595,'COL ACTSALT TPST200',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314009081','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(596,'CAS 100+200 save',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314009067','C128',NULL,NULL,0,'fixed','2','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(597,'COL MW FRESH TE',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314823304','C128',NULL,NULL,0,'fixed','1','','','33069000','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(598,'Kids Sup Junior 9+3',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314636447','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-03 07:09:07'),(599,'Super Flexi PO3 M',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314779823','C128',NULL,NULL,0,'fixed','1','','','96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(600,'Col ZZ PO3 M',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314116420','C128',NULL,NULL,0,'fixed','7',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-03 07:16:13'),(601,'Col Kids 2+yr 6+1 S',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314542175','C128',NULL,NULL,0,'fixed','5',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-03 06:48:01'),(602,'Gentle Sensitive 6+1',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314790545','C128',NULL,NULL,0,'fixed','9',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-03 07:11:52'),(603,'Zigzag Char PO4',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314532022','C128',NULL,NULL,0,'fixed','15',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-03 07:15:48'),(604,'Gentle Sensitive+P',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314117250','C128',NULL,NULL,0,'fixed','20',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-03 06:49:03'),(605,'SupFlex Char 10+2',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314524942','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-02 06:40:16'),(606,'Gentle Sensitive Pac',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314308177','C128',NULL,NULL,0,'fixed','20',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-03 06:51:47'),(607,'ZZ 9+3 GC (M)',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314560797','C128',NULL,NULL,0,'fixed','3','','','96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(608,'SF 11+2 ZZ+CMF',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314507327','C128',NULL,NULL,0,'fixed','7',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-03 06:53:08'),(609,'Col Zigzag PO6 S',1,'single',1,NULL,NULL,8,NULL,NULL,11,'inclusive',1,0.0000,'8901314308443','C128',NULL,NULL,0,'fixed','15',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 18:09:49','2025-02-03 06:49:57'),(610,'GiftBox',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8901123005700','C128',NULL,NULL,0,'fixed','2','','','17049030','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(611,'Amurthanjan S 2/-',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8901803001176','C128',NULL,NULL,0,'fixed','','','','30049011','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(612,'Amurthanjan Y 2/-',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8901803001169','C128',NULL,NULL,0,'fixed','','','','30049011','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(613,'Deepam 1L',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906010260125','C128',NULL,NULL,0,'fixed','5','','','1515','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(614,'Deepam 500 ml',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906010260118','C128',NULL,NULL,0,'fixed','3','','','1515','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(615,'Deepam 200 ml',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906010260095','C128',NULL,NULL,0,'fixed','1','','','1515','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(616,'Gold 1L',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906010261078','C128',NULL,NULL,0,'fixed','20',NULL,NULL,'15121910','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-03 05:52:16'),(617,'Gold 500 ml',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906010261047','C128',NULL,NULL,0,'fixed','13.5',NULL,NULL,'15121910','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-03 11:01:29'),(618,'M.Mix 125G',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057530861','C128',NULL,NULL,0,'fixed','','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(619,'M.Mix 125G S',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057532797','C128',NULL,NULL,0,'fixed','1','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(620,'M.Mix 75G',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057530854','C128',NULL,NULL,0,'fixed','','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(621,'M.Mix 75G S',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057532773','C128',NULL,NULL,0,'fixed','','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(622,'M.GLY Balance',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057531226','C128',NULL,NULL,0,'fixed','1','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(623,'M.GLY Natural',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057531219','C128',NULL,NULL,0,'fixed','1','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(624,'M.GLY Hydra',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057531202','C128',NULL,NULL,0,'fixed','1','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(625,'M.Mix 35G',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057532537','C128',NULL,NULL,0,'fixed','','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(626,'M.Mix 125G 3*',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057531363','C128',NULL,NULL,0,'fixed','2','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(627,'M.Mix Trans 3*',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057531370','C128',NULL,NULL,0,'fixed','2','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(628,'M.M 75G 3+1',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057531387','C128',NULL,NULL,0,'fixed','2','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(629,'M.Mix 125G 3*',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906057531318','C128',NULL,NULL,0,'fixed','5','','','3401110','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(630,'L.Dates 200G',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720039','C128',NULL,NULL,0,'fixed','2','','','8041020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(631,'L.Dates 100G',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720015','C128',NULL,NULL,0,'fixed','','','','8041020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(632,'L.Seeded 250G',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720107','C128',NULL,NULL,0,'fixed','2','','','8041020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(633,'L.Seeded 500G',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720114','C128',NULL,NULL,0,'fixed','5','','','8041020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(634,'L.Dates 250G CUP',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720077','C128',NULL,NULL,0,'fixed','2','','','8041020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(635,'L.Black 250G Cup',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720145','C128',NULL,NULL,0,'fixed','2','','','8041020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(636,'L.Arabian 250G',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006722194','C128',NULL,NULL,0,'fixed','2','','','8041020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(637,'L.Black 250G Ref',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720183','C128',NULL,NULL,0,'fixed','5','','','8041020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(638,'L.Black 500G Ref',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720190','C128',NULL,NULL,0,'fixed','','','','8041020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(639,'L.Honey 25g',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720299','C128',NULL,NULL,0,'fixed','','','','4090000','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(640,'L.Honey 50g',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720305','C128',NULL,NULL,0,'fixed','2','','','4090000','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(641,'L.Honey 100g',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8906006720312','C128',NULL,NULL,0,'fixed','','','','4090000','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(642,'Caramilk',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8901123004857','C128',NULL,NULL,0,'fixed','','','','17049030','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(643,'Eclaris',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8901123002099','C128',NULL,NULL,0,'fixed','','','','18069020','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(644,'Lactoking',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8901123005281','C128',NULL,NULL,0,'fixed','','','','17049030','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(645,'Cofeebite',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8901123005267','C128',NULL,NULL,0,'fixed','','','','17049030','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(646,'Coconut',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8901123005144','C128',NULL,NULL,0,'fixed','','','','17049030','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(647,'Chocopie',1,'single',1,NULL,NULL,9,NULL,NULL,NULL,'inclusive',1,0.0000,'8901123001214','C128',NULL,NULL,0,'fixed','','','','19059010','',NULL,1,NULL,0,0,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(648,'100g Milagu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000648','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 19:03:16','2025-02-01 19:03:16'),(649,'50g Milagu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000649','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 19:03:38','2025-02-01 19:03:38'),(650,'50g Sombu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000650','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 19:03:59','2025-02-01 19:03:59'),(651,'100g Sombu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000651','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 19:04:30','2025-02-01 19:04:30'),(652,'250g Malli',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000652','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 19:04:54','2025-02-02 12:05:14'),(653,'250g Milagai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000653','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 19:05:15','2025-02-01 19:05:15'),(654,'50-50 28.4+6.1G 144PK SW PROMO',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063016972','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(655,'50-50 62.8+6.4g 90pk bazooka pk promo',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063016934','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(656,'50-50 POTAZOZ 24G 144PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063017641','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(657,'50-50 POTAZOZ CHILLI AMERICAN 71.5G 48PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063017580','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(658,'50-50 POTAZOZ 71.5G 48PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063017559','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(659,'BOURBON 20G 450PK 15JAR CBB RENOVATION',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063139244','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(660,'BOURBON 20G 450PK DISP RENV',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063139244','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(661,'BOURBON 50G 140PK PI',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063139329','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(662,'BOURBON 100G 80PK RENOVATION',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063139336','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(663,'BOURBON 150G 48PK CBB RENOVATION',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063139213','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(664,'GOBBLES CHOCOLATE 50G 72PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063363809','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(665,'GOBBLES FRUIT 50G 72PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063363779','C128',NULL,NULL,0,'fixed','0.5',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-03 03:46:29'),(666,'GOBBLES MILK 50G 72PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063363823','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(667,'GOBBLES ORANGE 50G 72PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063363786','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(668,'GOBBLES PINEAPPLE 50G 72PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063363793','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(669,'CROSSAINT COCOA GT 45G 20PK T11 TEMP',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063032446','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(670,'CROSSAINT VANILLA GT 45G 20K T11 TEMP',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063032453','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(671,'TREAT CROSSAINT MIXED FRUIT 47G 20PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063032484','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(672,'GD BUTTER 30G 180PK RC',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063092709','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(673,'GD CASHEW ALMOND 30+5G 180 PK PROMO RC',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063092730','C128',NULL,NULL,0,'percentage','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-03 06:04:55'),(674,'GD BUTTER 52.5G 90PK NRC',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063092822','C128',NULL,NULL,0,'percentage','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-03 06:04:01'),(675,'GD CASHEW 52.5G 90PK CBBRC',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063093522','C128',NULL,NULL,0,'percentage','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-03 06:04:14'),(676,'GD PISTA BADAM 45G 72PK CBB NI NEW',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063094253','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(677,'GOOD DAY CHOCOCHIP 33.4G 72PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063004177','C128',NULL,NULL,0,'percentage','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-03 06:01:13'),(678,'GD CASHEW 100+20G 60PK RC',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063093409','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-03 06:00:33'),(679,'GD PISTA BADAM 45G 72PK CBB NI NEW',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063094147','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-03 06:03:07'),(680,'GD BUTTER 250G 40PK ATC RC',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063092310','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(681,'GD PISTA BADAM 250G 40PK MERCURY',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063094161','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(682,'LITTLE HEARTS 13G 224PK PKG RENOVATION',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063019171','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(683,'LITTLE HEARTS 26G 112PK PKG RENOVATION',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063019188','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(684,'LITTLE HEARTS 70G 48PK PKG PR',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063019201','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(685,'MARIEGOLD 36.8G 168PK ROI',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063162549','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(686,'MARIEGOLD 68G 72PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063162464','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(687,'VITA MG IMMUNITY 61G 80PK CBB',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063014312','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(688,'MARIEGOLD 117+30G 48PK CBB',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063162600','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(689,'MARIEGOLD 190+20G 30PK ROI GI',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063162655','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(690,'MILK BIKIS 33.5G 210PK DC',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063012608','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(691,'MILK BIKIS 66.8G 120PK AGP PR',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063012530','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(692,'MILK BIKIS CLASSIC 57.5G 120PK AGP',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063012547','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(693,'MILK BIKIS MILK CREAM 44G 72PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063035133','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(694,'MILK BIKIS 100G 60PKAGP PR',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063012516','C128',NULL,NULL,0,'percentage',NULL,NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-02 15:34:25'),(695,'MILK BIKIS CLASSIC 108G 60PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063012837','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(696,'MILK BIKIS 160G 45PK AGP PI',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063012592','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(697,'MILK BIKIS 150G 56PK AGP PI',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063012349','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(698,'MILK BIKIS MC 100+20GM 100PK BALLOON PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063035102','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(699,'MILK BIKIS 300G AGP PI',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063012332','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(700,'NC DIGESTIVE ATTA 41.7+8.3G 96PK NR',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063142466','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(701,'NC DIGESTIVE 100G 72PK CBB NR',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063142015','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(702,'MILK RUSK 54+9G 64PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063325852','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(703,'PREMIUM BAKE RUSK 50+8G 64PK RESTAGE',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063325654','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(704,'MILK RUSK RESTAGE 182G+18G 32PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063325791','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(705,'BAKE RUSK 183G 32PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063325753','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(706,'TIGER KREEMZ CHOCO 30.2G 144PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063164376','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(707,'TIGER KREEMZ CHOCO MILK 30.2G 144PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063164383','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(708,'TIGER KREEMZ ELAICHI 30.2G 144PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063164390','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(709,'TIGER KREEMZ ORANGE 30.2G 144PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063164406','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(710,'TIGER GLUCOSE 42.7 144PK CBB',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063163331','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(711,'TIGER GLUCOSE 85.3G 60PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063163348','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(712,'TIGER KRUNCH CC 27+4.5G 180PK RC',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063155442','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(713,'TIGER KRUNCH CC63G 108PK RC',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063155459','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(714,'TIGER BRITA 150G 48PK RESTAGE',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063021037','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(715,'TREAT JIMJAM 57G 120PK DS',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063029255','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(716,'TREAT JIMJAM 92G 75PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063029262','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(717,'TREAT WAFERS LOW DEN CHEESE 31G 144PK',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063032958','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(718,'WINKIN CLOWN CHOCOLATE',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063146457','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(719,'WINKIN CLLOWN BADAM',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063146402','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(720,'WINKIN CLOWN VANILA',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063146488','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(721,'WINKIN CLOWN STRAWBERRY',1,'single',1,NULL,NULL,10,NULL,NULL,NULL,'inclusive',1,0.0000,'8901063146464','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(722,'KIMIA 500GM COTTON',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000722','C128',NULL,NULL,0,'fixed','20','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(723,'NAGAS KIMIA 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000723','C128',NULL,NULL,0,'fixed','20','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(724,'NAGASSEEDLESS 500GM CONTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000724','C128',NULL,NULL,0,'fixed','10','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(725,'NAGASEEDED 200GM POUCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000725','C128',NULL,NULL,0,'fixed','5','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(726,'Nagaseedless 500gm pouch',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000726','C128',NULL,NULL,0,'fixed','20','','','','',NULL,1,NULL,0,0,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(727,'TURMERIC POWDER 100G',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021123129','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,'8906021123129','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-02 03:03:20'),(728,'Turmeric Powder 50G',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021123112','C128',NULL,NULL,0,'fixed','','','','8906021123112','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(729,'Daniya Powder 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021120661','C128',NULL,NULL,0,'fixed','','','','8906021120661','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(730,'Special Chilly 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021120562','C128',NULL,NULL,0,'fixed','','','','8906021120562','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(731,'Curry Masala 100g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8904064712041','C128',NULL,NULL,0,'fixed','','','','8904064712041','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(732,'Curry Masala Powder 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021120876','C128',NULL,NULL,0,'fixed','','','','8906021120876','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(733,'Sambar Powder 100g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021122627','C128',NULL,NULL,0,'fixed','','','','8906021122627','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(734,'Sambar Powder 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021122610','C128',NULL,NULL,0,'fixed','','','','8906021122610','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(735,'Hotel Sambar 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8904209323194','C128',NULL,NULL,0,'fixed','','','','8904209323194','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(736,'Idcha Sambar 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8904209319371','C128',NULL,NULL,0,'fixed','','','','8904209319371','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(737,'Chicken Masala Powder 100g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021120470','C128',NULL,NULL,0,'fixed','','','','8906021120470','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(738,'Chicken Masala Powder 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021120463','C128',NULL,NULL,0,'fixed','','','','8906021120463','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(739,'Mutton Masala Powder 100g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021122290','C128',NULL,NULL,0,'fixed','','','','8906021122290','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(740,'Mutton Masala Powder 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021122283','C128',NULL,NULL,0,'fixed','','','','8906021122283','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(741,'Rasam Powder(50gms)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021122535','C128',NULL,NULL,0,'fixed','','','','8906021122535','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(742,'Rasam powder 100g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021122542','C128',NULL,NULL,0,'fixed','','','','8906021122542','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(743,'Fish Curry Masala 50gms-MC',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021121064','C128',NULL,NULL,0,'fixed','','','','8906021121064','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(744,'Fish Fry Masala Powder (50gms)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021121118','C128',NULL,NULL,0,'fixed','','','','8906021121118','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(745,'Egg Masala Powder (50gms)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021120968','C128',NULL,NULL,0,'fixed','','','','8906021120968','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(746,'Garam Masala (50gms)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021121163','C128',NULL,NULL,0,'fixed','','','','8906021121163','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(747,'Idly Chilly Powder (100gms)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021121712','C128',NULL,NULL,0,'fixed','7',NULL,NULL,'8906021121712','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-03 11:22:46'),(748,'Idly chilly Powder(50gms)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021121705','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'8906021121705','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-03 11:55:35'),(749,'Nattu Koli Masala 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8904209307415','C128',NULL,NULL,0,'fixed','','','','8904209307415','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(750,'Kashmiri Chilly Powder (100gms)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021128377','C128',NULL,NULL,0,'fixed','','','','8906021128377','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(751,'Briyani Masala 50G',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021120272','C128',NULL,NULL,0,'fixed','','','','8906021120272','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(752,'Kuzhambu Chilli Powder (50gms)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021121859','C128',NULL,NULL,0,'fixed','','','','8906021121859','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(753,'Kuzhambu chilli powder 100gms',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021121866','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(754,'Sweet Mix',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8904209324528','C128',NULL,NULL,0,'fixed','','','','8904209324528','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(755,'Ginger Garlic Paste (Pouch) (rs.10)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021124454','C128',NULL,NULL,0,'fixed','0.5',NULL,NULL,'8906021124454','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-03 11:08:19'),(756,'Ginger Garlic Paste (Pouch) (rs.5)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021121408','C128',NULL,NULL,0,'fixed','0.25',NULL,NULL,'8906021121408','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-03 11:21:55'),(757,'Channa Masala 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021126458','C128',NULL,NULL,0,'fixed','','','','8906021126458','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(758,'CHATT MASALA 50g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906021125130','C128',NULL,NULL,0,'fixed','','','','8906021125130','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(759,'MANGAI 10 PC',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906180150356','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,'8906180150356','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-03 03:06:28'),(760,'MANGAI 20PC',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'123456','C128',NULL,NULL,0,'fixed','','','','123456','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(761,'Mangai 5pc',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906180150349','C128',NULL,NULL,0,'fixed','','','','8906180150349','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(762,'Mangai 100gm JAR',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906180150080','C128',NULL,NULL,0,'fixed','','','','8906180150080','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(763,'Mangai 50gm Jar',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'123456','C128',NULL,NULL,0,'fixed','','','','123456','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(764,'Mangai 10 Katty',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000764','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(765,'Mangai 5 Katty',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000765','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(766,'Mangai 5HC',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000766','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(767,'Mangai 10HC',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'0010','C128',NULL,NULL,0,'fixed','','','','0010','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(768,'Red Kungkumam 20G',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906180150479','C128',NULL,NULL,0,'fixed','','','','8906180150479','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(769,'Red Kungkumam 100G',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906180150547','C128',NULL,NULL,0,'fixed','','','','8906180150547','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(770,'Red Kungkumam 40g',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8965003721029','C128',NULL,NULL,0,'fixed','','','','8965003721029','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(771,'Thiruniru 40G',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000771','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(772,'Thiriniru 100gm',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000772','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(773,'Thirumanjanam 40G',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8906180150462','C128',NULL,NULL,0,'fixed','','','','8906180150462','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(774,'100gm Poojavillai',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000774','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(775,'ODO HERBAL PHYNOLE rs90 1+1',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'1933586292509','C128',NULL,NULL,0,'fixed','','','','1933586292509','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(776,'ODOFRESH SOAP Oil 700ml MI 49',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'2933586292126','C128',NULL,NULL,0,'fixed','','','','2933586292126','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(777,'ODOFRESH BLACK PHENOLL',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'9962841278097','C128',NULL,NULL,0,'fixed','','','','9962841278097','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(778,'ODOFRESH AITFRRRESHER',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8989478385715','C128',NULL,NULL,0,'fixed','','','','8989478385715','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(779,'ODO AIRFRESH Double',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8989478385777','C128',NULL,NULL,0,'fixed','','','','8989478385777','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(780,'ODOFRESH AIRFRESHER',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8989478385616','C128',NULL,NULL,0,'fixed','','','','8989478385616','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(781,'Napthalene BALLS',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'9962841278233','C128',NULL,NULL,0,'fixed','','','','9962841278233','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(782,'ODO FRESH ROSE CUBE RS 60',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'9962841278080','C128',NULL,NULL,0,'fixed','','','','9962841278080','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(783,'ODOFRESH 50GM SET PACK RS',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'2933586292492','C128',NULL,NULL,0,'fixed','','','','2933586292492','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(784,'ODOFRESH SETPACK 75GM',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'3996284127823','C128',NULL,NULL,0,'fixed','','','','3996284127823','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(785,'B. VASI PATHI RS22',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184113758','C128',NULL,NULL,0,'fixed','','','','8901184113758','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(786,'JIYO SANDAL RS22',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184117688','C128',NULL,NULL,0,'fixed','','','','8901184117688','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(787,'JIYO ROSE RS22',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184117701','C128',NULL,NULL,0,'fixed','','','','8901184117701','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(788,'MOMENTS RS25',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184112546','C128',NULL,NULL,0,'fixed','','','','8901184112546','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(789,'POOJA FLORA RS22',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184121814','C128',NULL,NULL,0,'fixed','','','','8901184121814','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(790,'B.VASI PATHI RS 12',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184100758','C128',NULL,NULL,0,'fixed','','','','8901184100758','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(791,'PINE APPLE RS 10',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184127601','C128',NULL,NULL,0,'fixed','','','','8901184127601','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(792,'CHAMPA RS12(24+1)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184117732','C128',NULL,NULL,0,'fixed','','','','8901184117732','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(793,'POOJA FLORARS12',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184120213','C128',NULL,NULL,0,'fixed','','','','8901184120213','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(794,'JIYO ROSE RS12(24+1)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184109225','C128',NULL,NULL,0,'fixed','','','','8901184109225','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(795,'MOMENTS RS12(24+1)',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184110870','C128',NULL,NULL,0,'fixed','','','','8901184110870','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(796,'JIYO ROSE RS55',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184109515','C128',NULL,NULL,0,'fixed','','','','8901184109515','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(797,'CHAMPA FLORA RS55',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184115585','C128',NULL,NULL,0,'fixed','','','','8901184115585','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(798,'JIYO NISARG RS55',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184109881','C128',NULL,NULL,0,'fixed','','','','8901184109881','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(799,'JIYO MOGRA RS55',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184110863','C128',NULL,NULL,0,'fixed','','','','8901184110863','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(800,'POOJA FLORA RS55',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184100475','C128',NULL,NULL,0,'fixed','','','','8901184100475','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(801,'CHAMPA RS125',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184113703','C128',NULL,NULL,0,'fixed','','','','8901184113703','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(802,'Mangal Pooja Cup rs 75',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184121883','C128',NULL,NULL,0,'fixed','','','','8901184121883','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(803,'Divine Pathi rs18',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184104879','C128',NULL,NULL,0,'fixed','','','','8901184104879','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(804,'JIOCONE',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184117831','C128',NULL,NULL,0,'fixed','','','','8901184117831','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(805,'AUTHRA 500ml',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8908022380013','C128',NULL,NULL,0,'fixed','','','','8908022380013','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(806,'Rice Black',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'Ajitvarshablack','C128',NULL,NULL,0,'fixed','','','','Ajitvarshablack','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(807,'Rice red',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'Ajitvarshared','C128',NULL,NULL,0,'fixed','','','','Ajitvarshared','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(808,'Continental cfe 100gm',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901036341988','C128',NULL,NULL,0,'fixed','','','','8901036341988','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(809,'Continental cfe 200gm',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901036173459','C128',NULL,NULL,0,'fixed','','','','8901036173459','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(810,'Continental extra 50+50',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901036173411','C128',NULL,NULL,0,'fixed','','','','8901036173411','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(811,'Continental CFE MRP 5',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901036173404','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,'8901036173404','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-02 13:37:56'),(812,'JIYO NISARG RS22',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184117671','C128',NULL,NULL,0,'fixed','','','','8901184117671','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(813,'JIYO NISARG RS12',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184109874','C128',NULL,NULL,0,'fixed','','','','8901184109874','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(814,'JIYO ROSE RS22',1,'single',1,NULL,NULL,16,NULL,NULL,NULL,'inclusive',1,0.0000,'8901184117701','C128',NULL,NULL,0,'fixed','','','','8901184117701','',NULL,1,NULL,0,0,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(815,'500g Shankar Gram Flour',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'700736197868','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 19:25:53','2025-02-01 19:26:21'),(816,'1 Kg Shankar Gram Flour',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'700736197851','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 19:26:58','2025-02-01 19:26:58'),(817,'Three In one 10.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901751021837','C128',NULL,NULL,0,'fixed','0','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(818,'Three in one 30',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901751016680','C128',NULL,NULL,0,'fixed','0','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(819,'Gs 30G 43.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014520300','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 08:00:55'),(820,'GS70G 75.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014520706','C128',NULL,NULL,0,'fixed','2','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(821,'GS 140G 129.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014521406','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 07:48:07'),(822,'GS 300G 244.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014523004','C128',NULL,NULL,0,'fixed','10',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 09:09:14'),(823,'EXO BAR 90GM 5',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102163923','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(824,'EXO BAR 150GM 10',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102163930','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(825,'EXO ROUND 32',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102163732','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(826,'EXO ROUND 60',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102163633','C128',NULL,NULL,0,'fixed','1','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(827,'THREE IN ONE 20.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901751016659','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(828,'GS SG 50G FLORAL FRESH 49.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014520539','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 08:35:35'),(829,'GS SG 100G FLORAL FRESH 88.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014521031','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 07:57:42'),(830,'GOKUL SANDAL SOAP 42',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014520751','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(831,'ASWINI 50ML 40.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908000498983','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(832,'ASWINI HAIR OIL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908000498976','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(833,'GS SG 50G LOVELY LAVANDER 49.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014520515','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 08:01:34'),(834,'GS SG 50G SECRET GARDEN 49.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014520508','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 07:50:48'),(835,'GS SG 50G ROYAL ROSE 49.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014520522','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 08:35:13'),(836,'GS SG 100G ROYAL ROSE 88.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014521024','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 08:33:36'),(837,'GS SG 100G LIVELY LAVENDER 88.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014521017','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 08:03:34'),(838,'GS SG 100G SECRET GARDEN 88.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8906014521000','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:38:39','2025-02-03 07:50:17'),(839,'Exo steel 15',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102164173','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,'73231000','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-03 08:45:32'),(840,'Exo safai small 10',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102164036','C128',NULL,NULL,0,'fixed','0','','','68053000','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(841,'Ujala  10',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102194910','C128',NULL,NULL,0,'fixed','0','','','32041294','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(842,'Ujala 75ml  35.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102126980','C128',NULL,NULL,0,'fixed','0','','','32041294','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(843,'Ujala 80',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102194934','C128',NULL,NULL,0,'fixed','2','','','32041294','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(844,'Nestle sunrise 10.00 12pc',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901058014600','C128',NULL,NULL,0,'fixed','0','','','21011120','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(845,'Nes.Milkybar Mould 24 pcs 10.0',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901058007596','C128',NULL,NULL,0,'fixed','0','','','17409090','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(846,'Nes. Kitkat 20.00 30pcs',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901058016116','C128',NULL,NULL,0,'fixed','0','','','19053211','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(847,'Kit kat 30.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901058903164','C128',NULL,NULL,0,'fixed','0','','','19053211','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(848,'TVS 1 ltr',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8943387346403','C128',NULL,NULL,0,'fixed','38',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-03 08:51:15'),(849,'Maxo 37.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902102197423','C128',NULL,NULL,0,'fixed','2','','','38089191','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(850,'Nes.Maggi 30.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901058000276','C128',NULL,NULL,0,'fixed','','','','19023010','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(851,'Nestle Magi Masala 60.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901058009514','C128',NULL,NULL,0,'fixed','','','','19023010','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(852,'Nes. Sunrise 50g Jar 180.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'89080276','C128',NULL,NULL,0,'fixed','1','','','21011120','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(853,'Nes.Sunrise 2',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'89080306','C128',NULL,NULL,0,'fixed','','','','21011120','',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(854,'tvs 500ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'7108749972510','C128',NULL,NULL,0,'fixed','57',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 19:44:25','2025-02-03 08:50:59'),(855,'PARLE BISCUIT 3.0',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901719129612','C128',NULL,NULL,0,'fixed','0','','','19059020','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(856,'PARLE BISCUIT 5.0',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901719125478','C128',NULL,NULL,0,'fixed','0','','','19059020','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(857,'PARLE BISCUIT 10.0',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901719128462','C128',NULL,NULL,0,'fixed','0','','','19059020','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(858,'PARLE HIDE AND SEEK 1.0',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901719124853','C128',NULL,NULL,0,'fixed','0','','','19059020','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(859,'TATA GINGER GARLIC PASTE 5',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901595862658','C128',NULL,NULL,0,'fixed','0','','','21039040','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(860,'CG CHINGS DARK SOYA SAU 60',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901595862726','C128',NULL,NULL,0,'fixed','1','','','21039020','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(861,'CG ORGANIC PINK SALT 150.0',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'801541515042','C128',NULL,NULL,0,'fixed','5','','','','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(862,'CG JAGGARY 500G 105.00',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'801541513710','C128',NULL,NULL,0,'fixed','5','','','17011410','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(863,'CG CHINGS CHILLI SAU 25',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901595862801','C128',NULL,NULL,0,'fixed','0','','','21039020','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(864,'INNILA RAVA 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908009157454','C128',NULL,NULL,0,'fixed','0.5',NULL,NULL,'11010000','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-03 03:24:47'),(865,'INNILA RAVA 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908009157546','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'11010000','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-03 03:32:26'),(866,'CG CHINGS GREEN CHILLI SAU 60',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901595862733','C128',NULL,NULL,0,'fixed','1','','','21039020','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(867,'CG CHINGS CHILLI VINEGAR 170ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901595852321','C128',NULL,NULL,0,'fixed','2','','','22090020','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(868,'NABATI WAFAR 10 RICHEESE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908008674785','C128',NULL,NULL,0,'fixed','1','','','19053219','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(869,'VGOLD 500M POU',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908002178029','C128',NULL,NULL,0,'fixed','2','','','15121920','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(870,'CG ORGANIC TULASI ORIGINAL GREEN TEA 215',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'801541050505','C128',NULL,NULL,0,'fixed','15','','','','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(871,'LAYS MIX 10 HOT N SWEET CHILLI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901491503051','C128',NULL,NULL,0,'fixed','','','','690','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(872,'KUR KURE 5',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901491367219','C128',NULL,NULL,0,'fixed','','','','210690','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(873,'KUR KURE 5 NT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901491104470','C128',NULL,NULL,0,'fixed','','','','210690','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(874,'LAYS MIX 10 CLASSIC SALTED',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901491503013','C128',NULL,NULL,0,'fixed','','','','690','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(875,'LAYS MIX 10 INDIAN MAGIC MASALA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901491503020','C128',NULL,NULL,0,'fixed','','','','690','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(876,'LAYS MIX 10 SPANISH TOMATO TANGO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901491503044','C128',NULL,NULL,0,'fixed','','','','690','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(877,'LAYS MIX 10 AMERICAN STYLE CREAM & ONION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901491503037','C128',NULL,NULL,0,'fixed','','','','690','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(878,'CG ORGANIC TULASI GINGER GREEN TEA 215',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'801541040438','C128',NULL,NULL,0,'fixed','5','','','','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(879,'CG ORGANIC TULASI HONEY LEMON GREEN TEA 215',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'801541521098','C128',NULL,NULL,0,'fixed','5','','','','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(880,'NABATI WAFAR 10 RICHOCO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908008674808','C128',NULL,NULL,0,'fixed','','','','19053219','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(881,'NABATI WAFAR 10 PINK LAVA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908008674846','C128',NULL,NULL,0,'fixed','','','','19053219','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(882,'NABATI WAFAR 10 MILK VANILA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908008674822','C128',NULL,NULL,0,'fixed','','','','19053219','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(883,'MAGGIE FAMILY PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901058000191','C128',NULL,NULL,0,'fixed','','','','','',NULL,1,NULL,0,0,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(884,'CMFT FAB CON BLUE JACONET 19ML SOUTH',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106021990','C128',NULL,NULL,0,'fixed','0','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(885,'CMFT FAB CON PINK JACONET 19ML NEW',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106022027','C128',NULL,NULL,0,'fixed','0','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(886,'CMFT FAB CONDITIONER SS DESIRE 210ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106020085','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(887,'CMFT FAB CONDITIONER SS ROYAL 19ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030856334','C128',NULL,NULL,0,'fixed','0','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(888,'CMFT FAB CONDITIONER SS ROYAL 210 ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106020054','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(889,'COMFORT FAB CON BLUE 210 ML SOUTH',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106022003','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(890,'COMFORT FAB CON BLUE 430 ML SOUTH',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106022058','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(891,'COMFORT FAB CON GREEN 210ML NEW',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106021945','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(892,'COMFORT FAB COND GREEN JACONET 9ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030856327','C128',NULL,NULL,0,'fixed','0','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(893,'COMFORT FAB CONDITIONER PINK 210 ML NEW',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106022010','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(894,'DMX TLT CLNR OCEAN FRESH 200ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106004436','C128',NULL,NULL,0,'fixed','1','','','38089400','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(895,'DMX TLT CLNR OCEAN FRESH 475ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106018396','C128',NULL,NULL,0,'fixed','2','','','38089400','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(896,'DOVE CREAM BEAUTY BAR 50G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030712999','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(897,'DVE CREAM BAR 100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030795589','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(898,'DVE CREAM BAR 100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030795589','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(899,'HAMAM 100% PUR NEM OILSP A50GB4G1 100GER',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030911217','C128',NULL,NULL,0,'fixed','2','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(900,'HAMAM 100% PURE LEMON FLOWERS SP100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030937804','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(901,'HAMAM 100% PURE NEEM OIL SOAP 100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030907449','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(902,'HAMAM 100% PURE NEEM OIL SOAP150G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030907456','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(903,'HAMAM 100% PURE NEEM OIL SOAP 38G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030911170','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(904,'HAMAM 100% PURE NEEM OIL SOAP 38150G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030911187','C128',NULL,NULL,0,'fixed','2','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(905,'HAMAM 100% PURE NEEM OIL SOAP 4*100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030911194','C128',NULL,NULL,0,'fixed','2','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(906,'HAMAM 100% PURE NEEM OIL SOAP 4*100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030911194','C128',NULL,NULL,0,'fixed','2','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(907,'HAMAM 100% PURE NEEM OIL SOAP 75G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030907449','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(908,'LB GERM GUARD SOAP 46G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030928321','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(909,'LB HW TOTAL 10 PROTECT 190ML+185ML FRE',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030904493','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(910,'LIFEBUOY CARE SOAP 100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030853715','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(911,'LIFEBUOY GERM GUARD SOAP 125G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030920714','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(912,'LIFEBUOY GERM GUARD SOAP 4*125G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030920707','C128',NULL,NULL,0,'fixed','2','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(913,'LIFEBUOY HW TOTAL 10 PROTECT 80ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030904455','C128',NULL,NULL,0,'fixed','0','','','34013019','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(914,'LIRIL SOAP 75G+25G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030844744','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(915,'LUX ADV EVEN-TONED GLOW 43G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030684869','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(916,'LUX ADVANCED EVEN-TONED GLOW 100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030539749','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(917,'LUX ADVANCED RADIANT GLOW 75G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030694592','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(918,'LUX EVEN TONED GLOW 150G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030925696','C128',NULL,NULL,0,'fixed','0','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(919,'PEARS OIL CLEAR GLOW SOAP 75G LIL FRE',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030871030','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(920,'PEARS P&GNTL T/SOAP 100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030766947','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(921,'PEARS SOFT &Fresh 100gm lill fre',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030871016','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(922,'RAB CATAPAULT FW 230G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106031227','C128',NULL,NULL,0,'fixed','0','','','34011930','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(923,'RAP ANTI BAC NEEM 1KG',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030833977','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(924,'RAO ANTI BAC NEEM 500G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030833984','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(925,'RAP ANTI BAC NEEM 90G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030899973','C128',NULL,NULL,0,'fixed','0','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(926,'RAP NORMAL BOLT 1KG (S)',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030737084','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(927,'RAP NORMAL BOLT 500G (S)',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030737091','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(928,'RAP REFRESH BOLT 1KG',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030746024','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(929,'RAP REFRESH BOLT 500G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030746048','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(930,'REXONA COCONUT & OLIVE OILS SOAP 100G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030964923','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(931,'RIN BAR CATAPAULT FW 130G+15G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030968266','C128',NULL,NULL,0,'fixed','','','','34011930','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(932,'RIN FAB WHTNR ALA BOLT 200ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030761188','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(933,'RIN FAB WHTNR ALA BOLT 500ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030761195','C128',NULL,NULL,0,'fixed','4.5',NULL,NULL,'34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-03 07:52:53'),(934,'RIN LIQUID 800ML POUCH FL NEW ED',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030756535','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(935,'RIN LIQUID 800ML POUCH TL NEW ED',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030756498','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(936,'RIN LIQUID 850 ML BOTTLE TL PEBBLE',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030711992','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(937,'RIN LIQUID 850 ML BOTTLE FL PEBBLE',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030713316','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(938,'RIN POWDER 95G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030899966','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(939,'SFXL EW 500G CNTRS S BVI',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106026346','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(940,'SURF EXCEL BAR 250 G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030865169','C128',NULL,NULL,0,'fixed','','','','34011930','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(941,'SURF EXCEL BAR FW 150G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030872976','C128',NULL,NULL,0,'fixed','','','','34011930','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(942,'SURF EXCEL BAR FW 80G+10G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106022478','C128',NULL,NULL,0,'fixed','','','','34011930','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(943,'SURF EXCEL BAR MPK 4*200G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030843150','C128',NULL,NULL,0,'fixed','2','','','34011930','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(944,'SURF EXCEL EW 1KG CNTRS S',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030850523','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(945,'SURF EXCEL EW 1KG CNTRS S',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030850523','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(946,'SURF EXL DET LIQ 500ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030695759','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(947,'SURF EXL DET LIQ 500ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030695759','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(948,'SURF EXL MTC LIQ FL 500ML CP',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030695612','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(949,'SURF EXL  MTC LIQ FL 50ML OFFER',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030695483','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(950,'SURF EXL MTC LIQ FLIL NEW BOTTLE',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030992216','C128',NULL,NULL,0,'fixed','5','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(951,'SURF EXL MTC LIQ TL 500ML CP',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030695490','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(952,'SURF EXL MTC LIQ TL 50ML OFFER',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030695476','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(953,'SURF EXL MTC LIQ TLIL NEW BOTTLE',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030992223','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(954,'SURF EL QW POWDER 1KG BVI',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106006478','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(955,'SURF EXL QW POWDER 500G BVI',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106006485','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(956,'SURF EXL QW POWDER 5T 65G BVI',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106007048','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(957,'SURF XL MTC LIQ FL 1LTR POUCH',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030695469','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(958,'SURF XL MTC LIQ TL 1LTR POUCH',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030695452','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(959,'VIM ANTI BAC BAR 110G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030902277','C128',NULL,NULL,0,'fixed','','','','34054000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(960,'VIM ANTI BAC BAR 250G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030881695','C128',NULL,NULL,0,'fixed','','','','34054000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(961,'VIM ANTI SMELL BAR 110G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030902260','C128',NULL,NULL,0,'fixed','','','','34054000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(962,'VIM ANTI SMELL BAR 250G 1H',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030765070','C128',NULL,NULL,0,'fixed','','','','34054000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(963,'VIM BAR 110G+45G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030535697','C128',NULL,NULL,0,'fixed','','','','34054000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(964,'VIM BAR 250G TUB CP RS7 SCRUBBER FREE',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030859557','C128',NULL,NULL,0,'fixed','','','','34054000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(965,'VIM BAR 60G+10G NEW AW',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106004528','C128',NULL,NULL,0,'fixed','','','','34054000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(966,'VIM BAR FW 300G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106000230','C128',NULL,NULL,0,'fixed','','','','34054000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(967,'VIM BAR TUB FW 500G WITH NKED SCRUB',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030972102','C128',NULL,NULL,0,'fixed','1','','','34054000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(968,'VIM DROP DW SPOUTED POUCH 500ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106017962','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(969,'VIM DRP DISHWASH ACTIVE GEL YELLOW 500ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106018006','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(970,'VIM DRP DW LMN ACT GEL 120ML CP',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106017924','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(971,'VIM GEL SHUDHHAM 100ML',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030960666','C128',NULL,NULL,0,'fixed','1','','','38101010','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(972,'VIM LIQUID 200ML POUCH',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030538421','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(973,'VIM LIQUID YELLOW BOTTLE 750M',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106017986','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(974,'VIM LIQUID YELLOW BOTTLE 750M',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8909106017986','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(975,'VIM SCRUB EASY RS.10',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030885556','C128',NULL,NULL,0,'fixed','','','','68053000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(976,'WHEEL LMN & JAS PWD a+ NILE 1KG',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030997778','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(977,'WHEEL LMN&JAS PWD A+ NILE 500G',1,'single',1,NULL,NULL,17,NULL,NULL,11,'inclusive',1,0.0000,'8901030997723','C128',NULL,NULL,0,'fixed','0.5','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(978,'3 ROSES DUST © 100G RELAUNCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030985812','C128',NULL,NULL,0,'fixed','1','','','09023020','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(979,'3 ROSES NATURAL CARE ©250G-4PANEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030987342','C128',NULL,NULL,0,'fixed','5','','','09023020','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(980,'3 ROSES NATURAL CARE 100G-4 PANEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030987335','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'09023021','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-03 05:54:42'),(981,'3RO DUST HTS (P) 2*500G RELAUNCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030985843','C128',NULL,NULL,0,'fixed','14',NULL,NULL,'09023022','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-03 02:45:58'),(982,'3 ROSES DUST © 250G RELAUNCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030985829','C128',NULL,NULL,0,'fixed','2','','','09023023','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(983,'3 ROSES DUST (P) 25G RELAUNCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030985591','C128',NULL,NULL,0,'fixed','','','','09023024','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(984,'3 ROSES DUST (P) 50G RELAUNCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030985607','C128',NULL,NULL,0,'fixed','1','','','09023025','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(985,'3ROSES DUST RS10 (P) 12G MT',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030985584','C128',NULL,NULL,0,'fixed','','','','09023026','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(986,'3 ROSES DUST RS5 (P) 6G MT',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030985577','C128',NULL,NULL,0,'fixed','','','','09023010','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(987,'3 ROSES NATURAL CARE 11G',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901030987328','C128',NULL,NULL,0,'fixed','','','','09023020','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(988,'BOOST 200G CS',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030818806','C128',NULL,NULL,0,'fixed','1','','','19019090','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(989,'BOOST 22 GM SCHT',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106018372','C128',NULL,NULL,0,'fixed','','','','19019091','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(990,'BOOST 500G CS POUCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030817281','C128',NULL,NULL,0,'fixed','2','','','19019092','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(991,'BOOST 9GM SACHET',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106018327','C128',NULL,NULL,0,'fixed','','','','19019093','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(992,'BOOST SE 200G ICON JAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030543944','C128',NULL,NULL,0,'fixed','1','','','19019094','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(993,'BOOST SE 500GM ICON JAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030818660','C128',NULL,NULL,0,'fixed','2','','','19019095','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(994,'BRU INS RS5 4.6G AROMASOUTH',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106013889','C128',NULL,NULL,0,'fixed','','','','21011120','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(995,'BRU INST POLY 50G ASC',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030935213','C128',NULL,NULL,0,'fixed','2','','','21011121','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(996,'BRU INST RS10 8G AROMA SOUTH',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030951091','C128',NULL,NULL,0,'fixed','','','','21011122','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(997,'BRU INST RS2 1.2G AROMA 2.0',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106027695','C128',NULL,NULL,0,'fixed','','','','21011123','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(998,'KISSAN FRESH TOMATO KETCHUP 90G HCP',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901030897542','C128',NULL,NULL,0,'fixed','','','','21032000','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(999,'KISSAN MF JAM DOY 45 GM-9M SL',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901030917592','C128',NULL,NULL,0,'fixed','','','','20079990','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1000,'KSN MF JAM TUB 90G F KP 25*',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901030922787','C128',NULL,NULL,0,'fixed','','','','20079991','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1001,'STD HLX 10G SACHET PL STRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106018280','C128',NULL,NULL,0,'fixed','','','','19019090','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1002,'STD HLX 200G CS POUCH SOUTH',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030978180','C128',NULL,NULL,0,'fixed','1','','','19019091','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1003,'STD HLX 24G SACHET PL STRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106015869','C128',NULL,NULL,0,'fixed','','','','19019092','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1004,'STD HORLICKS 500GCSP PRELEOCP',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106008960','C128',NULL,NULL,0,'fixed','2','','','19019093','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1005,'STD HLX ICON JAR 200 PL',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030976094','C128',NULL,NULL,0,'fixed','1','','','19019094','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1006,'STD HORLIKS ICON JAR 500G PL',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030993404','C128',NULL,NULL,0,'fixed','4','','','19019095','',NULL,1,NULL,0,0,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1007,'CLINIC PLUS S&l SHMP 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030984709','C128',NULL,NULL,0,'fixed','0','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1008,'CLINIC PLUS STRONG&SHINY SHMP 6ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030975806','C128',NULL,NULL,0,'fixed','0','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1009,'CLOSEUP RH TP 17G EC',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030999369','C128',NULL,NULL,0,'fixed','0','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1010,'CLP SL SHMP 6.5ML WITH 60% EXTRA',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106013087','C128',NULL,NULL,0,'fixed','0.05',NULL,NULL,'33051090','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-03 03:11:15'),(1011,'CUP RH TP 40G 6+1 FR ONHG EC TRADEOFF',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106006287','C128',NULL,NULL,0,'fixed','','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1012,'CUP RH TP 90G 8+1 FREE EC TRADEOFFER',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030995057','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1013,'DOVE DAILY SHINE SHP BIOPROTEIN CARE 6ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030996375','C128',NULL,NULL,0,'fixed','','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1014,'DOVE DANDRUFF CARE SHP SCHT 5.5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030899768','C128',NULL,NULL,0,'fixed','','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1015,'DOVE HAIRF RES+SH BIOPROTEIN CARE6ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030996368','C128',NULL,NULL,0,'fixed','','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1016,'GAL ADV MV 15G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106013650','C128',NULL,NULL,0,'fixed','0.5','','','33049910','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1017,'GAL ADV MV 25G RL',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030942679','C128',NULL,NULL,0,'fixed','1','','','33049910','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1018,'GAL ADV MV 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030942686','C128',NULL,NULL,0,'fixed','2','','','33049910','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1019,'GAL ADV MV 9G TRADE OFFER 24+1',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030942648','C128',NULL,NULL,0,'fixed','','','','33049910','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1020,'INDULEKHA BRINGHA SHAMOO+5.5ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106004986','C128',NULL,NULL,0,'fixed','','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1021,'PBB 15G SERM IN CRM POFF',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030997068','C128',NULL,NULL,0,'fixed','1','','','33049910','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1022,'PBB 7G SERUM IN CREAM 22+2 TO',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030533877','C128',NULL,NULL,0,'fixed','','','','33049910','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1023,'PBB SRMCRM 23GPOFF',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030997075','C128',NULL,NULL,0,'fixed','2','','','33049910','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1024,'PEP 12HR GC 16G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030534096','C128',NULL,NULL,0,'fixed','','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1025,'pep 12hr gc 39g (6+1)',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030970405','C128',NULL,NULL,0,'fixed','','','','33061020','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1026,'PNDS DRMFLR TALC PINK LILY 19G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106010772','C128',NULL,NULL,0,'fixed','','','','33049120','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1027,'PONDS DF TAL PWD 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030869013','C128',NULL,NULL,0,'fixed','2','','','33049120','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1028,'PONDS DF TAL PWD 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030869020','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'33049120','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-03 09:15:52'),(1029,'PONDS MAGIC TALC 19G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909106010789','C128',NULL,NULL,0,'fixed','','','','33049120','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1030,'PONDS MGK TAL 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030868962','C128',NULL,NULL,0,'fixed','2','','','33049120','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1031,'PONDS MGK TAL 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030868979','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'33049120','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-03 09:19:37'),(1032,'PONDS SANDAL TALC 19G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030523922','C128',NULL,NULL,0,'fixed','','','','33049120','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1033,'PONDS SNDL TAL 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030869112','C128',NULL,NULL,0,'fixed','2','','','33049120','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1034,'PONDS SNDL TAL 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030869129','C128',NULL,NULL,0,'fixed','5',NULL,NULL,'33049120','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-03 08:02:50'),(1035,'SS BL SH SHP 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030945311','C128',NULL,NULL,0,'fixed','','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1036,'SS BLACK SH SMP SCHT 6ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030898457','C128',NULL,NULL,0,'fixed','','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1037,'VAS DEEP MOISTURE LOTION 45ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030912061','C128',NULL,NULL,0,'fixed','1','','','33049930','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1038,'VASL HB DBL 45ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901030997266','C128',NULL,NULL,0,'fixed','1','','','33049930','',NULL,1,NULL,0,0,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1039,'ASV MP AT0.5KGQCPR_FA2116C',1,'single',1,NULL,NULL,18,NULL,NULL,4,'inclusive',1,0.0000,'8909081001567','C128',NULL,NULL,0,'fixed','1','','','11010000','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1040,'AASHIRVAAD SUPMPATTA2KG A',1,'single',1,NULL,NULL,18,NULL,NULL,4,'inclusive',1,0.0000,'8909081002779','C128',NULL,NULL,0,'fixed','2','','','11010000','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1041,'ASV MP AT 1KG QCPR_FD2113C',1,'single',1,NULL,NULL,18,NULL,NULL,4,'inclusive',1,0.0000,'8901725016838','C128',NULL,NULL,0,'fixed','2','','','1101000','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1042,'ASV MP AT 5KG QCPR_FH2112C',1,'single',1,NULL,NULL,18,NULL,NULL,4,'inclusive',1,0.0000,'8901725016852','C128',NULL,NULL,0,'fixed','21',NULL,NULL,'1101000','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-02 05:16:05'),(1043,'AASHIRVAAD GRAM FLOUR 200',1,'single',1,NULL,NULL,18,NULL,NULL,4,'inclusive',1,0.0000,'8901725015701','C128',NULL,NULL,0,'fixed','2','','','11061090','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1044,'AASHIRVAAD GRAM FLOUR 500',1,'single',1,NULL,NULL,18,NULL,NULL,4,'inclusive',1,0.0000,'8901725015695','C128',NULL,NULL,0,'fixed','12','','','11061090','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1045,'AASHIRVAAD SOOJI RAVA 200G',1,'single',1,NULL,NULL,18,NULL,NULL,4,'inclusive',1,0.0000,'8901725012250','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'11031120','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-03 03:24:21'),(1046,'ASV SOOJI RAVA 500G TN_FBC',1,'single',1,NULL,NULL,18,NULL,NULL,4,'inclusive',1,0.0000,'8901725001070','C128',NULL,NULL,0,'fixed','7',NULL,NULL,'11031120','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-03 03:23:45'),(1047,'ASVD ROASTED SHORT VERMI',1,'single',1,NULL,NULL,18,NULL,NULL,4,'inclusive',1,0.0000,'8909081002328','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'19023010','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-03 04:15:29'),(1048,'AASHVD PURE COW GHEE 50M',1,'single',1,NULL,NULL,18,NULL,NULL,8,'inclusive',1,0.0000,'8901725100315','C128',NULL,NULL,0,'fixed','2','','','4059020','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1049,'AASHVD PURE COW GHEE 100ML',1,'single',1,NULL,NULL,18,NULL,NULL,8,'inclusive',1,0.0000,'8901725100322','C128',NULL,NULL,0,'fixed','3','','','4059020','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1050,'AASHVD PURE COW GHEE 200M',1,'single',1,NULL,NULL,18,NULL,NULL,8,'inclusive',1,0.0000,'8901725100339','C128',NULL,NULL,0,'fixed','12','','','4059020','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1051,'ASV CRYSTAL SALT 1KG_FA',1,'single',1,NULL,NULL,18,NULL,NULL,NULL,'inclusive',1,0.0000,'8901725110611','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'25010010','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-03 11:59:58'),(1052,'AASHIRVAAD SALT-1KG',1,'single',1,NULL,NULL,18,NULL,NULL,NULL,'inclusive',1,0.0000,'8901725123123','C128',NULL,NULL,0,'fixed','1','','','25010010','',NULL,1,NULL,0,0,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1053,'MD TREYA CUP SAMBRANI 75_1',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725715755','C128',NULL,NULL,0,'fixed','2','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1054,'MD NEW SANDA RS20 NP(N)',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725009373','C128',NULL,NULL,0,'fixed','1','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1055,'MS CUP SMBRANI RS 72',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725007218','C128',NULL,NULL,0,'fixed','5','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1056,'MD FOT NP14G',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725710729','C128',NULL,NULL,0,'fixed','','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1057,'MD TREYA NP 13G',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725710835','C128',NULL,NULL,0,'fixed','','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1058,'MD REFRSH SANDAL NP 14G',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725013233','C128',NULL,NULL,0,'fixed','','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1059,'MD 10 NEW 3IN1 RS10NP 14G',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725011529','C128',NULL,NULL,0,'fixed','','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1060,'MD REFRESH ROSE 14G',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725014360','C128',NULL,NULL,0,'fixed','','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1061,'MD REFRESH LAVANDER NP 14G',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725014377','C128',NULL,NULL,0,'fixed','','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1062,'MD REFRESH LAVENDAR FREE MB',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725014292','C128',NULL,NULL,0,'fixed','2','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1063,'MD REFRESH SANDAL RS 55',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725013219','C128',NULL,NULL,0,'fixed','2','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1064,'MD REFRESH 3IN1 RS 55 FREE MB',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725004965','C128',NULL,NULL,0,'fixed','2','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1065,'MD 72 TREYA RS 55 FREE MB',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725710842','C128',NULL,NULL,0,'fixed','2','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1066,'MD 72 TEMPLE RS 50 FREE MB',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725710460','C128',NULL,NULL,0,'fixed','2','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1067,'MD NEW 3IN1 RS 20 NON PROMO',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725009076','C128',NULL,NULL,0,'fixed','','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1068,'MD RS 60 FUSIONS 91G',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8906016570846','C128',NULL,NULL,0,'fixed','5','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1069,'MD RS 60 SCENT 3IN1 PUSHPA',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725016470','C128',NULL,NULL,0,'fixed','5','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1070,'MD 18 TREYA  STIK SAMBRANI RS 25',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725720254','C128',NULL,NULL,0,'fixed','1','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1071,'MD 15 SAMBRANI 15(N)',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725710095','C128',NULL,NULL,0,'fixed','1','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1072,'MD 89 SADHVI 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'8901725710064','C128',NULL,NULL,0,'fixed','1','','','33074100','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1073,'SANKALP POOKA CAMPHOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906016571201','C128',NULL,NULL,0,'fixed','5','','','29142922','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1074,'ENGAGE BLUSH DEO 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725951009','C128',NULL,NULL,0,'fixed','35',NULL,NULL,'33072000','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-03 07:29:56'),(1075,'ENGAGESPIRITBLISFULBERRIE',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8905110009863','C128',NULL,NULL,0,'fixed','20',NULL,NULL,'33072000','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-03 07:30:40'),(1076,'ENGAGESPIRITSENSUAL GARD',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8905110009870','C128',NULL,NULL,0,'fixed','20',NULL,NULL,'33072000','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-03 07:30:16'),(1077,'SIAMA MENTHOL & MANGOLIA',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725927134','C128',NULL,NULL,0,'fixed','2','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1078,'FIAMA MENTHOL MONGOLIA125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725927134','C128',NULL,NULL,0,'fixed','2','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1079,'FIAMA MEN GBB RP 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8905110001225','C128',NULL,NULL,0,'fixed','2','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1080,'FIAMA GBB B&B 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8905110001188','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1081,'FIAMA GBB P&a 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8905110001201','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1082,'VIVEL COOL MINT 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725931810','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1083,'VIVEL ALOE VERA 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725937188','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1084,'VIVEL LOTUS OIL 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725937218','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1085,'VIVEL SANDAL SS 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8905110009368','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1086,'BINGO HASHTAG CHIPS RS 10',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725119829','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1087,'BINGO HASTAG CHIP RS 10',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725119843','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1088,'BINGO HASH TAG CHIPS RS 30',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725004576','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1089,'BINGO CHIPS RS 10 HNS KORE',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725018665','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1090,'BINGO CHIPS RS 10 CRM&ON',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8909081000140','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1091,'BINGO CHIPS RS 5 TOMATO',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725015220','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1092,'BINGO CHIPS RS 5 MASALA',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725015244','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1093,'BINGO CHIPS RS 10 MASALA',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725007539','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1094,'BINGO CHIPS RS 5 TOMATO',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725015268','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1095,'BINGO CHIPS RS 5 CHILLI',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725015251','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1096,'BINGO OS RS 10  CHILLI SPRIN',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725007102','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1097,'BINGO OS RS 20 CHILLI SPRING',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725007447','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1098,'BINGO OS RS 10 SALT SPRINK',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725007096','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1099,'BINGO OS RS 10 CRM& ONION',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725007119','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1100,'BINGO OS RS 20 CRM & ONION',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725007454','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1101,'BINGO OS RS 30 CRM & ONION',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725007515','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1102,'BINGO OS RS 10 CHILLI',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725013165','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1103,'BINGO OS RS 10 HNS KOREAN',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725018634','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1104,'BINGO OS RS 20 HNS KOREAN',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725018771','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1105,'BINGO OS RS 20 HIMALAYAN PINK SA',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8909081002076','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1106,'BINGO OS HIMALAYANPINK SAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8909081002083','C128',NULL,NULL,0,'','','','','20052000','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1107,'MAD ANGLES RS 5 PIZZA',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725013837','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1108,'NO RULZ RS 5 MIX PUFFS',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725014025','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1109,'BINGO NO RULS RS 5 TOMATO',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725117498','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1110,'BINGO NACHOS RS.10 CHEESE',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725004422','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1111,'BINGONACHOS RS 10 HNS',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8909081004131','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1112,'POPPED  CHIPS RS 20 SALT N PE',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8909081002960','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1113,'POPPED CHIPS RS 20 HOTPOT',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8909081002984','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1114,'POPPED CHIPS RS 20 HOTPOT',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8909081002946','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1115,'TEDHEMEDHE RS5 CHATPATAT',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725011017','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1116,'TEDHE MEDHE RS5 TOMATO',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725004217','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1117,'TEDHE MEDHE RS 10 MASALA',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725118914','C128',NULL,NULL,0,'','','','','21069099','',NULL,1,NULL,0,0,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1118,'SUNFEAST NICE 64G_FA3401F',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725017545','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1119,'SUNFEAST NICE 142G_FA3402E',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'2025001119','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1120,'DARK FANTASY CHOCO FILLS',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725015886','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1121,'DARK FANTASY CHOCO FILLS',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725015275','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1122,'DAR FANTASY CHOCOLATE',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081000256','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1123,'DARK FANTASY CHOCOLATE CR',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081003851','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1124,'DARK FANTASY VANILLA',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081000317','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1125,'DARK FANTASY VANILLA CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081003844','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1126,'DARK FANTASY VANILLA FILLS',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081000218','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1127,'DARK FANTASY VANILLA FILLS',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725013974','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1128,'DARK FANTASY BOURBON 55.8',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725016258','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1129,'DARK FANTASY BOURBON 93G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725016289','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1130,'DREAM CREAM STRBYVANILLA',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725012328','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1131,'BNC DAY N NIGHT CHOCOVANILA',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001208','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1132,'BNC DAY N NIGHT CHOCOVANILA',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001215','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1133,'SF FARMLITE DIG HIGH FIBRE',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725002237','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1134,'SF FARMLITEDIGHIGHFIB100G+',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001550','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1135,'BNC CREAM CHOCO TWIST 24.8',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001123','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1136,'BNC CREAM CHOCO TWIST 49.6',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001161','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1137,'BNC CREAM ELAICHI DELIGHT',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001130','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1138,'BNC CREAMELAICHI DELIGHT',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001178','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1139,'BNC CREAM TANGY ORANGE',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001147','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1140,'BNC CREAM PINEAPPLE ZING',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001154','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1141,'BNC CREAMPINEAPPLEZING',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081001192','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1142,'SF MOMSMAGIC CWNALMD GH',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081005107','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1143,'SF MOMS MAGIC CASHEW & AL',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725000622','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1144,'SF MOMS MAGIC C&A GHRSTD 9',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725019419','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1145,'SUNFEAST HIFI CASHEW COOK',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725120740','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1146,'SUNFEAST GLUCOSE BISCUITS',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081005084','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1147,'SUNFEAST GLUCOSE BISCUITS',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725113490','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1148,'SUNFEAST MARIE LGT ACTIVE',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725013011','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1149,'SUNFEAST MARIE LGT ACTIVE',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725013028','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1150,'SUNFEAST MARIE LGT ACTIVE',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725012977','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1151,'SUNFEAST MARIE LIGHTVITAO',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725015435','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1152,'SUNFEAST MARIE LIGHT VITAO',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725015428','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1153,'SUNFEAST SUPER MILK 33G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725007300','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1154,'SUNFEAST SUPER MILK 64G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081004391','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1155,'SUNFEAST SUPERMILK 140.8G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081004360','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1156,'SUNFEAST SWEET N SALT 34.2',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725009144','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1157,'SUNFEAST SWEET N SALT 68.4',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725009151','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1158,'SF ALLROUNDER SPICY MSLA',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725019617','C128',NULL,NULL,0,'','','','','19059020','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1159,'SF WOWZERS CHEESE 16G',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8909081003387','C128',NULL,NULL,0,'','','','','19053100','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1160,'SF FANTASTIK CH ALMOND RS1',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725013325','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1161,'SF FANTASTIK FRUIT N NUT',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725018092','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1162,'SUNFEAST FANTASTIK 4D RS',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901725018030','C128',NULL,NULL,0,'','','','','19053290','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1163,'YIPPEE MAGIC MASALA NOODL',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725005986','C128',NULL,NULL,0,'','','','','19023010','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1164,'YIPPEE MAGIC MASALA NOODL',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725005887','C128',NULL,NULL,0,'','','','','19023010','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1165,'YIPPEE MAGIC MASALA NOODL',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725005900','C128',NULL,NULL,0,'','','','','19023010','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1166,'YIPPE MAGIC MASALA NOODL',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725005924','C128',NULL,NULL,0,'','','','','19023010','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1167,'YIPPE MAGIC MASALA NOODL',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725005955','C128',NULL,NULL,0,'fixed','2',NULL,NULL,'19023010','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-03 03:49:15'),(1168,'YIPPE MAGIC MASALA NOODL',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901725017958','C128',NULL,NULL,0,'','','','','19023010','',NULL,1,NULL,0,0,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1169,'VCD 105+5 worth Rs.10 Off',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'2025001169','C128',NULL,NULL,0,'fixed','5','','','30049011','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1170,'H&S Neem Rs.2 20S',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176230829','C128',NULL,NULL,0,'fixed','0','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1171,'H&S Daily Smooth Rs.2 20S',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176230751','C128',NULL,NULL,0,'fixed','0','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1172,'H&S Daily Cool',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176230768','C128',NULL,NULL,0,'fixed','0','','','33051090','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1173,'H&S Daily Clean Rs.2 20S',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176230775','C128',NULL,NULL,0,'fixed','0.1',NULL,NULL,'33051090','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-03 03:10:53'),(1174,'Tide Naturals 500g',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4902430907712','C128',NULL,NULL,0,'fixed','0','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1175,'Tide Nat 800G+200G A+Rs.10',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176257482','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1176,'Tide Liq 850ML TL',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176222121','C128',NULL,NULL,0,'fixed','5','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1177,'Tide Liq 850ML FL',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176222145','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1178,'Tide SHS JR 500g F',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176068897','C128',NULL,NULL,0,'fixed','2','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1179,'Tide SHS JR 1Kg F',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176115058','C128',NULL,NULL,0,'fixed','5','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1180,'Tide JR Rs.10 A',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176167064','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1181,'Ariel Liq 1L Pouch TL',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176164056','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1182,'Ariel Liq 1L Pouch FL',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176164070','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1183,'Ariel PW Rs.10 N',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176223029','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1184,'Ariels PW Blue 500g E',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176108630','C128',NULL,NULL,0,'fixed','1','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1185,'Blue Pants Regs XL',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176137586','C128',NULL,NULL,0,'fixed','5','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1186,'Blue Pants Regs SM',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176137524','C128',NULL,NULL,0,'fixed','2','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1187,'Blue Pants Regs NB',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176137500','C128',NULL,NULL,0,'fixed','2','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1188,'Blue Pants Regs MD',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176137548','C128',NULL,NULL,0,'fixed','2','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1189,'Blue Pants Regs LG',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176137562','C128',NULL,NULL,0,'fixed','2','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1190,'Blue Pants Econs SM',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176215017','C128',NULL,NULL,0,'fixed','5','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1191,'Blue Pants Econs NB',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176141767','C128',NULL,NULL,0,'fixed','5','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1192,'Blue Pants Econs MD',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176141743','C128',NULL,NULL,0,'fixed','5','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1193,'Blue Pants Econs LG',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176215079','C128',NULL,NULL,0,'fixed','5','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1194,'RED Pants 2s XL',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176071361','C128',NULL,NULL,0,'fixed','','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1195,'RED Pants 2s SM',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176071323','C128',NULL,NULL,0,'fixed','','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1196,'RED Pants 2s NB',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176071392','C128',NULL,NULL,0,'fixed','','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1197,'RED Pants 2s MD',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176071385','C128',NULL,NULL,0,'fixed','','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1198,'RED Pants 2s LG',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'4987176071347','C128',NULL,NULL,0,'fixed','','','','96190030','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1199,'Free Tide Plus Rs.10',1,'single',1,NULL,NULL,NULL,NULL,NULL,4,'inclusive',1,0.0000,'2025001199','C128',NULL,NULL,0,'fixed','','','','34025000','',NULL,1,NULL,0,0,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1200,'OB Sens White B2G2',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176279163','C128',NULL,NULL,0,'fixed','5','','','96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1201,'OB Sens Care 6+2 CC Sens',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176245472','C128',NULL,NULL,0,'fixed','10','','','96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1202,'OB Sens Care 5s Pack',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176270337','C128',NULL,NULL,0,'fixed','5','','','96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1203,'OB Kids Chota Bheem 3s',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176226532','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:10','2025-02-03 06:49:25'),(1204,'OB Crisscross Sens UT B2G1',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176239945','C128',NULL,NULL,0,'fixed','5','','','96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1205,'OB Crisscross Rs.50 6+2 CD s',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176287632','C128',NULL,NULL,0,'fixed','10','','','96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1206,'OB CrissCross Bact Blast B2G2 Sft',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176239969','C128',NULL,NULL,0,'fixed','30',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:10','2025-02-03 06:50:47'),(1207,'OB Crisscross Antiplaq Neem B2G2',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176240002','C128',NULL,NULL,0,'fixed','20',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:10','2025-02-03 06:51:26'),(1208,'OB Crisscross Antiplaq B2G2 sft',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176239976','C128',NULL,NULL,0,'fixed','25',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-03 07:08:20'),(1209,'OB CDBacF s6+2SW free',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176232632','C128',NULL,NULL,0,'fixed','10','','','96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1210,'OB CDBacf S6s Pack',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176231543','C128',NULL,NULL,0,'fixed','20',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-03 07:02:04'),(1211,'OB cav def Neem sft4',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176232663','C128',NULL,NULL,0,'fixed','15',NULL,NULL,'96032100','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-03 06:58:28'),(1212,'Wikinson Saloon - 50s',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176212498','C128',NULL,NULL,0,'fixed','5','','','82122019','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1213,'Vector3 Rzr',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176288264','C128',NULL,NULL,0,'fixed','5','','','8212010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1214,'Vcetor3 Cart 4s',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176169907','C128',NULL,NULL,0,'fixed','5','','','82122011','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1215,'GUARD3 RAZOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176102041','C128',NULL,NULL,0,'fixed','2','','','82121010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1216,'GILLETTE GUARD3 CART 1S35',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4902430914710','C128',NULL,NULL,0,'fixed','','','','82122011','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1217,'GUARD RAZOR WILKI PROMO',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'2025001217','C128',NULL,NULL,0,'fixed','5','','','82122019','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1218,'GUARD CART 8S SBD',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176280565','C128',NULL,NULL,0,'fixed','4','','','82122011','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1219,'GUARD CART 4S SBD',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176280541','C128',NULL,NULL,0,'fixed','','','','82122011','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1220,'GUARD CART 1 SBD',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176280596','C128',NULL,NULL,0,'fixed','5','','','8212201','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1221,'VECTOR RZR',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176278548','C128',NULL,NULL,0,'fixed','2','','','82121010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1222,'VECTOR 6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176278609','C128',NULL,NULL,0,'fixed','5','','','82122011','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1223,'VECTOR 4S',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176278630','C128',NULL,NULL,0,'fixed','5','','','82122011','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1224,'VECTOR 2S',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176278579','C128',NULL,NULL,0,'fixed','2','','','82122011','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1225,'GPI-B3G1',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176258168','C128',NULL,NULL,0,'fixed','1','','','82121010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1226,'MACH 3RZR',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176286833','C128',NULL,NULL,0,'fixed','5','','','82121010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1227,'MACH 3CART2S',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176300478','C128',NULL,NULL,0,'fixed','5','','','82122011','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1228,'SS 10S',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4902430801591','C128',NULL,NULL,0,'fixed','','','','82122019','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1229,'7O CLOCK READY II RZ',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176278593','C128',NULL,NULL,0,'fixed','','','','82121010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1230,'SS RZR',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176278531','C128',NULL,NULL,0,'fixed','','','','82121010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1231,'SP RZR',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176278562','C128',NULL,NULL,0,'fixed','2','','','82121090','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1232,'VENUS SKIN LOVE IS',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176273352','C128',NULL,NULL,0,'fixed','5','','','8212010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1233,'SIMPLY VENUS 3S DISP',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'4987176278180','C128',NULL,NULL,0,'fixed','','','','82121010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1234,'WHSPR SOFT XL+6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176192196','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1235,'WHSPR SOFT XL+30S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176192127','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1236,'WHSPR SOFT XL+15S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176192219','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1237,'WHSPR SOFT XL 6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176202208','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1238,'WHSPR SOFT XL 30S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176192226','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1239,'WHSPR SOFT XL 15S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176192103','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1240,'WHSPR ULT ON XL+30S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176200655','C128',NULL,NULL,0,'fixed','10','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1241,'WHSPR ULTRA XL+7S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176237262','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1242,'WHSPR ULTRA XL+45S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176237255','C128',NULL,NULL,0,'fixed','20','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1243,'WHSPR ULTRA XL+30S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176237231','C128',NULL,NULL,0,'fixed','20','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1244,'WHSPR ULTRA XL+15S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176237163','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1245,'WHSPR ULTRA XL 6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176294562','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1246,'WHSPR ULTRA XL 30S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176294586','C128',NULL,NULL,0,'fixed','10','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1247,'WHSPR ULTRA XL 15S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176294609','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1248,'WHSPR ULT XXXL ON 20S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176301819','C128',NULL,NULL,0,'fixed','50','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1249,'WHSPR ULT XXXL ON 10S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176301932','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1250,'WHSPR ULT XXXL ON 4S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176301840','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1251,'WHSPR ULT ON XXL+6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176301796','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1252,'WHSPR UT ON XXL+16S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176263582','C128',NULL,NULL,0,'fixed','10','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1253,'WHSPR ON KOALA XXXXL+8S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176195692','C128',NULL,NULL,0,'fixed','10','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1254,'WHSPR ON KOALA XXXXL+4S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176195708','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1255,'WHSPR ON KOALA XXL +5S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176195722','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1256,'WHSPR ONKOALA XXL+10S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176195715','C128',NULL,NULL,0,'fixed','10','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1257,'WHSPR ON KOALA PANTS 2S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176276957','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1258,'WHSPR MAXI XLW 8S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176252708','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1259,'WHSPR MAXI XLW15S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176252715','C128',NULL,NULL,0,'fixed','5','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1260,'WHSPR MAXI RG 8S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176252678','C128',NULL,NULL,0,'fixed','2','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1261,'WHSPR MAXU REGW ON 7S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176252647','C128',NULL,NULL,0,'fixed','2','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1262,'WHSPR CHOICE XL 18',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176246301','C128',NULL,NULL,0,'fixed','2','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1263,'WHSPR ALOE XL 6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176318411','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1264,'WHSPR CHOICE ULTRA 40S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176246356','C128',NULL,NULL,0,'fixed','10','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1265,'WHSPR CHOICE ULTRA 20S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176246332','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1266,'WHSPR CHOICE WINGS 6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176245281','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1267,'WHSPR CHOICE WINGS 6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176319159','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1268,'WHSPR CHOICE WINGS 20S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176254467','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1269,'WHSPR CHOICE ALOE 6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176252692','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1270,'WHSPR CHOICE ON XXL 6S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176189745','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1271,'WHSPR CHOICE ON XXL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'4987176210333','C128',NULL,NULL,0,'fixed','','','','96190010','',NULL,1,NULL,0,0,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1272,'CLASSMATE 35 MRP DX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902519600011','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1273,'CLASSMATE 70 MRP LONG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902519002341','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1274,'LONG 1 CORELEMI UN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001274','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1275,'LONG 1 CORELEMI .ROLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001275','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1276,'RORITO MARKER PERMANENT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902532045493','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1277,'FLAIR MARKER PERMANENT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901765143594','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1278,'DELUXE NOTE 132 PJ',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001278','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1279,'APSARA PENCIL 6MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901324055795','C128',NULL,NULL,0,'percentage',NULL,NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-02 14:17:30'),(1280,'NATRAJ PENCIL 621',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901324054972','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1281,'DOMS NEON PENCIL 6MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908004279403','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1282,'APSARA LONG SHARPENER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901324003451','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1283,'APSARA COL.ERASER 2MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901324061208','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1284,'APSARA NONDUST SML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901324060027','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1285,'NATRAJ SHARPENER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901324012217','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1286,'STIKY PAD COL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001286','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1287,'DOMS 12 COL PENCIL 30',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908000034433','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1288,'COLOUR PENCIL 12 MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908004279267','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1289,'CAMLIN COL.PENCIL BIG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901425001813','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1290,'APSARA WAXCRAYONS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901324061390','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1291,'COLORING BOOK 1PKT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'9994937657138','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1292,'DOMAS SCALE SMOL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908000034341','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1293,'DOMAS SCAL BIG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8908000034594','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1294,'CD MARKER PEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901198118701','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1295,'PLASTIC ROLL BROWN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001295','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1296,'LUXRE SKESH 30MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901198014294','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1297,'FEVI STICK 5 GRM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901860633501','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1298,'FEVI STICK 8 GRM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901860633532','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1299,'APSARA KIT 25MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901324056792','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1300,'NATRAJ KIT 15 MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901324056808','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1301,'CLAY PK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'6978527836751','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1302,'FEVICOL TUBE.(10.00)',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901860630241','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1303,'TNPL COPIER A/4 70GSM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8902444892765','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1304,'TIP BOX MIX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001304','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1305,'MINI SKETCH PKT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001305','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1306,'ARTIST 9MM CUTTER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8904279300774','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1307,'10X4 MYS CRAFT COVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'*','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1308,'10 MRP MIX PEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001308','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1309,'HI-LIGHTER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001309','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1310,'NATRAJ ERASER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001310','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1311,'CAR JAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001311','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1312,'PVC ROLL 16INS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001312','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1313,'FLAIR WOODYPEN 20MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901765094803','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1314,'COLOURING BOOK MULTI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001314','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1315,'WAX CRYON 25MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901425073452','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1316,'WHITE NOR PEN BIG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901765095428','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1317,'PAPER (UNRD) 10',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001317','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1318,'CAMLIN SCALE 30CM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901425054697','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1319,'CAMLIN SCALE 15CM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901425027738','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1320,'7 MRP PEN MIX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001320','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1321,'5 MRP MIX PEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001321','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1322,'MONOMAX CUTRE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'*','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1323,'CAMEL STAMP PAD BIG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901425012109','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1324,'CAMEL STAMP PAD SMALL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901425012024','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1325,'DF PEN 3MRP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001325','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1326,'SPRING BOOK BLEK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001326','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1327,'FANCY ERASER PKT 100PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001327','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1328,'FEVICOL TUBE.(5.00)',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901860630005','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1329,'BHIKSHU INK PEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'*','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1330,'SPIRAL BOOK NO.4',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001330','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1331,'STIKIPAD 3X3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001331','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1332,'TIP PENCIL 10MRP MIX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901765132307','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1333,'LUXAR FINERITER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001333','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1334,'GIFT PAPER 3-D',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001334','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1335,'PENCIL POUCH Rs.22',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001335','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-03 08:38:22'),(1336,'FANCY BUTEN FILS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001336','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1337,'MY CLEAR BAG F/C',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001337','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1338,'STIC FILE A/4 CLEAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001338','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1339,'STIC FILE F/C CLEAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001339','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1340,'BROWN SHEET SPB 48',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001340','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1341,'REYNOLDS BRIDE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001341','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1342,'RORITO FASTY GEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001342','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1343,'SS URBAN BLACK GEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001343','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1344,'BALAJI KIDDO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001344','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1345,'STHUL MINI INK ERASER PEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001345','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1346,'MONOTEX GLIDER INK BALL PEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'8901015278007','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1347,'UNOMAX ULTRON 2X',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001347','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1348,'PENTONIC BALL PEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001348','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1349,'FLAIR SRX RETRACTABLE BALL PEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025001349','C128',NULL,NULL,0,'','','','','','',NULL,1,NULL,0,0,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1350,'1 ltr SVM G.Oil',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001350','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 00:11:26','2025-02-02 00:11:26'),(1351,'5 ltr SVM G.Oil',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001351','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 00:12:10','2025-02-02 00:14:01'),(1352,'500 ml SVM G.Oil',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001352','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 00:19:56','2025-02-02 06:05:19'),(1353,'Him Baby powder 50gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138715069','C128',NULL,NULL,0,'fixed','1','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1354,'Him Baby powder 100g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511814','C128',NULL,NULL,0,'fixed','5','','','33049120','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1355,'Him Baby powder 200g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138513153','C128',NULL,NULL,0,'fixed','5','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1356,'him baby shampoo 100m',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511449','C128',NULL,NULL,0,'fixed','5','','','33051090','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1357,'him baby shampoo 200m',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511456','C128',NULL,NULL,0,'fixed','5','','','33051090','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1358,'him baby lotion 100ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511463','C128',NULL,NULL,0,'fixed','5','','','33049930','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1359,'him baby lotion 200ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511470','C128',NULL,NULL,0,'fixed','5','','','33049930','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1360,'him baby oilml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511739','C128',NULL,NULL,0,'fixed','5','','','33049930','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1361,'baby hair oil 100ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138845476','C128',NULL,NULL,0,'fixed','5','','','33059011','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1362,'him baby cream50gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511487','C128',NULL,NULL,0,'fixed','2','','','33049930','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1363,'him baby cream 100gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511494','C128',NULL,NULL,0,'fixed','5','','','33049930','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1364,'him baby wipes 72s 9',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901138847494','C128',NULL,NULL,0,'fixed','2','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1365,'him baby wipes 12s m',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901138817756','C128',NULL,NULL,0,'fixed','','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1366,'him baby wipes 24s m',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901138513177','C128',NULL,NULL,0,'fixed','2','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1367,'him baby wipes 72s m',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901138513184','C128',NULL,NULL,0,'fixed','5','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1368,'him gentle baby soap',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511838','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1369,'him nourshing baby so',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138822248','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1370,'him mois baby soap75',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138822217','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1371,'him ref baby soap75',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138822231','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1372,'him gentle baby soap',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138512606','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1373,'him mois baby soap12',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138822224','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1374,'him nourshing baby so',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138825898','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1375,'him ref baby soap12',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138825881','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1376,'him baby gift 255mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138837518','C128',NULL,NULL,0,'fixed','18',NULL,NULL,'33049990','',NULL,1,NULL,0,0,'2025-02-02 00:37:37','2025-02-03 06:06:31'),(1377,'him baby gift 440mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138834470','C128',NULL,NULL,0,'fixed','10','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1378,'him baby gift 630mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138513207','C128',NULL,NULL,0,'fixed','50',NULL,NULL,'33049990','',NULL,1,NULL,0,0,'2025-02-02 00:37:37','2025-02-03 06:07:00'),(1379,'him baby diaper l1 2',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901138009502','C128',NULL,NULL,0,'fixed','','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1380,'him baby diaper m1 2',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901138009519','C128',NULL,NULL,0,'fixed','','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1381,'him baby diaper s1 2',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901138009526','C128',NULL,NULL,0,'fixed','','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1382,'JOHN POWDER 50g 65',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012100554','C128',NULL,NULL,0,'fixed','1','','','33049190','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1383,'JOHN POWDER 100g 130',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012100561','C128',NULL,NULL,0,'fixed','2','','','33049190','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1384,'john blossom pow 50g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012100516','C128',NULL,NULL,0,'fixed','1','','','33049120','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1385,'john blossom pow100',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012100523','C128',NULL,NULL,0,'fixed','2','','','33049190','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1386,'john blossom soap 75g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012116678','C128',NULL,NULL,0,'fixed','1','','','34011190','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1387,'john soap 75gm 68mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012116647','C128',NULL,NULL,0,'fixed','','','','34011190','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1388,'john buds 30s 39mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901012155066','C128',NULL,NULL,0,'fixed','','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1389,'john buds 60s 72mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901012155073','C128',NULL,NULL,0,'fixed','1','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1390,'john buds 150s 155mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901012155080','C128',NULL,NULL,0,'fixed','5','','','96190090','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1391,'john oil 100ml 150',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012116715','C128',NULL,NULL,0,'fixed','5','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1392,'john lotion 50ml-60m',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012116838','C128',NULL,NULL,0,'fixed','','','','33049930','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1393,'john lotion 100ml-mr',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012116845','C128',NULL,NULL,0,'fixed','5','','','33049930','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1394,'john wipes 20s-mrp 85',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012119112','C128',NULL,NULL,0,'fixed','1','','','34011990','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1395,'john wipes 80s 280 mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901012119259','C128',NULL,NULL,0,'fixed','2','','','34011090','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1396,'com cho 200gm jar mr',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901542000027','C128',NULL,NULL,0,'fixed','2','','','19011090','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1397,'com cho 500gm jar',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901542001932','C128',NULL,NULL,0,'fixed','2','','','19011090','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1398,'com cho 200gm ref',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901542000003','C128',NULL,NULL,0,'fixed','2','','','19011090','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1399,'com cho 500gmref',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901542000072','C128',NULL,NULL,0,'fixed','5','','','19011090','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1400,'glu-d reg 125gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901542016226','C128',NULL,NULL,0,'fixed','','','','17023020','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1401,'glu-d orange 125gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901542002786','C128',NULL,NULL,0,'fixed','','','','17023020','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1402,'glu-d reg 250gm jar',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901542001673','C128',NULL,NULL,0,'fixed','1','','','17023020','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1403,'glu-d reg 500gm jar',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901542011702','C128',NULL,NULL,0,'fixed','1','','','17023020','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1404,'glu-d reg 1kg jar',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901542001765','C128',NULL,NULL,0,'fixed','5','','','17023020','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1405,'E.Y GOLDEN P.OFF 30M',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901548147184','C128',NULL,NULL,0,'fixed','1','','','3304','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1406,'E.Y GOLDEN P.OFF 50M',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901548147191','C128',NULL,NULL,0,'fixed','2','','','3304','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1407,'E.Y ORANGE P.OFF 30M',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901120146215','C128',NULL,NULL,0,'fixed','1','','','3304','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1408,'E.Y ORANGE P.OFF 50M',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901120146222','C128',NULL,NULL,0,'fixed','2','','','3304','',NULL,1,NULL,0,0,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1409,'him neem f/w 50ml 85',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138512187','C128',NULL,NULL,0,'fixed','1','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1410,'him aloevera f/w 50m',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138509224','C128',NULL,NULL,0,'fixed','2','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1411,'him neem f/w 100ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138512460','C128',NULL,NULL,0,'fixed','2','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1412,'him charcoal f/w 50m',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138000165','C128',NULL,NULL,0,'fixed','2','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1413,'him orange f/w 50ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138837051','C128',NULL,NULL,0,'fixed','2','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1414,'him turmeric f/w 50m',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138006112','C128',NULL,NULL,0,'fixed','2','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1415,'him rose f/w 50ml-9',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138847265','C128',NULL,NULL,0,'fixed','2','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1416,'him lemon f/w 50ml-w',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138509217','C128',NULL,NULL,0,'fixed','2','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1417,'him blueberry f/w 50',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138005955','C128',NULL,NULL,0,'fixed','2','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1418,'him or vitamin c f/w',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138005948','C128',NULL,NULL,0,'fixed','2','','','34013090','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1419,'him fairness cream 2',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138504519','C128',NULL,NULL,0,'fixed','1','','','33049910','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1420,'him fairness cream 5',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138500467','C128',NULL,NULL,0,'fixed','2','','','33049910','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1421,'him aloevera b/l 100ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138821197','C128',NULL,NULL,0,'fixed','2','','','33049930','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1422,'him coco b/l 100ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138510039','C128',NULL,NULL,0,'fixed','2','','','33049930','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1423,'him lip balm 5gm 20m',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138834937','C128',NULL,NULL,0,'fixed','1','','','33041000','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1424,'him con.care 80gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138836092','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1425,'him sparkling white',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138836115','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1426,'him activefresh',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138836061','C128',NULL,NULL,0,'fixed','1','','','33061020','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1427,'him complete care 15',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138836306','C128',NULL,NULL,0,'fixed','2','','','33061020','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1428,'him complete care 150',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138836108','C128',NULL,NULL,0,'fixed','2','','','33061020','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1429,'him neem&turmeric 75',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138711962','C128',NULL,NULL,0,'fixed','1','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1430,'him almond soap 75gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511593','C128',NULL,NULL,0,'fixed','1','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1431,'him cucumber soap75gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511616','C128',NULL,NULL,0,'fixed','1','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1432,'him cream honey soap 7',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138511609','C128',NULL,NULL,0,'fixed','1','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1433,'him neem&turmeric 12',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138714550','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1434,'him almond soap 125gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138513085','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1435,'him cream honey soap 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138513061','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1436,'him cucumber soap 12',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138513078','C128',NULL,NULL,0,'fixed','2','','','34011110','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1437,'him ad shampoo 80ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138002459','C128',NULL,NULL,0,'fixed','2','','','33051090','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1438,'him ahf shampoo 80ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138002404','C128',NULL,NULL,0,'fixed','2','','','33051090','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1439,'him gdc shampoo 80ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138002367','C128',NULL,NULL,0,'fixed','2','','','33051090','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1440,'him ahf shampoo 200ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138002411','C128',NULL,NULL,0,'fixed','5','','','33051090','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1441,'him damagerepair sha',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138002329','C128',NULL,NULL,0,'fixed','5','','','33051090','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1442,'him neem f/w 15ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138513627','C128',NULL,NULL,0,'fixed','0.5','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1443,'him rose f/w 15ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138002176','C128',NULL,NULL,0,'fixed','0.5','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1444,'him aloevera gel 90m',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138848484','C128',NULL,NULL,0,'fixed','1','','','33049910','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1445,'him rose gel 90mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138848491','C128',NULL,NULL,0,'fixed','1','','','33049990','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1446,'him neem gel 90mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138848460','C128',NULL,NULL,0,'fixed','1','','','33049910','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1447,'him kesar gel 90mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901138848477','C128',NULL,NULL,0,'fixed','1','','','33049910','',NULL,1,NULL,0,0,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1448,'vicco turmeric 15gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901288030159','C128',NULL,NULL,0,'fixed','1','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1449,'vicco turmeric 30gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901288030302','C128',NULL,NULL,0,'fixed','2','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1450,'vicco wsd cream 15gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901288230153','C128',NULL,NULL,0,'fixed','0.5','','','33049011','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1451,'vicco wsd cream 30gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901288230306','C128',NULL,NULL,0,'fixed','1','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1452,'vicco paste 50g',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901288010502','C128',NULL,NULL,0,'fixed','1','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1453,'vicco paste 100gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901288011004','C128',NULL,NULL,0,'fixed','2','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1454,'vicco paste 150gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901288011509','C128',NULL,NULL,0,'fixed','2','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1455,'vicco powder 25gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'8901288020259','C128',NULL,NULL,0,'fixed','','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1456,'vicco powder 50gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,8,'inclusive',1,0.0000,'2025001456','C128',NULL,NULL,0,'fixed','1','','','30049011','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1457,'vip die 20ml 51mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8908011235140','C128',NULL,NULL,0,'fixed','0.5','','','3305','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1458,'vip die 40ml 96mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8908011235027','C128',NULL,NULL,0,'fixed','1','','','3305','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1459,'v care moustache&bea',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8904089100502','C128',NULL,NULL,0,'fixed','','','','33059040','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1460,'v care shampoo hair',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8904089100410','C128',NULL,NULL,0,'fixed','1','','','33059040','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1461,'v care shampoo hair',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8904089100328','C128',NULL,NULL,0,'fixed','2','','','33059040','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1462,'v care skin whi soap',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8904089101967','C128',NULL,NULL,0,'fixed','1','','','34011911','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1463,'v care wine soap',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8904089103602','C128',NULL,NULL,0,'fixed','1','','','34011911','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1464,'garnier ori.black',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901526209903','C128',NULL,NULL,0,'fixed','','','','33059040','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1465,'garnier natural balc',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901526202935','C128',NULL,NULL,0,'fixed','2','','','33059040','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1466,'garnier natural blac',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901526637690','C128',NULL,NULL,0,'fixed','2','','','33059040','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1467,'garnier natural black',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901526204731','C128',NULL,NULL,0,'fixed','1','','','33059040','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1468,'yar e.rose soap 2+1',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105031189','C128',NULL,NULL,0,'fixed','2','','','33011190','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1469,'yar lav soap 2+1 mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105031172','C128',NULL,NULL,0,'fixed','2','','','33011190','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1470,'yar red rose soap se',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105011624','C128',NULL,NULL,0,'fixed','2','','','33011190','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1471,'yar jasmine soap set',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105011617','C128',NULL,NULL,0,'fixed','2','','','33011190','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1472,'yar sandal soap set',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105011631','C128',NULL,NULL,0,'fixed','2','','','33011190','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1473,'yar e.rose pow-mrp 60',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105034449','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'9608301','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-03 08:34:30'),(1474,'yar lav pow-60mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105010283','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'3309120','',NULL,1,NULL,0,0,'2025-02-02 01:18:39','2025-02-03 09:18:38'),(1475,'yar m.dev talc -60mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105030021','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'33049120','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 09:16:38'),(1476,'yar san pow mrp60',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105034456','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'33071010','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 09:17:27'),(1477,'yar english rose tal',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105010313','C128',NULL,NULL,0,'fixed','2','','','33049120','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1478,'yar lavendar talc 10',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105010269','C128',NULL,NULL,0,'fixed','2','','','33049120','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1479,'yar redrose talc 100',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105010146','C128',NULL,NULL,0,'fixed','2','','','33049120','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1480,'yar sandal talc 100g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105010177','C128',NULL,NULL,0,'fixed','2','','','33049120','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1481,'yar jasmine talc 100',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105010207','C128',NULL,NULL,0,'fixed','2','','','33049120','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1482,'yar gentleman talc 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105010498','C128',NULL,NULL,0,'fixed','10',NULL,NULL,'33049120','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 08:38:50'),(1483,'yar gold talc 100gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8903105010023','C128',NULL,NULL,0,'fixed','10',NULL,NULL,'9608109','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 09:15:29'),(1484,'keto soap 50gm 137',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906101650224','C128',NULL,NULL,0,'fixed','2','','','3402','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1485,'keto soap 100gm 289',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906101654710','C128',NULL,NULL,0,'fixed','5','','','3402','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1486,'teddy bear soap 199',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8904187001367','C128',NULL,NULL,0,'fixed','5','','','33049910','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1487,'z Talc 50g 75 mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906015120011','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'33049120','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 09:18:01'),(1488,'z talc 100gm mrp145',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906015120028','C128',NULL,NULL,0,'fixed','8',NULL,NULL,'33049120','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 08:03:11'),(1489,'z deo 45ml 80 mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906015120042','C128',NULL,NULL,0,'fixed','5',NULL,NULL,'33073090','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 07:49:27'),(1490,'z deo 75 ml 135 mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906015120059','C128',NULL,NULL,0,'fixed','5',NULL,NULL,'33073090','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 07:47:11'),(1491,'z deo 1+1 mrp 299',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906015120479','C128',NULL,NULL,0,'fixed','5','','','33072000','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1492,'jass 8ml 50mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901360207912','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'33030090','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 09:17:44'),(1493,'jas 50ml 95mrp',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901360222816','C128',NULL,NULL,0,'fixed','6',NULL,NULL,'33030090','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 07:48:35'),(1494,'tara talc 100gm mrp 8',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901360101241','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'33030090','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 08:02:23'),(1495,'jass perfume talc 10',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8901360232617','C128',NULL,NULL,0,'fixed','4',NULL,NULL,'33049910','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 07:47:38'),(1496,'fogg marco 120ml 225',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8908001158305','C128',NULL,NULL,0,'fixed','5','','','3307','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1497,'fogg nepoleon 120 ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8908001158244','C128',NULL,NULL,0,'fixed','25',NULL,NULL,'3307','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 07:31:36'),(1498,'fogg royal 120ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8908001158312','C128',NULL,NULL,0,'fixed','5','','','3307','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1499,'fogg paradise 120ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8908001158350','C128',NULL,NULL,0,'fixed','25',NULL,NULL,'3307','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 07:31:18'),(1500,'fogg essance 120ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8908001158343','C128',NULL,NULL,0,'fixed','5','','','3307','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1501,'fogg delicious 120 ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8908001158336','C128',NULL,NULL,0,'fixed','25',NULL,NULL,'3307','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 07:32:22'),(1502,'white tone powder 30g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8908001158077','C128',NULL,NULL,0,'fixed','3',NULL,NULL,'3304','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-03 08:01:16'),(1503,'allout sattav refill',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8904271200454','C128',NULL,NULL,0,'fixed','1','','','38089191','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1504,'allout machine',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906006435773','C128',NULL,NULL,0,'fixed','1','','','38089191','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1505,'allout*2 refill',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906006430402','C128',NULL,NULL,0,'fixed','5','','','3808','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1506,'allout machine 180m',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,0.0000,'8906006430594','C128',NULL,NULL,0,'fixed','5','','','38089191','',NULL,1,NULL,0,0,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1507,'Plastic Items',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001507','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 01:20:07','2025-02-02 01:20:45'),(1508,'parimal pine',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8901184127533','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 02:49:56','2025-02-02 02:49:56'),(1509,'Chocolate',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'7622202245558','C128',NULL,NULL,0,'percentage',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 03:08:02','2025-02-02 03:08:14'),(1510,'Maida',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001510','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 03:34:17','2025-02-02 03:34:17'),(1511,'kadalai 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001511','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 03:46:56','2025-02-02 03:46:56'),(1512,'1kg Malli',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001512','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:09:37','2025-02-02 04:09:37'),(1513,'reynold pen',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001513','C128',7.00,'months',0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:11:17','2025-02-02 04:11:17'),(1514,'broom stick',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001514','C128',6.00,'months',0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:23:28','2025-02-02 04:23:28'),(1515,'broom stick',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001515','C128',5.00,'months',0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:24:31','2025-02-02 04:24:31'),(1516,'broom stick',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001516','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:25:38','2025-02-02 04:25:38'),(1517,'broom stick',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001517','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:26:06','2025-02-02 04:26:06'),(1518,'broom stick',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001518','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:26:53','2025-02-02 04:26:53'),(1519,'maitha',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001519','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:27:36','2025-02-02 04:27:36'),(1520,'kg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001520','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:32:58','2025-02-02 04:32:58'),(1521,'kothamalli 2kg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001521','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:41:48','2025-02-02 04:41:48'),(1522,'tray',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001522','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:43:01','2025-02-02 04:43:01'),(1523,'anil semiya',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001523','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:45:56','2025-02-02 04:45:56'),(1524,'odofresh',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001524','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:46:32','2025-02-02 04:46:32'),(1525,'JAGGERY 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'2025001525','C128',NULL,NULL,0,'fixed','15',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:52:37','2025-02-02 04:52:37'),(1526,'JAGGERY 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'2025001526','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:55:42','2025-02-02 04:55:42'),(1527,'EAR CUFF',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001527','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:57:47','2025-02-02 04:57:47'),(1528,'EAR CUFF',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001528','C128',NULL,NULL,0,'fixed','20',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 04:58:48','2025-02-02 04:58:48'),(1529,'broom',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001529','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 05:03:56','2025-02-02 05:03:56'),(1530,'1 kg Kadalai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001530','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 05:10:02','2025-02-02 05:10:02'),(1531,'gems',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001531','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 05:16:03','2025-02-02 05:16:03'),(1532,'GLUCOVITA BOLTS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001532','C128',NULL,NULL,0,'percentage',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 05:44:08','2025-02-02 09:16:42'),(1533,'10 Rs.Selavu Pack',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001533','C128',NULL,NULL,0,'fixed','0.5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 06:34:42','2025-02-03 02:55:13'),(1534,'VADA PARUPPU 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001534','C128',NULL,NULL,0,'fixed','6',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 07:59:04','2025-02-02 08:01:47'),(1535,'VADA PARUPPU 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001535','C128',0.00,'months',0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 08:01:15','2025-02-02 08:01:15'),(1536,'DAIRY MILK ROAST ALMOND 50RS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'7622201150150','C128',NULL,NULL,0,'percentage',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 09:03:57','2025-02-02 09:08:50'),(1537,'TULIP EAR BUDS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8904117400116','C128',0.00,'months',0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 09:26:50','2025-02-02 09:26:50'),(1538,'GROUNDNUT (VERKADALAI1KG)',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001538','C128',0.00,'months',0,'fixed','10',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 09:38:50','2025-02-02 09:38:50'),(1539,'GROUNDNUT(VERKADALAI 500G)',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001539','C128',0.00,'months',0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 09:40:04','2025-02-02 09:40:04'),(1540,'250G GROUNDNUT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001540','C128',0.00,'months',0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 09:41:35','2025-02-02 09:41:35'),(1541,'BIRIYANI SET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001541','C128',0.00,'months',0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 09:56:19','2025-02-02 09:56:19'),(1542,'BLACK CURRAT ICONE 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8904057301405','C128',0.00,'months',0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 10:51:48','2025-02-02 10:51:48'),(1543,'ARUN STRAWBEERY 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8904057300859','C128',0.00,'months',0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 10:53:03','2025-02-02 10:53:03'),(1544,'20 RS-UNDIYAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001544','C128',0.00,'months',0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 11:19:32','2025-02-02 11:19:32'),(1545,'175-METAL WATERBOTTLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001545','C128',0.00,'months',0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 11:29:03','2025-02-02 11:29:03'),(1546,'vanilla 125 ml tub',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8904057301238','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 11:54:54','2025-02-02 11:55:29'),(1547,'PATTAI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001547','C128',0.00,'months',0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 12:37:11','2025-02-02 12:37:11'),(1548,'ARUN KULFI KING 50RS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8904057300330','C128',0.00,'months',0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 12:40:49','2025-02-02 12:40:49'),(1549,'CHOCO MINI 20RS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8904057300125','C128',0.00,'months',0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 12:41:38','2025-02-02 12:41:38'),(1550,'100g pattai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001550','C128',0.00,'months',0,'fixed','2.5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 12:41:50','2025-02-02 12:41:50'),(1551,'1Kg Pachai Arisi',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001551','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 13:07:20','2025-02-02 13:07:20'),(1552,'JIYO ENRICHING CONES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8901184117862','C128',0.00,'months',0,'fixed','1',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 13:15:41','2025-02-02 13:15:41'),(1553,'NAPTHALENE BALLS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001553','C128',0.00,'months',0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 13:17:00','2025-02-02 13:17:00'),(1554,'BUTTERSCOTCH 125MIL TUB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8904057301269','C128',0.00,'months',0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 13:18:06','2025-02-02 13:18:06'),(1555,'500G N.Sugar',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001555','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 13:18:09','2025-02-02 13:18:09'),(1556,'Egg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001556','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 13:30:23','2025-02-02 13:30:23'),(1557,'1 Kg N.Sugar',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001557','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 14:24:43','2025-02-02 14:24:43'),(1558,'bath stand',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001558','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 14:34:59','2025-02-02 14:34:59'),(1559,'250g B.Kavuni',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001559','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 14:46:52','2025-02-02 14:46:52'),(1560,'500g B.Kavuni',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001560','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-02 14:50:29','2025-02-02 14:50:29'),(1561,'175ml NOBBY FEEDING',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001561','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 06:10:51','2025-02-03 06:11:02'),(1562,'CHHAYA JUICER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001562','C128',NULL,NULL,0,'fixed','80',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 06:46:22','2025-02-03 06:46:22'),(1563,'UMBERLLA 2 FOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001563','C128',NULL,NULL,0,'fixed','20',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 06:55:35','2025-02-03 06:55:35'),(1564,'UMBERLLA 3 FOLD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001564','C128',NULL,NULL,0,'fixed','20',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:00:26','2025-02-03 07:00:53'),(1565,'Zodiac Comb small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001565','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:04:25','2025-02-03 07:21:27'),(1566,'ZODIAC COMB BIG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001566','C128',NULL,NULL,0,'fixed','-10',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:05:27','2025-02-03 07:05:27'),(1567,'SUPER FLEXI BRUSH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8901314200044','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:11:02','2025-02-03 07:11:02'),(1568,'OB SEN EXTRA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'4987176268693','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:13:07','2025-02-03 07:13:26'),(1569,'Comb gold',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001569','C128',NULL,NULL,0,'fixed','20',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:15:02','2025-02-03 07:19:44'),(1570,'100g Milagai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001570','C128',NULL,NULL,0,'fixed','0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:17:54','2025-02-03 07:17:54'),(1571,'Moram Small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001571','C128',NULL,NULL,0,'fixed','20',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:23:36','2025-02-03 07:23:36'),(1572,'Moram big',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001572','C128',NULL,NULL,0,'fixed','25',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:24:20','2025-02-03 07:24:20'),(1573,'zodiac med Comb',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001573','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:25:38','2025-02-03 07:25:38'),(1574,'tic tac',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'8000500366769','C128',NULL,NULL,0,'fixed','.5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 07:53:24','2025-02-03 07:53:24'),(1575,'Pencil Pouch Rs.28',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001575','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 08:23:43','2025-02-03 08:23:43'),(1576,'Pencil Pouch Rs.35',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001576','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 08:24:36','2025-02-03 08:24:36'),(1577,'Pencil Pouch Rs.37',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001577','C128',NULL,NULL,0,'fixed','10',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 08:25:00','2025-02-03 08:25:00'),(1578,'OB Criss Cross Rs.50',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'4987176176455','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 08:43:03','2025-02-03 08:43:03'),(1579,'whspr choice ultra 10s',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'4987176324672','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:27:21','2025-02-03 09:27:21'),(1580,'whspr ult on xl+7s',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'4987176200648','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:29:25','2025-02-03 09:29:25'),(1581,'OB Criss Cross Rs.120',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'4987176278838','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:31:04','2025-02-03 09:31:04'),(1582,'Cream Gil Reg 93gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'4987176150585','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:33:49','2025-02-03 09:33:49'),(1583,'TSG (Mst)60g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'4987176093714','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:44:41','2025-02-03 09:44:41'),(1584,'Guard Cream Small 25gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176303363','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:47:09','2025-02-03 09:47:09'),(1585,'cream musk 30g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176278616','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:49:10','2025-02-03 09:49:10'),(1586,'TSG (sen) 60g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'4987176093738','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:51:13','2025-02-03 09:51:13'),(1587,'Patta 50g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001587','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:55:58','2025-02-03 09:55:58'),(1588,'patta 20g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001588','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:57:09','2025-02-03 09:57:09'),(1589,'Patta 10g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001589','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:57:56','2025-02-03 09:57:56'),(1590,'Guard Cream 125g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176239921','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 09:59:58','2025-02-03 09:59:58'),(1591,'Gillete TSG 25g Sen',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176030023','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:01:37','2025-02-03 10:01:37'),(1592,'Cream Gil Reg 30gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176198235','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:04:11','2025-02-03 10:04:11'),(1593,'cream gil reg 93 gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176150578','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:27:02','2025-02-03 10:27:02'),(1594,'Foam Reg 200ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176030108','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:33:26','2025-02-03 10:33:26'),(1595,'gilletfoam 50g reg90',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4902430722193','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:35:15','2025-02-03 10:35:15'),(1596,'asl original 50ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176295026','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:36:34','2025-02-03 10:36:34'),(1597,'asl musk 50 ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176176752','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:37:36','2025-02-03 10:37:36'),(1598,'cream gil reg 30 gm',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176198242','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:38:51','2025-02-03 10:38:51'),(1599,'cream lime 75g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176037374','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:40:17','2025-02-03 10:40:17'),(1600,'cream musk 70g',1,'single',1,NULL,NULL,NULL,NULL,NULL,11,'inclusive',1,NULL,'4987176029942','C128',NULL,NULL,0,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 10:41:24','2025-02-03 10:41:24'),(1601,'500g Malli',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025001601','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 11:20:14','2025-02-03 11:20:14'),(1602,'10-SAFTYPIN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,10.0000,'2025001602','C128',NULL,NULL,0,'fixed',NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 12:07:16','2025-02-03 12:07:16'),(1603,'odofresh',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,10.0000,'2025001603','C128',NULL,NULL,0,'fixed','20',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 12:09:12','2025-02-03 12:09:12'),(1604,'COLORING BOOK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,10.0000,'2025001604','C128',NULL,NULL,0,'fixed','2.5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 12:11:16','2025-02-03 12:11:16'),(1605,'NOTE BOOK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,10.0000,'2025001605','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-03 12:13:26','2025-02-03 12:13:26');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `purchase_order_line_id` int(11) DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1603 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,1,1,54.0000,0.0000,4.0000,0.00,4.0000,5.0000,0.2000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:01','2025-02-02 14:16:09'),(2,2,2,2,40.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 03:55:23'),(3,3,3,3,24.0000,0.0000,17.0000,0.00,17.0000,18.0000,0.8500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(4,4,4,4,56.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 05:13:16'),(5,5,5,5,40.0000,0.0000,17.0000,0.00,17.0000,18.0000,0.8500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 04:44:12'),(6,6,6,6,30.0000,0.0000,38.0000,0.00,38.0000,40.0000,1.9000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 04:57:16'),(7,7,7,7,10.0000,0.0000,85.0000,0.00,85.0000,89.0000,4.2500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 04:23:43'),(8,8,8,8,40.0000,0.0000,43.0000,0.00,43.0000,45.0000,2.1500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 05:17:08'),(9,9,9,9,48.0000,0.0000,4.0000,0.00,4.0000,5.0000,0.2000,4,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 14:16:09'),(10,10,10,10,64.0000,0.0000,9.0000,0.00,9.0000,9.4500,0.4500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-03 03:46:55'),(11,11,11,11,64.0000,0.0000,4.0000,0.00,4.0000,4.2000,0.2000,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 05:27:38'),(12,12,12,12,12.0000,0.0000,43.0000,0.00,43.0000,45.0000,2.1500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 03:43:24'),(13,13,13,13,12.0000,0.0000,38.0000,0.00,38.0000,40.0000,1.9000,4,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 12:25:07'),(14,14,14,14,24.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 12:39:49'),(15,15,15,15,12.0000,0.0000,17.0000,0.00,17.0000,18.0000,0.8500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 06:26:14'),(16,16,16,16,12.0000,0.0000,26.0000,0.00,26.0000,27.0000,1.3000,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 13:14:11'),(17,17,17,17,6.0000,0.0000,34.0000,0.00,34.0000,36.0000,1.7000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(18,18,18,18,6.0000,0.0000,38.0000,0.00,38.0000,40.0000,1.9000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 06:27:54'),(19,19,19,19,6.0000,0.0000,38.0000,0.00,38.0000,40.0000,1.9000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-02-02 06:47:23'),(20,21,20,20,39.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 15:44:20'),(21,22,21,21,21.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-03 08:45:53'),(22,23,22,22,16.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 03:47:22'),(23,24,23,23,25.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-03 03:08:44'),(24,25,24,24,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-03 12:14:20'),(25,26,25,25,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 03:28:19'),(26,27,26,26,40.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-03 12:14:20'),(27,28,27,27,29.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 11:01:13'),(28,29,28,28,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 04:33:27'),(29,30,29,29,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(30,31,30,30,14.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-03 03:08:44'),(31,32,31,31,13.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 14:22:04'),(32,33,32,32,2.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(33,34,33,33,38.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 14:56:17'),(34,35,34,34,40.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-03 10:20:16'),(35,36,35,35,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,26.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 15:33:57'),(36,37,36,36,40.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(37,38,37,37,40.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 13:32:10'),(38,39,38,38,19.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,18.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 13:14:21'),(39,40,39,39,18.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 04:12:57'),(40,41,40,40,16.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 13:04:47'),(41,42,41,41,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 13:30:42'),(42,43,42,42,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 03:28:22'),(43,44,43,43,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 04:01:22'),(44,45,44,44,18.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 12:49:55'),(45,46,45,45,5.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(46,47,46,46,25.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-03 12:14:20'),(47,48,47,47,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(48,49,48,48,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 09:58:02'),(49,50,49,49,54.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-03 05:56:11'),(50,51,50,50,32.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 08:34:37'),(51,52,51,51,31.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-03 08:45:53'),(52,53,52,52,14.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 11:28:15'),(53,54,53,53,13.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 12:48:25'),(54,55,54,54,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 12:06:07'),(55,56,55,55,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 13:04:47'),(56,57,56,56,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(57,58,57,57,14.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 04:51:21'),(58,59,58,58,19.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 12:49:26'),(59,60,59,59,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 13:04:47'),(60,61,60,60,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 05:36:33'),(61,62,61,61,5.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(62,63,62,62,34.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 13:04:47'),(63,64,63,63,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 13:14:11'),(64,65,64,64,11.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-02-02 12:48:25'),(65,66,65,65,31.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,19.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 10:15:15','2025-02-03 12:14:20'),(66,67,66,66,63.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,51.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 10:15:58','2025-02-03 11:50:47'),(67,68,67,67,21.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 12:20:25','2025-02-03 12:14:20'),(68,69,68,68,31.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,13.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 12:21:28','2025-02-02 14:16:09'),(69,70,69,69,9.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 12:22:04','2025-02-02 13:14:21'),(70,71,70,70,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:19:53','2025-01-31 18:08:29'),(71,72,71,71,21.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:21:03','2025-02-02 04:51:21'),(72,73,72,72,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:24:04','2025-01-31 13:24:04'),(73,74,73,73,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:53:47','2025-02-02 13:04:47'),(74,75,74,74,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:54:27','2025-02-02 05:36:33'),(75,76,75,75,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:56:25','2025-02-02 03:28:22'),(76,77,76,76,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:56:58','2025-02-03 03:03:20'),(77,78,77,77,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:59:03','2025-02-02 13:04:47'),(78,79,78,78,5.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:59:32','2025-02-02 07:23:03'),(79,80,79,79,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 14:03:17','2025-02-02 05:36:33'),(80,81,80,80,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 14:03:57','2025-02-02 04:12:57'),(81,82,81,81,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 14:06:36','2025-02-03 03:03:20'),(82,83,82,82,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 14:07:27','2025-02-02 03:49:18'),(83,84,83,83,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 06:58:56','2025-02-02 15:13:40'),(84,85,84,84,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 06:59:46','2025-02-01 06:59:46'),(85,86,85,85,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 07:00:16','2025-02-02 15:13:40'),(86,87,86,86,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 07:00:40','2025-02-03 08:45:53'),(87,88,87,87,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 07:01:00','2025-02-03 11:00:35'),(88,89,88,88,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 07:01:20','2025-02-02 13:14:11'),(140,141,140,140,100.0000,0.0000,10.0000,0.00,10.0000,11.0000,0.5000,4,NULL,27.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 12:14:20'),(141,142,141,141,50.0000,0.0000,21.0000,0.00,21.0000,22.0000,1.0500,4,NULL,21.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 08:49:53'),(142,143,142,142,25.0000,0.0000,42.0000,0.00,42.0000,44.0000,2.1000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 06:19:26'),(143,144,143,143,10.0000,0.0000,104.0000,0.00,104.0000,109.0000,5.2000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 05:46:07'),(144,145,144,144,60.0000,0.0000,7.0000,0.00,7.0000,8.0000,0.3500,4,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 13:43:47'),(145,146,145,145,50.0000,0.0000,15.0000,0.00,15.0000,16.0000,0.7500,4,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 15:54:30'),(146,147,146,146,25.0000,0.0000,29.0000,0.00,29.0000,31.0000,1.4500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 12:49:26'),(147,148,147,147,10.0000,0.0000,73.0000,0.00,73.0000,77.0000,3.6500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 13:14:21'),(148,149,148,148,60.0000,0.0000,11.0000,0.00,11.0000,12.0000,0.5500,4,NULL,15.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 03:03:20'),(149,150,149,149,50.0000,0.0000,23.0000,0.00,23.0000,25.0000,1.1500,4,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 12:06:07'),(150,151,150,150,25.0000,0.0000,46.0000,0.00,46.0000,49.0000,2.3000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 03:08:32'),(151,152,151,151,10.0000,0.0000,115.0000,0.00,115.0000,121.0000,5.7500,4,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 12:14:20'),(152,153,152,152,60.0000,0.0000,17.0000,0.00,17.0000,18.0000,0.8500,4,NULL,18.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 13:54:56'),(153,154,153,153,50.0000,0.0000,35.0000,0.00,35.0000,36.0000,1.7500,4,NULL,19.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 08:49:53'),(154,155,154,154,25.0000,0.0000,69.0000,0.00,69.0000,72.0000,3.4500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 12:14:20'),(155,156,155,155,10.0000,0.0000,171.0000,0.00,171.0000,180.0000,8.5500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 13:14:21'),(156,157,156,156,40.0000,0.0000,14.0000,0.00,14.0000,15.0000,0.7000,4,NULL,15.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 03:03:20'),(157,158,157,157,50.0000,0.0000,29.0000,0.00,29.0000,31.0000,1.4500,4,NULL,22.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 08:49:53'),(158,159,158,158,25.0000,0.0000,58.0000,0.00,58.0000,61.0000,2.9000,4,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 12:14:20'),(159,160,159,159,10.0000,0.0000,146.0000,0.00,146.0000,153.0000,7.3000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 05:46:07'),(160,161,160,160,40.0000,0.0000,21.0000,0.00,21.0000,23.0000,1.0500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 15:44:20'),(161,162,161,161,20.0000,0.0000,43.0000,0.00,43.0000,45.0000,2.1500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 12:22:42'),(162,163,162,162,60.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.6500,4,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 08:49:53'),(163,164,163,163,50.0000,0.0000,26.0000,0.00,26.0000,27.0000,1.3000,4,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 13:54:56'),(164,165,164,164,20.0000,0.0000,52.0000,0.00,52.0000,54.0000,2.6000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(165,166,165,165,10.0000,0.0000,129.0000,0.00,129.0000,136.0000,6.4500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 07:04:48'),(166,167,166,166,60.0000,0.0000,18.0000,0.00,18.0000,19.0000,0.9000,4,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 13:54:56'),(167,168,167,167,50.0000,0.0000,35.0000,0.00,35.0000,37.0000,1.7500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 04:21:43'),(168,169,168,168,20.0000,0.0000,71.0000,0.00,71.0000,74.0000,3.5500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 12:14:20'),(169,170,169,169,6.0000,0.0000,176.0000,0.00,176.0000,185.0000,8.8000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(170,171,170,170,20.0000,0.0000,42.0000,0.00,42.0000,45.0000,2.1000,4,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 13:47:31'),(171,172,171,171,40.0000,0.0000,20.0000,0.00,20.0000,21.0000,1.0000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 07:11:54'),(172,173,172,172,20.0000,0.0000,11.0000,0.00,11.0000,12.0000,0.5500,4,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 12:49:26'),(173,174,173,173,40.0000,0.0000,15.0000,0.00,15.0000,16.0000,0.7500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 12:14:20'),(174,175,174,174,40.0000,0.0000,18.0000,0.00,18.0000,19.0000,0.9000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(175,176,175,175,20.0000,0.0000,20.0000,0.00,20.0000,21.0000,1.0000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 15:44:20'),(176,177,176,176,10.0000,0.0000,16.0000,0.00,16.0000,17.0000,0.8000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 06:58:55'),(177,178,177,177,10.0000,0.0000,21.0000,0.00,21.0000,22.0000,1.0500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(178,179,178,178,10.0000,0.0000,23.0000,0.00,23.0000,25.0000,1.1500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 13:14:11'),(179,180,179,179,10.0000,0.0000,14.0000,0.00,14.0000,15.0000,0.7000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(180,181,180,180,10.0000,0.0000,11.0000,0.00,11.0000,11.0000,0.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(181,182,181,181,20.0000,0.0000,20.0000,0.00,20.0000,21.0000,1.0000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 13:14:11'),(182,183,182,182,20.0000,0.0000,33.0000,0.00,33.0000,34.0000,1.6500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(183,184,183,183,20.0000,0.0000,16.0000,0.00,16.0000,17.0000,0.8000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(184,185,184,184,100.0000,0.0000,23.0000,0.00,23.0000,24.0000,1.1500,4,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 12:14:20'),(185,186,185,185,10.0000,0.0000,91.0000,0.00,91.0000,96.0000,4.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(186,187,186,186,20.0000,0.0000,21.0000,0.00,21.0000,22.0000,1.0500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 08:34:37'),(187,188,187,187,10.0000,0.0000,30.0000,0.00,30.0000,32.0000,1.5000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-03 06:23:04'),(188,189,188,188,25.0000,0.0000,23.0000,0.00,23.0000,27.0000,4.1400,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 11:01:13'),(189,190,189,189,10.0000,0.0000,56.0000,0.00,56.0000,66.0000,10.0800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 09:19:28'),(190,191,190,190,20.0000,0.0000,18.0000,0.00,18.0000,19.0000,0.9000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-02 12:06:07'),(191,192,191,191,960.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,32.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-02 07:04:48'),(192,193,192,192,600.0000,0.0000,1.0000,0.00,1.0000,1.1800,0.1800,11,NULL,31.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-02 07:11:54'),(193,194,193,193,192.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(194,195,194,194,600.0000,0.0000,2.0000,0.00,2.0000,2.2400,0.2400,8,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-02 03:03:42'),(195,196,195,195,240.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(196,197,196,196,240.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(197,198,197,197,240.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(198,199,198,198,150.0000,0.0000,3.0000,0.00,3.0000,4.0000,0.5400,11,NULL,27.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-02 06:58:55'),(199,200,199,199,240.0000,0.0000,1.0000,0.00,1.0000,2.0000,0.1800,11,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-02 07:11:54'),(200,201,200,200,480.0000,0.0000,1.0000,0.00,1.0000,2.0000,0.1800,11,NULL,30.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-02 15:44:20'),(201,202,201,201,6.0000,0.0000,46.0000,0.00,46.0000,54.0000,8.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(202,203,202,202,6.0000,0.0000,85.0000,0.00,85.0000,100.0000,15.3000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(203,204,203,203,6.0000,0.0000,38.0000,0.00,38.0000,45.0000,6.8400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(204,205,204,204,6.0000,0.0000,85.0000,0.00,85.0000,100.0000,15.3000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(205,206,205,205,6.0000,0.0000,53.0000,0.00,53.0000,63.0000,9.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(206,207,206,206,6.0000,0.0000,58.0000,0.00,58.0000,69.0000,10.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(207,208,207,207,6.0000,0.0000,133.0000,0.00,133.0000,157.0000,23.9400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(208,209,208,208,6.0000,0.0000,152.0000,0.00,152.0000,179.0000,27.3600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(209,210,209,209,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,0.9600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(210,211,210,210,6.0000,0.0000,50.0000,0.00,50.0000,56.0000,6.0000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(211,212,211,211,6.0000,0.0000,90.0000,0.00,90.0000,106.0000,16.2000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(212,213,212,212,6.0000,0.0000,29.0000,0.00,29.0000,35.0000,5.2200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(213,214,213,213,6.0000,0.0000,60.0000,0.00,60.0000,71.0000,10.8000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(214,215,214,214,6.0000,0.0000,38.0000,0.00,38.0000,45.0000,6.8400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(215,216,215,215,6.0000,0.0000,38.0000,0.00,38.0000,45.0000,6.8400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(216,217,216,216,6.0000,0.0000,92.0000,0.00,92.0000,109.0000,16.5600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(217,218,217,217,6.0000,0.0000,85.0000,0.00,85.0000,100.0000,15.3000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-02 13:06:45'),(218,219,218,218,6.0000,0.0000,48.0000,0.00,48.0000,57.0000,8.6400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(219,220,219,219,6.0000,0.0000,87.0000,0.00,87.0000,103.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(220,221,220,220,6.0000,0.0000,52.0000,0.00,52.0000,62.0000,9.3600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(221,222,221,221,6.0000,0.0000,94.0000,0.00,94.0000,111.0000,16.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(222,223,222,222,6.0000,0.0000,41.0000,0.00,41.0000,48.0000,7.3800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(223,224,223,223,6.0000,0.0000,41.0000,0.00,41.0000,48.0000,7.3800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(224,225,224,224,6.0000,0.0000,78.0000,0.00,78.0000,92.0000,14.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(225,226,225,225,6.0000,0.0000,78.0000,0.00,78.0000,92.0000,14.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(226,227,226,226,22.0000,0.0000,15.0000,0.00,15.0000,18.0000,2.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(227,228,227,227,32.0000,0.0000,11.0000,0.00,11.0000,13.0000,1.9800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(228,229,228,228,24.0000,0.0000,21.0000,0.00,21.0000,25.0000,3.7800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(229,230,229,229,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 12:36:29','2025-02-02 13:04:47'),(230,231,230,230,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 12:37:32','2025-02-03 03:03:20'),(231,232,231,231,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:29:49','2025-02-02 15:44:20'),(232,233,232,232,16.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:31:48','2025-02-02 07:11:54'),(233,234,233,233,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:35:15','2025-02-02 13:04:47'),(234,235,234,234,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:36:25','2025-02-02 08:34:37'),(235,236,235,235,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:37:49','2025-02-03 08:45:53'),(236,237,236,236,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:43:42','2025-02-03 10:20:16'),(237,238,237,237,31.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,21.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:44:17','2025-02-03 03:03:20'),(238,239,238,238,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:44:48','2025-02-03 10:20:16'),(239,240,239,239,39.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:50:07','2025-02-02 15:44:20'),(240,241,240,240,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:50:31','2025-02-02 04:12:57'),(241,242,241,241,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:50:53','2025-02-03 11:00:39'),(242,243,242,242,16.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:53:45','2025-02-02 06:58:55'),(243,244,243,243,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:54:10','2025-02-03 11:00:39'),(244,245,244,244,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:57:36','2025-02-02 08:34:37'),(245,246,245,245,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:57:59','2025-02-02 13:30:42'),(246,247,246,246,9.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 14:58:34','2025-02-02 13:14:21'),(247,248,247,247,29.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 15:04:31','2025-02-03 10:57:02'),(248,249,248,248,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 15:05:09','2025-02-02 06:40:08'),(249,250,249,249,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 15:05:31','2025-02-02 04:33:27'),(250,251,250,250,19.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 15:08:41','2025-02-02 04:45:27'),(251,252,251,251,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 15:09:07','2025-02-02 07:11:54'),(252,253,252,252,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 15:09:33','2025-02-03 03:08:44'),(253,254,253,253,110.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,21.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 16:43:35','2025-02-03 08:49:53'),(254,255,254,254,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 16:45:56','2025-02-02 12:51:47'),(255,256,255,255,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 16:46:54','2025-02-03 03:56:54'),(256,257,256,256,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:07:40','2025-02-02 05:36:33'),(257,258,257,257,24.0000,0.0000,35.0000,0.00,35.0000,41.0000,6.3000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:56','2025-02-02 07:21:13'),(258,259,258,258,6.0000,0.0000,46.0000,0.00,46.0000,54.0000,8.2800,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:56','2025-02-02 07:50:10'),(259,260,259,259,6.0000,0.0000,46.0000,0.00,46.0000,54.0000,8.2800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:56','2025-02-03 05:56:11'),(260,261,260,260,24.0000,0.0000,36.0000,0.00,36.0000,43.0000,6.4800,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:56','2025-02-03 12:14:20'),(261,262,261,261,12.0000,0.0000,36.0000,0.00,36.0000,43.0000,6.4800,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:56','2025-02-02 13:54:56'),(262,263,262,262,12.0000,0.0000,34.0000,0.00,34.0000,40.0000,6.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(263,264,263,263,12.0000,0.0000,34.0000,0.00,34.0000,40.0000,6.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(264,265,264,264,24.0000,0.0000,83.0000,0.00,83.0000,98.0000,14.9400,11,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-03 08:45:53'),(265,266,265,265,6.0000,0.0000,86.0000,0.00,86.0000,102.0000,15.4800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-02 05:44:33'),(266,267,266,266,6.0000,0.0000,86.0000,0.00,86.0000,102.0000,15.4800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-02 03:36:32'),(267,268,267,267,12.0000,0.0000,92.0000,0.00,92.0000,109.0000,16.5600,11,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-02 14:22:04'),(268,269,268,268,6.0000,0.0000,92.0000,0.00,92.0000,109.0000,16.5600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-02 05:00:24'),(269,270,269,269,6.0000,0.0000,87.0000,0.00,87.0000,103.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(270,271,270,270,6.0000,0.0000,87.0000,0.00,87.0000,103.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(271,272,271,271,6.0000,0.0000,87.0000,0.00,87.0000,103.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(272,273,272,272,6.0000,0.0000,87.0000,0.00,87.0000,103.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(273,274,273,273,6.0000,0.0000,87.0000,0.00,87.0000,103.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(274,275,274,274,6.0000,0.0000,146.0000,0.00,146.0000,173.0000,26.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-01 17:11:57'),(275,276,275,275,6.0000,0.0000,176.0000,0.00,176.0000,208.0000,31.6800,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:11:57','2025-02-02 06:05:24'),(276,277,276,276,12.0000,0.0000,32.0000,0.00,32.0000,38.0000,5.7600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-02 13:32:10'),(277,278,277,277,12.0000,0.0000,32.0000,0.00,32.0000,38.0000,5.7600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-02 13:14:11'),(278,279,278,278,12.0000,0.0000,54.0000,0.00,54.0000,63.0000,9.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(279,280,279,279,12.0000,0.0000,54.0000,0.00,54.0000,63.0000,9.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(280,281,280,280,6.0000,0.0000,134.0000,0.00,134.0000,158.0000,24.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(281,282,281,281,6.0000,0.0000,134.0000,0.00,134.0000,158.0000,24.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(282,283,282,282,3.0000,0.0000,161.0000,0.00,161.0000,190.0000,28.9800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(283,284,283,283,3.0000,0.0000,161.0000,0.00,161.0000,190.0000,28.9800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(284,285,284,284,12.0000,0.0000,59.0000,0.00,59.0000,70.0000,10.6200,11,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-02 11:55:48'),(285,286,285,285,12.0000,0.0000,30.0000,0.00,30.0000,35.0000,5.4000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-02 04:54:24'),(286,287,286,286,6.0000,0.0000,114.0000,0.00,114.0000,135.0000,20.5200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-02 03:29:46'),(287,288,287,287,6.0000,0.0000,191.0000,0.00,191.0000,225.0000,34.3800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(288,289,288,288,12.0000,0.0000,44.0000,0.00,44.0000,52.0000,7.9200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-02 13:47:31'),(289,290,289,289,12.0000,0.0000,81.0000,0.00,81.0000,96.0000,14.5800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(290,291,290,290,6.0000,0.0000,63.0000,0.00,63.0000,74.0000,11.3400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(291,292,291,291,6.0000,0.0000,132.0000,0.00,132.0000,156.0000,23.7600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(292,293,292,292,12.0000,0.0000,23.0000,0.00,23.0000,27.0000,4.1400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-02 08:34:37'),(293,294,293,293,6.0000,0.0000,68.0000,0.00,68.0000,81.0000,12.2400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:07','2025-02-01 17:15:07'),(294,295,294,294,3.0000,0.0000,30.0000,0.00,30.0000,35.0000,5.4000,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:08','2025-02-02 14:22:04'),(295,296,295,295,3.0000,0.0000,56.0000,0.00,56.0000,66.0000,10.0800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(296,297,296,296,3.0000,0.0000,86.0000,0.00,86.0000,102.0000,15.4800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:08','2025-02-01 17:15:08'),(297,298,297,297,3.0000,0.0000,74.0000,0.00,74.0000,88.0000,13.3200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:08','2025-02-02 13:06:45'),(298,299,298,298,3.0000,0.0000,74.0000,0.00,74.0000,88.0000,13.3200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:08','2025-02-02 04:31:06'),(299,300,299,299,3.0000,0.0000,74.0000,0.00,74.0000,88.0000,13.3200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:08','2025-02-02 09:19:28'),(300,301,300,300,6.0000,0.0000,26.0000,0.00,26.0000,31.0000,4.6800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:15:08','2025-02-02 03:55:23'),(301,302,301,301,30.0000,0.0000,30.0000,0.00,30.0000,36.0000,5.4000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-02 09:58:02'),(302,303,302,302,15.0000,0.0000,30.0000,0.00,30.0000,36.0000,5.4000,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-02 08:34:37'),(303,304,303,303,15.0000,0.0000,30.0000,0.00,30.0000,36.0000,5.4000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(304,305,304,304,15.0000,0.0000,30.0000,0.00,30.0000,36.0000,5.4000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-02 05:44:33'),(305,306,305,305,15.0000,0.0000,34.0000,0.00,34.0000,40.0000,6.1200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-02 07:04:48'),(306,307,306,306,65.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(307,308,307,307,60.0000,0.0000,14.0000,0.00,14.0000,16.0000,2.5200,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-02 07:04:48'),(308,309,308,308,3.0000,0.0000,95.0000,0.00,95.0000,112.0000,17.1000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(309,310,309,309,3.0000,0.0000,50.0000,0.00,50.0000,59.0000,9.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(310,311,310,310,12.0000,0.0000,34.0000,0.00,34.0000,36.0000,1.7000,4,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-03 03:56:54'),(311,312,311,311,6.0000,0.0000,60.0000,0.00,60.0000,64.0000,3.0000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-02 09:27:06'),(312,313,312,312,6.0000,0.0000,87.0000,0.00,87.0000,91.0000,4.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(313,314,313,313,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(314,315,314,314,6.0000,0.0000,158.0000,0.00,158.0000,166.0000,7.9000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-02 03:08:32'),(315,316,315,315,12.0000,0.0000,17.0000,0.00,17.0000,18.0000,0.8500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(316,317,316,316,6.0000,0.0000,15.0000,0.00,15.0000,18.0000,2.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(317,318,317,317,6.0000,0.0000,32.0000,0.00,32.0000,38.0000,5.7600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(318,319,318,318,6.0000,0.0000,67.0000,0.00,67.0000,80.0000,12.0600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(319,320,319,319,6.0000,0.0000,29.0000,0.00,29.0000,34.0000,5.2200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(320,321,320,320,6.0000,0.0000,61.0000,0.00,61.0000,72.0000,10.9800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(321,322,321,321,6.0000,0.0000,117.0000,0.00,117.0000,139.0000,21.0600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(322,323,322,322,3.0000,0.0000,207.0000,0.00,207.0000,217.0000,10.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(323,324,323,323,3.0000,0.0000,84.0000,0.00,84.0000,89.0000,4.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(324,325,324,324,24.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(325,326,325,325,6.0000,0.0000,30.0000,0.00,30.0000,35.0000,5.4000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-02 03:28:22'),(326,327,326,326,6.0000,0.0000,66.0000,0.00,66.0000,78.0000,11.8800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-01 17:19:07'),(327,328,327,327,24.0000,0.0000,8.0000,0.00,8.0000,9.0000,0.9600,8,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:07','2025-02-02 11:01:13'),(328,329,328,328,6.0000,0.0000,33.0000,0.00,33.0000,37.0000,3.9600,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:08','2025-02-02 14:16:09'),(329,330,329,329,6.0000,0.0000,36.0000,0.00,36.0000,40.0000,4.3200,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(330,331,330,330,6.0000,0.0000,68.0000,0.00,68.0000,76.0000,8.1600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(331,332,331,331,6.0000,0.0000,36.0000,0.00,36.0000,40.0000,4.3200,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(332,333,332,332,6.0000,0.0000,40.0000,0.00,40.0000,44.0000,4.8000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:19:08','2025-02-01 17:19:08'),(333,334,333,333,10.0000,0.0000,7.0000,0.00,7.0000,8.0000,0.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(334,335,334,334,10.0000,0.0000,7.0000,0.00,7.0000,8.0000,0.3500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-02 13:41:49'),(335,336,335,335,10.0000,0.0000,7.0000,0.00,7.0000,8.0000,0.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(336,337,336,336,10.0000,0.0000,7.0000,0.00,7.0000,8.0000,0.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(337,338,337,337,12.0000,0.0000,19.0000,0.00,19.0000,20.0000,0.9500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(338,339,338,338,12.0000,0.0000,19.0000,0.00,19.0000,20.0000,0.9500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(339,340,339,339,12.0000,0.0000,19.0000,0.00,19.0000,20.0000,0.9500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(340,341,340,340,6.0000,0.0000,67.0000,0.00,67.0000,70.0000,3.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(341,342,341,341,6.0000,0.0000,69.0000,0.00,69.0000,73.0000,3.4500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-02 14:37:37'),(342,343,342,342,6.0000,0.0000,67.0000,0.00,67.0000,70.0000,3.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(343,344,343,343,3.0000,0.0000,80.0000,0.00,80.0000,84.0000,4.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(344,345,344,344,3.0000,0.0000,80.0000,0.00,80.0000,84.0000,4.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(345,346,345,345,3.0000,0.0000,83.0000,0.00,83.0000,87.0000,4.1500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(346,347,346,346,6.0000,0.0000,59.0000,0.00,59.0000,61.0000,2.9500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-02 09:24:54'),(347,348,347,347,6.0000,0.0000,98.0000,0.00,98.0000,103.0000,4.9000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-02 08:34:37'),(348,349,348,348,6.0000,0.0000,99.0000,0.00,99.0000,104.0000,4.9500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(349,350,349,349,6.0000,0.0000,67.0000,0.00,67.0000,70.0000,3.3500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-02 11:01:13'),(350,351,350,350,6.0000,0.0000,136.0000,0.00,136.0000,143.0000,6.8000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(351,352,351,351,24.0000,0.0000,12.0000,0.00,12.0000,13.0000,0.6000,4,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-02 13:14:11'),(352,353,352,352,24.0000,0.0000,30.0000,0.00,30.0000,31.0000,1.5000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(353,354,353,353,12.0000,0.0000,62.0000,0.00,62.0000,65.0000,3.1000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(354,355,354,354,6.0000,0.0000,111.0000,0.00,111.0000,116.0000,5.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(355,356,355,355,3.0000,0.0000,124.0000,0.00,124.0000,130.0000,6.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(356,357,356,356,3.0000,0.0000,222.0000,0.00,222.0000,233.0000,11.1000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(357,358,357,357,6.0000,0.0000,40.0000,0.00,40.0000,42.0000,2.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:29:26','2025-02-01 17:29:26'),(358,359,358,358,10.0000,0.0000,138.0000,0.00,138.0000,138.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:37:53','2025-02-02 15:36:05'),(359,360,359,359,20.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:37:53','2025-02-02 12:24:07'),(360,361,360,360,2.0000,0.0000,680.0000,0.00,680.0000,680.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:37:53','2025-02-02 14:51:16'),(361,362,361,361,10.0000,0.0000,168.0000,0.00,168.0000,168.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:37:53','2025-02-02 03:57:25'),(362,363,362,362,20.0000,0.0000,85.0000,0.00,85.0000,85.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:37:53','2025-02-02 05:10:41'),(363,364,363,363,2.0000,0.0000,920.0000,0.00,920.0000,920.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(364,365,364,364,10.0000,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(365,366,365,365,20.0000,0.0000,92.0000,0.00,92.0000,92.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:37:53','2025-02-01 17:37:53'),(366,367,366,366,25.0000,0.0000,40.0000,0.00,40.0000,40.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:37:53','2025-02-02 07:11:54'),(367,368,367,367,10.0000,0.0000,31.0000,0.00,31.0000,33.0000,1.5500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-02 14:22:04'),(368,369,368,368,10.0000,0.0000,18.0000,0.00,18.0000,18.9000,0.9000,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 03:50:24'),(369,370,369,369,10.0000,0.0000,19.0000,0.00,19.0000,19.9500,0.9500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:27:59'),(370,371,370,370,10.0000,0.0000,18.0000,0.00,18.0000,18.9000,0.9000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:28:20'),(371,372,371,371,10.0000,0.0000,19.0000,0.00,19.0000,19.9500,0.9500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:28:50'),(372,373,372,372,10.0000,0.0000,18.0000,0.00,18.0000,18.9000,0.9000,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:31:30'),(373,374,373,373,10.0000,0.0000,21.0000,0.00,21.0000,22.0500,1.0500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:22:00'),(374,375,374,374,10.0000,0.0000,20.0000,0.00,20.0000,21.0000,1.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:30:42'),(375,376,375,375,10.0000,0.0000,21.0000,0.00,21.0000,22.0500,1.0500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:30:17'),(376,377,376,376,10.0000,0.0000,24.0000,0.00,24.0000,25.2000,1.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:29:42'),(377,378,377,377,10.0000,0.0000,23.0000,0.00,23.0000,25.7600,2.7600,8,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 04:14:55'),(378,379,378,378,10.0000,0.0000,17.0000,0.00,17.0000,19.0400,2.0400,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:29:22'),(379,380,379,379,10.0000,0.0000,33.0000,0.00,33.0000,36.9600,3.9600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:26:08'),(380,381,380,380,5.0000,0.0000,69.0000,0.00,69.0000,72.0000,3.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-01 17:42:21'),(381,382,381,381,25.0000,0.0000,35.0000,0.00,35.0000,36.7500,1.7500,4,NULL,15.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 03:27:57'),(382,383,382,382,10.0000,0.0000,15.0000,0.00,15.0000,15.7500,0.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 03:30:55'),(383,384,383,383,5.0000,0.0000,62.0000,0.00,62.0000,65.1000,3.1000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 04:14:04'),(384,385,384,384,10.0000,0.0000,31.0000,0.00,31.0000,32.5500,1.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 03:51:36'),(385,386,385,385,10.0000,0.0000,13.0000,0.00,13.0000,13.6500,0.6500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 03:52:13'),(386,387,386,386,10.0000,0.0000,26.0000,0.00,26.0000,27.3000,1.3000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 03:49:56'),(387,388,387,387,10.0000,0.0000,64.0000,0.00,64.0000,67.0000,3.2000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-02 06:05:24'),(388,389,388,388,3.0000,0.0000,44.0000,0.00,44.0000,46.2000,2.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:42:21','2025-02-03 02:27:27'),(389,390,389,389,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(390,391,390,390,24.0000,0.0000,31.0000,0.00,31.0000,36.0000,5.5800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-02 03:23:29'),(391,392,391,391,12.0000,0.0000,30.0000,0.00,30.0000,35.0000,5.4000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-02 13:47:31'),(392,393,392,392,3.0000,0.0000,189.0000,0.00,189.0000,223.0000,34.0200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(393,394,393,393,24.0000,0.0000,26.0000,0.00,26.0000,31.0000,4.6800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(394,395,394,394,24.0000,0.0000,40.0000,0.00,40.0000,47.0000,7.2000,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-02 02:50:42'),(395,396,395,395,3.0000,0.0000,81.0000,0.00,81.0000,95.0000,14.5800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-03 11:00:22'),(396,397,396,396,3.0000,0.0000,120.0000,0.00,120.0000,142.0000,21.6000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(397,398,397,397,13.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(398,399,398,398,6.0000,0.0000,51.0000,0.00,51.0000,60.0000,9.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(399,400,399,399,3.0000,0.0000,99.0000,0.00,99.0000,117.0000,17.8200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(400,401,400,400,10.0000,0.0000,19.0000,0.00,19.0000,22.0000,3.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(401,402,401,401,40.0000,0.0000,3.0000,0.00,3.0000,4.0000,0.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(402,403,402,402,40.0000,0.0000,2.0000,0.00,2.0000,2.0000,0.3600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(403,404,403,403,40.0000,0.0000,2.0000,0.00,2.0000,2.0000,0.3600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(404,405,404,404,40.0000,0.0000,3.0000,0.00,3.0000,4.0000,0.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(405,406,405,405,40.0000,0.0000,3.0000,0.00,3.0000,4.0000,0.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(406,407,406,406,6.0000,0.0000,78.0000,0.00,78.0000,92.0000,14.0400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-02 09:05:42'),(407,408,407,407,6.0000,0.0000,78.0000,0.00,78.0000,92.0000,14.0400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-02 09:27:06'),(408,409,408,408,6.0000,0.0000,78.0000,0.00,78.0000,92.0000,14.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(409,410,409,409,6.0000,0.0000,78.0000,0.00,78.0000,92.0000,14.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(410,411,410,410,3.0000,0.0000,184.0000,0.00,184.0000,218.0000,33.1200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-02 03:19:56'),(411,412,411,411,3.0000,0.0000,184.0000,0.00,184.0000,218.0000,33.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(412,413,412,412,3.0000,0.0000,184.0000,0.00,184.0000,218.0000,33.1200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-02 03:47:22'),(413,414,413,413,3.0000,0.0000,184.0000,0.00,184.0000,218.0000,33.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(414,415,414,414,3.0000,0.0000,94.0000,0.00,94.0000,111.0000,16.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(415,416,415,415,3.0000,0.0000,94.0000,0.00,94.0000,111.0000,16.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(416,417,416,416,1.0000,0.0000,156.0000,0.00,156.0000,184.0000,28.0800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(417,418,417,417,1.0000,0.0000,145.0000,0.00,145.0000,171.0000,26.1000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(418,419,418,418,12.0000,0.0000,6.0000,0.00,6.0000,6.0000,1.0800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(419,420,419,419,12.0000,0.0000,6.0000,0.00,6.0000,8.0000,1.0800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(420,421,420,420,1.0000,0.0000,84.0000,0.00,84.0000,99.0000,15.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(421,422,421,421,1.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-02 11:55:48'),(422,423,422,422,1.0000,0.0000,134.0000,0.00,134.0000,158.0000,24.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(423,424,423,423,1.0000,0.0000,155.0000,0.00,155.0000,183.0000,27.9000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:52:49','2025-02-01 17:52:49'),(424,425,424,424,15.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-03 06:58:02'),(425,426,425,425,15.0000,0.0000,12.0000,0.00,12.0000,13.0000,0.6000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(426,427,426,426,15.0000,0.0000,36.0000,0.00,36.0000,38.0000,1.8000,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 14:56:17'),(427,428,427,427,8.0000,0.0000,65.0000,0.00,65.0000,68.0000,3.2500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 04:48:16'),(428,429,428,428,6.0000,0.0000,92.0000,0.00,92.0000,97.0000,4.6000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(429,430,429,429,6.0000,0.0000,171.0000,0.00,171.0000,180.0000,8.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(430,431,430,430,6.0000,0.0000,150.0000,0.00,150.0000,158.0000,7.5000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(431,432,431,431,10.0000,0.0000,121.0000,0.00,121.0000,127.0000,6.0500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(432,433,432,432,20.0000,0.0000,61.0000,0.00,61.0000,64.0000,3.0500,4,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 15:44:20'),(433,434,433,433,10.0000,0.0000,17.0000,0.00,17.0000,17.0000,0.8500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 09:19:28'),(434,435,434,434,96.0000,0.0000,38.0000,0.00,38.0000,44.0000,6.8400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 04:33:27'),(435,436,435,435,24.0000,0.0000,23.0000,0.00,23.0000,27.0000,4.1400,11,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 13:43:12'),(436,437,436,436,24.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 14:16:09'),(437,438,437,437,16.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 07:05:42'),(438,439,438,438,75.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(439,440,439,439,25.0000,0.0000,13.0000,0.00,13.0000,15.0000,1.5600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(440,441,440,440,20.0000,0.0000,37.0000,0.00,37.0000,41.0000,4.4400,8,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 15:44:20'),(441,442,441,441,10.0000,0.0000,70.0000,0.00,70.0000,78.0000,8.4000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(442,443,442,442,5.0000,0.0000,135.0000,0.00,135.0000,151.0000,16.2000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(443,444,443,443,2.0000,0.0000,326.0000,0.00,326.0000,365.0000,39.1200,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(444,445,444,444,1.0000,0.0000,636.0000,0.00,636.0000,712.0000,76.3200,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(445,446,445,445,6.0000,0.0000,76.0000,0.00,76.0000,90.0000,13.6800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(446,447,446,446,3.0000,0.0000,109.0000,0.00,109.0000,129.0000,19.6200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-03 04:49:47'),(447,448,447,447,3.0000,0.0000,115.0000,0.00,115.0000,136.0000,20.7000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-02 12:22:42'),(448,449,448,448,3.0000,0.0000,77.0000,0.00,77.0000,91.0000,13.8600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 17:56:23','2025-02-01 17:56:23'),(449,450,449,449,4.0000,0.0000,64.0000,0.00,64.0000,76.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(450,451,450,450,4.0000,0.0000,64.0000,0.00,64.0000,76.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(451,452,451,451,4.0000,0.0000,64.0000,0.00,64.0000,76.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(452,453,452,452,6.0000,0.0000,49.0000,0.00,49.0000,58.0000,8.8200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(453,454,453,453,6.0000,0.0000,49.0000,0.00,49.0000,58.0000,8.8200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 07:50:10'),(454,455,454,454,6.0000,0.0000,49.0000,0.00,49.0000,58.0000,8.8200,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 04:31:06'),(455,456,455,455,6.0000,0.0000,49.0000,0.00,49.0000,58.0000,8.8200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(456,457,456,456,6.0000,0.0000,49.0000,0.00,49.0000,58.0000,8.8200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(457,458,457,457,6.0000,0.0000,49.0000,0.00,49.0000,58.0000,8.8200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 07:23:03'),(458,459,458,458,3.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(459,460,459,459,3.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(460,461,460,460,3.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(461,462,461,461,3.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(462,463,462,462,3.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(463,464,463,463,3.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(464,465,464,464,3.0000,0.0000,124.0000,0.00,124.0000,147.0000,22.3200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-03 10:20:16'),(465,466,465,465,12.0000,0.0000,39.0000,0.00,39.0000,46.0000,7.0200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(466,467,466,466,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 06:40:08'),(467,468,467,467,3.0000,0.0000,117.0000,0.00,117.0000,137.0000,21.0600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(468,469,468,468,12.0000,0.0000,39.0000,0.00,39.0000,46.0000,7.0200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(469,470,469,469,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 09:05:42'),(470,471,470,470,12.0000,0.0000,34.0000,0.00,34.0000,40.0000,6.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(471,472,471,471,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 04:51:21'),(472,473,472,472,3.0000,0.0000,89.0000,0.00,89.0000,105.0000,16.0200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(473,474,473,473,6.0000,0.0000,154.0000,0.00,154.0000,181.0000,27.7200,11,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-03 05:19:06'),(474,475,474,474,24.0000,0.0000,39.0000,0.00,39.0000,47.0000,7.0200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 06:44:12'),(475,476,475,475,24.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(476,477,476,476,24.0000,0.0000,31.0000,0.00,31.0000,37.0000,5.5800,11,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 14:56:17'),(477,478,477,477,24.0000,0.0000,60.0000,0.00,60.0000,70.0000,10.8000,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 06:58:55'),(478,479,478,478,3.0000,0.0000,20.0000,0.00,20.0000,24.0000,3.6000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(479,480,479,479,2.0000,0.0000,64.0000,0.00,64.0000,75.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(480,481,480,480,2.0000,0.0000,64.0000,0.00,64.0000,75.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(481,482,481,481,20.0000,0.0000,11.0000,0.00,11.0000,12.0000,1.9800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(482,483,482,482,10.0000,0.0000,28.0000,0.00,28.0000,33.0000,5.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(483,484,483,483,6.0000,0.0000,108.0000,0.00,108.0000,128.0000,19.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(484,485,484,484,15.0000,0.0000,64.0000,0.00,64.0000,76.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(485,486,485,485,36.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(486,487,486,486,12.0000,0.0000,29.0000,0.00,29.0000,34.0000,5.2200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(487,488,487,487,12.0000,0.0000,31.0000,0.00,31.0000,36.0000,5.5800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(488,489,488,488,12.0000,0.0000,31.0000,0.00,31.0000,36.0000,5.5800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(489,490,489,489,12.0000,0.0000,79.0000,0.00,79.0000,94.0000,14.2200,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 03:55:23'),(490,491,490,490,30.0000,0.0000,65.0000,0.00,65.0000,76.0000,11.7000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 03:36:32'),(491,492,491,491,15.0000,0.0000,76.0000,0.00,76.0000,90.0000,13.6800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(492,493,492,492,6.0000,0.0000,126.0000,0.00,126.0000,149.0000,22.6800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-02 04:54:24'),(493,494,493,493,6.0000,0.0000,125.0000,0.00,125.0000,147.0000,22.5000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(494,495,494,494,12.0000,0.0000,73.0000,0.00,73.0000,86.0000,13.1400,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-03 03:45:10'),(495,496,495,495,6.0000,0.0000,159.0000,0.00,159.0000,188.0000,28.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(496,497,496,496,72.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(497,498,497,497,10.0000,0.0000,10.0000,0.00,10.0000,12.0000,1.8000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(498,499,498,498,12.0000,0.0000,19.0000,0.00,19.0000,23.0000,3.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(499,500,499,499,3.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(500,501,500,500,24.0000,0.0000,9.0000,0.00,9.0000,11.0000,1.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(501,502,501,501,6.0000,0.0000,58.0000,0.00,58.0000,68.0000,10.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(502,503,502,502,3.0000,0.0000,81.0000,0.00,81.0000,95.0000,14.5800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(503,504,503,503,2.0000,0.0000,162.0000,0.00,162.0000,191.0000,29.1600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(504,505,504,504,1.0000,0.0000,162.0000,0.00,162.0000,191.0000,29.1600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(505,506,505,505,6.0000,0.0000,65.0000,0.00,65.0000,77.0000,11.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(506,507,506,506,3.0000,0.0000,92.0000,0.00,92.0000,109.0000,16.5600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(507,508,507,507,3.0000,0.0000,162.0000,0.00,162.0000,191.0000,29.1600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(508,509,508,508,3.0000,0.0000,108.0000,0.00,108.0000,127.0000,19.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(509,510,509,509,10.0000,0.0000,25.0000,0.00,25.0000,30.0000,4.5000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(510,511,510,510,10.0000,0.0000,51.0000,0.00,51.0000,60.0000,9.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(511,512,511,511,12.0000,0.0000,18.0000,0.00,18.0000,22.0000,3.2400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(512,513,512,512,3.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(513,514,513,513,3.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(514,515,514,514,3.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(515,516,515,515,3.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(516,517,516,516,2.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(517,518,517,517,4.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(518,519,518,518,3.0000,0.0000,51.0000,0.00,51.0000,61.0000,9.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(519,520,519,519,3.0000,0.0000,51.0000,0.00,51.0000,61.0000,9.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(520,521,520,520,2.0000,0.0000,93.0000,0.00,93.0000,110.0000,16.7400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(521,522,521,521,2.0000,0.0000,93.0000,0.00,93.0000,110.0000,16.7400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(522,523,522,522,3.0000,0.0000,113.0000,0.00,113.0000,134.0000,20.3400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:01:42','2025-02-01 18:01:42'),(523,524,523,523,10.0000,0.0000,1870.0000,0.00,1870.0000,1870.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(524,525,524,524,10.0000,0.0000,1570.0000,0.00,1570.0000,1570.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(525,526,525,525,5.0000,0.0000,1620.0000,0.00,1620.0000,1620.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(526,527,526,526,10.0000,0.0000,1420.0000,0.00,1420.0000,1420.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(527,528,527,527,5.0000,0.0000,1830.0000,0.00,1830.0000,1830.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(528,529,528,528,5.0000,0.0000,1840.0000,0.00,1840.0000,1840.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(529,530,529,529,10.0000,0.0000,1530.0000,0.00,1530.0000,1530.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 08:27:13'),(530,531,530,530,5.0000,0.0000,1380.0000,0.00,1380.0000,1380.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(531,532,531,531,10.0000,0.0000,1570.0000,0.00,1570.0000,1570.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(532,533,532,532,5.0000,0.0000,1790.0000,0.00,1790.0000,1790.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(533,534,533,533,3.0000,0.0000,1780.0000,0.00,1780.0000,1780.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(534,535,534,534,5.0000,0.0000,1720.0000,0.00,1720.0000,1720.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(535,536,535,535,10.0000,0.0000,1600.0000,0.00,1600.0000,1600.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(536,537,536,536,5.0000,0.0000,1770.0000,0.00,1770.0000,1770.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(537,538,537,537,5.0000,0.0000,1750.0000,0.00,1750.0000,1750.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(538,539,538,538,5.0000,0.0000,1630.0000,0.00,1630.0000,1630.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(539,540,539,539,5.0000,0.0000,1150.0000,0.00,1150.0000,1150.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 13:43:47'),(540,541,540,540,5.0000,0.0000,1070.0000,0.00,1070.0000,1070.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(541,542,541,541,8.0000,0.0000,1120.0000,0.00,1120.0000,1120.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(542,543,542,542,5.0000,0.0000,1170.0000,0.00,1170.0000,1170.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(543,544,543,543,2.0000,0.0000,1700.0000,0.00,1700.0000,1700.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(544,545,544,544,2.0000,0.0000,900.0000,0.00,900.0000,900.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(545,546,545,545,5.0000,0.0000,1610.0000,0.00,1610.0000,1610.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(546,547,546,546,1.0000,0.0000,1800.0000,0.00,1800.0000,1800.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(547,548,547,547,5.0000,0.0000,790.0000,0.00,790.0000,790.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(548,549,548,548,10.0000,0.0000,640.0000,0.00,640.0000,640.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(549,550,549,549,10.0000,0.0000,330.0000,0.00,330.0000,330.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(550,551,550,550,10.0000,0.0000,340.0000,0.00,340.0000,340.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(551,552,551,551,5.0000,0.0000,670.0000,0.00,670.0000,670.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(552,553,552,552,10.0000,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(553,554,553,553,5.0000,0.0000,730.0000,0.00,730.0000,730.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(554,555,554,554,10.0000,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 13:54:07'),(555,556,555,555,5.0000,0.0000,585.0000,0.00,585.0000,585.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 12:22:42'),(556,557,556,556,10.0000,0.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 13:05:11'),(557,558,557,557,5.0000,0.0000,480.0000,0.00,480.0000,480.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(558,559,558,558,5.0000,0.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(559,560,559,559,10.0000,0.0000,110.0000,0.00,110.0000,110.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 04:21:43'),(560,561,560,560,1.0000,0.0000,2450.0000,0.00,2450.0000,2450.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(561,562,561,561,6.0000,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 04:33:27'),(562,563,562,562,6.0000,0.0000,160.0000,0.00,160.0000,160.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 06:27:54'),(563,564,563,563,10.0000,0.0000,90.0000,0.00,90.0000,90.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 08:34:37'),(564,565,564,564,10.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 14:37:37'),(565,566,565,565,10.0000,0.0000,200.0000,0.00,200.0000,200.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(566,567,566,566,5.0000,0.0000,85.0000,0.00,85.0000,85.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(567,568,567,567,5.0000,0.0000,73.0000,0.00,73.0000,73.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(568,569,568,568,5.0000,0.0000,85.0000,0.00,85.0000,85.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(569,570,569,569,5.0000,0.0000,90.0000,0.00,90.0000,90.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(570,571,570,570,5.0000,0.0000,90.0000,0.00,90.0000,90.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(571,572,571,571,5.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(572,573,572,572,5.0000,0.0000,55.0000,0.00,55.0000,55.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(573,574,573,573,10.0000,0.0000,1805.0000,0.00,1805.0000,1805.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-03 10:28:34'),(574,575,574,574,10.0000,0.0000,725.0000,0.00,725.0000,725.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 04:33:27'),(575,576,575,575,10.0000,0.0000,372.0000,0.00,372.0000,372.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-01 18:07:02'),(576,577,576,576,1.0000,0.0000,2440.0000,0.00,2440.0000,2440.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 07:25:30'),(577,578,577,577,5.0000,0.0000,1930.0000,0.00,1930.0000,1930.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:07:02','2025-02-02 04:31:06'),(578,579,578,578,3.0000,0.0000,31.0000,0.00,31.0000,35.0000,3.7200,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(579,580,579,579,14.0000,0.0000,13.0000,0.00,13.0000,15.0000,2.3400,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 04:44:12'),(580,581,580,580,14.0000,0.0000,12.0000,0.00,12.0000,15.0000,2.1600,11,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 13:01:15'),(581,582,581,581,12.0000,0.0000,15.0000,0.00,15.0000,18.0000,2.7000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-03 04:49:47'),(582,583,582,582,1.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(583,584,583,583,13.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 12:49:26'),(584,585,584,584,13.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 13:32:10'),(585,586,585,585,6.0000,0.0000,73.0000,0.00,73.0000,86.0000,13.1400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(586,587,586,586,3.0000,0.0000,159.0000,0.00,159.0000,187.0000,28.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(587,588,587,587,6.0000,0.0000,105.0000,0.00,105.0000,124.0000,18.9000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 03:09:21'),(588,589,588,588,12.0000,0.0000,55.0000,0.00,55.0000,64.0000,9.9000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(589,590,589,589,12.0000,0.0000,60.0000,0.00,60.0000,71.0000,10.8000,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 14:37:37'),(590,591,590,590,6.0000,0.0000,55.0000,0.00,55.0000,65.0000,9.9000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(591,592,591,591,12.0000,0.0000,23.0000,0.00,23.0000,27.0000,4.1400,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 12:33:45'),(592,593,592,592,12.0000,0.0000,58.0000,0.00,58.0000,68.0000,10.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(593,594,593,593,6.0000,0.0000,73.0000,0.00,73.0000,86.0000,13.1400,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 13:14:11'),(594,595,594,594,6.0000,0.0000,68.0000,0.00,68.0000,80.0000,12.2400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(595,596,595,595,6.0000,0.0000,115.0000,0.00,115.0000,135.0000,20.7000,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-03 07:55:38'),(596,597,596,596,3.0000,0.0000,166.0000,0.00,166.0000,196.0000,29.8800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-03 05:19:06'),(597,598,597,597,3.0000,0.0000,55.0000,0.00,55.0000,65.0000,9.9000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 11:28:15'),(598,599,598,598,1.0000,0.0000,113.0000,0.00,113.0000,133.0000,20.3400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(599,600,599,599,6.0000,0.0000,26.0000,0.00,26.0000,30.0000,4.6800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 08:34:37'),(600,601,600,600,6.0000,0.0000,44.0000,0.00,44.0000,52.0000,7.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(601,602,601,601,2.0000,0.0000,113.0000,0.00,113.0000,133.0000,20.3400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(602,603,602,602,1.0000,0.0000,245.0000,0.00,245.0000,289.0000,44.1000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-03 12:14:20'),(603,604,603,603,6.0000,0.0000,75.0000,0.00,75.0000,89.0000,13.5000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(604,605,604,604,3.0000,0.0000,79.0000,0.00,79.0000,93.0000,14.2200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-03 10:20:16'),(605,606,605,605,1.0000,0.0000,122.0000,0.00,122.0000,144.0000,21.9600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-02 06:30:50'),(606,607,606,606,3.0000,0.0000,97.0000,0.00,97.0000,114.0000,17.4600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(607,608,607,607,1.0000,0.0000,169.0000,0.00,169.0000,200.0000,30.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(608,609,608,608,2.0000,0.0000,108.0000,0.00,108.0000,127.0000,19.4400,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-03 05:56:11'),(609,610,609,609,3.0000,0.0000,85.0000,0.00,85.0000,100.0000,15.3000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:09:49','2025-02-01 18:09:49'),(610,611,610,610,3.0000,0.0000,85.0000,0.00,85.0000,85.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-03 03:52:50'),(611,612,611,611,24.0000,0.0000,3.0000,0.00,3.0000,3.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 11:01:13'),(612,613,612,612,24.0000,0.0000,3.0000,0.00,3.0000,3.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(613,614,613,613,6.0000,0.0000,167.0000,0.00,167.0000,167.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(614,615,614,614,6.0000,0.0000,88.0000,0.00,88.0000,88.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-03 10:20:16'),(615,616,615,615,10.0000,0.0000,41.0000,0.00,41.0000,41.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(616,617,616,616,11.0000,0.0000,143.0000,0.00,143.0000,143.0000,0.0000,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-03 05:56:11'),(617,618,617,617,20.0000,0.0000,72.0000,0.00,72.0000,72.0000,0.0000,NULL,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-03 11:00:39'),(618,619,618,618,12.0000,0.0000,47.0000,0.00,47.0000,47.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 06:52:44'),(619,620,619,619,12.0000,0.0000,55.0000,0.00,55.0000,55.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(620,621,620,620,12.0000,0.0000,32.0000,0.00,32.0000,32.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(621,622,621,621,12.0000,0.0000,35.0000,0.00,35.0000,35.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(622,623,622,622,6.0000,0.0000,41.0000,0.00,41.0000,41.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(623,624,623,623,6.0000,0.0000,41.0000,0.00,41.0000,41.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(624,625,624,624,6.0000,0.0000,41.0000,0.00,41.0000,41.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(625,626,625,625,24.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(626,627,626,626,2.0000,0.0000,164.0000,0.00,164.0000,164.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(627,628,627,627,2.0000,0.0000,145.0000,0.00,145.0000,145.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 13:06:45'),(628,629,628,628,2.0000,0.0000,95.0000,0.00,95.0000,95.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 04:44:12'),(629,630,629,629,2.0000,0.0000,118.0000,0.00,118.0000,118.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(630,631,630,630,10.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(631,632,631,631,10.0000,0.0000,28.0000,0.00,28.0000,28.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(632,633,632,632,3.0000,0.0000,90.0000,0.00,90.0000,90.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 13:49:54'),(633,634,633,633,3.0000,0.0000,161.0000,0.00,161.0000,161.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(634,635,634,634,3.0000,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 06:26:14'),(635,636,635,635,3.0000,0.0000,126.0000,0.00,126.0000,126.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 15:36:05'),(636,637,636,636,3.0000,0.0000,111.0000,0.00,111.0000,111.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 11:01:13'),(637,638,637,637,3.0000,0.0000,117.0000,0.00,117.0000,117.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 09:05:42'),(638,639,638,638,3.0000,0.0000,215.0000,0.00,215.0000,215.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 03:09:21'),(639,640,639,639,16.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 13:41:49'),(640,641,640,640,6.0000,0.0000,33.0000,0.00,33.0000,33.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(641,642,641,641,6.0000,0.0000,52.0000,0.00,52.0000,52.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 13:14:11'),(642,643,642,642,110.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(643,644,643,643,110.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.0000,NULL,NULL,100.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 07:16:22'),(644,645,644,644,110.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(645,646,645,645,110.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.0000,NULL,NULL,100.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 07:16:22'),(646,647,646,646,110.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-01 18:17:55'),(647,648,647,647,72.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,17.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 18:17:55','2025-02-02 14:16:09'),(648,649,648,648,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:03:20','2025-02-02 07:04:48'),(649,650,649,649,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:03:43','2025-02-02 15:44:20'),(650,651,650,650,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:04:03','2025-02-02 15:44:20'),(651,652,651,651,18.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:04:35','2025-02-02 13:14:21'),(652,653,652,652,22.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,15.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:05:00','2025-02-02 13:04:47'),(653,654,653,653,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:05:21','2025-02-03 03:03:20'),(654,655,654,654,144.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(655,656,655,655,90.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,13.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 13:54:56'),(656,657,656,656,24.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 09:19:28'),(657,658,657,657,3.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(658,659,658,658,3.0000,0.0000,27.0000,0.00,27.0000,27.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 05:32:25'),(659,660,659,659,18.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 07:23:03'),(660,661,660,660,12.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(661,662,661,661,20.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,13.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 15:44:20'),(662,663,662,662,12.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 12:39:49'),(663,664,663,663,6.0000,0.0000,35.0000,0.00,35.0000,35.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 12:33:45'),(664,665,664,664,6.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 12:39:49'),(665,666,665,665,6.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 05:00:24'),(666,667,666,666,6.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 08:34:37'),(667,668,667,667,12.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 13:14:11'),(668,669,668,668,6.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-03 12:14:20'),(669,670,669,669,6.0000,0.0000,18.0000,0.00,18.0000,18.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 12:25:07'),(670,671,670,670,6.0000,0.0000,18.0000,0.00,18.0000,18.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(671,672,671,671,6.0000,0.0000,18.0000,0.00,18.0000,18.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(672,673,672,672,72.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 06:08:35'),(673,674,673,673,72.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(674,675,674,674,45.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-03 06:03:45'),(675,676,675,675,45.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-03 05:56:11'),(676,677,676,676,36.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 11:28:15'),(677,678,677,677,36.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 15:34:53'),(678,679,678,678,36.0000,0.0000,23.0000,0.00,23.0000,23.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-03 08:45:53'),(679,680,679,679,24.0000,0.0000,23.0000,0.00,23.0000,23.0000,0.0000,NULL,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 06:58:55'),(680,681,680,680,6.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(681,682,681,681,6.0000,0.0000,73.0000,0.00,73.0000,73.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 13:54:56'),(682,683,682,682,14.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 06:40:08'),(683,684,683,683,14.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 11:07:58'),(684,685,684,684,6.0000,0.0000,27.0000,0.00,27.0000,27.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 06:19:26'),(685,686,685,685,168.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,24.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 13:54:07'),(686,687,686,686,72.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 14:56:17'),(687,688,687,687,6.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 13:49:54'),(688,689,688,688,12.0000,0.0000,18.0000,0.00,18.0000,18.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 14:16:09'),(689,690,689,689,3.0000,0.0000,32.0000,0.00,32.0000,32.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 07:45:53'),(690,691,690,690,210.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(691,692,691,691,120.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,13.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-03 08:45:53'),(692,693,692,692,120.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,21.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 13:32:10'),(693,694,693,693,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 15:34:53'),(694,695,694,694,11.0000,0.0000,820.0000,0.00,820.0000,820.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 15:34:53'),(695,696,695,695,60.0000,0.0000,18.0000,0.00,18.0000,18.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-03 10:52:05'),(696,697,696,696,3.0000,0.0000,27.0000,0.00,27.0000,27.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(697,698,697,697,12.0000,0.0000,32.0000,0.00,32.0000,32.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(698,699,698,698,12.0000,0.0000,32.0000,0.00,32.0000,32.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-03 12:14:20'),(699,700,699,699,3.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(700,701,700,700,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(701,702,701,701,12.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 04:45:23'),(702,703,702,702,24.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 12:33:45'),(703,704,703,703,64.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-03 03:56:54'),(704,705,704,704,12.0000,0.0000,32.0000,0.00,32.0000,32.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(705,706,705,705,12.0000,0.0000,32.0000,0.00,32.0000,32.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 05:08:15'),(706,707,706,706,36.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(707,708,707,707,36.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(708,709,708,708,36.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(709,710,709,709,36.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(710,711,710,710,48.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(711,712,711,711,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 06:52:21'),(712,713,712,712,12.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(713,714,713,713,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 09:27:06'),(714,715,714,714,6.0000,0.0000,26.0000,0.00,26.0000,26.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 15:36:05'),(715,716,715,715,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 10:17:30'),(716,717,716,716,6.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(717,718,717,717,24.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(718,719,718,718,15.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(719,720,719,719,15.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(720,721,720,720,15.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-01 19:15:26'),(721,722,721,721,15.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:26','2025-02-02 05:44:33'),(722,723,722,722,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:30','2025-02-02 04:23:43'),(723,724,723,723,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:30','2025-02-02 03:08:32'),(724,725,724,724,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(725,726,725,725,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(726,727,726,726,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:15:30','2025-02-01 19:15:30'),(727,728,727,727,500.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 11:01:15'),(728,729,728,728,0.0000,0.0000,11.0000,0.00,11.0000,11.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(729,730,729,729,40.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(730,731,730,730,40.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(731,732,731,731,20.0000,0.0000,38.0000,0.00,38.0000,38.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(732,733,732,732,20.0000,0.0000,19.0000,0.00,19.0000,19.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(733,734,733,733,20.0000,0.0000,31.0000,0.00,31.0000,31.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(734,735,734,734,20.0000,0.0000,16.0000,0.00,16.0000,16.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(735,736,735,735,20.0000,0.0000,16.0000,0.00,16.0000,16.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 12:06:07'),(736,737,736,736,20.0000,0.0000,16.0000,0.00,16.0000,16.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 03:49:18'),(737,738,737,737,20.0000,0.0000,28.0000,0.00,28.0000,28.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 13:14:11'),(738,739,738,738,20.0000,0.0000,14.0000,0.00,14.0000,14.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 15:44:20'),(739,740,739,739,10.0000,0.0000,38.0000,0.00,38.0000,38.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 13:14:11'),(740,741,740,740,20.0000,0.0000,19.0000,0.00,19.0000,19.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 11:55:48'),(741,742,741,741,20.0000,0.0000,23.0000,0.00,23.0000,23.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(742,743,742,742,10.0000,0.0000,46.0000,0.00,46.0000,46.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(743,744,743,743,20.0000,0.0000,17.0000,0.00,17.0000,17.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(744,745,744,744,20.0000,0.0000,20.0000,0.00,20.0000,20.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 08:34:37'),(745,746,745,745,20.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(746,747,746,746,20.0000,0.0000,23.0000,0.00,23.0000,23.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 03:23:29'),(747,748,747,747,10.0000,0.0000,26.0000,0.00,26.0000,26.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(748,749,748,748,20.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 07:23:03'),(749,750,749,749,20.0000,0.0000,20.0000,0.00,20.0000,20.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(750,751,750,750,10.0000,0.0000,83.0000,0.00,83.0000,83.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(751,752,751,751,20.0000,0.0000,24.0000,0.00,24.0000,24.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 03:23:54'),(752,753,752,752,40.0000,0.0000,15.0000,0.00,15.0000,15.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 15:44:20'),(753,754,753,753,20.0000,0.0000,30.0000,0.00,30.0000,30.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 13:54:56'),(754,755,754,754,6.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 12:48:25'),(755,756,755,755,20.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(756,757,756,756,20.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 15:44:20'),(757,758,757,757,5.0000,0.0000,20.0000,0.00,20.0000,20.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(758,759,758,758,5.0000,0.0000,20.0000,0.00,20.0000,20.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(759,760,759,759,12.0000,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-03 03:08:44'),(760,761,760,760,24.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 15:44:20'),(761,762,761,761,40.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(762,763,762,762,12.0000,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 03:47:22'),(763,764,763,763,12.0000,0.0000,40.0000,0.00,40.0000,40.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-03 08:45:53'),(764,765,764,764,1.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(765,766,765,765,1.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(766,767,766,766,2.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(767,768,767,767,40.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 04:44:12'),(768,769,768,768,40.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(769,770,769,769,20.0000,0.0000,12.0000,0.00,12.0000,12.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-03 08:45:53'),(770,771,770,770,40.0000,0.0000,6.0000,0.00,6.0000,6.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-03 08:45:53'),(771,772,771,771,2.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(772,773,772,772,2.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(773,774,773,773,40.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 04:03:57'),(774,775,774,774,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(775,776,775,775,10.0000,0.0000,80.0000,0.00,80.0000,80.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-03 05:45:13'),(776,777,776,776,6.0000,0.0000,42.0000,0.00,42.0000,42.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(777,778,777,777,6.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(778,779,778,778,6.0000,0.0000,38.0000,0.00,38.0000,38.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 13:14:11'),(779,780,779,779,6.0000,0.0000,60.0000,0.00,60.0000,60.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-03 05:45:13'),(780,781,780,780,6.0000,0.0000,60.0000,0.00,60.0000,60.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 11:01:13'),(781,782,781,781,6.0000,0.0000,36.0000,0.00,36.0000,36.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(782,783,782,782,6.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(783,784,783,783,3.0000,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(784,785,784,784,3.0000,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(785,786,785,785,24.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 12:49:26'),(786,787,786,786,12.0000,0.0000,17.0000,0.00,17.0000,17.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(787,788,787,787,12.0000,0.0000,17.0000,0.00,17.0000,17.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(788,789,788,788,12.0000,0.0000,17.0000,0.00,17.0000,17.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(789,790,789,789,24.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(790,791,790,790,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(791,792,791,791,1.0000,0.0000,105.0000,0.00,105.0000,105.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(792,793,792,792,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(793,794,793,793,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(794,795,794,794,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 08:34:37'),(795,796,795,795,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(796,797,796,796,6.0000,0.0000,38.0000,0.00,38.0000,38.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 07:18:18'),(797,798,797,797,6.0000,0.0000,38.0000,0.00,38.0000,38.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 12:51:47'),(798,799,798,798,6.0000,0.0000,38.0000,0.00,38.0000,38.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(799,800,799,799,6.0000,0.0000,38.0000,0.00,38.0000,38.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(800,801,800,800,6.0000,0.0000,38.0000,0.00,38.0000,38.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(801,802,801,801,6.0000,0.0000,90.0000,0.00,90.0000,90.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(802,803,802,802,6.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 04:06:56'),(803,804,803,803,1.0000,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(804,805,804,804,12.0000,0.0000,10.0000,0.00,10.0000,10.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(805,806,805,805,12.0000,0.0000,80.0000,0.00,80.0000,80.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 03:21:59'),(806,807,806,806,5.0000,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(807,808,807,807,3.0000,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(808,809,808,808,3.0000,0.0000,263.0000,0.00,263.0000,263.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(809,810,809,809,2.0000,0.0000,527.0000,0.00,527.0000,527.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(810,811,810,810,3.0000,0.0000,200.0000,0.00,200.0000,200.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(811,812,811,811,14.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-03 12:14:20'),(812,813,812,812,2.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 03:21:59'),(813,814,813,813,5.0000,0.0000,12.0000,0.00,12.0000,12.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-02 03:28:22'),(814,815,814,814,2.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:19:09','2025-02-01 19:19:09'),(815,816,815,815,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:26:04','2025-02-02 12:22:42'),(816,817,816,816,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:27:02','2025-02-01 19:27:02'),(817,818,817,817,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-02 04:03:57'),(818,819,818,818,12.0000,0.0000,25.0000,0.00,25.0000,25.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-02 06:05:24'),(819,820,819,819,12.0000,0.0000,39.0000,0.00,39.0000,39.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(820,821,820,820,6.0000,0.0000,68.0000,0.00,68.0000,68.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(821,822,821,821,3.0000,0.0000,117.0000,0.00,117.0000,117.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-02 09:29:28'),(822,823,822,822,3.0000,0.0000,222.0000,0.00,222.0000,222.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(823,824,823,823,24.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-02 12:49:26'),(824,825,824,824,24.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-03 12:14:20'),(825,826,825,825,6.0000,0.0000,29.0000,0.00,29.0000,29.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-02 04:27:27'),(826,827,826,826,3.0000,0.0000,52.0000,0.00,52.0000,52.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-02 06:52:21'),(827,828,827,827,12.0000,0.0000,17.0000,0.00,17.0000,17.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-02 06:52:21'),(828,829,828,828,6.0000,0.0000,46.0000,0.00,46.0000,46.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(829,830,829,829,3.0000,0.0000,80.0000,0.00,80.0000,80.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(830,831,830,830,15.0000,0.0000,39.0000,0.00,39.0000,39.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-02 15:54:30'),(831,832,831,831,3.0000,0.0000,33.0000,0.00,33.0000,33.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(832,833,832,832,3.0000,0.0000,64.0000,0.00,64.0000,64.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(833,834,833,833,6.0000,0.0000,46.0000,0.00,46.0000,46.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(834,835,834,834,6.0000,0.0000,46.0000,0.00,46.0000,46.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(835,836,835,835,6.0000,0.0000,46.0000,0.00,46.0000,46.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(836,837,836,836,3.0000,0.0000,80.0000,0.00,80.0000,80.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(837,838,837,837,3.0000,0.0000,80.0000,0.00,80.0000,80.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(838,839,838,838,3.0000,0.0000,80.0000,0.00,80.0000,80.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:38:39','2025-02-01 19:38:39'),(839,840,839,839,7.0000,0.0000,14.0000,0.00,14.0000,14.0000,0.0000,NULL,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-03 12:14:20'),(840,841,840,840,20.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-02 14:56:17'),(841,842,841,841,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-02 15:44:20'),(842,843,842,842,3.0000,0.0000,31.0000,0.00,31.0000,31.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(843,844,843,843,3.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(844,845,844,844,48.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-02 10:34:21'),(845,846,845,845,30.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-02 12:25:07'),(846,847,846,846,30.0000,0.0000,18.0000,0.00,18.0000,18.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-02 06:08:35'),(847,848,847,847,21.0000,0.0000,28.0000,0.00,28.0000,28.0000,0.0000,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-02 11:01:13'),(848,849,848,848,10.0000,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-03 08:51:19'),(849,850,849,849,6.0000,0.0000,29.0000,0.00,29.0000,29.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(850,851,850,850,12.0000,0.0000,28.0000,0.00,28.0000,28.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-02 15:06:23'),(851,852,851,851,3.0000,0.0000,55.0000,0.00,55.0000,55.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-02 15:44:20'),(852,853,852,852,3.0000,0.0000,168.0000,0.00,168.0000,168.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-01 19:44:25'),(853,854,853,853,600.0000,0.0000,18.0000,0.00,18.0000,18.0000,0.0000,NULL,NULL,54.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-02 11:01:13'),(854,855,854,854,20.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:44:25','2025-02-03 08:51:01'),(855,856,855,855,24.0000,0.0000,3.0000,0.00,3.0000,3.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(856,857,856,856,24.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(857,858,857,857,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(858,859,858,858,15.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 09:05:42'),(859,860,859,859,30.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(860,861,860,860,2.0000,0.0000,47.0000,0.00,47.0000,47.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(861,862,861,861,2.0000,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 03:09:21'),(862,863,862,862,2.0000,0.0000,84.0000,0.00,84.0000,84.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 03:45:25'),(863,864,863,863,3.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 04:21:43'),(864,865,864,864,5.0000,0.0000,12.0000,0.00,12.0000,12.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(865,866,865,865,4.0000,0.0000,29.0000,0.00,29.0000,29.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(866,867,866,866,2.0000,0.0000,47.0000,0.00,47.0000,47.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(867,868,867,867,2.0000,0.0000,40.0000,0.00,40.0000,40.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(868,869,868,868,5.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 15:44:20'),(869,870,869,869,20.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 11:01:13'),(870,871,870,870,3.0000,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(871,872,871,871,10.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 05:43:32'),(872,873,872,872,15.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 04:21:43'),(873,874,873,873,15.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(874,875,874,874,10.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(875,876,875,875,10.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(876,877,876,876,10.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 10:54:09'),(877,878,877,877,10.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 07:23:03'),(878,879,878,878,3.0000,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(879,880,879,879,3.0000,0.0000,187.0000,0.00,187.0000,187.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(880,881,880,880,5.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 12:25:07'),(881,882,881,881,5.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(882,883,882,882,5.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-02 15:44:20'),(883,884,883,883,3.0000,0.0000,110.0000,0.00,110.0000,110.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 19:49:47','2025-02-01 19:49:47'),(884,885,884,884,40.0000,0.0000,3.0000,0.00,3.0000,4.0000,0.5400,11,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 07:11:54'),(885,886,885,885,40.0000,0.0000,3.0000,0.00,3.0000,3.0000,0.5400,11,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 13:54:56'),(886,887,886,886,3.0000,0.0000,46.0000,0.00,46.0000,55.0000,8.2800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 13:04:47'),(887,888,887,887,40.0000,0.0000,3.0000,0.00,3.0000,4.0000,0.5400,11,NULL,40.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-03 05:45:13'),(888,889,888,888,3.0000,0.0000,46.0000,0.00,46.0000,55.0000,8.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(889,890,889,889,3.0000,0.0000,44.0000,0.00,44.0000,52.0000,7.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(890,891,890,890,3.0000,0.0000,90.0000,0.00,90.0000,107.0000,16.2000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 03:32:06'),(891,892,891,891,3.0000,0.0000,45.0000,0.00,45.0000,53.0000,8.1000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 04:06:56'),(892,893,892,892,40.0000,0.0000,3.0000,0.00,3.0000,3.0000,0.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(893,894,893,893,3.0000,0.0000,44.0000,0.00,44.0000,52.0000,7.9200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 03:03:42'),(894,895,894,894,4.0000,0.0000,30.0000,0.00,30.0000,35.0000,5.4000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(895,896,895,895,4.0000,0.0000,73.0000,0.00,73.0000,87.0000,13.1400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(896,897,896,896,12.0000,0.0000,27.0000,0.00,27.0000,31.0000,4.8600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(897,898,897,897,4.0000,0.0000,47.0000,0.00,47.0000,55.0000,8.4600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(898,899,898,898,8.0000,0.0000,47.0000,0.00,47.0000,55.0000,8.4600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 06:52:21'),(899,900,899,899,6.0000,0.0000,220.0000,0.00,220.0000,259.0000,39.6000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(900,901,900,900,6.0000,0.0000,33.0000,0.00,33.0000,39.0000,5.9400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(901,902,901,901,24.0000,0.0000,32.0000,0.00,32.0000,38.0000,5.7600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 04:45:27'),(902,903,902,902,12.0000,0.0000,55.0000,0.00,55.0000,65.0000,9.9000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 06:19:26'),(903,904,903,903,24.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 15:22:45'),(904,905,904,904,6.0000,0.0000,165.0000,0.00,165.0000,194.0000,29.7000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 09:39:32'),(905,906,905,905,5.0000,0.0000,125.0000,0.00,125.0000,147.0000,22.5000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(906,907,906,906,1.0000,0.0000,125.0000,0.00,125.0000,147.0000,22.5000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-01 20:08:52'),(907,908,907,907,24.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:52','2025-02-02 04:06:56'),(908,909,908,908,24.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 04:51:21'),(909,910,909,909,3.0000,0.0000,76.0000,0.00,76.0000,90.0000,13.6800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(910,911,910,910,6.0000,0.0000,31.0000,0.00,31.0000,37.0000,5.5800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 07:11:54'),(911,912,911,911,24.0000,0.0000,30.0000,0.00,30.0000,36.0000,5.4000,11,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 14:56:17'),(912,913,912,912,6.0000,0.0000,119.0000,0.00,119.0000,140.0000,21.4200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 06:52:21'),(913,914,913,913,3.0000,0.0000,23.0000,0.00,23.0000,27.0000,4.1400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 03:03:42'),(914,915,914,914,12.0000,0.0000,28.0000,0.00,28.0000,33.0000,5.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(915,916,915,915,24.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 03:47:22'),(916,917,916,916,24.0000,0.0000,30.0000,0.00,30.0000,36.0000,5.4000,11,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 15:38:05'),(917,918,917,917,12.0000,0.0000,15.0000,0.00,15.0000,18.0000,2.7000,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 13:41:49'),(918,919,918,918,6.0000,0.0000,63.0000,0.00,63.0000,74.0000,11.3400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(919,920,919,919,12.0000,0.0000,47.0000,0.00,47.0000,55.0000,8.4600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(920,921,920,920,12.0000,0.0000,42.0000,0.00,42.0000,49.0000,7.5600,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 12:25:15'),(921,922,921,921,12.0000,0.0000,42.0000,0.00,42.0000,49.0000,7.5600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 12:48:25'),(922,923,922,922,60.0000,0.0000,16.0000,0.00,16.0000,18.0000,2.8800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(923,924,923,923,6.0000,0.0000,94.0000,0.00,94.0000,111.0000,16.9200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 06:58:55'),(924,925,924,924,12.0000,0.0000,48.0000,0.00,48.0000,56.0000,8.6400,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 09:27:06'),(925,926,925,925,30.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-03 05:57:10'),(926,927,926,926,6.0000,0.0000,92.0000,0.00,92.0000,108.0000,16.5600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(927,928,927,927,12.0000,0.0000,47.0000,0.00,47.0000,55.0000,8.4600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 05:44:33'),(928,929,928,928,6.0000,0.0000,92.0000,0.00,92.0000,108.0000,16.5600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 04:06:56'),(929,930,929,929,12.0000,0.0000,47.0000,0.00,47.0000,55.0000,8.4600,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 04:06:56'),(930,931,930,930,12.0000,0.0000,31.0000,0.00,31.0000,37.0000,5.5800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(931,932,931,931,84.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 13:41:49'),(932,933,932,932,6.0000,0.0000,35.0000,0.00,35.0000,41.0000,6.3000,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 07:21:13'),(933,934,933,933,6.0000,0.0000,70.0000,0.00,70.0000,82.0000,12.6000,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-03 07:55:38'),(934,935,934,934,6.0000,0.0000,81.0000,0.00,81.0000,96.0000,14.5800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 06:27:54'),(935,936,935,935,6.0000,0.0000,70.0000,0.00,70.0000,83.0000,12.6000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 07:11:54'),(936,937,936,936,3.0000,0.0000,109.0000,0.00,109.0000,129.0000,19.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(937,938,937,937,3.0000,0.0000,124.0000,0.00,124.0000,147.0000,22.3200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(938,939,938,938,30.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(939,940,939,939,12.0000,0.0000,68.0000,0.00,68.0000,80.0000,12.2400,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 03:55:21'),(940,941,940,940,60.0000,0.0000,25.0000,0.00,25.0000,29.0000,4.5000,11,NULL,38.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-03 12:14:20'),(941,942,941,941,36.0000,0.0000,15.0000,0.00,15.0000,18.0000,2.7000,11,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 12:51:47'),(942,943,942,942,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(943,944,943,943,10.0000,0.0000,98.0000,0.00,98.0000,116.0000,17.6400,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-03 05:19:06'),(944,945,944,944,1.0000,0.0000,136.0000,0.00,136.0000,161.0000,24.4800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(945,946,945,945,5.0000,0.0000,136.0000,0.00,136.0000,161.0000,24.4800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 07:11:54'),(946,947,946,946,1.0000,0.0000,80.0000,0.00,80.0000,94.0000,14.4000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(947,948,947,947,2.0000,0.0000,80.0000,0.00,80.0000,94.0000,14.4000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(948,949,948,948,3.0000,0.0000,112.0000,0.00,112.0000,132.0000,20.1600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(949,950,949,949,20.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(950,951,950,950,3.0000,0.0000,190.0000,0.00,190.0000,224.0000,34.2000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 03:32:06'),(951,952,951,951,3.0000,0.0000,101.0000,0.00,101.0000,119.0000,18.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(952,953,952,952,20.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(953,954,953,953,3.0000,0.0000,168.0000,0.00,168.0000,198.0000,30.2400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(954,955,954,954,6.0000,0.0000,170.0000,0.00,170.0000,201.0000,30.6000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 13:54:56'),(955,956,955,955,12.0000,0.0000,85.0000,0.00,85.0000,100.0000,15.3000,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 07:50:10'),(956,957,956,956,30.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 12:22:42'),(957,958,957,957,3.0000,0.0000,141.0000,0.00,141.0000,166.0000,25.3800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(958,959,958,958,3.0000,0.0000,124.0000,0.00,124.0000,146.0000,22.3200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 03:03:42'),(959,960,959,959,5.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(960,961,960,960,6.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(961,962,961,961,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(962,963,962,962,6.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(963,964,963,963,96.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,13.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 10:34:21'),(964,965,964,964,6.0000,0.0000,23.0000,0.00,23.0000,28.0000,4.1400,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 03:23:29'),(965,966,965,965,189.0000,0.0000,4.0000,0.00,4.0000,5.0000,0.7200,11,NULL,16.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 14:56:17'),(966,967,966,966,12.0000,0.0000,24.0000,0.00,24.0000,28.0000,4.3200,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 13:54:56'),(967,968,967,967,6.0000,0.0000,45.0000,0.00,45.0000,53.0000,8.1000,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 14:22:04'),(968,969,968,968,6.0000,0.0000,75.0000,0.00,75.0000,89.0000,13.5000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-03 05:19:06'),(969,970,969,969,5.0000,0.0000,96.0000,0.00,96.0000,113.0000,17.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(970,971,970,970,12.0000,0.0000,11.0000,0.00,11.0000,13.0000,1.9800,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-03 03:56:54'),(971,972,971,971,5.0000,0.0000,45.0000,0.00,45.0000,53.0000,8.1000,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 03:47:22'),(972,973,972,972,10.0000,0.0000,18.0000,0.00,18.0000,21.0000,3.2400,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-03 08:45:53'),(973,974,973,973,2.0000,0.0000,153.0000,0.00,153.0000,181.0000,27.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(974,975,974,974,1.0000,0.0000,153.0000,0.00,153.0000,181.0000,27.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(975,976,975,975,36.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 12:49:26'),(976,977,976,976,6.0000,0.0000,59.0000,0.00,59.0000,69.0000,10.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-01 20:08:53'),(977,978,977,977,6.0000,0.0000,30.0000,0.00,30.0000,35.0000,5.4000,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:08:53','2025-02-02 13:47:31'),(978,979,978,978,30.0000,0.0000,80.0000,0.00,80.0000,84.0000,4.0000,4,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-03 03:08:44'),(979,980,979,979,4.0000,0.0000,214.0000,0.00,214.0000,224.0000,10.7000,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-03 10:52:05'),(980,981,980,980,10.0000,0.0000,87.0000,0.00,87.0000,92.0000,4.3500,4,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-03 05:56:11'),(981,982,981,981,6.0000,0.0000,320.0000,0.00,320.0000,336.0000,16.0000,4,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-03 06:17:13'),(982,983,982,982,8.0000,0.0000,200.0000,0.00,200.0000,210.0000,10.0000,4,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 08:25:30'),(983,984,983,983,80.0000,0.0000,22.0000,0.00,22.0000,23.0000,1.1000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 02:54:36'),(984,985,984,984,40.0000,0.0000,38.0000,0.00,38.0000,39.0000,1.9000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 12:06:07'),(985,986,985,985,120.0000,0.0000,8.0000,0.00,8.0000,9.0000,0.4000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(986,987,986,986,48.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(987,988,987,987,42.0000,0.0000,8.0000,0.00,8.0000,9.0000,0.4000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(988,989,988,988,3.0000,0.0000,77.0000,0.00,77.0000,91.0000,13.8600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(989,990,989,989,48.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,21.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 14:16:09'),(990,991,990,990,3.0000,0.0000,187.0000,0.00,187.0000,220.0000,33.6600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 11:01:15'),(991,992,991,991,75.0000,0.0000,4.0000,0.00,4.0000,5.0000,0.7200,11,NULL,21.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 15:44:20'),(992,993,992,992,3.0000,0.0000,97.0000,0.00,97.0000,115.0000,17.4600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 13:04:47'),(993,994,993,993,3.0000,0.0000,233.0000,0.00,233.0000,275.0000,41.9400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(994,995,994,994,72.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 14:16:09'),(995,996,995,995,4.0000,0.0000,109.0000,0.00,109.0000,129.0000,19.6200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-03 10:20:16'),(996,997,996,996,72.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,16.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-03 05:45:13'),(997,998,997,997,144.0000,0.0000,2.0000,0.00,2.0000,2.0000,0.3600,11,NULL,27.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 15:13:40'),(998,999,998,998,6.0000,0.0000,12.0000,0.00,12.0000,13.0000,1.4400,8,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 13:41:49'),(999,1000,999,999,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,0.9600,8,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-03 12:14:20'),(1000,1001,1000,1000,12.0000,0.0000,20.0000,0.00,20.0000,23.0000,2.4000,8,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 12:48:25'),(1001,1002,1001,1001,75.0000,0.0000,4.0000,0.00,4.0000,5.0000,0.7200,11,NULL,44.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 13:06:45'),(1002,1003,1002,1002,3.0000,0.0000,76.0000,0.00,76.0000,90.0000,13.6800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1003,1004,1003,1003,48.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1004,1005,1004,1004,3.0000,0.0000,182.0000,0.00,182.0000,214.0000,32.7600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-01 20:13:59'),(1005,1006,1005,1005,3.0000,0.0000,95.0000,0.00,95.0000,113.0000,17.1000,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-03 10:52:05'),(1006,1007,1006,1006,3.0000,0.0000,227.0000,0.00,227.0000,268.0000,40.8600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:13:59','2025-02-02 05:46:07'),(1007,1008,1007,1007,13.0000,0.0000,14.0000,0.00,14.0000,17.0000,2.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1008,1009,1008,1008,192.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,48.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-02 15:22:45'),(1009,1010,1009,1009,24.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1010,1011,1010,1010,960.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,173.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-03 03:56:54'),(1011,1012,1011,1011,24.0000,0.0000,15.0000,0.00,15.0000,17.0000,2.7000,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-02 07:18:18'),(1012,1013,1012,1012,8.0000,0.0000,53.0000,0.00,53.0000,62.0000,9.5400,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-02 14:56:17'),(1013,1014,1013,1013,192.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,96.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-03 10:57:02'),(1014,1015,1014,1014,192.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,22.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-02 06:27:54'),(1015,1016,1015,1015,192.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,16.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-03 12:14:20'),(1016,1017,1016,1016,8.0000,0.0000,18.0000,0.00,18.0000,22.0000,3.2400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-03 04:49:47'),(1017,1018,1017,1017,6.0000,0.0000,52.0000,0.00,52.0000,62.0000,9.3600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-02 08:34:37'),(1018,1019,1018,1018,3.0000,0.0000,100.0000,0.00,100.0000,118.0000,18.0000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-03 05:56:11'),(1019,1020,1019,1019,24.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1020,1021,1020,1020,192.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1021,1022,1021,1021,6.0000,0.0000,44.0000,0.00,44.0000,52.0000,7.9200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-02 07:18:18'),(1022,1023,1022,1022,12.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1023,1024,1023,1023,3.0000,0.0000,65.0000,0.00,65.0000,77.0000,11.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1024,1025,1024,1024,24.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1025,1026,1025,1025,24.0000,0.0000,14.0000,0.00,14.0000,17.0000,2.5200,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-02 07:11:54'),(1026,1027,1026,1026,22.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1027,1028,1027,1027,3.0000,0.0000,93.0000,0.00,93.0000,110.0000,16.7400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1028,1029,1028,1028,6.0000,0.0000,49.0000,0.00,49.0000,57.0000,8.8200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1029,1030,1029,1029,22.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1030,1031,1030,1030,3.0000,0.0000,108.0000,0.00,108.0000,128.0000,19.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1031,1032,1031,1031,6.0000,0.0000,56.0000,0.00,56.0000,66.0000,10.0800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1032,1033,1032,1032,22.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1033,1034,1033,1033,3.0000,0.0000,108.0000,0.00,108.0000,128.0000,19.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1034,1035,1034,1034,6.0000,0.0000,58.0000,0.00,58.0000,68.0000,10.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1035,1036,1035,1035,13.0000,0.0000,14.0000,0.00,14.0000,17.0000,2.5200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-02 02:50:40'),(1036,1037,1036,1036,960.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,17.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-02 13:41:49'),(1037,1038,1037,1037,3.0000,0.0000,30.0000,0.00,30.0000,35.0000,5.4000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1038,1039,1038,1038,3.0000,0.0000,36.0000,0.00,36.0000,42.0000,6.4800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 20:17:55','2025-02-01 20:17:55'),(1039,1040,1039,1039,60.0000,0.0000,30.0000,0.00,30.0000,31.0000,1.5000,4,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-03 03:08:44'),(1040,1041,1040,1040,15.0000,0.0000,95.0000,0.00,95.0000,100.0000,4.7500,4,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-02 14:16:09'),(1041,1042,1041,1041,30.0000,0.0000,58.0000,0.00,58.0000,61.0000,2.9000,4,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-02 12:49:26'),(1042,1043,1042,1042,6.0000,0.0000,293.0000,0.00,293.0000,307.6500,14.6500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-02 06:58:55'),(1043,1044,1043,1043,15.0000,0.0000,21.0000,0.00,21.0000,22.0000,1.0500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-02 08:06:41'),(1044,1045,1044,1044,6.0000,0.0000,53.0000,0.00,53.0000,56.0000,2.6500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-02 04:33:27'),(1045,1046,1045,1045,15.0000,0.0000,13.0000,0.00,13.0000,14.0000,0.6500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-02 07:14:32'),(1046,1047,1046,1046,12.0000,0.0000,33.0000,0.00,33.0000,34.0000,1.6500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-02 06:27:54'),(1047,1048,1047,1047,20.0000,0.0000,14.0000,0.00,14.0000,14.7000,0.7000,4,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-03 04:15:31'),(1048,1049,1048,1048,12.0000,0.0000,36.0000,0.00,36.0000,40.0000,4.3200,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-01 21:16:06'),(1049,1050,1049,1049,6.0000,0.0000,67.0000,0.00,67.0000,75.0000,8.0400,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-02 03:49:18'),(1050,1051,1050,1050,6.0000,0.0000,128.0000,0.00,128.0000,144.0000,15.3600,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-02 03:45:25'),(1051,1052,1051,1051,30.0000,0.0000,12.0000,0.00,12.0000,12.0000,0.0000,NULL,NULL,27.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-03 12:14:20'),(1052,1053,1052,1052,25.0000,0.0000,24.0000,0.00,24.0000,24.0000,0.0000,NULL,NULL,15.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:16:06','2025-02-03 08:52:37'),(1053,1054,1053,1053,6.0000,0.0000,55.0000,0.00,55.0000,58.0000,2.7500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 08:34:37'),(1054,1055,1054,1054,12.0000,0.0000,14.0000,0.00,14.0000,14.0000,0.7000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1055,1056,1055,1055,8.0000,0.0000,42.0000,0.00,42.0000,44.0000,2.1000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 03:47:22'),(1056,1057,1056,1056,12.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1057,1058,1057,1057,12.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1058,1059,1058,1058,12.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.3500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 13:14:11'),(1059,1060,1059,1059,12.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1060,1061,1060,1060,12.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1061,1062,1061,1061,12.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1062,1063,1062,1062,6.0000,0.0000,35.0000,0.00,35.0000,37.0000,1.7500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 13:06:45'),(1063,1064,1063,1063,6.0000,0.0000,35.0000,0.00,35.0000,37.0000,1.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1064,1065,1064,1064,6.0000,0.0000,35.0000,0.00,35.0000,37.0000,1.7500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 14:51:16'),(1065,1066,1065,1065,6.0000,0.0000,35.0000,0.00,35.0000,37.0000,1.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1066,1067,1066,1066,6.0000,0.0000,35.0000,0.00,35.0000,37.0000,1.7500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 11:01:13'),(1067,1068,1067,1067,12.0000,0.0000,14.0000,0.00,14.0000,14.0000,0.7000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1068,1069,1068,1068,6.0000,0.0000,35.0000,0.00,35.0000,37.0000,1.7500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 08:34:37'),(1069,1070,1069,1069,6.0000,0.0000,35.0000,0.00,35.0000,37.0000,1.7500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 14:22:04'),(1070,1071,1070,1070,12.0000,0.0000,14.0000,0.00,14.0000,15.0000,0.7000,4,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 12:48:25'),(1071,1072,1071,1071,12.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-02 09:27:06'),(1072,1073,1072,1072,12.0000,0.0000,24.0000,0.00,24.0000,25.0000,1.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1073,1074,1073,1073,11.0000,0.0000,13.0000,0.00,13.0000,15.0000,2.3400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1074,1075,1074,1074,2.0000,0.0000,122.0000,0.00,122.0000,143.0000,21.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1075,1076,1075,1075,3.0000,0.0000,77.0000,0.00,77.0000,91.0000,13.8600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1076,1077,1076,1076,3.0000,0.0000,77.0000,0.00,77.0000,91.0000,13.8600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1077,1078,1077,1077,1.0000,0.0000,70.0000,0.00,70.0000,83.0000,12.6000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1078,1079,1078,1078,2.0000,0.0000,70.0000,0.00,70.0000,83.0000,12.6000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1079,1080,1079,1079,3.0000,0.0000,70.0000,0.00,70.0000,83.0000,12.6000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1080,1081,1080,1080,3.0000,0.0000,53.0000,0.00,53.0000,63.0000,9.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1081,1082,1081,1081,3.0000,0.0000,53.0000,0.00,53.0000,63.0000,9.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1082,1083,1082,1082,6.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1083,1084,1083,1083,6.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1084,1085,1084,1084,6.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1085,1086,1085,1085,6.0000,0.0000,22.0000,0.00,22.0000,27.0000,3.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:21:37','2025-02-01 21:21:37'),(1086,1087,1086,1086,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1087,1088,1087,1087,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 14:16:09'),(1088,1089,1088,1088,6.0000,0.0000,23.0000,0.00,23.0000,26.0000,2.7600,8,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 15:51:31'),(1089,1090,1089,1089,8.0000,0.0000,8.0000,0.00,8.0000,9.0000,0.9600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1090,1091,1090,1090,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1091,1092,1091,1091,16.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.4800,8,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 12:48:25'),(1092,1093,1092,1092,16.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.4800,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 06:08:46'),(1093,1094,1093,1093,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 15:38:05'),(1094,1095,1094,1094,16.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.4800,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1095,1096,1095,1095,16.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.4800,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 14:16:09'),(1096,1097,1096,1096,36.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1097,1098,1097,1097,12.0000,0.0000,14.0000,0.00,14.0000,16.0000,1.6800,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-03 06:23:04'),(1098,1099,1098,1098,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 07:23:03'),(1099,1100,1099,1099,24.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1100,1101,1100,1100,6.0000,0.0000,14.0000,0.00,14.0000,16.0000,1.6800,8,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 13:57:57'),(1101,1102,1101,1101,3.0000,0.0000,23.0000,0.00,23.0000,26.0000,2.7600,8,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 15:51:31'),(1102,1103,1102,1102,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-03 12:14:20'),(1103,1104,1103,1103,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 05:44:33'),(1104,1105,1104,1104,6.0000,0.0000,14.0000,0.00,14.0000,16.0000,1.6800,8,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 15:36:05'),(1105,1106,1105,1105,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1106,1107,1106,1106,6.0000,0.0000,14.0000,0.00,14.0000,16.0000,1.6800,8,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 06:08:46'),(1107,1108,1107,1107,16.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.4800,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1108,1109,1108,1108,15.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.4800,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1109,1110,1109,1109,15.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.4800,8,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 05:00:24'),(1110,1111,1110,1110,10.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 15:36:05'),(1111,1112,1111,1111,10.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 13:41:49'),(1112,1113,1112,1112,12.0000,0.0000,13.0000,0.00,13.0000,14.0000,1.5600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1113,1114,1113,1113,12.0000,0.0000,13.0000,0.00,13.0000,14.0000,1.5600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1114,1115,1114,1114,12.0000,0.0000,13.0000,0.00,13.0000,14.0000,1.5600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1115,1116,1115,1115,12.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.4800,8,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 13:41:49'),(1116,1117,1116,1116,9.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.4800,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-01 21:24:44'),(1117,1118,1117,1117,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.9600,8,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:24:44','2025-02-02 04:41:06'),(1118,1119,1118,1118,12.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1119,1120,1119,1119,4.0000,0.0000,18.0000,0.00,18.0000,22.0000,3.2400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1120,1121,1120,1120,20.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-02 04:41:06'),(1121,1122,1121,1121,12.0000,0.0000,29.0000,0.00,29.0000,35.0000,5.2200,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-02 12:48:25'),(1122,1123,1122,1122,6.0000,0.0000,29.0000,0.00,29.0000,34.0000,5.2200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1123,1124,1123,1123,12.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1124,1125,1124,1124,6.0000,0.0000,29.0000,0.00,29.0000,34.0000,5.2200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-02 13:47:31'),(1125,1126,1125,1125,12.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1126,1127,1126,1126,12.0000,0.0000,30.0000,0.00,30.0000,35.0000,5.4000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1127,1128,1127,1127,20.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-02 05:44:33'),(1128,1129,1128,1128,24.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1129,1130,1129,1129,6.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1130,1131,1130,1130,12.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-03 12:14:20'),(1131,1132,1131,1131,12.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1132,1133,1132,1132,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:41','2025-02-01 21:29:41'),(1133,1134,1133,1133,12.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1134,1135,1134,1134,12.0000,0.0000,15.0000,0.00,15.0000,17.0000,2.7000,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 11:55:48'),(1135,1136,1135,1135,12.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1136,1137,1136,1136,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1137,1138,1137,1137,12.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1138,1139,1138,1138,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1139,1140,1139,1139,12.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1140,1141,1140,1140,12.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1141,1142,1141,1141,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,1.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1142,1143,1142,1142,24.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1143,1144,1143,1143,24.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1144,1145,1144,1144,6.0000,0.0000,26.0000,0.00,26.0000,31.0000,4.6800,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 11:36:01'),(1145,1146,1145,1145,24.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1146,1147,1146,1146,24.0000,0.0000,2.0000,0.00,2.0000,3.0000,0.3600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1147,1148,1147,1147,24.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1148,1149,1148,1148,24.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1149,1150,1149,1149,12.0000,0.0000,15.0000,0.00,15.0000,17.0000,2.7000,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 13:14:11'),(1150,1151,1150,1150,6.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1151,1152,1151,1151,12.0000,0.0000,11.0000,0.00,11.0000,13.0000,1.9800,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 13:54:56'),(1152,1153,1152,1152,12.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 11:01:13'),(1153,1154,1153,1153,48.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 14:16:09'),(1154,1155,1154,1154,24.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1155,1156,1155,1155,12.0000,0.0000,22.0000,0.00,22.0000,26.0000,3.9600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 05:06:41'),(1156,1157,1156,1156,1.0000,0.0000,4.0000,0.00,4.0000,4.0000,0.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1157,1158,1157,1157,12.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1158,1159,1158,1158,18.0000,0.0000,7.0000,0.00,7.0000,9.0000,1.2600,11,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 13:32:10'),(1159,1160,1159,1159,24.0000,0.0000,3.0000,0.00,3.0000,4.0000,0.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1160,1161,1160,1160,24.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 03:47:22'),(1161,1162,1161,1161,24.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 07:50:10'),(1162,1163,1162,1162,24.0000,0.0000,7.0000,0.00,7.0000,8.0000,1.2600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 03:16:09'),(1163,1164,1163,1163,3.0000,0.0000,97.0000,0.00,97.0000,109.0000,11.6400,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1164,1165,1164,1164,24.0000,0.0000,12.0000,0.00,12.0000,14.0000,1.4400,8,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 06:08:46'),(1165,1166,1165,1165,24.0000,0.0000,24.0000,0.00,24.0000,27.0000,2.8800,8,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-03 12:14:20'),(1166,1167,1166,1166,12.0000,0.0000,49.0000,0.00,49.0000,54.0000,5.8800,8,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 09:39:32'),(1167,1168,1167,1167,6.0000,0.0000,73.0000,0.00,73.0000,82.0000,8.7600,8,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-02 14:16:09'),(1168,1169,1168,1168,12.0000,0.0000,7.0000,0.00,7.0000,8.0000,0.8400,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:29:42','2025-02-01 21:29:42'),(1169,1170,1169,1169,1.0000,0.0000,155.0000,0.00,155.0000,163.0000,7.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1170,1171,1170,1170,200.0000,0.0000,1.0000,0.00,1.0000,2.0000,0.0500,4,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 03:03:42'),(1171,1172,1171,1171,200.0000,0.0000,1.0000,0.00,1.0000,2.0000,0.0500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1172,1173,1172,1172,200.0000,0.0000,1.0000,0.00,1.0000,2.0000,0.0500,4,NULL,60.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 14:19:18'),(1173,1174,1173,1173,200.0000,0.0000,1.0000,0.00,1.0000,2.0000,0.0500,4,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-03 03:03:20'),(1174,1175,1174,1174,12.0000,0.0000,40.0000,0.00,40.0000,42.0000,2.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1175,1176,1175,1175,12.0000,0.0000,75.0000,0.00,75.0000,79.0000,3.7500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 07:04:48'),(1176,1177,1176,1176,4.0000,0.0000,108.0000,0.00,108.0000,113.0000,5.4000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1177,1178,1177,1177,4.0000,0.0000,128.0000,0.00,128.0000,135.0000,6.4000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1178,1179,1178,1178,12.0000,0.0000,64.0000,0.00,64.0000,67.0000,3.2000,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 04:27:27'),(1179,1180,1179,1179,12.0000,0.0000,128.0000,0.00,128.0000,135.0000,6.4000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1180,1181,1180,1180,5.0000,0.0000,95.0000,0.00,95.0000,100.0000,4.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1181,1182,1181,1181,6.0000,0.0000,140.0000,0.00,140.0000,147.0000,7.0000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 06:52:21'),(1182,1183,1182,1182,6.0000,0.0000,161.0000,0.00,161.0000,170.0000,8.0500,4,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 05:00:30'),(1183,1184,1183,1183,60.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.4000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 12:51:47'),(1184,1185,1184,1184,12.0000,0.0000,87.0000,0.00,87.0000,92.0000,4.3500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 11:01:13'),(1185,1186,1185,1185,3.0000,0.0000,120.0000,0.00,120.0000,126.0000,6.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1186,1187,1186,1186,3.0000,0.0000,75.0000,0.00,75.0000,78.0000,3.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1187,1188,1187,1187,3.0000,0.0000,75.0000,0.00,75.0000,78.0000,3.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1188,1189,1188,1188,3.0000,0.0000,75.0000,0.00,75.0000,78.0000,3.7500,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 03:14:29'),(1189,1190,1189,1189,3.0000,0.0000,75.0000,0.00,75.0000,78.0000,3.7500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 15:04:11'),(1190,1191,1190,1190,2.0000,0.0000,150.0000,0.00,150.0000,158.0000,7.5000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1191,1192,1191,1191,2.0000,0.0000,150.0000,0.00,150.0000,158.0000,7.5000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 07:23:03'),(1192,1193,1192,1192,2.0000,0.0000,150.0000,0.00,150.0000,158.0000,7.5000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1193,1194,1193,1193,2.0000,0.0000,150.0000,0.00,150.0000,158.0000,7.5000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1194,1195,1194,1194,16.0000,0.0000,29.0000,0.00,29.0000,30.0000,1.4500,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 04:54:24'),(1195,1196,1195,1195,16.0000,0.0000,16.0000,0.00,16.0000,17.0000,0.8000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1196,1197,1196,1196,16.0000,0.0000,16.0000,0.00,16.0000,17.0000,0.8000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1197,1198,1197,1197,16.0000,0.0000,20.0000,0.00,20.0000,21.0000,1.0000,4,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 10:34:21'),(1198,1199,1198,1198,16.0000,0.0000,24.0000,0.00,24.0000,25.0000,1.2000,4,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-02 03:20:50'),(1199,1200,1199,1199,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:35:34','2025-02-01 21:35:34'),(1200,1201,1200,1200,2.0000,0.0000,97.0000,0.00,97.0000,114.0000,17.4600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1201,1202,1201,1201,1.0000,0.0000,127.0000,0.00,127.0000,150.0000,22.8600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:10','2025-02-02 03:23:29'),(1202,1203,1202,1202,3.0000,0.0000,82.0000,0.00,82.0000,96.0000,14.7600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1203,1204,1203,1203,3.0000,0.0000,36.0000,0.00,36.0000,43.0000,6.4800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:10','2025-02-02 06:30:51'),(1204,1205,1204,1204,2.0000,0.0000,79.0000,0.00,79.0000,93.0000,14.2200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:10','2025-02-02 03:35:58'),(1205,1206,1205,1205,1.0000,0.0000,202.0000,0.00,202.0000,239.0000,36.3600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:10','2025-02-02 06:52:44'),(1206,1207,1206,1206,2.0000,0.0000,120.0000,0.00,120.0000,141.0000,21.6000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:10','2025-02-01 21:48:10'),(1207,1208,1207,1207,2.0000,0.0000,97.0000,0.00,97.0000,114.0000,17.4600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1208,1209,1208,1208,2.0000,0.0000,97.0000,0.00,97.0000,114.0000,17.4600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1209,1210,1209,1209,1.0000,0.0000,109.0000,0.00,109.0000,128.0000,19.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1210,1211,1210,1210,2.0000,0.0000,82.0000,0.00,82.0000,96.0000,14.7600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1211,1212,1211,1211,2.0000,0.0000,72.0000,0.00,72.0000,86.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1212,1213,1212,1212,2.0000,0.0000,87.0000,0.00,87.0000,103.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1213,1214,1213,1213,1.0000,0.0000,132.0000,0.00,132.0000,156.0000,23.7600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1214,1215,1214,1214,1.0000,0.0000,188.0000,0.00,188.0000,222.0000,33.8400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1215,1216,1215,1215,4.0000,0.0000,59.0000,0.00,59.0000,69.0000,10.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1216,1217,1216,1216,4.0000,0.0000,26.0000,0.00,26.0000,31.0000,4.6800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1217,1218,1217,1217,2.0000,0.0000,85.0000,0.00,85.0000,100.0000,15.3000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1218,1219,1218,1218,6.0000,0.0000,59.0000,0.00,59.0000,70.0000,10.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1219,1220,1219,1219,6.0000,0.0000,34.0000,0.00,34.0000,40.0000,6.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1220,1221,1220,1220,3.0000,0.0000,95.0000,0.00,95.0000,112.0000,17.1000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1221,1222,1221,1221,2.0000,0.0000,71.0000,0.00,71.0000,84.0000,12.7800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1222,1223,1222,1222,1.0000,0.0000,174.0000,0.00,174.0000,205.0000,31.3200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1223,1224,1223,1223,2.0000,0.0000,130.0000,0.00,130.0000,153.0000,23.4000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1224,1225,1224,1224,2.0000,0.0000,70.0000,0.00,70.0000,83.0000,12.6000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1225,1226,1225,1225,6.0000,0.0000,56.0000,0.00,56.0000,66.0000,10.0800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1226,1227,1226,1226,1.0000,0.0000,208.0000,0.00,208.0000,246.0000,37.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1227,1228,1227,1227,1.0000,0.0000,246.0000,0.00,246.0000,290.0000,44.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1228,1229,1228,1228,20.0000,0.0000,17.0000,0.00,17.0000,20.0000,3.0600,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-02 04:41:06'),(1229,1230,1229,1229,12.0000,0.0000,15.0000,0.00,15.0000,18.0000,2.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1230,1231,1230,1230,6.0000,0.0000,36.0000,0.00,36.0000,42.0000,6.4800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1231,1232,1231,1231,3.0000,0.0000,74.0000,0.00,74.0000,87.0000,13.3200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1232,1233,1232,1232,2.0000,0.0000,123.0000,0.00,123.0000,145.0000,22.1400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1233,1234,1233,1233,8.0000,0.0000,66.0000,0.00,66.0000,78.0000,11.8800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1234,1235,1234,1234,6.0000,0.0000,81.0000,0.00,81.0000,81.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1235,1236,1235,1235,1.0000,0.0000,333.0000,0.00,333.0000,333.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1236,1237,1236,1236,3.0000,0.0000,176.0000,0.00,176.0000,176.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-02 06:46:12'),(1237,1238,1237,1237,6.0000,0.0000,63.0000,0.00,63.0000,63.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1238,1239,1238,1238,1.0000,0.0000,307.0000,0.00,307.0000,307.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1239,1240,1239,1239,3.0000,0.0000,158.0000,0.00,158.0000,158.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1240,1241,1240,1240,1.0000,0.0000,345.0000,0.00,345.0000,345.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1241,1242,1241,1241,6.0000,0.0000,81.0000,0.00,81.0000,81.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1242,1243,1242,1242,2.0000,0.0000,371.0000,0.00,371.0000,371.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1243,1244,1243,1243,2.0000,0.0000,279.0000,0.00,279.0000,279.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1244,1245,1244,1244,3.0000,0.0000,171.0000,0.00,171.0000,171.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1245,1246,1245,1245,6.0000,0.0000,59.0000,0.00,59.0000,59.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-02 06:46:12'),(1246,1247,1246,1246,1.0000,0.0000,257.0000,0.00,257.0000,257.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1247,1248,1247,1247,3.0000,0.0000,158.0000,0.00,158.0000,158.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1248,1249,1248,1248,1.0000,0.0000,469.0000,0.00,469.0000,469.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1249,1250,1249,1249,2.0000,0.0000,307.0000,0.00,307.0000,307.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1250,1251,1250,1250,6.0000,0.0000,123.0000,0.00,123.0000,123.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1251,1252,1251,1251,6.0000,0.0000,123.0000,0.00,123.0000,123.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1252,1253,1252,1252,2.0000,0.0000,277.0000,0.00,277.0000,277.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1253,1254,1253,1253,2.0000,0.0000,289.0000,0.00,289.0000,289.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1254,1255,1254,1254,4.0000,0.0000,132.0000,0.00,132.0000,132.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1255,1256,1255,1255,4.0000,0.0000,132.0000,0.00,132.0000,132.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1256,1257,1256,1256,2.0000,0.0000,289.0000,0.00,289.0000,289.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1257,1258,1257,1257,2.0000,0.0000,99.0000,0.00,99.0000,99.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1258,1259,1258,1258,6.0000,0.0000,90.0000,0.00,90.0000,90.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1259,1260,1259,1259,3.0000,0.0000,162.0000,0.00,162.0000,162.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1260,1261,1260,1260,6.0000,0.0000,99.0000,0.00,99.0000,99.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1261,1262,1261,1261,6.0000,0.0000,108.0000,0.00,108.0000,108.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1262,1263,1262,1262,6.0000,0.0000,97.0000,0.00,97.0000,97.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1263,1264,1263,1263,6.0000,0.0000,54.0000,0.00,54.0000,54.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1264,1265,1264,1264,2.0000,0.0000,231.0000,0.00,231.0000,231.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1265,1266,1265,1265,6.0000,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1266,1267,1266,1266,54.0000,0.0000,33.0000,0.00,33.0000,33.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-03 12:14:20'),(1267,1268,1267,1267,6.0000,0.0000,32.0000,0.00,32.0000,32.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-02 13:54:56'),(1268,1269,1268,1268,6.0000,0.0000,104.0000,0.00,104.0000,104.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-02 11:36:01'),(1269,1270,1269,1269,12.0000,0.0000,36.0000,0.00,36.0000,36.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1270,1271,1270,1270,24.0000,0.0000,41.0000,0.00,41.0000,41.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1271,1272,1271,1271,4.0000,0.0000,86.0000,0.00,86.0000,86.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:48:11','2025-02-01 21:48:11'),(1272,1273,1272,1272,24.0000,0.0000,26.0000,0.00,26.0000,26.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:19','2025-02-03 12:14:20'),(1273,1274,1273,1273,12.0000,0.0000,53.0000,0.00,53.0000,53.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1274,1275,1274,1274,5.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1275,1276,1275,1275,5.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1276,1277,1276,1276,10.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:19','2025-02-02 03:14:29'),(1277,1278,1277,1277,10.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:19','2025-02-01 21:54:19'),(1278,1279,1278,1278,5.0000,0.0000,12.0000,0.00,12.0000,12.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 12:17:28'),(1279,1280,1279,1279,20.0000,0.0000,41.0000,0.00,41.0000,41.0000,0.0000,NULL,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 14:19:18'),(1280,1281,1280,1280,5.0000,0.0000,34.0000,0.00,34.0000,34.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:40:58'),(1281,1282,1281,1281,3.0000,0.0000,42.0000,0.00,42.0000,42.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-03 12:14:20'),(1282,1283,1282,1282,20.0000,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:55:23'),(1283,1284,1283,1283,20.0000,0.0000,32.0000,0.00,32.0000,32.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 04:21:43'),(1284,1285,1284,1284,20.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1285,1286,1285,1285,20.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1286,1287,1286,1286,4.0000,0.0000,15.0000,0.00,15.0000,15.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1287,1288,1287,1287,5.0000,0.0000,23.0000,0.00,23.0000,23.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:14:29'),(1288,1289,1288,1288,10.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-03 12:14:20'),(1289,1290,1289,1289,5.0000,0.0000,27.0000,0.00,27.0000,27.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:40:58'),(1290,1291,1290,1290,10.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 09:19:28'),(1291,1292,1291,1291,10.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:55:23'),(1292,1293,1292,1292,10.0000,0.0000,35.0000,0.00,35.0000,35.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1293,1294,1293,1293,10.0000,0.0000,78.0000,0.00,78.0000,78.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1294,1295,1294,1294,10.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1295,1296,1295,1295,5.0000,0.0000,15.0000,0.00,15.0000,15.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1296,1297,1296,1296,3.0000,0.0000,22.0000,0.00,22.0000,22.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 05:04:03'),(1297,1298,1297,1297,30.0000,0.0000,12.0000,0.00,12.0000,12.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:40:58'),(1298,1299,1298,1298,30.0000,0.0000,20.0000,0.00,20.0000,20.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1299,1300,1299,1299,5.0000,0.0000,19.0000,0.00,19.0000,19.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 08:51:21'),(1300,1301,1300,1300,5.0000,0.0000,11.0000,0.00,11.0000,11.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 09:19:28'),(1301,1302,1301,1301,2.0000,0.0000,36.0000,0.00,36.0000,36.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-03 12:14:20'),(1302,1303,1302,1302,10.0000,0.0000,78.0000,0.00,78.0000,78.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 13:30:42'),(1303,1304,1303,1303,2.0000,0.0000,190.0000,0.00,190.0000,190.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1304,1305,1304,1304,20.0000,0.0000,35.0000,0.00,35.0000,35.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 04:21:43'),(1305,1306,1305,1305,3.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 05:25:21'),(1306,1307,1306,1306,9.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1307,1308,1307,1307,5.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1308,1309,1309,1309,10.0000,0.0000,16.0000,0.00,16.0000,16.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1309,1310,1310,1310,20.0000,0.0000,15.0000,0.00,15.0000,15.0000,0.0000,NULL,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-03 11:00:22'),(1310,1311,1311,1311,25.0000,0.0000,16.0000,0.00,16.0000,16.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 06:46:12'),(1311,1312,1312,1312,5.0000,0.0000,35.0000,0.00,35.0000,35.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1312,1313,1313,1313,2.0000,0.0000,15.0000,0.00,15.0000,15.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:45:25'),(1313,1314,1314,1314,15.0000,0.0000,15.0000,0.00,15.0000,15.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 05:25:21'),(1314,1315,1315,1315,5.0000,0.0000,19.0000,0.00,19.0000,19.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1315,1316,1316,1316,5.0000,0.0000,17.0000,0.00,17.0000,17.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 07:11:54'),(1316,1317,1317,1317,44.0000,0.0000,16.0000,0.00,16.0000,16.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1317,1318,1318,1318,10.0000,0.0000,80.0000,0.00,80.0000,80.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:55:23'),(1318,1319,1319,1319,10.0000,0.0000,36.0000,0.00,36.0000,36.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:55:23'),(1319,1320,1322,1322,12.0000,0.0000,42.0000,0.00,42.0000,42.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1320,1321,1323,1323,2.0000,0.0000,28.0000,0.00,28.0000,28.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1321,1322,1324,1324,2.0000,0.0000,48.0000,0.00,48.0000,48.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1322,1323,1325,1325,20.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1323,1324,1326,1326,6.0000,0.0000,23.0000,0.00,23.0000,23.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1324,1325,1327,1327,100.0000,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 11:07:58'),(1325,1326,1328,1328,10.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1326,1327,1329,1329,10.0000,0.0000,18.0000,0.00,18.0000,18.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:20:50'),(1327,1328,1330,1330,10.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:55:23'),(1328,1329,1331,1331,2.0000,0.0000,25.0000,0.00,25.0000,25.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1329,1330,1332,1332,10.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 11:01:13'),(1330,1331,1333,1333,10.0000,0.0000,72.0000,0.00,72.0000,72.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1331,1332,1334,1334,30.0000,0.0000,3.0000,0.00,3.0000,3.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1332,1333,1335,1335,6.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-03 08:38:25'),(1333,1334,1336,1336,12.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1334,1335,1337,1337,12.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1335,1336,1338,1338,10.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1336,1337,1339,1339,10.0000,0.0000,8.0000,0.00,8.0000,8.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 03:55:23'),(1337,1338,1340,1340,100.0000,0.0000,360.0000,0.00,360.0000,360.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1338,1339,1341,1341,30.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.0000,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 12:43:06'),(1339,1340,1342,1342,30.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1340,1341,1343,1343,10.0000,0.0000,7.0000,0.00,7.0000,7.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1341,1342,1344,1344,15.0000,0.0000,5.0000,0.00,5.0000,5.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 12:22:42'),(1342,1343,1345,1345,10.0000,0.0000,20.0000,0.00,20.0000,20.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-03 03:05:10'),(1343,1344,1346,1346,10.0000,0.0000,10.0000,0.00,10.0000,10.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1344,1345,1347,1347,10.0000,0.0000,10.0000,0.00,10.0000,10.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1345,1346,1348,1348,10.0000,0.0000,10.0000,0.00,10.0000,10.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-01 21:54:20'),(1346,1347,1349,1349,10.0000,0.0000,10.0000,0.00,10.0000,10.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 21:54:20','2025-02-02 13:47:31'),(1347,1348,1350,1350,25.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,13.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:11:34','2025-02-03 06:23:04'),(1348,1349,1351,1351,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:12:22','2025-02-03 12:14:20'),(1349,1350,1353,1353,6.0000,0.0000,40.0000,0.00,40.0000,47.0000,7.2000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1350,1351,1354,1354,6.0000,0.0000,77.0000,0.00,77.0000,91.0000,13.8600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 03:19:56'),(1351,1352,1355,1355,3.0000,0.0000,141.0000,0.00,141.0000,166.0000,25.3800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 07:54:33'),(1352,1353,1356,1356,6.0000,0.0000,77.0000,0.00,77.0000,91.0000,13.8600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1353,1354,1357,1357,3.0000,0.0000,147.0000,0.00,147.0000,174.0000,26.4600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1354,1355,1358,1358,6.0000,0.0000,77.0000,0.00,77.0000,91.0000,13.8600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1355,1356,1359,1359,3.0000,0.0000,134.0000,0.00,134.0000,158.0000,24.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1356,1357,1360,1360,3.0000,0.0000,94.0000,0.00,94.0000,111.0000,16.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1357,1358,1361,1361,3.0000,0.0000,97.0000,0.00,97.0000,115.0000,17.4600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1358,1359,1362,1362,6.0000,0.0000,64.0000,0.00,64.0000,75.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1359,1360,1363,1363,3.0000,0.0000,134.0000,0.00,134.0000,158.0000,24.1200,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 04:54:06'),(1360,1361,1364,1364,6.0000,0.0000,76.0000,0.00,76.0000,85.0000,9.1200,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1361,1362,1365,1365,6.0000,0.0000,37.0000,0.00,37.0000,41.0000,4.4400,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1362,1363,1366,1366,6.0000,0.0000,65.0000,0.00,65.0000,73.0000,7.8000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1363,1364,1367,1367,3.0000,0.0000,153.0000,0.00,153.0000,171.0000,18.3600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1364,1365,1368,1368,12.0000,0.0000,44.0000,0.00,44.0000,51.0000,7.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1365,1366,1369,1369,12.0000,0.0000,46.0000,0.00,46.0000,54.0000,8.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1366,1367,1370,1370,12.0000,0.0000,44.0000,0.00,44.0000,51.0000,7.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1367,1368,1371,1371,12.0000,0.0000,44.0000,0.00,44.0000,51.0000,7.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 00:37:36'),(1368,1369,1372,1372,12.0000,0.0000,64.0000,0.00,64.0000,75.0000,11.5200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:36','2025-02-02 07:54:33'),(1369,1370,1373,1373,12.0000,0.0000,64.0000,0.00,64.0000,75.0000,11.5200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:37','2025-02-02 03:08:33'),(1370,1371,1374,1374,12.0000,0.0000,64.0000,0.00,64.0000,75.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1371,1372,1375,1375,12.0000,0.0000,64.0000,0.00,64.0000,75.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1372,1373,1376,1376,2.0000,0.0000,185.0000,0.00,185.0000,218.3000,33.3000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:37','2025-02-03 06:06:08'),(1373,1374,1377,1377,2.0000,0.0000,319.0000,0.00,319.0000,376.0000,57.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1374,1375,1378,1378,1.0000,0.0000,456.0000,0.00,456.0000,538.0000,82.0800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1375,1376,1379,1379,10.0000,0.0000,20.0000,0.00,20.0000,22.0000,2.4000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1376,1377,1380,1380,10.0000,0.0000,17.0000,0.00,17.0000,19.0000,2.0400,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1377,1378,1381,1381,10.0000,0.0000,14.0000,0.00,14.0000,16.0000,1.6800,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:37:37','2025-02-02 00:37:37'),(1378,1379,1382,1382,3.0000,0.0000,48.0000,0.00,48.0000,56.0000,8.6400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1379,1380,1383,1383,3.0000,0.0000,91.0000,0.00,91.0000,108.0000,16.3800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1380,1381,1384,1384,3.0000,0.0000,51.0000,0.00,51.0000,60.0000,9.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1381,1382,1385,1385,3.0000,0.0000,95.0000,0.00,95.0000,112.0000,17.1000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1382,1383,1386,1386,6.0000,0.0000,57.0000,0.00,57.0000,67.0000,10.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1383,1384,1387,1387,6.0000,0.0000,51.0000,0.00,51.0000,61.0000,9.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1384,1385,1388,1388,6.0000,0.0000,30.0000,0.00,30.0000,34.0000,3.6000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1385,1386,1389,1389,6.0000,0.0000,56.0000,0.00,56.0000,63.0000,6.7200,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1386,1387,1390,1390,6.0000,0.0000,120.0000,0.00,120.0000,135.0000,14.4000,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 06:05:24'),(1387,1388,1391,1391,3.0000,0.0000,110.0000,0.00,110.0000,129.0000,19.8000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1388,1389,1392,1392,3.0000,0.0000,49.0000,0.00,49.0000,58.0000,8.8200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1389,1390,1393,1393,3.0000,0.0000,84.0000,0.00,84.0000,99.0000,15.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1390,1391,1394,1394,3.0000,0.0000,62.0000,0.00,62.0000,73.0000,11.1600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1391,1392,1395,1395,2.0000,0.0000,216.0000,0.00,216.0000,255.0000,38.8800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1392,1393,1396,1396,2.0000,0.0000,116.0000,0.00,116.0000,137.0000,20.8800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1393,1394,1397,1397,2.0000,0.0000,256.0000,0.00,256.0000,302.0000,46.0800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1394,1395,1398,1398,1.0000,0.0000,108.0000,0.00,108.0000,128.0000,19.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1395,1396,1399,1399,1.0000,0.0000,253.0000,0.00,253.0000,298.0000,45.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1396,1397,1400,1400,12.0000,0.0000,29.0000,0.00,29.0000,35.0000,5.2200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1397,1398,1401,1401,12.0000,0.0000,43.0000,0.00,43.0000,51.0000,7.7400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1398,1399,1402,1402,3.0000,0.0000,64.0000,0.00,64.0000,76.0000,11.5200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1399,1400,1403,1403,3.0000,0.0000,113.0000,0.00,113.0000,133.0000,20.3400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1400,1401,1404,1404,1.0000,0.0000,200.0000,0.00,200.0000,236.0000,36.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1401,1402,1405,1405,3.0000,0.0000,41.0000,0.00,41.0000,49.0000,7.3800,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 13:41:49'),(1402,1403,1406,1406,3.0000,0.0000,75.0000,0.00,75.0000,88.0000,13.5000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1403,1404,1407,1407,3.0000,0.0000,38.0000,0.00,38.0000,45.0000,6.8400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1404,1405,1408,1408,3.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:44:59','2025-02-02 00:44:59'),(1405,1406,1409,1409,6.0000,0.0000,62.0000,0.00,62.0000,73.0000,11.1600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1406,1407,1410,1410,3.0000,0.0000,65.0000,0.00,65.0000,77.0000,11.7000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 04:45:23'),(1407,1408,1411,1411,3.0000,0.0000,109.0000,0.00,109.0000,128.0000,19.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1408,1409,1412,1412,3.0000,0.0000,80.0000,0.00,80.0000,94.0000,14.4000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1409,1410,1413,1413,3.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1410,1411,1414,1414,3.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1411,1412,1415,1415,3.0000,0.0000,65.0000,0.00,65.0000,77.0000,11.7000,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 04:41:06'),(1412,1413,1416,1416,3.0000,0.0000,65.0000,0.00,65.0000,77.0000,11.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1413,1414,1417,1417,3.0000,0.0000,83.0000,0.00,83.0000,98.0000,14.9400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 06:05:24'),(1414,1415,1418,1418,3.0000,0.0000,83.0000,0.00,83.0000,98.0000,14.9400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1415,1416,1419,1419,6.0000,0.0000,40.0000,0.00,40.0000,47.0000,7.2000,11,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 08:34:37'),(1416,1417,1420,1420,6.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1417,1418,1421,1421,3.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1418,1419,1422,1422,3.0000,0.0000,48.0000,0.00,48.0000,56.0000,8.6400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1419,1420,1423,1423,18.0000,0.0000,14.0000,0.00,14.0000,17.0000,2.5200,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 14:16:09'),(1420,1421,1424,1424,6.0000,0.0000,43.0000,0.00,43.0000,50.0000,7.7400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1421,1422,1425,1425,6.0000,0.0000,47.0000,0.00,47.0000,56.0000,8.4600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1422,1423,1426,1426,6.0000,0.0000,43.0000,0.00,43.0000,50.0000,7.7400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1423,1424,1427,1427,3.0000,0.0000,128.0000,0.00,128.0000,151.0000,23.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1424,1425,1428,1428,3.0000,0.0000,72.0000,0.00,72.0000,85.0000,12.9600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1425,1426,1429,1429,12.0000,0.0000,28.0000,0.00,28.0000,32.0000,5.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1426,1427,1430,1430,12.0000,0.0000,28.0000,0.00,28.0000,32.0000,5.0400,11,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-03 12:14:20'),(1427,1428,1431,1431,12.0000,0.0000,28.0000,0.00,28.0000,32.0000,5.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1428,1429,1432,1432,12.0000,0.0000,28.0000,0.00,28.0000,32.0000,5.0400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-03 12:14:20'),(1429,1430,1433,1433,6.0000,0.0000,46.0000,0.00,46.0000,55.0000,8.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1430,1431,1434,1434,6.0000,0.0000,46.0000,0.00,46.0000,55.0000,8.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1431,1432,1435,1435,6.0000,0.0000,46.0000,0.00,46.0000,55.0000,8.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1432,1433,1436,1436,6.0000,0.0000,46.0000,0.00,46.0000,55.0000,8.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1433,1434,1437,1437,3.0000,0.0000,54.0000,0.00,54.0000,63.0000,9.7200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1434,1435,1438,1438,3.0000,0.0000,49.0000,0.00,49.0000,57.0000,8.8200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1435,1436,1439,1439,3.0000,0.0000,49.0000,0.00,49.0000,57.0000,8.8200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1436,1437,1440,1440,3.0000,0.0000,119.0000,0.00,119.0000,141.0000,21.4200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1437,1438,1441,1441,3.0000,0.0000,116.0000,0.00,116.0000,137.0000,20.8800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1438,1439,1442,1442,12.0000,0.0000,11.0000,0.00,11.0000,13.0000,1.9800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1439,1440,1443,1443,6.0000,0.0000,15.0000,0.00,15.0000,17.0000,2.7000,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 13:41:49'),(1440,1441,1444,1444,4.0000,0.0000,65.0000,0.00,65.0000,77.0000,11.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1441,1442,1445,1445,4.0000,0.0000,65.0000,0.00,65.0000,77.0000,11.7000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 04:21:43'),(1442,1443,1446,1446,4.0000,0.0000,65.0000,0.00,65.0000,77.0000,11.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1443,1444,1447,1447,4.0000,0.0000,65.0000,0.00,65.0000,77.0000,11.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 00:58:02','2025-02-02 00:58:02'),(1444,1445,1448,1448,6.0000,0.0000,64.0000,0.00,64.0000,71.0000,7.6800,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1445,1446,1449,1449,3.0000,0.0000,115.0000,0.00,115.0000,129.0000,13.8000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1446,1447,1450,1450,3.0000,0.0000,29.0000,0.00,29.0000,33.0000,3.4800,8,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 04:41:06'),(1447,1448,1451,1451,3.0000,0.0000,56.0000,0.00,56.0000,62.0000,6.7200,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1448,1449,1452,1452,6.0000,0.0000,38.0000,0.00,38.0000,43.0000,4.5600,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 03:03:42'),(1449,1450,1453,1453,3.0000,0.0000,68.0000,0.00,68.0000,76.0000,8.1600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1450,1451,1454,1454,3.0000,0.0000,95.0000,0.00,95.0000,107.0000,11.4000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1451,1452,1455,1455,3.0000,0.0000,33.0000,0.00,33.0000,37.0000,3.9600,8,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 13:47:31'),(1452,1453,1456,1456,3.0000,0.0000,59.0000,0.00,59.0000,66.0000,7.0800,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1453,1454,1457,1457,6.0000,0.0000,39.0000,0.00,39.0000,46.0000,7.0200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1454,1455,1458,1458,3.0000,0.0000,70.0000,0.00,70.0000,83.0000,12.6000,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-03 10:57:02'),(1455,1456,1459,1459,6.0000,0.0000,18.0000,0.00,18.0000,21.0000,3.2400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1456,1457,1460,1460,3.0000,0.0000,46.0000,0.00,46.0000,54.0000,8.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1457,1458,1461,1461,3.0000,0.0000,70.0000,0.00,70.0000,82.0000,12.6000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1458,1459,1462,1462,3.0000,0.0000,80.0000,0.00,80.0000,95.0000,14.4000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1459,1460,1463,1463,3.0000,0.0000,49.0000,0.00,49.0000,57.0000,8.8200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1460,1461,1464,1464,10.0000,0.0000,34.0000,0.00,34.0000,40.0000,6.1200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1461,1462,1465,1465,3.0000,0.0000,87.0000,0.00,87.0000,102.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1462,1463,1466,1466,3.0000,0.0000,165.0000,0.00,165.0000,195.0000,29.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1463,1464,1467,1467,3.0000,0.0000,75.0000,0.00,75.0000,88.0000,13.5000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1464,1465,1468,1468,3.0000,0.0000,121.0000,0.00,121.0000,143.0000,21.7800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1465,1466,1469,1469,3.0000,0.0000,121.0000,0.00,121.0000,143.0000,21.7800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1466,1467,1470,1470,2.0000,0.0000,133.0000,0.00,133.0000,157.0000,23.9400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1467,1468,1471,1471,2.0000,0.0000,133.0000,0.00,133.0000,157.0000,23.9400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1468,1469,1472,1472,2.0000,0.0000,133.0000,0.00,133.0000,157.0000,23.9400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1469,1470,1473,1473,3.0000,0.0000,44.0000,0.00,44.0000,52.0000,7.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1470,1471,1474,1474,3.0000,0.0000,44.0000,0.00,44.0000,52.0000,7.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:39','2025-02-02 01:18:39'),(1471,1472,1475,1475,3.0000,0.0000,44.0000,0.00,44.0000,52.0000,7.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1472,1473,1476,1476,3.0000,0.0000,44.0000,0.00,44.0000,52.0000,7.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1473,1474,1477,1477,3.0000,0.0000,103.0000,0.00,103.0000,121.0000,18.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1474,1475,1478,1478,3.0000,0.0000,103.0000,0.00,103.0000,121.0000,18.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1475,1476,1479,1479,3.0000,0.0000,103.0000,0.00,103.0000,121.0000,18.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1476,1477,1480,1480,3.0000,0.0000,103.0000,0.00,103.0000,121.0000,18.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1477,1478,1481,1481,3.0000,0.0000,96.0000,0.00,96.0000,113.0000,17.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1478,1479,1482,1482,3.0000,0.0000,103.0000,0.00,103.0000,121.0000,18.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1479,1480,1483,1483,3.0000,0.0000,103.0000,0.00,103.0000,121.5400,18.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-03 09:15:09'),(1480,1481,1484,1484,6.0000,0.0000,87.0000,0.00,87.0000,103.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1481,1482,1485,1485,6.0000,0.0000,174.0000,0.00,174.0000,205.0000,31.3200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1482,1483,1486,1486,20.0000,0.0000,127.0000,0.00,127.0000,150.0000,22.8600,11,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 11:36:01'),(1483,1484,1487,1487,6.0000,0.0000,57.0000,0.00,57.0000,67.0000,10.2600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1484,1485,1488,1488,3.0000,0.0000,109.0000,0.00,109.0000,129.0000,19.6200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1485,1486,1489,1489,3.0000,0.0000,60.0000,0.00,60.0000,71.0000,10.8000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1486,1487,1490,1490,3.0000,0.0000,102.0000,0.00,102.0000,120.0000,18.3600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1487,1488,1491,1491,2.0000,0.0000,225.0000,0.00,225.0000,266.0000,40.5000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1488,1489,1492,1492,6.0000,0.0000,33.0000,0.00,33.0000,39.0000,5.9400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1489,1490,1493,1493,6.0000,0.0000,62.0000,0.00,62.0000,73.0000,11.1600,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 05:17:08'),(1490,1491,1494,1494,6.0000,0.0000,60.0000,0.00,60.0000,71.0000,10.8000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1491,1492,1495,1495,6.0000,0.0000,60.0000,0.00,60.0000,71.0000,10.8000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1492,1493,1496,1496,2.0000,0.0000,140.0000,0.00,140.0000,165.0000,25.2000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1493,1494,1497,1497,2.0000,0.0000,140.0000,0.00,140.0000,165.0000,25.2000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1494,1495,1498,1498,2.0000,0.0000,140.0000,0.00,140.0000,165.0000,25.2000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1495,1496,1499,1499,2.0000,0.0000,140.0000,0.00,140.0000,165.0000,25.2000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1496,1497,1500,1500,2.0000,0.0000,140.0000,0.00,140.0000,165.0000,25.2000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1497,1498,1501,1501,2.0000,0.0000,140.0000,0.00,140.0000,165.0000,25.2000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1498,1499,1502,1502,6.0000,0.0000,49.0000,0.00,49.0000,58.0000,8.8200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 07:04:48'),(1499,1500,1503,1503,20.0000,0.0000,63.0000,0.00,63.0000,75.0000,11.3400,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 07:14:32'),(1500,1501,1504,1504,12.0000,0.0000,79.0000,0.00,79.0000,94.0000,14.2200,11,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 04:06:56'),(1501,1502,1505,1505,6.0000,0.0000,117.0000,0.00,117.0000,138.0000,21.0600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1502,1503,1506,1506,6.0000,0.0000,136.0000,0.00,136.0000,160.0000,24.4800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:18:40','2025-02-02 01:18:40'),(1503,1504,1507,1507,100.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,25.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 01:20:49','2025-02-03 03:05:10'),(1504,1517,1509,1509,20.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 03:08:19','2025-02-02 03:09:21'),(1505,1537,1510,1510,150.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,46.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 03:34:23','2025-02-03 11:50:47'),(1506,1545,1511,1511,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 03:47:01','2025-02-02 04:51:21'),(1507,1558,1512,1512,25.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:09:42','2025-02-02 04:21:43'),(1508,1559,1513,1513,1.0000,0.0000,35.0000,0.00,35.0000,35.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:11:17','2025-02-02 04:11:51'),(1509,1565,1516,1516,1.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:25:38','2025-02-02 04:25:38'),(1510,1566,1517,1517,2.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:26:06','2025-02-02 04:43:03'),(1511,1567,1518,1518,2.0000,0.0000,60.0000,0.00,60.0000,60.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:26:53','2025-02-02 04:28:47'),(1512,1569,1519,1519,15.0000,0.0000,25.0000,0.00,25.0000,25.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:27:36','2025-02-02 04:28:47'),(1513,1574,1520,1520,2.0000,0.0000,110.0000,0.00,110.0000,110.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:32:58','2025-02-02 04:32:58'),(1514,1578,1521,1521,1.0000,0.0000,110.0000,0.00,110.0000,110.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:41:48','2025-02-02 04:43:03'),(1515,1579,1522,1522,1.0000,0.0000,30.0000,0.00,30.0000,30.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:43:01','2025-02-02 04:43:03'),(1516,1584,1523,1523,3.0000,0.0000,21.0000,0.00,21.0000,21.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:45:56','2025-02-02 04:48:16'),(1517,1585,1524,1524,1.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:46:32','2025-02-02 04:48:16'),(1518,1590,1525,1525,50.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:52:56','2025-02-02 04:54:24'),(1519,1594,1526,1526,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:55:52','2025-02-02 13:04:47'),(1520,1596,1527,1527,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:58:01','2025-02-02 04:58:01'),(1521,1597,1528,1528,16.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 04:58:58','2025-02-02 04:58:58'),(1522,1600,1529,1529,1.0000,0.0000,60.0000,0.00,60.0000,60.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 05:03:56','2025-02-02 05:03:56'),(1523,1607,1530,1530,50.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 05:10:06','2025-02-02 06:44:12'),(1524,1611,1531,1531,1.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 05:16:03','2025-02-02 05:17:08'),(1525,1619,1532,1532,11.0000,0.0000,10.0000,0.00,10.0000,10.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 05:44:08','2025-02-02 13:41:49'),(1526,1625,1352,1352,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 06:05:23','2025-02-02 06:08:46'),(1527,1635,1533,1533,550.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 06:34:52','2025-02-03 03:03:20'),(1528,1660,1534,1534,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 07:59:37','2025-02-02 15:33:57'),(1529,1661,1535,1535,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 08:01:21','2025-02-02 15:33:57'),(1530,1674,1536,1536,11.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 09:03:57','2025-02-02 09:09:09'),(1531,1682,1537,1537,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 09:26:54','2025-02-02 13:47:31'),(1532,1686,1538,1538,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 09:38:59','2025-02-02 13:04:47'),(1533,1688,1539,1539,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 09:40:36','2025-02-02 11:55:48'),(1534,1689,1540,1540,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 09:41:44','2025-02-02 09:41:44'),(1535,1690,1541,1541,200.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 09:57:34','2025-02-02 12:06:07'),(1536,1698,1542,1542,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 10:51:55','2025-02-02 10:54:09'),(1537,1700,1543,1543,24.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 10:53:37','2025-02-02 11:37:28'),(1538,1706,1544,1544,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 11:19:42','2025-02-02 13:54:56'),(1539,1708,1545,1545,3.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 11:29:09','2025-02-02 14:35:25'),(1540,1712,1546,1546,7.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 11:55:01','2025-02-02 13:18:18'),(1541,1722,1547,1547,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 12:37:15','2025-02-02 15:44:20'),(1542,1724,1548,1548,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 12:41:00','2025-02-02 13:18:18'),(1543,1725,1549,1549,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 12:41:50','2025-02-02 12:43:06'),(1544,1727,1550,1550,25.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 12:42:30','2025-02-02 13:14:21'),(1545,1737,1551,1551,5.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 13:07:24','2025-02-02 13:07:58'),(1546,1743,1552,1552,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 13:15:44','2025-02-02 13:18:18'),(1547,1744,1553,1553,25.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 13:17:05','2025-02-02 13:18:18'),(1548,1745,1554,1554,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 13:18:10','2025-02-02 13:18:18'),(1549,1746,1555,1555,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 13:18:15','2025-02-02 13:18:15'),(1550,1748,1556,1556,100.0000,0.0000,6.0000,0.00,6.0000,6.0000,0.0000,NULL,NULL,56.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 13:30:23','2025-02-03 12:17:59'),(1551,1764,1557,1557,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 14:24:47','2025-02-02 14:24:47'),(1552,1765,1558,1558,3.0000,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 14:34:59','2025-02-02 14:35:25'),(1553,1768,1559,1559,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 14:46:56','2025-02-03 03:03:20'),(1554,1771,1560,1560,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-02 14:50:39','2025-02-02 14:50:39'),(1555,1795,848,848,20.0000,0.0000,138.0000,0.00,138.0000,138.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 05:00:32','2025-02-03 08:52:37'),(1556,1795,854,854,40.0000,0.0000,69.5000,0.00,70.0000,70.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 05:04:10','2025-02-03 05:07:01'),(1557,1800,1561,1561,2.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 06:11:26','2025-02-03 06:11:26'),(1558,1802,1562,1562,2.0000,0.0000,45.0000,0.00,45.0000,45.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 06:46:25','2025-02-03 06:46:25'),(1559,1803,1563,1563,3.0000,0.0000,115.0000,0.00,115.0000,115.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 06:55:40','2025-02-03 06:55:40'),(1560,1805,1564,1564,3.0000,0.0000,176.0000,0.00,176.0000,176.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:00:58','2025-02-03 07:00:58'),(1561,1806,1565,1565,6.0000,0.0000,3.0000,0.00,3.0000,3.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:04:40','2025-02-03 07:04:40'),(1562,1807,1566,1566,11.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:05:32','2025-02-03 07:05:32'),(1563,1808,1567,1567,10.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:11:06','2025-02-03 07:55:38'),(1564,1809,1568,1568,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:13:30','2025-02-03 07:13:30'),(1565,1810,1569,1569,2.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:15:05','2025-02-03 07:15:05'),(1566,1811,1570,1570,9.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:17:57','2025-02-03 07:17:57'),(1567,1812,1571,1571,5.0000,0.0000,36.0000,0.00,36.0000,36.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:23:43','2025-02-03 07:23:43'),(1568,1813,1572,1572,6.0000,0.0000,36.0000,0.00,36.0000,36.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:24:23','2025-02-03 07:24:23'),(1569,1814,1573,1573,24.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:25:47','2025-02-03 07:25:47'),(1570,1815,1574,1574,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 07:53:27','2025-02-03 07:55:38'),(1571,1817,1575,1575,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 08:23:48','2025-02-03 08:23:48'),(1572,1818,1576,1576,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 08:24:39','2025-02-03 08:24:39'),(1573,1819,1577,1577,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 08:25:03','2025-02-03 08:25:03'),(1574,1820,1578,1578,12.0000,0.0000,30.0000,0.00,30.0000,30.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 08:43:03','2025-02-03 08:45:53'),(1575,1823,1581,1581,3.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:36:31','2025-02-03 10:42:35'),(1576,1823,1579,1579,3.0000,0.0000,63.0000,0.00,63.0000,63.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:36:31','2025-02-03 10:42:35'),(1577,1823,1580,1580,3.0000,0.0000,99.0000,0.00,99.0000,99.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:36:31','2025-02-03 10:42:35'),(1578,1823,1582,1582,2.0000,0.0000,67.0000,0.00,67.0000,67.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:36:31','2025-02-03 10:42:35'),(1579,1823,1583,1583,1.0000,0.0000,88.0000,0.00,88.0000,88.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:45:07','2025-02-03 10:42:35'),(1580,1823,1584,1584,4.0000,0.0000,20.0000,0.00,20.0000,24.0000,4.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:47:54','2025-02-03 10:42:35'),(1581,1823,1585,1585,3.0000,0.0000,35.0000,0.00,35.0000,41.0000,6.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:49:41','2025-02-03 10:42:35'),(1582,1823,1586,1586,1.0000,0.0000,88.0000,0.00,88.0000,88.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:51:18','2025-02-03 10:42:35'),(1583,1825,1587,1587,8.0000,0.0000,18.0000,0.00,18.0000,18.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:55:58','2025-02-03 09:55:58'),(1584,1826,1588,1588,9.0000,0.0000,6.0000,0.00,6.0000,6.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:57:09','2025-02-03 09:57:09'),(1585,1827,1589,1589,1.0000,0.0000,3.0000,0.00,3.0000,3.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 09:57:56','2025-02-03 09:57:56'),(1586,1823,1590,1590,2.0000,0.0000,41.0000,0.00,41.0000,48.0000,7.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:00:03','2025-02-03 10:42:35'),(1587,1823,1591,1591,2.0000,0.0000,37.0000,0.00,37.0000,44.0000,7.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:06:48','2025-02-03 10:42:35'),(1588,1823,1592,1592,3.0000,0.0000,31.0000,0.00,31.0000,37.0000,6.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:06:48','2025-02-03 10:42:35'),(1589,1823,1592,1592,3.0000,0.0000,31.0000,0.00,31.0000,37.0000,6.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:35:25','2025-02-03 10:42:35'),(1590,1823,1593,1593,2.0000,0.0000,57.0000,0.00,57.0000,67.0000,10.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:35:25','2025-02-03 10:42:35'),(1591,1823,1594,1594,1.0000,0.0000,170.0000,0.00,170.0000,201.0000,31.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:35:25','2025-02-03 10:42:35'),(1592,1823,1595,1595,2.0000,0.0000,69.0000,0.00,69.0000,81.0000,12.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:35:25','2025-02-03 10:42:35'),(1593,1823,1596,1596,1.0000,0.0000,113.0000,0.00,113.0000,133.0000,20.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:39:06','2025-02-03 10:42:35'),(1594,1823,1597,1597,1.0000,0.0000,98.0000,0.00,98.0000,116.0000,18.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:39:06','2025-02-03 10:42:35'),(1595,1823,1598,1598,3.0000,0.0000,30.0000,0.00,30.0000,35.0000,5.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:39:06','2025-02-03 10:42:35'),(1596,1823,1599,1599,2.0000,0.0000,60.0000,0.00,60.0000,71.0000,11.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:42:35','2025-02-03 10:42:35'),(1597,1823,1600,1600,2.0000,0.0000,61.0000,0.00,61.0000,72.0000,11.0000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 10:42:35','2025-02-03 10:42:35'),(1598,1835,1601,1601,5.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 11:20:26','2025-02-03 11:20:26'),(1599,1837,1602,1602,50.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 12:07:34','2025-02-03 12:14:20'),(1600,1838,1603,1603,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 12:09:21','2025-02-03 12:14:20'),(1601,1839,1604,1604,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 12:11:21','2025-02-03 12:14:20'),(1602,1840,1605,1605,5.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-03 12:13:32','2025-02-03 12:13:32');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reference_counts_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',6,1,'2022-10-20 06:14:39','2025-02-03 09:25:36'),(2,'business_location',1,1,'2022-10-20 06:14:39','2024-02-27 06:54:11'),(3,'draft',4,1,'2025-01-29 14:36:17','2025-02-03 12:18:38'),(4,'sell_payment',274,1,'2025-02-02 01:30:54','2025-02-03 12:14:20'),(5,'purchase',2,1,'2025-02-03 05:00:32','2025-02-03 09:36:31'),(6,'purchase_payment',1,1,'2025-02-03 05:07:08','2025-02-03 05:07:08');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (3,3),(6,3),(27,3),(32,3),(36,3),(37,3),(38,3),(40,3),(41,3),(48,3),(49,3),(50,3),(81,3),(2,4),(3,4),(8,4),(10,4),(16,4),(25,4),(26,4),(27,4),(32,4),(36,4),(37,4),(38,4),(40,4),(41,4),(48,4),(49,4),(52,4),(53,4),(54,4),(59,4),(61,4),(67,4),(68,4),(69,4),(71,4),(72,4),(73,4),(75,4),(76,4),(77,4),(81,4),(87,4),(90,4),(91,4),(92,4),(93,4),(94,4),(95,4),(96,4),(97,4),(98,4),(99,4);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_service_staff` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(3,'Cashier#1','web',1,0,0,'2024-04-11 15:41:21','2024-04-11 15:41:21'),(4,'Sales Staff#1','web',1,0,0,'2024-04-16 07:15:55','2024-04-16 07:15:55');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int(11) NOT NULL,
  `warranty_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `business_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  KEY `stock_adjustment_lines_lot_no_line_id_index` (`lot_no_line_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
INSERT INTO `stock_adjustment_lines` VALUES (4,2104,2002,2002,1.7500,0.0000,90.0000,NULL,NULL,'2024-03-30 14:23:05','2024-03-30 14:23:05'),(9,2477,2018,2018,0.7000,0.0000,170.0000,NULL,NULL,'2024-04-08 08:08:20','2024-04-08 08:08:20'),(10,5986,2594,2594,5.0000,0.0000,22.0000,NULL,NULL,'2024-05-17 15:22:14','2024-05-17 15:22:14'),(11,8500,2594,2594,1.0000,0.0000,22.0000,NULL,NULL,'2024-06-16 12:00:53','2024-06-16 12:00:53'),(12,10348,2641,2641,3.0000,0.0000,30.0000,NULL,NULL,'2024-07-13 11:05:28','2024-07-13 11:05:28'),(13,10554,2594,2594,1.0000,0.0000,22.0000,NULL,NULL,'2024-07-15 15:11:52','2024-07-15 15:11:52'),(14,4,2,2,5.0000,0.0000,34.0000,NULL,NULL,'2025-01-24 14:20:47','2025-01-24 14:20:47'),(15,6,2,2,10.0000,0.0000,34.0000,NULL,NULL,'2025-01-24 14:41:16','2025-01-24 14:41:16');
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','4.7.8'),(2,'default_business_active_status','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `for_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
INSERT INTO `tax_rates` VALUES (1,1,'best',5.0000,0,0,1,'2022-11-19 14:17:46','2022-11-19 08:21:33','2022-11-19 14:17:46'),(2,1,'CGST 2.5%',2.5000,0,1,1,NULL,'2022-11-19 14:17:40','2024-02-27 05:07:18'),(3,1,'SGST 2.5%',2.5000,0,1,1,NULL,'2022-11-19 14:18:00','2024-02-27 05:07:37'),(4,1,'GST 5%',5.0000,1,0,1,NULL,'2022-11-19 14:18:27','2025-01-29 13:46:42'),(5,1,'IGST (5%)',5.0000,0,0,1,'2024-02-27 05:07:09','2022-11-19 14:19:20','2024-02-27 05:07:09'),(6,1,'CGST 6%',6.0000,0,1,1,NULL,'2022-11-23 16:26:14','2024-02-27 05:07:28'),(7,1,'SGST 6%',6.0000,0,1,1,NULL,'2022-11-23 16:26:25','2024-02-27 05:07:47'),(8,1,'GST 12%',12.0000,1,0,1,NULL,'2022-11-23 16:26:43','2025-01-29 14:06:05'),(9,1,'CGST 9%',9.0000,0,1,1,NULL,'2024-03-08 14:52:31','2024-03-08 14:52:31'),(10,1,'SGST 9%',9.0000,0,1,1,NULL,'2024-03-08 14:52:40','2024-03-08 14:52:40'),(11,1,'GST 18%',18.0000,1,0,1,NULL,'2024-03-08 14:52:53','2025-01-29 14:05:59'),(12,1,'cess',12.0000,0,1,1,NULL,'2024-04-15 09:28:49','2024-04-15 09:28:49'),(13,1,'CGST 14%',14.0000,0,1,1,NULL,'2024-04-15 09:30:45','2024-04-15 09:34:31'),(14,1,'SGST 14%',14.0000,0,1,1,NULL,'2024-04-15 09:30:56','2024-04-15 09:40:22'),(15,1,'CGST',14.0000,1,0,1,'2024-04-15 09:33:17','2024-04-15 09:31:31','2024-04-15 09:33:17'),(16,1,'GST 28%',28.0000,1,0,1,NULL,'2024-04-15 09:33:42','2025-01-29 14:05:52'),(17,1,'GST 0%',0.0000,0,0,1,NULL,'2024-11-08 13:30:19','2025-01-29 14:06:20');
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `return_transaction_id` int(11) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_transaction_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `paid_through_link` tinyint(1) NOT NULL DEFAULT '0',
  `gateway` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_advance` tinyint(1) NOT NULL DEFAULT '0',
  `payment_for` int(11) DEFAULT NULL COMMENT 'stores the contact id',
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  KEY `transaction_payments_payment_type_index` (`payment_type`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=276 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (1,1505,NULL,1,0,33.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 07:00:54',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0001',NULL,'2025-02-02 01:30:54','2025-02-02 01:31:44'),(2,1506,NULL,1,0,60.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:09:03',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0002',NULL,'2025-02-02 02:39:03','2025-02-02 02:39:03'),(3,1507,NULL,1,0,10.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:09:42',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0003',NULL,'2025-02-02 02:39:42','2025-02-02 02:39:42'),(4,1508,NULL,1,0,75.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:15:21',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0004',NULL,'2025-02-02 02:45:21','2025-02-02 02:45:21'),(5,1509,NULL,1,0,10.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:16:58',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0005',NULL,'2025-02-02 02:46:58','2025-02-02 02:46:58'),(6,1510,NULL,1,0,242.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:20:40',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0006',NULL,'2025-02-02 02:50:40','2025-02-02 02:50:40'),(7,1511,NULL,1,0,339.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:20:42',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0007',NULL,'2025-02-02 02:50:42','2025-02-02 02:50:42'),(8,1512,NULL,1,0,181.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:22:46',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0008',NULL,'2025-02-02 02:52:46','2025-02-02 02:52:46'),(9,1513,NULL,1,0,88.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:24:36',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0009',NULL,'2025-02-02 02:54:36','2025-02-02 02:54:36'),(10,1514,NULL,1,0,274.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:26:03',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0010',NULL,'2025-02-02 02:56:03','2025-02-02 02:56:03'),(11,1515,NULL,1,0,20.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:30:18',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0011',NULL,'2025-02-02 03:00:18','2025-02-02 03:00:18'),(12,1516,NULL,1,0,993.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:33:42',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0012',NULL,'2025-02-02 03:03:42','2025-02-02 03:03:42'),(13,1518,NULL,1,0,1610.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:38:32',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0013',NULL,'2025-02-02 03:08:32','2025-02-02 03:08:32'),(14,1519,NULL,1,0,692.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:39:21',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0014',NULL,'2025-02-02 03:09:21','2025-02-02 03:09:21'),(15,1520,NULL,1,0,564.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:44:29',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0015',NULL,'2025-02-02 03:14:29','2025-02-02 03:14:29'),(16,1521,NULL,1,0,55.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:46:09',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0016',NULL,'2025-02-02 03:16:09','2025-02-02 03:16:09'),(17,1522,NULL,1,0,55.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:47:26',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0017',NULL,'2025-02-02 03:17:26','2025-02-02 03:17:26'),(18,1523,NULL,1,0,1245.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:49:56',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0018',NULL,'2025-02-02 03:19:56','2025-02-02 03:19:56'),(19,1524,NULL,1,0,196.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:50:50',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0019',NULL,'2025-02-02 03:20:50','2025-02-02 03:20:50'),(20,1525,NULL,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:51:59',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0020',NULL,'2025-02-02 03:21:59','2025-02-02 03:21:59'),(21,1526,NULL,1,0,1531.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:53:29',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0021',NULL,'2025-02-02 03:23:29','2025-02-02 03:23:29'),(22,1527,NULL,1,0,334.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:53:54',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0022',NULL,'2025-02-02 03:23:54','2025-02-02 03:23:54'),(23,1528,NULL,1,0,306.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:54:16',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0023',NULL,'2025-02-02 03:24:16','2025-02-02 03:24:16'),(24,1529,NULL,1,0,22.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:54:42',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0024',NULL,'2025-02-02 03:24:42','2025-02-02 03:24:42'),(25,1530,NULL,1,0,765.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:58:19',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0025',NULL,'2025-02-02 03:28:19','2025-02-02 03:28:19'),(26,1531,NULL,1,0,646.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:58:21',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0026',NULL,'2025-02-02 03:28:21','2025-02-02 03:28:21'),(27,1532,NULL,1,0,543.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 08:59:46',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0027',NULL,'2025-02-02 03:29:46','2025-02-02 03:29:46'),(28,1533,NULL,1,0,161.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:00:53',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0028',NULL,'2025-02-02 03:30:53','2025-02-02 03:30:53'),(29,1534,NULL,1,0,240.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:01:21',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0029',NULL,'2025-02-02 03:31:21','2025-02-02 03:31:21'),(30,1535,NULL,1,0,457.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:02:06',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0030',NULL,'2025-02-02 03:32:06','2025-02-02 03:32:06'),(31,1536,NULL,1,0,329.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:02:31',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0031',NULL,'2025-02-02 03:32:31','2025-02-02 03:32:31'),(32,1538,NULL,1,0,1480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:04:48',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0032',NULL,'2025-02-02 03:34:48','2025-02-02 03:34:48'),(33,1539,NULL,1,0,421.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:05:58',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0033',NULL,'2025-02-02 03:35:58','2025-02-02 03:35:58'),(34,1540,NULL,1,0,1070.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:06:32',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0034',NULL,'2025-02-02 03:36:32','2025-02-02 03:36:32'),(35,1541,NULL,1,0,363.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:08:10',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0035',NULL,'2025-02-02 03:38:10','2025-02-02 03:38:10'),(36,1542,NULL,1,0,485.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:10:58',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0036',NULL,'2025-02-02 03:40:58','2025-02-02 03:40:58'),(37,1543,NULL,1,0,392.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:13:24',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0037',NULL,'2025-02-02 03:43:24','2025-02-02 03:43:24'),(38,1544,NULL,1,0,681.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:15:25',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0038',NULL,'2025-02-02 03:45:25','2025-02-02 03:45:25'),(39,1546,NULL,1,0,1884.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:17:22',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0039',NULL,'2025-02-02 03:47:22','2025-02-02 03:47:22'),(40,1547,NULL,1,0,873.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:19:18',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0040',NULL,'2025-02-02 03:49:18','2025-02-02 03:49:18'),(41,1548,NULL,1,0,2068.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:25:20',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0041',NULL,'2025-02-02 03:55:20','2025-02-02 03:55:20'),(42,1549,NULL,1,0,2298.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:25:23',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0042',NULL,'2025-02-02 03:55:23','2025-02-02 03:55:23'),(43,1550,NULL,1,0,654.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:27:25',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0043',NULL,'2025-02-02 03:57:25','2025-02-02 03:57:25'),(44,1551,NULL,1,0,178.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:29:12',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0044',NULL,'2025-02-02 03:59:12','2025-02-02 03:59:12'),(45,1552,NULL,1,0,1880.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:30:46',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0045',NULL,'2025-02-02 04:00:46','2025-02-02 04:00:46'),(46,1553,NULL,1,0,1139.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:31:22',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0046',NULL,'2025-02-02 04:01:22','2025-02-02 04:01:22'),(47,1554,NULL,1,0,147.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:33:57',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0047',NULL,'2025-02-02 04:03:57','2025-02-02 04:03:57'),(48,1555,NULL,1,0,657.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:36:19',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0048',NULL,'2025-02-02 04:06:19','2025-02-02 04:06:19'),(49,1556,NULL,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:36:56',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0049',NULL,'2025-02-02 04:06:56','2025-02-02 04:06:56'),(50,1556,NULL,1,0,596.0000,'card',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:36:56',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0050',NULL,'2025-02-02 04:06:56','2025-02-02 04:06:56'),(51,1557,NULL,1,0,47.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:38:44',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0051',NULL,'2025-02-02 04:08:44','2025-02-02 04:08:44'),(52,1560,NULL,1,0,167.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:41:51',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0052',NULL,'2025-02-02 04:11:51','2025-02-02 04:11:51'),(53,1561,NULL,1,0,400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:42:57',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0053',NULL,'2025-02-02 04:12:57','2025-02-02 04:12:57'),(54,1562,NULL,1,0,884.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:51:43',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0054',NULL,'2025-02-02 04:21:43','2025-02-02 04:21:43'),(55,1563,NULL,1,0,694.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:53:43',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0055',NULL,'2025-02-02 04:23:43','2025-02-02 04:23:43'),(56,1564,NULL,1,0,245.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:54:33',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0056',NULL,'2025-02-02 04:24:33','2025-02-02 04:24:33'),(57,1568,NULL,1,0,2169.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:57:27',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0057',NULL,'2025-02-02 04:27:27','2025-02-02 04:27:27'),(58,1570,NULL,1,0,1349.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:58:46',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0058',NULL,'2025-02-02 04:28:46','2025-02-02 04:28:46'),(59,1571,NULL,1,0,85.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 09:59:40',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0059',NULL,'2025-02-02 04:29:40','2025-02-02 04:29:40'),(60,1572,NULL,1,0,2610.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 10:01:06',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0060',NULL,'2025-02-02 04:31:06','2025-02-02 04:31:06'),(61,1573,NULL,1,0,558.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 10:01:44',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0061',NULL,'2025-02-02 04:31:44','2025-02-02 04:31:44'),(62,1575,NULL,1,0,1549.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 10:03:27',1,0,NULL,0,1,NULL,NULL