
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_details` text COLLATE utf8mb4_unicode_ci,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-01-29 13:54:00','2025-01-29 13:54:00'),(2,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-29 13:55:02','2025-01-29 13:55:02'),(3,'default','added',20,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":45}}','2025-01-29 14:36:17','2025-01-29 14:36:17'),(4,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-01-29 14:49:09','2025-01-29 14:49:09'),(5,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-29 15:31:22','2025-01-29 15:31:22'),(6,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-30 02:05:34','2025-01-30 02:05:34'),(7,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-01-30 02:05:49','2025-01-30 02:05:49'),(8,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-30 06:46:09','2025-01-30 06:46:09'),(9,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-30 10:50:53','2025-01-30 10:50:53'),(10,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-30 11:25:08','2025-01-30 11:25:08'),(11,'default','logout',1,'App\\User',1,1,'App\\User','[]','2025-01-30 11:25:19','2025-01-30 11:25:19'),(12,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-31 07:18:33','2025-01-31 07:18:33'),(13,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-31 08:28:48','2025-01-31 08:28:48'),(14,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-01-31 18:07:06','2025-01-31 18:07:06'),(15,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 02:57:27','2025-02-01 02:57:27'),(16,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 05:11:46','2025-02-01 05:11:46'),(17,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 05:12:13','2025-02-01 05:12:13'),(18,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 05:28:25','2025-02-01 05:28:25'),(19,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 09:42:39','2025-02-01 09:42:39'),(20,'default','login',1,'App\\User',1,1,'App\\User','[]','2025-02-01 12:32:18','2025-02-01 12:32:18');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 00:43:44','2017-12-18 00:43:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 00:34:39','2017-12-18 00:40:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 00:25:40','2017-12-18 00:25:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 00:28:40','2017-12-18 00:28:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10'),(7,'2 nd 2 Lable Print',NULL,1.9685,0.9448,3.9960,0.0000,0.0000,0.0000,0.0000,0.0000,2,0,1,28,1,'2022-11-23 11:09:36','2024-03-16 07:45:33'),(8,'2X3',NULL,1.3779,0.9800,4.3307,0.0000,0.0000,0.0000,0.0000,0.0000,3,1,1,28,1,'2024-03-16 07:45:28','2025-01-24 14:25:48');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'Sakthi Masala',NULL,1,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(2,1,'Cavinkare',NULL,1,NULL,'2025-02-01 11:15:55','2025-02-01 11:15:55');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `weighing_scale_setting` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT '0',
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT '2',
  `quantity_precision` tinyint(4) NOT NULL DEFAULT '2',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text COLLATE utf8mb4_unicode_ci,
  `sms_settings` text COLLATE utf8mb4_unicode_ci,
  `custom_labels` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'SVM SMART HYPER MARKET',53,'2025-01-24',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00,1,'Asia/Kolkata',4,'lifo',0.00,'includes','1708173603_logo1 (1).png','202500',1,'add_manufacturing','stop_selling',7,1,0,NULL,1.000,180,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":\"1\",\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"hide_product_suggestion\":\"1\",\"show_pricing_on_product_sugesstion\":\"1\",\"cash_denominations\":\"500,200,100,50,20,10,5,2,1\",\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',0,0,0,1,1,0,1,0,0,0,1,1,NULL,1,1,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','d-m-Y','12',0,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}','blue-light',NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":\"G-PAY\",\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":\"Product Discount\",\"custom_field_2\":\"Size\",\"custom_field_3\":\"Design\",\"custom_field_4\":\"HSN CODE\"},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"enable_secondary_unit\":\"1\",\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2022-10-20 06:14:39','2025-01-29 09:33:40');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured_products` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `default_payment_accounts` text COLLATE utf8mb4_unicode_ci,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'0001','SVM SMART HYPER MARKET','NEAR TMB BANK, THARAMANGALAM MAIN ROAD, OMALUR','INDIA','TAMILNADU','SALEM','636455',1,1,1,0,1,'browser',NULL,'9566211543',NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"cheque\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,'2022-10-20 06:14:39','2025-01-24 13:45:39');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pay_method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_card_slips` int(11) NOT NULL DEFAULT '0',
  `total_cheques` int(11) NOT NULL DEFAULT '0',
  `denominations` text COLLATE utf8mb4_unicode_ci,
  `closing_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2025-01-29 13:55:00','2025-01-29 13:55:10');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Chocolet',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(2,'Masala & Flour',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `middle_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_line_1` text COLLATE utf8mb4_unicode_ci,
  `address_line_2` text COLLATE utf8mb4_unicode_ci,
  `zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_rp` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `shipping_address` text COLLATE utf8mb4_unicode_ci,
  `shipping_custom_field_details` longtext COLLATE utf8mb4_unicode_ci,
  `is_export` tinyint(1) NOT NULL DEFAULT '0',
  `export_custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_6` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field6` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field7` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field8` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field9` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field10` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-20 06:14:39','2023-09-26 15:48:20');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `spg` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
INSERT INTO `group_sub_taxes` VALUES (4,2),(4,3),(8,6),(8,7),(11,9),(11,10),(15,13),(16,13),(16,14);
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `round_off_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_time_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `show_lot` tinyint(1) NOT NULL DEFAULT '0',
  `show_image` tinyint(1) NOT NULL DEFAULT '0',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commission_agent_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT '0',
  `show_reward_point` tinyint(1) NOT NULL DEFAULT '0',
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `module_info` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int(10) unsigned NOT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT '0',
  `qr_code_fields` text COLLATE utf8mb4_unicode_ci,
  `design` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text COLLATE utf8mb4_unicode_ci,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT '0',
  `prev_bal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `change_return_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `contact_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `location_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Bill No',NULL,'BILL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Total','Your Saving Amt','Tax','Net Amount','Round Off',NULL,NULL,0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,'Billed By',1,'Item','Qty','MRP','Amt',NULL,'1709016977_1708939915_logo.png',0,0,1,1,1,0,1,0,1,1,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','<p style=\"text-align: center;\"><strong style=\"text-align: center;\"><strong>!!!நன்றி மீண்டும் வருக!!!</strong></strong></p>',NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":\"Disc\",\"discounted_unit_price_label\":null,\"total_items_label\":\"Total Qty\",\"num_to_word_format\":\"international\",\"tax_summary_label\":\"Tax Details\"}',1,1,0,NULL,'slim','Return Inv No','Return No','Return Total Amount',NULL,0,NULL,NULL,NULL,NULL,NULL,'2022-10-20 06:14:39','2025-01-24 14:00:09');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT '0',
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'SVM SMART HYPER MARKET','blank','',1,0,4,1,'2022-10-20 06:14:39','2025-01-29 13:49:08');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_media_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
INSERT INTO `media` VALUES (2,1,'1708173548_1426502851_logo1 (1).png',NULL,1,'App\\User',NULL,1,'2024-02-17 12:39:08','2024-02-17 12:39:08');
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (80,'App\\User',1),(83,'App\\User',2),(82,'App\\User',3);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(3,'App\\User',2),(4,'App\\User',3);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci,
  `sms_body` text COLLATE utf8mb4_unicode_ci,
  `whatsapp_text` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bcc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2022-10-20 06:14:39','2022-10-20 06:14:39');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
INSERT INTO `password_resets` VALUES ('ARKTRADERS9981@GMAIL.COM','$2y$10$fDS8/9VzR/QVJdq9E9ZA3.IbPKkZLlpFN4Ne1ectboox5eoDUMIm.','2024-04-16 11:18:27');
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2022-10-20 06:12:40',NULL),(2,'direct_sell.access','web','2022-10-20 06:12:40',NULL),(3,'product.opening_stock','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(4,'crud_all_bookings','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(5,'crud_own_bookings','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(6,'access_default_selling_price','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(7,'purchase.payments','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(8,'sell.payments','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(9,'edit_product_price_from_sale_screen','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(10,'edit_product_discount_from_sale_screen','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(11,'roles.view','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(12,'roles.create','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(13,'roles.update','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(14,'roles.delete','web','2022-10-20 06:12:40','2022-10-20 06:12:40'),(15,'account.access','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(16,'discount.access','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(17,'view_purchase_price','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(18,'view_own_sell_only','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(19,'edit_product_discount_from_pos_screen','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(20,'edit_product_price_from_pos_screen','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(21,'access_shipping','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(22,'purchase.update_status','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(23,'list_drafts','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(24,'list_quotations','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(25,'view_cash_register','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(26,'close_cash_register','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(27,'print_invoice','web','2022-10-20 06:12:41','2022-10-20 06:12:41'),(28,'user.view','web','2022-10-20 06:12:41',NULL),(29,'user.create','web','2022-10-20 06:12:41',NULL),(30,'user.update','web','2022-10-20 06:12:41',NULL),(31,'user.delete','web','2022-10-20 06:12:41',NULL),(32,'supplier.view','web','2022-10-20 06:12:41',NULL),(33,'supplier.create','web','2022-10-20 06:12:41',NULL),(34,'supplier.update','web','2022-10-20 06:12:41',NULL),(35,'supplier.delete','web','2022-10-20 06:12:41',NULL),(36,'customer.view','web','2022-10-20 06:12:41',NULL),(37,'customer.create','web','2022-10-20 06:12:41',NULL),(38,'customer.update','web','2022-10-20 06:12:41',NULL),(39,'customer.delete','web','2022-10-20 06:12:41',NULL),(40,'product.view','web','2022-10-20 06:12:41',NULL),(41,'product.create','web','2022-10-20 06:12:41',NULL),(42,'product.update','web','2022-10-20 06:12:41',NULL),(43,'product.delete','web','2022-10-20 06:12:41',NULL),(44,'purchase.view','web','2022-10-20 06:12:41',NULL),(45,'purchase.create','web','2022-10-20 06:12:41',NULL),(46,'purchase.update','web','2022-10-20 06:12:41',NULL),(47,'purchase.delete','web','2022-10-20 06:12:41',NULL),(48,'sell.view','web','2022-10-20 06:12:41',NULL),(49,'sell.create','web','2022-10-20 06:12:41',NULL),(50,'sell.update','web','2022-10-20 06:12:41',NULL),(51,'sell.delete','web','2022-10-20 06:12:41',NULL),(52,'purchase_n_sell_report.view','web','2022-10-20 06:12:41',NULL),(53,'contacts_report.view','web','2022-10-20 06:12:41',NULL),(54,'stock_report.view','web','2022-10-20 06:12:41',NULL),(55,'tax_report.view','web','2022-10-20 06:12:41',NULL),(56,'trending_product_report.view','web','2022-10-20 06:12:41',NULL),(57,'register_report.view','web','2022-10-20 06:12:41',NULL),(58,'sales_representative.view','web','2022-10-20 06:12:41',NULL),(59,'expense_report.view','web','2022-10-20 06:12:41',NULL),(60,'business_settings.access','web','2022-10-20 06:12:41',NULL),(61,'barcode_settings.access','web','2022-10-20 06:12:41',NULL),(62,'invoice_settings.access','web','2022-10-20 06:12:41',NULL),(63,'brand.view','web','2022-10-20 06:12:41',NULL),(64,'brand.create','web','2022-10-20 06:12:41',NULL),(65,'brand.update','web','2022-10-20 06:12:41',NULL),(66,'brand.delete','web','2022-10-20 06:12:41',NULL),(67,'tax_rate.view','web','2022-10-20 06:12:41',NULL),(68,'tax_rate.create','web','2022-10-20 06:12:41',NULL),(69,'tax_rate.update','web','2022-10-20 06:12:41',NULL),(70,'tax_rate.delete','web','2022-10-20 06:12:41',NULL),(71,'unit.view','web','2022-10-20 06:12:41',NULL),(72,'unit.create','web','2022-10-20 06:12:41',NULL),(73,'unit.update','web','2022-10-20 06:12:41',NULL),(74,'unit.delete','web','2022-10-20 06:12:41',NULL),(75,'category.view','web','2022-10-20 06:12:41',NULL),(76,'category.create','web','2022-10-20 06:12:41',NULL),(77,'category.update','web','2022-10-20 06:12:41',NULL),(78,'category.delete','web','2022-10-20 06:12:41',NULL),(79,'expense.access','web','2022-10-20 06:12:41',NULL),(80,'access_all_locations','web','2022-10-20 06:12:41',NULL),(81,'dashboard.data','web','2022-10-20 06:12:41',NULL),(82,'location.1','web','2022-10-20 06:14:39','2022-10-20 06:14:39'),(83,'location.2','web','2023-01-26 07:31:07','2023-01-26 07:31:07'),(84,'location.3','web','2023-10-14 11:19:44','2023-10-14 11:19:44'),(85,'location.4','web','2024-02-27 06:54:11','2024-02-27 06:54:11'),(86,'view_product_stock_value','web','2024-03-21 12:30:38','2024-03-21 12:30:38'),(87,'expense.add','web','2024-03-21 12:30:38','2024-03-21 12:30:38'),(88,'view_own_expense','web','2024-03-21 12:30:38','2024-03-21 12:30:38'),(89,'expense.edit','web','2024-04-16 07:15:55','2024-04-16 07:15:55'),(90,'customer_irrespective_of_sell','web','2024-04-16 07:15:55','2024-04-16 07:15:55'),(91,'direct_sell.view','web','2024-04-16 07:15:55','2024-04-16 07:15:55'),(92,'all_expense.access','web','2024-04-16 07:15:55','2024-04-16 07:15:55'),(93,'view_paid_sells_only','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(94,'view_due_sells_only','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(95,'view_partial_sells_only','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(96,'view_overdue_sells_only','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(97,'direct_sell.update','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(98,'edit_sell_payment','web','2024-04-16 07:18:14','2024-04-16 07:18:14'),(99,'access_printers','web','2024-04-16 09:24:59','2024-04-16 09:24:59');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
INSERT INTO `printers` VALUES (1,1,'TVS RECEIPT PRINTER','windows','default','60','','','COM1',1,'2022-10-20 16:02:33','2022-11-19 10:44:22');
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(93,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(126,1),(127,1),(128,1),(129,1),(130,1),(131,1),(132,1),(133,1),(134,1),(135,1),(136,1),(137,1),(138,1),(139,1),(140,1),(141,1),(142,1),(143,1),(144,1),(145,1),(146,1),(147,1),(148,1),(149,1),(150,1),(151,1),(152,1),(153,1),(154,1),(155,1),(156,1),(157,1),(158,1),(159,1),(160,1),(161,1),(162,1),(163,1),(164,1),(165,1),(166,1),(167,1),(168,1),(169,1),(170,1),(171,1),(172,1),(173,1),(174,1),(175,1),(176,1),(177,1),(178,1),(179,1),(180,1),(181,1),(182,1),(183,1),(184,1),(185,1),(186,1),(187,1),(188,1),(189,1),(190,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(201,1),(202,1),(203,1),(204,1),(205,1),(206,1),(207,1),(208,1),(209,1),(210,1),(211,1),(212,1),(213,1),(214,1),(215,1),(216,1),(217,1),(218,1),(219,1),(220,1),(221,1),(222,1),(223,1),(224,1),(225,1),(226,1),(227,1),(228,1),(229,1),(230,1);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
INSERT INTO `product_racks` VALUES (1,1,1,19,NULL,NULL,NULL,'2025-01-29 13:57:37','2025-01-29 13:57:37'),(2,1,1,8,NULL,NULL,NULL,'2025-01-29 14:35:38','2025-01-29 14:35:38'),(3,1,1,65,NULL,NULL,NULL,'2025-01-31 10:15:01','2025-01-31 10:17:37'),(4,1,1,66,NULL,NULL,NULL,'2025-01-31 10:15:53','2025-01-31 10:18:04'),(5,1,1,60,NULL,NULL,NULL,'2025-01-31 10:44:49','2025-01-31 10:44:49'),(6,1,1,61,NULL,NULL,NULL,'2025-01-31 10:45:15','2025-01-31 10:45:15'),(7,1,1,64,NULL,NULL,NULL,'2025-01-31 10:47:22','2025-01-31 10:47:22'),(8,1,1,62,NULL,NULL,NULL,'2025-01-31 10:47:47','2025-01-31 10:47:47'),(9,1,1,63,NULL,NULL,NULL,'2025-01-31 10:48:16','2025-01-31 10:48:16'),(10,1,1,25,NULL,NULL,NULL,'2025-01-31 10:51:40','2025-01-31 10:51:40'),(11,1,1,23,NULL,NULL,NULL,'2025-01-31 10:52:33','2025-01-31 10:52:33'),(12,1,1,24,NULL,NULL,NULL,'2025-01-31 10:53:10','2025-01-31 10:53:10'),(13,1,1,67,NULL,NULL,NULL,'2025-01-31 12:20:16','2025-01-31 12:20:16'),(14,1,1,68,NULL,NULL,NULL,'2025-01-31 12:21:22','2025-01-31 12:21:22'),(15,1,1,69,NULL,NULL,NULL,'2025-01-31 12:22:00','2025-01-31 12:22:00'),(16,1,1,70,NULL,NULL,NULL,'2025-01-31 13:19:44','2025-01-31 18:08:25'),(17,1,1,71,NULL,NULL,NULL,'2025-01-31 13:20:58','2025-01-31 18:09:36'),(18,1,1,72,NULL,NULL,NULL,'2025-01-31 13:23:57','2025-01-31 18:09:01'),(19,1,1,73,NULL,NULL,NULL,'2025-01-31 13:53:28','2025-01-31 13:53:28'),(20,1,1,74,NULL,NULL,NULL,'2025-01-31 13:54:22','2025-01-31 13:54:22'),(21,1,1,75,NULL,NULL,NULL,'2025-01-31 13:56:19','2025-01-31 13:56:19'),(22,1,1,76,NULL,NULL,NULL,'2025-01-31 13:56:53','2025-01-31 13:56:53'),(23,1,1,77,NULL,NULL,NULL,'2025-01-31 13:58:58','2025-01-31 13:58:58'),(24,1,1,78,NULL,NULL,NULL,'2025-01-31 13:59:27','2025-01-31 13:59:27'),(25,1,1,79,NULL,NULL,NULL,'2025-01-31 14:03:12','2025-01-31 14:03:12'),(26,1,1,80,NULL,NULL,NULL,'2025-01-31 14:03:52','2025-01-31 14:03:52'),(27,1,1,81,NULL,NULL,NULL,'2025-01-31 14:06:31','2025-01-31 14:06:31'),(28,1,1,82,NULL,NULL,NULL,'2025-01-31 14:07:21','2025-01-31 14:07:21'),(29,1,1,56,NULL,NULL,NULL,'2025-01-31 14:51:28','2025-01-31 14:51:28'),(30,1,1,54,NULL,NULL,NULL,'2025-01-31 14:51:53','2025-01-31 14:51:53'),(31,1,1,55,NULL,NULL,NULL,'2025-01-31 14:52:43','2025-01-31 14:52:43'),(32,1,1,39,NULL,NULL,NULL,'2025-01-31 14:57:59','2025-01-31 14:57:59'),(33,1,1,40,NULL,NULL,NULL,'2025-01-31 14:58:23','2025-01-31 14:58:23'),(34,1,1,41,NULL,NULL,NULL,'2025-01-31 14:58:50','2025-01-31 14:58:50'),(35,1,1,42,NULL,NULL,NULL,'2025-01-31 15:07:14','2025-01-31 15:07:14'),(36,1,1,43,NULL,NULL,NULL,'2025-01-31 15:07:36','2025-01-31 15:07:36'),(37,1,1,44,NULL,NULL,NULL,'2025-01-31 15:08:19','2025-01-31 15:08:19'),(38,1,1,45,NULL,NULL,NULL,'2025-01-31 15:09:12','2025-01-31 15:09:12'),(39,1,1,31,NULL,NULL,NULL,'2025-01-31 15:19:29','2025-01-31 15:19:29'),(40,1,1,30,NULL,NULL,NULL,'2025-01-31 15:19:46','2025-01-31 15:19:46'),(41,1,1,46,NULL,NULL,NULL,'2025-01-31 15:21:36','2025-01-31 15:21:36'),(42,1,1,47,NULL,NULL,NULL,'2025-01-31 15:22:10','2025-01-31 15:22:10'),(43,1,1,83,NULL,NULL,NULL,'2025-02-01 06:58:51','2025-02-01 09:46:43'),(44,1,1,84,NULL,NULL,NULL,'2025-02-01 06:59:23','2025-02-01 09:48:58'),(45,1,1,85,NULL,NULL,NULL,'2025-02-01 07:00:12','2025-02-01 09:47:50'),(46,1,1,86,NULL,NULL,NULL,'2025-02-01 07:00:36','2025-02-01 09:48:22'),(47,1,1,87,NULL,NULL,NULL,'2025-02-01 07:00:56','2025-02-01 09:47:11'),(48,1,1,88,NULL,NULL,NULL,'2025-02-01 07:01:16','2025-02-01 09:49:29'),(49,1,1,21,NULL,NULL,NULL,'2025-02-01 09:52:12','2025-02-01 09:52:12'),(50,1,1,22,NULL,NULL,NULL,'2025-02-01 09:52:35','2025-02-01 09:52:35'),(51,1,1,20,NULL,NULL,NULL,'2025-02-01 09:52:56','2025-02-01 09:52:56'),(52,1,1,29,NULL,NULL,NULL,'2025-02-01 09:53:27','2025-02-01 09:53:27'),(53,1,1,26,NULL,NULL,NULL,'2025-02-01 09:54:00','2025-02-01 09:54:00'),(54,1,1,27,NULL,NULL,NULL,'2025-02-01 09:54:25','2025-02-01 09:54:25'),(55,1,1,28,NULL,NULL,NULL,'2025-02-01 09:54:50','2025-02-01 09:54:50'),(56,1,1,95,NULL,NULL,NULL,'2025-02-01 10:10:32','2025-02-01 10:10:32'),(57,1,1,229,NULL,NULL,NULL,'2025-02-01 12:36:21','2025-02-01 12:36:21'),(58,1,1,230,NULL,NULL,NULL,'2025-02-01 12:37:28','2025-02-01 12:37:28');
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(2,NULL,'DUMMY',2,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(3,NULL,'DUMMY',3,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(4,NULL,'DUMMY',4,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(5,NULL,'DUMMY',5,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(6,NULL,'DUMMY',6,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(7,NULL,'DUMMY',7,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(8,NULL,'DUMMY',8,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(9,NULL,'DUMMY',9,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(10,NULL,'DUMMY',10,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(11,NULL,'DUMMY',11,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(12,NULL,'DUMMY',12,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(13,NULL,'DUMMY',13,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(14,NULL,'DUMMY',14,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(15,NULL,'DUMMY',15,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(16,NULL,'DUMMY',16,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(17,NULL,'DUMMY',17,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(18,NULL,'DUMMY',18,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(19,NULL,'DUMMY',19,1,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(20,NULL,'DUMMY',20,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(21,NULL,'DUMMY',21,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(22,NULL,'DUMMY',22,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(23,NULL,'DUMMY',23,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(24,NULL,'DUMMY',24,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(25,NULL,'DUMMY',25,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(26,NULL,'DUMMY',26,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(27,NULL,'DUMMY',27,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(28,NULL,'DUMMY',28,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(29,NULL,'DUMMY',29,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(30,NULL,'DUMMY',30,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(31,NULL,'DUMMY',31,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(32,NULL,'DUMMY',32,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(33,NULL,'DUMMY',33,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(34,NULL,'DUMMY',34,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(35,NULL,'DUMMY',35,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(36,NULL,'DUMMY',36,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(37,NULL,'DUMMY',37,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(38,NULL,'DUMMY',38,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(39,NULL,'DUMMY',39,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(40,NULL,'DUMMY',40,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(41,NULL,'DUMMY',41,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(42,NULL,'DUMMY',42,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(43,NULL,'DUMMY',43,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(44,NULL,'DUMMY',44,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(45,NULL,'DUMMY',45,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(46,NULL,'DUMMY',46,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(47,NULL,'DUMMY',47,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(48,NULL,'DUMMY',48,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(49,NULL,'DUMMY',49,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(50,NULL,'DUMMY',50,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(51,NULL,'DUMMY',51,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(52,NULL,'DUMMY',52,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(53,NULL,'DUMMY',53,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(54,NULL,'DUMMY',54,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(55,NULL,'DUMMY',55,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(56,NULL,'DUMMY',56,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(57,NULL,'DUMMY',57,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(58,NULL,'DUMMY',58,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(59,NULL,'DUMMY',59,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(60,NULL,'DUMMY',60,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(61,NULL,'DUMMY',61,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(62,NULL,'DUMMY',62,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(63,NULL,'DUMMY',63,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(64,NULL,'DUMMY',64,1,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(65,NULL,'DUMMY',65,1,'2025-01-31 10:15:01','2025-01-31 10:15:01'),(66,NULL,'DUMMY',66,1,'2025-01-31 10:15:53','2025-01-31 10:15:53'),(67,NULL,'DUMMY',67,1,'2025-01-31 12:20:16','2025-01-31 12:20:16'),(68,NULL,'DUMMY',68,1,'2025-01-31 12:21:22','2025-01-31 12:21:22'),(69,NULL,'DUMMY',69,1,'2025-01-31 12:22:00','2025-01-31 12:22:00'),(70,NULL,'DUMMY',70,1,'2025-01-31 13:19:44','2025-01-31 13:19:44'),(71,NULL,'DUMMY',71,1,'2025-01-31 13:20:58','2025-01-31 13:20:58'),(72,NULL,'DUMMY',72,1,'2025-01-31 13:23:57','2025-01-31 13:23:57'),(73,NULL,'DUMMY',73,1,'2025-01-31 13:53:28','2025-01-31 13:53:28'),(74,NULL,'DUMMY',74,1,'2025-01-31 13:54:22','2025-01-31 13:54:22'),(75,NULL,'DUMMY',75,1,'2025-01-31 13:56:19','2025-01-31 13:56:19'),(76,NULL,'DUMMY',76,1,'2025-01-31 13:56:53','2025-01-31 13:56:53'),(77,NULL,'DUMMY',77,1,'2025-01-31 13:58:58','2025-01-31 13:58:58'),(78,NULL,'DUMMY',78,1,'2025-01-31 13:59:27','2025-01-31 13:59:27'),(79,NULL,'DUMMY',79,1,'2025-01-31 14:03:12','2025-01-31 14:03:12'),(80,NULL,'DUMMY',80,1,'2025-01-31 14:03:52','2025-01-31 14:03:52'),(81,NULL,'DUMMY',81,1,'2025-01-31 14:06:31','2025-01-31 14:06:31'),(82,NULL,'DUMMY',82,1,'2025-01-31 14:07:21','2025-01-31 14:07:21'),(83,NULL,'DUMMY',83,1,'2025-02-01 06:58:51','2025-02-01 06:58:51'),(84,NULL,'DUMMY',84,1,'2025-02-01 06:59:23','2025-02-01 06:59:23'),(85,NULL,'DUMMY',85,1,'2025-02-01 07:00:12','2025-02-01 07:00:12'),(86,NULL,'DUMMY',86,1,'2025-02-01 07:00:36','2025-02-01 07:00:36'),(87,NULL,'DUMMY',87,1,'2025-02-01 07:00:56','2025-02-01 07:00:56'),(88,NULL,'DUMMY',88,1,'2025-02-01 07:01:16','2025-02-01 07:01:16'),(140,NULL,'DUMMY',140,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(141,NULL,'DUMMY',141,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(142,NULL,'DUMMY',142,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(143,NULL,'DUMMY',143,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(144,NULL,'DUMMY',144,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(145,NULL,'DUMMY',145,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(146,NULL,'DUMMY',146,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(147,NULL,'DUMMY',147,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(148,NULL,'DUMMY',148,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(149,NULL,'DUMMY',149,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(150,NULL,'DUMMY',150,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(151,NULL,'DUMMY',151,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(152,NULL,'DUMMY',152,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(153,NULL,'DUMMY',153,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(154,NULL,'DUMMY',154,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(155,NULL,'DUMMY',155,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(156,NULL,'DUMMY',156,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(157,NULL,'DUMMY',157,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(158,NULL,'DUMMY',158,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(159,NULL,'DUMMY',159,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(160,NULL,'DUMMY',160,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(161,NULL,'DUMMY',161,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(162,NULL,'DUMMY',162,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(163,NULL,'DUMMY',163,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(164,NULL,'DUMMY',164,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(165,NULL,'DUMMY',165,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(166,NULL,'DUMMY',166,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(167,NULL,'DUMMY',167,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(168,NULL,'DUMMY',168,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(169,NULL,'DUMMY',169,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(170,NULL,'DUMMY',170,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(171,NULL,'DUMMY',171,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(172,NULL,'DUMMY',172,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(173,NULL,'DUMMY',173,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(174,NULL,'DUMMY',174,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(175,NULL,'DUMMY',175,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(176,NULL,'DUMMY',176,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(177,NULL,'DUMMY',177,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(178,NULL,'DUMMY',178,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(179,NULL,'DUMMY',179,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(180,NULL,'DUMMY',180,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(181,NULL,'DUMMY',181,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(182,NULL,'DUMMY',182,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(183,NULL,'DUMMY',183,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(184,NULL,'DUMMY',184,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(185,NULL,'DUMMY',185,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(186,NULL,'DUMMY',186,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(187,NULL,'DUMMY',187,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(188,NULL,'DUMMY',188,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(189,NULL,'DUMMY',189,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(190,NULL,'DUMMY',190,1,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(191,NULL,'DUMMY',191,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(192,NULL,'DUMMY',192,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(193,NULL,'DUMMY',193,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(194,NULL,'DUMMY',194,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(195,NULL,'DUMMY',195,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(196,NULL,'DUMMY',196,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(197,NULL,'DUMMY',197,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(198,NULL,'DUMMY',198,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(199,NULL,'DUMMY',199,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(200,NULL,'DUMMY',200,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(201,NULL,'DUMMY',201,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(202,NULL,'DUMMY',202,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(203,NULL,'DUMMY',203,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(204,NULL,'DUMMY',204,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(205,NULL,'DUMMY',205,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(206,NULL,'DUMMY',206,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(207,NULL,'DUMMY',207,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(208,NULL,'DUMMY',208,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(209,NULL,'DUMMY',209,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(210,NULL,'DUMMY',210,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(211,NULL,'DUMMY',211,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(212,NULL,'DUMMY',212,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(213,NULL,'DUMMY',213,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(214,NULL,'DUMMY',214,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(215,NULL,'DUMMY',215,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(216,NULL,'DUMMY',216,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(217,NULL,'DUMMY',217,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(218,NULL,'DUMMY',218,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(219,NULL,'DUMMY',219,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(220,NULL,'DUMMY',220,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(221,NULL,'DUMMY',221,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(222,NULL,'DUMMY',222,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(223,NULL,'DUMMY',223,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(224,NULL,'DUMMY',224,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(225,NULL,'DUMMY',225,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(226,NULL,'DUMMY',226,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(227,NULL,'DUMMY',227,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(228,NULL,'DUMMY',228,1,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(229,NULL,'DUMMY',229,1,'2025-02-01 12:36:21','2025-02-01 12:36:21'),(230,NULL,'DUMMY',230,1,'2025-02-01 12:37:28','2025-02-01 12:37:28');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text COLLATE utf8mb4_unicode_ci,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT '0',
  `not_for_selling` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'CAD.FIVE STAR MRP 5',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202238826','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(2,'CAD.FIVE STAR MRP 10',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202216145','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(3,'CAD.FIVE STAR MRP 20',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201808037','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(4,'CAD.DAIRYMILK MRP 10',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202272592','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(5,'CAD.DAIRYMILK MRP 20',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202272622','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(6,'CAD.DAIRYMILK MRP 45',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202245541','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(7,'CAD.DAIRYMILK MRP 100',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201762056','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(8,'CAD. ROAST ALMOND MRP 50',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201150143','C128',NULL,NULL,0,'percentage',NULL,NULL,NULL,'18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 14:35:38'),(9,'CAD. LOLLY MRP 5',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201463434','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(10,'CAD. GEMS MRP 10',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202216718','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(11,'CAD. SHOTS MRP 5',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202250521','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(12,'CAD. GEMS BALL MRP 50',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201726218','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(13,'CAD. DAIRYMILK LICKABLES MRP 45',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202020650','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(14,'CAD. OREO VANNILA MRP 10',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202225512','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(15,'CAD. OREO RED VELVET MRP 20',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622202252518','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(16,'CAD. OREO VANNILA MRP 30',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201757212','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(17,'CAD. CHOCOBAKES MRP 40',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'7622201385088','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(18,'MALKIST CHOCO MRP 50',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'8996001312490','C128',NULL,NULL,0,'','','','','18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(19,'MALKIST CHEESE MRP 50',1,'single',1,NULL,NULL,NULL,1,NULL,4,'inclusive',1,0.0000,'8996001312506','C128',NULL,NULL,0,'fixed','0',NULL,NULL,'18069010','',NULL,1,NULL,0,0,'2025-01-29 13:57:02','2025-01-29 13:57:37'),(20,'50g Seeragam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000020','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:52:56'),(21,'100g Seeragam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000021','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:52:12'),(22,'200g Seeragam',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000022','C128',NULL,NULL,0,'fixed','8',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:52:35'),(23,'200g Big V.Sundal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000023','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:52:33'),(24,'500g Big V.Sundal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000024','C128',NULL,NULL,0,'fixed','8',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:53:10'),(25,'1 Kg Big V.Sundal',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000025','C128',NULL,NULL,0,'fixed','17',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:51:40'),(26,'100g Pachai Pattani',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000026','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:54:00'),(27,'200g Pachai Pattani',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000027','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:54:25'),(28,'500g Pachai Pattani',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000028','C128',NULL,NULL,0,'fixed','10',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:54:50'),(29,'1 Kg Pachai Pattani',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000029','C128',NULL,NULL,0,'fixed','22',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-02-01 09:53:27'),(30,'50g Dry Grapes',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000030','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:19:46'),(31,'100g Dry Grapes',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000031','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:19:29'),(32,'Ulundhu 100g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000032','C128',NULL,NULL,0,'fixed','2','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(33,'Ulundhu 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000033','C128',NULL,NULL,0,'fixed','3','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(34,'Ulundhu 500g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000034','C128',NULL,NULL,0,'fixed','7','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(35,'Ulundhu 1Kg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000035','C128',NULL,NULL,0,'fixed','15','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(36,'Thuvaram Parupu 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000036','C128',NULL,NULL,0,'fixed','3','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(37,'Thuvaram Parupu 500g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000037','C128',NULL,NULL,0,'fixed','7','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(38,'Thuvaram Parupu 1Kg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000038','C128',NULL,NULL,0,'fixed','16','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(39,'100g Black Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000039','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:57:59'),(40,'200g Black Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000040','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:58:23'),(41,'250g Black Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000041','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:58:50'),(42,'100g Avara Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000042','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:07:14'),(43,'200g Avara Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000043','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:07:36'),(44,'250g Avara Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000044','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:08:19'),(45,'500g Avara Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000045','C128',NULL,NULL,0,'fixed','9',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:09:12'),(46,'200g Red Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000046','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:21:36'),(47,'500g Red Beans',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000047','C128',NULL,NULL,0,'fixed','7',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 15:22:10'),(48,'Kadala Parupu 50g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000048','C128',NULL,NULL,0,'fixed','1','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(49,'Kadala Parupu 100g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000049','C128',NULL,NULL,0,'fixed','1','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(50,'Kadala Parupu 200g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000050','C128',NULL,NULL,0,'fixed','2','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(51,'Kadala Parupu 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000051','C128',NULL,NULL,0,'fixed','2','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(52,'Kadala Parupu 500g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000052','C128',NULL,NULL,0,'fixed','4','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(53,'Kadala Parupu 1Kg',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000053','C128',NULL,NULL,0,'fixed','10','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(54,'250g Vella Sundal Small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000054','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:51:53'),(55,'500g vella Sundal Small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000055','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:52:43'),(56,'1Kg Vella Sundal Small',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000056','C128',NULL,NULL,0,'fixed','11',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 14:51:28'),(57,'Soya Beans Small 50g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000057','C128',NULL,NULL,0,'fixed','1','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(58,'Soya Beans Small 100g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000058','C128',NULL,NULL,0,'fixed','1','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(59,'Soya Beans Small 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000059','C128',NULL,NULL,0,'fixed','2','','','','',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(60,'250g M.Samba',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000060','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:44:49'),(61,'500g M.Samba',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000061','C128',NULL,NULL,0,'fixed','15',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:45:15'),(62,'250g P.Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000062','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:47:47'),(63,'500g P.Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000063','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:48:16'),(64,'1Kg P.Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,0.0000,'2025000064','C128',NULL,NULL,0,'fixed','12',NULL,NULL,NULL,'',NULL,1,NULL,0,0,'2025-01-31 08:32:13','2025-01-31 10:47:22'),(65,'P.Kadalai 250g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000065','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 10:15:01','2025-01-31 10:17:37'),(66,'P.Kadalai 500g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000066','C128',NULL,NULL,0,'fixed','6',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 10:15:53','2025-01-31 10:18:04'),(67,'250g Pasi Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000067','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 12:20:16','2025-01-31 12:20:16'),(68,'500g Pasi Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000068','C128',NULL,NULL,0,'fixed','6',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 12:21:22','2025-01-31 12:21:22'),(69,'1 Kg Pasi Parupu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000069','C128',NULL,NULL,0,'fixed','12',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 12:22:00','2025-01-31 12:22:00'),(70,'1 Kg Thatta Payaru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000070','C128',NULL,NULL,0,'fixed','12',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:19:44','2025-01-31 18:08:25'),(71,'500g Thatta Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000071','C128',NULL,NULL,0,'fixed','6',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:20:58','2025-01-31 18:09:36'),(72,'250g Thatta Payiru',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000072','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:23:57','2025-01-31 18:09:01'),(73,'250g Saamai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000073','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:53:28','2025-01-31 13:53:28'),(74,'500g Saamai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000074','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:54:22','2025-01-31 13:54:22'),(75,'250g Kuthiraivali',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000075','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:56:19','2025-01-31 13:56:19'),(76,'500g Kuthiraivali',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000076','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:56:53','2025-01-31 13:56:53'),(77,'250g Varagu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000077','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:58:58','2025-01-31 13:58:58'),(78,'500g varagu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000078','C128',NULL,NULL,0,'fixed','5',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 13:59:27','2025-01-31 13:59:27'),(79,'250g Thinai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000079','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 14:03:12','2025-01-31 14:03:12'),(80,'500g Thinai',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000080','C128',NULL,NULL,0,'fixed','8',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 14:03:52','2025-01-31 14:03:52'),(81,'500g Sivapu Arisi',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000081','C128',NULL,NULL,0,'fixed','2',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 14:06:30','2025-01-31 14:06:31'),(82,'250g Sivapu arisi',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000082','C128',NULL,NULL,0,'fixed','1',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-01-31 14:07:21','2025-01-31 14:07:21'),(83,'Boondi Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000083','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 06:58:51','2025-02-01 09:46:43'),(84,'Poondu Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000084','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 06:59:23','2025-02-01 09:48:58'),(85,'Kaaram Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000085','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 07:00:12','2025-02-01 09:47:50'),(86,'Mixer Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000086','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 07:00:36','2025-02-01 09:48:22'),(87,'Dal Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000087','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 07:00:56','2025-02-01 09:47:11'),(88,'Sev Snacks',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000088','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 07:01:16','2025-02-01 09:49:29'),(140,'Turmeric powder 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080014','C128',NULL,NULL,0,'fixed','10','','','9103030','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(141,'Turmeric powder 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080021','C128',NULL,NULL,0,'fixed','19','','','9103030','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(142,'Tumeric powder 200G',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080038','C128',NULL,NULL,0,'fixed','30','','','9103030','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(143,'Tumeric powder 500G',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080045','C128',NULL,NULL,0,'fixed','77','','','9103030','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(144,'Corriander Powder 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080212','C128',NULL,NULL,0,'fixed','7','','','9092200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(145,'Corriander Powder 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080229','C128',NULL,NULL,0,'fixed','12','','','9092200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(146,'Corriander Powder 200GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080236','C128',NULL,NULL,0,'fixed','27','','','9092200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(147,'Corriander Powder 500GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080243','C128',NULL,NULL,0,'fixed','68','','','9092200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(148,'Chilli powder 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080113','C128',NULL,NULL,0,'fixed','16','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(149,'Chilli powder 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080120','C128',NULL,NULL,0,'fixed','32','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(150,'Chilli powder 200GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080137','C128',NULL,NULL,0,'fixed','63','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(151,'Chilli powder 500GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080144','C128',NULL,NULL,0,'fixed','135','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(152,'Curry masla 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080410','C128',NULL,NULL,0,'fixed','14','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(153,'Curry masla 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080427','C128',NULL,NULL,0,'fixed','28','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(154,'Curry masla 200GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080434','C128',NULL,NULL,0,'fixed','56','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(155,'Curry masla 500GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080441','C128',NULL,NULL,0,'fixed','112','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(156,'Sambar powder 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080311','C128',NULL,NULL,0,'fixed','11','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(157,'Sambar powder 100GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080328','C128',NULL,NULL,0,'fixed','23','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(158,'Sambar powder 200GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080335','C128',NULL,NULL,0,'fixed','45','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(159,'Sambar powder 500GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080342','C128',NULL,NULL,0,'fixed','113','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(160,'Rasam powder 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080618','C128',NULL,NULL,0,'fixed','16','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(161,'Rasam powder 100Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080625','C128',NULL,NULL,0,'fixed','32','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(162,'Chicken masala 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081516','C128',NULL,NULL,0,'fixed','10','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(163,'Chicken masala 100Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081523','C128',NULL,NULL,0,'fixed','20','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(164,'Chicken masala 200Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081561','C128',NULL,NULL,0,'fixed','31','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(165,'Chicken masala 500Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081585','C128',NULL,NULL,0,'fixed','78','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(166,'Mutton masal 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081417','C128',NULL,NULL,0,'fixed','13','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(167,'Mutton masal 100Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081424','C128',NULL,NULL,0,'fixed','26','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(168,'Mutton masal 200Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081486','C128',NULL,NULL,0,'fixed','40','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(169,'Mutton masal 500Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081462','C128',NULL,NULL,0,'fixed','102','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(170,'Pepper powder 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082117','C128',NULL,NULL,0,'fixed','28','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(171,'Garam masala  50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081813','C128',NULL,NULL,0,'fixed','15','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(172,'Chilli Chutney 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080519','C128',NULL,NULL,0,'fixed','7','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(173,'Fish curry 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081776','C128',NULL,NULL,0,'fixed','11','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(174,'Fish fry masala 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081714','C128',NULL,NULL,0,'fixed','15','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(175,'Chilli chicken 65 50gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082018','C128',NULL,NULL,0,'fixed','13','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(176,'Channa masala 50gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082711','C128',NULL,NULL,0,'fixed','10','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(177,'Dall rice powder 100gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080816','C128',NULL,NULL,0,'fixed','19','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(178,'Garlic rice powder 100gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002080915','C128',NULL,NULL,0,'fixed','16','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(179,'Tamarind rice 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081011','C128',NULL,NULL,0,'fixed','10','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(180,'Kulambu milaki 50G',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082612','C128',NULL,NULL,0,'fixed','8','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(181,'Egg kurma masala 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081912','C128',NULL,NULL,0,'fixed','15.5','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(182,'Kasmir chilli 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002083725','C128',NULL,NULL,0,'fixed','30','','','9042211','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(183,'Vatha puli 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081318','C128',NULL,NULL,0,'fixed','11','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(184,'Biriyani masala 50Gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081615','C128',NULL,NULL,0,'fixed','16','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(185,'Biriyani masala 200gm',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002081684','C128',NULL,NULL,0,'fixed','48','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(186,'Cumin powder 50G',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082216','C128',NULL,NULL,0,'fixed','24','','','9093200','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(187,'Ragi flour 500g',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082506','C128',NULL,NULL,0,'fixed','12','','','1105100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(188,'Baji bonda powder 200',1,'single',1,NULL,NULL,1,2,NULL,11,'inclusive',1,0.0000,'8906002082445','C128',NULL,NULL,0,'fixed','11','','','2106909','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(189,'Baji bonda powder 500',1,'single',1,NULL,NULL,1,2,NULL,11,'inclusive',1,0.0000,'8906002082452','C128',NULL,NULL,0,'fixed','27','','','2106909','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(190,'Country chicken gravy 50GM',1,'single',1,NULL,NULL,1,2,NULL,4,'inclusive',1,0.0000,'8906002082957','C128',NULL,NULL,0,'fixed','13.5','','','9109100','',NULL,1,NULL,0,0,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(191,'Chick Black 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979002035','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(192,'Chick White 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979025836','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(193,'Chick Green 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979002080','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(194,'Karthika Powder 2/-',1,'single',1,NULL,NULL,2,NULL,NULL,8,'inclusive',1,0.0000,'8902979000444','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(195,'Karthika Shamp BL 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979032865','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(196,'Karthika Shamp R 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979000826','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(197,'Karthika Shamp G 1/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979027069','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(198,'Meera Powder 4/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979023146','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(199,'Meera Sha Bad 2/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979022682','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(200,'Meera Sha Whi 2/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979029025','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(201,'Chick 80 Ml Black',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979002059','C128',NULL,NULL,0,'fixed','2','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(202,'Chick 180 Ml Black',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979002066','C128',NULL,NULL,0,'fixed','5','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(203,'Karthi 80 Ml Shamp',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979000833','C128',NULL,NULL,0,'fixed','1','','','3304991','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(204,'Karthi 175 Ml Shampoo',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979026727','C128',NULL,NULL,0,'fixed','5','','','3304991','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(205,'Meera 80Ml Sha Bad',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'2025000205','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(206,'Meera 80 Ml Sha Whi',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979029032','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(207,'Meera 180 Ml Sha Bad',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979022798','C128',NULL,NULL,0,'fixed','2','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(208,'Meera 180 Ml Sha Whi',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979029049','C128',NULL,NULL,0,'fixed','2','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(209,'Karthi Powder 10/-',1,'single',1,NULL,NULL,2,NULL,NULL,8,'inclusive',1,0.0000,'8902979026703','C128',NULL,NULL,0,'fixed','0','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(210,'Karthi 65/- Powder Jar',1,'single',1,NULL,NULL,2,NULL,NULL,8,'inclusive',1,0.0000,'8902979026710','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(211,'Meera 120g Powder',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979023177','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(212,'Meera 40g Powder',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979023153','C128',NULL,NULL,0,'fixed','0.5','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(213,'Meera 80g Powder',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979023160','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(214,'Nyil 90 Ml Green 52/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979053877','C128',NULL,NULL,0,'fixed','1.5','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(215,'Nyil 90 Ml Oran 52/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979053884','C128',NULL,NULL,0,'fixed','1.5','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(216,'Nyil 180 ml Greeen 125/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979053938','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(217,'Nyil 180 ml Oran 115',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979053945','C128',NULL,NULL,0,'fixed','1','','','3305109','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(218,'Spinz BB 35g 65/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979026871','C128',NULL,NULL,0,'fixed','1','','','3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(219,'Spinz BB 70g 120/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979026888','C128',NULL,NULL,0,'fixed','1','','','3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(220,'Spinz Bb Cream 15g',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979005906','C128',NULL,NULL,0,'fixed','1','','','3304991','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(221,'Spinz BB Cream 29g',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979005937','C128',NULL,NULL,0,'fixed','1','','','3304991','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(222,'Spinz Rose 50g 55/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979020022','C128',NULL,NULL,0,'fixed','1','','','3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(223,'Spinz Violet 50g 55/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979020060','C128',NULL,NULL,0,'fixed','1','','','3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(224,'Spinz Rose 100g 105/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979020039','C128',NULL,NULL,0,'fixed','1','','','3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(225,'Spinz Violet 100g 105/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979020077','C128',NULL,NULL,0,'fixed','1','','','3304912','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(226,'Indica 21/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979001953','C128',NULL,NULL,0,'fixed','0.5','','','3305904','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(227,'Indica Easy 15/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979011136','C128',NULL,NULL,0,'fixed','0.5','','','1905904','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(228,'Indica Easy 30/-',1,'single',1,NULL,NULL,2,NULL,NULL,11,'inclusive',1,0.0000,'8902979027137','C128',NULL,NULL,0,'fixed','1','','','3305904','',NULL,1,NULL,0,0,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(229,'250g Kollu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000229','C128',NULL,NULL,0,'fixed','3',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 12:36:21','2025-02-01 12:36:21'),(230,'500g Kollu',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,NULL,'2025000230','C128',NULL,NULL,0,'fixed','4',NULL,NULL,NULL,NULL,NULL,1,NULL,0,0,'2025-02-01 12:37:28','2025-02-01 12:37:28');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `purchase_order_line_id` int(11) DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,1,1,54.0000,0.0000,4.0000,0.00,4.0000,5.0000,0.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(2,2,2,2,40.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(3,3,3,3,24.0000,0.0000,17.0000,0.00,17.0000,18.0000,0.8500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(4,4,4,4,56.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(5,5,5,5,40.0000,0.0000,17.0000,0.00,17.0000,18.0000,0.8500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(6,6,6,6,30.0000,0.0000,38.0000,0.00,38.0000,40.0000,1.9000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(7,7,7,7,10.0000,0.0000,85.0000,0.00,85.0000,89.0000,4.2500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(8,8,8,8,40.0000,0.0000,43.0000,0.00,43.0000,45.0000,2.1500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(9,9,9,9,48.0000,0.0000,4.0000,0.00,4.0000,5.0000,0.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(10,10,10,10,64.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(11,11,11,11,64.0000,0.0000,4.0000,0.00,4.0000,5.0000,0.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(12,12,12,12,12.0000,0.0000,43.0000,0.00,43.0000,45.0000,2.1500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(13,13,13,13,12.0000,0.0000,38.0000,0.00,38.0000,40.0000,1.9000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(14,14,14,14,24.0000,0.0000,9.0000,0.00,9.0000,9.0000,0.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(15,15,15,15,12.0000,0.0000,17.0000,0.00,17.0000,18.0000,0.8500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(16,16,16,16,12.0000,0.0000,26.0000,0.00,26.0000,27.0000,1.3000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(17,17,17,17,6.0000,0.0000,34.0000,0.00,34.0000,36.0000,1.7000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(18,18,18,18,6.0000,0.0000,38.0000,0.00,38.0000,40.0000,1.9000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(19,19,19,19,6.0000,0.0000,38.0000,0.00,38.0000,40.0000,1.9000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(20,21,20,20,39.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(21,22,21,21,21.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(22,23,22,22,16.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(23,24,23,23,25.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(24,25,24,24,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(25,26,25,25,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(26,27,26,26,40.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(27,28,27,27,29.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(28,29,28,28,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(29,30,29,29,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(30,31,30,30,14.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(31,32,31,31,13.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(32,33,32,32,2.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(33,34,33,33,38.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(34,35,34,34,40.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(35,36,35,35,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(36,37,36,36,40.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(37,38,37,37,40.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(38,39,38,38,19.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(39,40,39,39,18.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(40,41,40,40,16.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(41,42,41,41,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(42,43,42,42,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(43,44,43,43,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(44,45,44,44,18.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(45,46,45,45,5.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(46,47,46,46,25.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(47,48,47,47,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(48,49,48,48,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(49,50,49,49,54.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(50,51,50,50,32.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(51,52,51,51,31.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(52,53,52,52,14.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(53,54,53,53,13.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(54,55,54,54,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(55,56,55,55,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(56,57,56,56,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(57,58,57,57,14.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(58,59,58,58,19.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(59,60,59,59,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(60,61,60,60,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(61,62,61,61,5.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(62,63,62,62,34.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(63,64,63,63,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(64,65,64,64,11.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(65,66,65,65,31.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 10:15:15','2025-01-31 10:17:39'),(66,67,66,66,43.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 10:15:58','2025-01-31 10:18:07'),(67,68,67,67,21.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 12:20:25','2025-01-31 12:20:25'),(68,69,68,68,31.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 12:21:28','2025-01-31 12:21:28'),(69,70,69,69,9.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 12:22:04','2025-01-31 12:22:04'),(70,71,70,70,12.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:19:53','2025-01-31 18:08:29'),(71,72,71,71,21.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:21:03','2025-01-31 13:21:03'),(72,73,72,72,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:24:04','2025-01-31 13:24:04'),(73,74,73,73,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:53:47','2025-01-31 13:53:47'),(74,75,74,74,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:54:27','2025-01-31 13:54:27'),(75,76,75,75,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:56:25','2025-01-31 13:56:25'),(76,77,76,76,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:56:58','2025-01-31 13:56:58'),(77,78,77,77,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:59:03','2025-01-31 13:59:03'),(78,79,78,78,5.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 13:59:32','2025-01-31 13:59:32'),(79,80,79,79,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 14:03:17','2025-01-31 14:03:17'),(80,81,80,80,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 14:03:57','2025-01-31 14:03:57'),(81,82,81,81,6.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 14:06:36','2025-01-31 14:06:36'),(82,83,82,82,8.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-31 14:07:27','2025-01-31 14:07:27'),(83,84,83,83,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 06:58:56','2025-02-01 06:58:56'),(84,85,84,84,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 06:59:46','2025-02-01 06:59:46'),(85,86,85,85,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 07:00:16','2025-02-01 07:00:16'),(86,87,86,86,30.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 07:00:40','2025-02-01 07:00:40'),(87,88,87,87,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 07:01:00','2025-02-01 07:01:00'),(88,89,88,88,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 07:01:20','2025-02-01 07:01:20'),(140,141,140,140,100.0000,0.0000,10.0000,0.00,10.0000,11.0000,0.5000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(141,142,141,141,50.0000,0.0000,21.0000,0.00,21.0000,22.0000,1.0500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(142,143,142,142,25.0000,0.0000,42.0000,0.00,42.0000,44.0000,2.1000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(143,144,143,143,10.0000,0.0000,104.0000,0.00,104.0000,109.0000,5.2000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(144,145,144,144,60.0000,0.0000,7.0000,0.00,7.0000,8.0000,0.3500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(145,146,145,145,50.0000,0.0000,15.0000,0.00,15.0000,16.0000,0.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(146,147,146,146,25.0000,0.0000,29.0000,0.00,29.0000,31.0000,1.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(147,148,147,147,10.0000,0.0000,73.0000,0.00,73.0000,77.0000,3.6500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(148,149,148,148,60.0000,0.0000,11.0000,0.00,11.0000,12.0000,0.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(149,150,149,149,50.0000,0.0000,23.0000,0.00,23.0000,25.0000,1.1500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(150,151,150,150,25.0000,0.0000,46.0000,0.00,46.0000,49.0000,2.3000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(151,152,151,151,10.0000,0.0000,115.0000,0.00,115.0000,121.0000,5.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(152,153,152,152,60.0000,0.0000,17.0000,0.00,17.0000,18.0000,0.8500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(153,154,153,153,50.0000,0.0000,35.0000,0.00,35.0000,36.0000,1.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(154,155,154,154,25.0000,0.0000,69.0000,0.00,69.0000,72.0000,3.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(155,156,155,155,10.0000,0.0000,171.0000,0.00,171.0000,180.0000,8.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(156,157,156,156,40.0000,0.0000,14.0000,0.00,14.0000,15.0000,0.7000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(157,158,157,157,50.0000,0.0000,29.0000,0.00,29.0000,31.0000,1.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(158,159,158,158,25.0000,0.0000,58.0000,0.00,58.0000,61.0000,2.9000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(159,160,159,159,10.0000,0.0000,146.0000,0.00,146.0000,153.0000,7.3000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(160,161,160,160,40.0000,0.0000,21.0000,0.00,21.0000,23.0000,1.0500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(161,162,161,161,20.0000,0.0000,43.0000,0.00,43.0000,45.0000,2.1500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(162,163,162,162,60.0000,0.0000,13.0000,0.00,13.0000,13.0000,0.6500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(163,164,163,163,50.0000,0.0000,26.0000,0.00,26.0000,27.0000,1.3000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(164,165,164,164,20.0000,0.0000,52.0000,0.00,52.0000,54.0000,2.6000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(165,166,165,165,10.0000,0.0000,129.0000,0.00,129.0000,136.0000,6.4500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(166,167,166,166,60.0000,0.0000,18.0000,0.00,18.0000,19.0000,0.9000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(167,168,167,167,50.0000,0.0000,35.0000,0.00,35.0000,37.0000,1.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(168,169,168,168,20.0000,0.0000,71.0000,0.00,71.0000,74.0000,3.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(169,170,169,169,6.0000,0.0000,176.0000,0.00,176.0000,185.0000,8.8000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(170,171,170,170,20.0000,0.0000,42.0000,0.00,42.0000,45.0000,2.1000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(171,172,171,171,40.0000,0.0000,20.0000,0.00,20.0000,21.0000,1.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(172,173,172,172,20.0000,0.0000,11.0000,0.00,11.0000,12.0000,0.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(173,174,173,173,40.0000,0.0000,15.0000,0.00,15.0000,16.0000,0.7500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(174,175,174,174,40.0000,0.0000,18.0000,0.00,18.0000,19.0000,0.9000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(175,176,175,175,20.0000,0.0000,20.0000,0.00,20.0000,21.0000,1.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(176,177,176,176,10.0000,0.0000,16.0000,0.00,16.0000,17.0000,0.8000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(177,178,177,177,10.0000,0.0000,21.0000,0.00,21.0000,22.0000,1.0500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(178,179,178,178,10.0000,0.0000,23.0000,0.00,23.0000,25.0000,1.1500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(179,180,179,179,10.0000,0.0000,14.0000,0.00,14.0000,15.0000,0.7000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(180,181,180,180,10.0000,0.0000,11.0000,0.00,11.0000,11.0000,0.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(181,182,181,181,20.0000,0.0000,20.0000,0.00,20.0000,21.0000,1.0000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(182,183,182,182,20.0000,0.0000,33.0000,0.00,33.0000,34.0000,1.6500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(183,184,183,183,20.0000,0.0000,16.0000,0.00,16.0000,17.0000,0.8000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(184,185,184,184,100.0000,0.0000,23.0000,0.00,23.0000,24.0000,1.1500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(185,186,185,185,10.0000,0.0000,91.0000,0.00,91.0000,96.0000,4.5500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(186,187,186,186,20.0000,0.0000,21.0000,0.00,21.0000,22.0000,1.0500,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(187,188,187,187,10.0000,0.0000,30.0000,0.00,30.0000,32.0000,1.5000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(188,189,188,188,25.0000,0.0000,23.0000,0.00,23.0000,27.0000,4.1400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(189,190,189,189,10.0000,0.0000,56.0000,0.00,56.0000,66.0000,10.0800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(190,191,190,190,20.0000,0.0000,18.0000,0.00,18.0000,19.0000,0.9000,4,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(191,192,191,191,960.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(192,193,192,192,0.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(193,194,193,193,192.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(194,195,194,194,0.0000,0.0000,2.0000,0.00,2.0000,2.0000,0.2400,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(195,196,195,195,240.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(196,197,196,196,240.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(197,198,197,197,240.0000,0.0000,1.0000,0.00,1.0000,1.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(198,199,198,198,150.0000,0.0000,3.0000,0.00,3.0000,4.0000,0.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(199,200,199,199,240.0000,0.0000,1.0000,0.00,1.0000,2.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(200,201,200,200,480.0000,0.0000,1.0000,0.00,1.0000,2.0000,0.1800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(201,202,201,201,6.0000,0.0000,46.0000,0.00,46.0000,54.0000,8.2800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(202,203,202,202,6.0000,0.0000,85.0000,0.00,85.0000,100.0000,15.3000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(203,204,203,203,6.0000,0.0000,38.0000,0.00,38.0000,45.0000,6.8400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(204,205,204,204,6.0000,0.0000,85.0000,0.00,85.0000,100.0000,15.3000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(205,206,205,205,6.0000,0.0000,53.0000,0.00,53.0000,63.0000,9.5400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(206,207,206,206,6.0000,0.0000,58.0000,0.00,58.0000,69.0000,10.4400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(207,208,207,207,6.0000,0.0000,133.0000,0.00,133.0000,157.0000,23.9400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(208,209,208,208,6.0000,0.0000,152.0000,0.00,152.0000,179.0000,27.3600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(209,210,209,209,12.0000,0.0000,8.0000,0.00,8.0000,9.0000,0.9600,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(210,211,210,210,6.0000,0.0000,50.0000,0.00,50.0000,56.0000,6.0000,8,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(211,212,211,211,6.0000,0.0000,90.0000,0.00,90.0000,106.0000,16.2000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(212,213,212,212,6.0000,0.0000,29.0000,0.00,29.0000,35.0000,5.2200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(213,214,213,213,6.0000,0.0000,60.0000,0.00,60.0000,71.0000,10.8000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(214,215,214,214,6.0000,0.0000,38.0000,0.00,38.0000,45.0000,6.8400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(215,216,215,215,6.0000,0.0000,38.0000,0.00,38.0000,45.0000,6.8400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(216,217,216,216,6.0000,0.0000,92.0000,0.00,92.0000,109.0000,16.5600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(217,218,217,217,6.0000,0.0000,85.0000,0.00,85.0000,100.0000,15.3000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(218,219,218,218,6.0000,0.0000,48.0000,0.00,48.0000,57.0000,8.6400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(219,220,219,219,6.0000,0.0000,87.0000,0.00,87.0000,103.0000,15.6600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(220,221,220,220,6.0000,0.0000,52.0000,0.00,52.0000,62.0000,9.3600,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(221,222,221,221,6.0000,0.0000,94.0000,0.00,94.0000,111.0000,16.9200,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(222,223,222,222,6.0000,0.0000,41.0000,0.00,41.0000,48.0000,7.3800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(223,224,223,223,6.0000,0.0000,41.0000,0.00,41.0000,48.0000,7.3800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(224,225,224,224,6.0000,0.0000,78.0000,0.00,78.0000,92.0000,14.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(225,226,225,225,6.0000,0.0000,78.0000,0.00,78.0000,92.0000,14.0400,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(226,227,226,226,22.0000,0.0000,15.0000,0.00,15.0000,18.0000,2.7000,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(227,228,227,227,32.0000,0.0000,11.0000,0.00,11.0000,13.0000,1.9800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(228,229,228,228,24.0000,0.0000,21.0000,0.00,21.0000,25.0000,3.7800,11,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(229,230,229,229,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 12:36:29','2025-02-01 12:36:29'),(230,231,230,230,10.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-02-01 12:37:32','2025-02-01 12:37:32');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reference_counts_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',1,1,'2022-10-20 06:14:39','2025-01-24 14:17:01'),(2,'business_location',1,1,'2022-10-20 06:14:39','2024-02-27 06:54:11'),(3,'draft',1,1,'2025-01-29 14:36:17','2025-01-29 14:36:17');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (3,3),(6,3),(27,3),(32,3),(36,3),(37,3),(38,3),(40,3),(41,3),(48,3),(49,3),(50,3),(81,3),(2,4),(3,4),(8,4),(10,4),(16,4),(25,4),(26,4),(27,4),(32,4),(36,4),(37,4),(38,4),(40,4),(41,4),(48,4),(49,4),(52,4),(53,4),(54,4),(59,4),(61,4),(67,4),(68,4),(69,4),(71,4),(72,4),(73,4),(75,4),(76,4),(77,4),(81,4),(87,4),(90,4),(91,4),(92,4),(93,4),(94,4),(95,4),(96,4),(97,4),(98,4),(99,4);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_service_staff` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2022-10-20 06:14:39','2022-10-20 06:14:39'),(3,'Cashier#1','web',1,0,0,'2024-04-11 15:41:21','2024-04-11 15:41:21'),(4,'Sales Staff#1','web',1,0,0,'2024-04-16 07:15:55','2024-04-16 07:15:55');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int(11) NOT NULL,
  `warranty_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `business_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  KEY `stock_adjustment_lines_lot_no_line_id_index` (`lot_no_line_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
INSERT INTO `stock_adjustment_lines` VALUES (4,2104,2002,2002,1.7500,0.0000,90.0000,NULL,NULL,'2024-03-30 14:23:05','2024-03-30 14:23:05'),(9,2477,2018,2018,0.7000,0.0000,170.0000,NULL,NULL,'2024-04-08 08:08:20','2024-04-08 08:08:20'),(10,5986,2594,2594,5.0000,0.0000,22.0000,NULL,NULL,'2024-05-17 15:22:14','2024-05-17 15:22:14'),(11,8500,2594,2594,1.0000,0.0000,22.0000,NULL,NULL,'2024-06-16 12:00:53','2024-06-16 12:00:53'),(12,10348,2641,2641,3.0000,0.0000,30.0000,NULL,NULL,'2024-07-13 11:05:28','2024-07-13 11:05:28'),(13,10554,2594,2594,1.0000,0.0000,22.0000,NULL,NULL,'2024-07-15 15:11:52','2024-07-15 15:11:52'),(14,4,2,2,5.0000,0.0000,34.0000,NULL,NULL,'2025-01-24 14:20:47','2025-01-24 14:20:47'),(15,6,2,2,10.0000,0.0000,34.0000,NULL,NULL,'2025-01-24 14:41:16','2025-01-24 14:41:16');
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','4.7.8'),(2,'default_business_active_status','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `for_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
INSERT INTO `tax_rates` VALUES (1,1,'best',5.0000,0,0,1,'2022-11-19 14:17:46','2022-11-19 08:21:33','2022-11-19 14:17:46'),(2,1,'CGST 2.5%',2.5000,0,1,1,NULL,'2022-11-19 14:17:40','2024-02-27 05:07:18'),(3,1,'SGST 2.5%',2.5000,0,1,1,NULL,'2022-11-19 14:18:00','2024-02-27 05:07:37'),(4,1,'GST 5%',5.0000,1,0,1,NULL,'2022-11-19 14:18:27','2025-01-29 13:46:42'),(5,1,'IGST (5%)',5.0000,0,0,1,'2024-02-27 05:07:09','2022-11-19 14:19:20','2024-02-27 05:07:09'),(6,1,'CGST 6%',6.0000,0,1,1,NULL,'2022-11-23 16:26:14','2024-02-27 05:07:28'),(7,1,'SGST 6%',6.0000,0,1,1,NULL,'2022-11-23 16:26:25','2024-02-27 05:07:47'),(8,1,'GST 12%',12.0000,1,0,1,NULL,'2022-11-23 16:26:43','2025-01-29 14:06:05'),(9,1,'CGST 9%',9.0000,0,1,1,NULL,'2024-03-08 14:52:31','2024-03-08 14:52:31'),(10,1,'SGST 9%',9.0000,0,1,1,NULL,'2024-03-08 14:52:40','2024-03-08 14:52:40'),(11,1,'GST 18%',18.0000,1,0,1,NULL,'2024-03-08 14:52:53','2025-01-29 14:05:59'),(12,1,'cess',12.0000,0,1,1,NULL,'2024-04-15 09:28:49','2024-04-15 09:28:49'),(13,1,'CGST 14%',14.0000,0,1,1,NULL,'2024-04-15 09:30:45','2024-04-15 09:34:31'),(14,1,'SGST 14%',14.0000,0,1,1,NULL,'2024-04-15 09:30:56','2024-04-15 09:40:22'),(15,1,'CGST',14.0000,1,0,1,'2024-04-15 09:33:17','2024-04-15 09:31:31','2024-04-15 09:33:17'),(16,1,'GST 28%',28.0000,1,0,1,NULL,'2024-04-15 09:33:42','2025-01-29 14:05:52'),(17,1,'GST 0%',0.0000,0,0,1,NULL,'2024-11-08 13:30:19','2025-01-29 14:06:20');
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `return_transaction_id` int(11) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_transaction_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `paid_through_link` tinyint(1) NOT NULL DEFAULT '0',
  `gateway` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_advance` tinyint(1) NOT NULL DEFAULT '0',
  `payment_for` int(11) DEFAULT NULL COMMENT 'stores the contact id',
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  KEY `transaction_payments_payment_type_index` (`payment_type`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `unit_price_before_discount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Sell price excluding tax',
  `line_discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_discount_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text COLLATE utf8mb4_unicode_ci,
  `so_line_id` int(11) DEFAULT NULL,
  `so_quantity_invoiced` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `res_service_staff_id` int(11) DEFAULT NULL,
  `res_line_order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `children_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Type of children for the parent, like modifier or combo',
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  KEY `transaction_sell_lines_children_type_index` (`children_type`),
  KEY `transaction_sell_lines_parent_sell_line_id_index` (`parent_sell_line_id`),
  KEY `transaction_sell_lines_line_discount_type_index` (`line_discount_type`),
  KEY `transaction_sell_lines_discount_id_index` (`discount_id`),
  KEY `transaction_sell_lines_lot_no_line_id_index` (`lot_no_line_id`),
  KEY `transaction_sell_lines_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (1,20,13,13,1.0000,0.0000,0.0000,45.0000,45.0000,'fixed',0.0000,45.0000,2.0000,4,NULL,NULL,'',NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-01-29 14:36:17','2025-01-29 14:36:17');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(22,4) NOT NULL,
  `qty_returned` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sell_line_id` (`sell_line_id`),
  KEY `stock_adjustment_line_id` (`stock_adjustment_line_id`),
  KEY `purchase_line_id` (`purchase_line_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT '0',
  `payment_status` enum('paid','due','partial') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_repeat_on` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total before the purchase/invoice tax, this includeds the indivisual product tax',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) DEFAULT '0.0000',
  `rp_redeemed` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `rp_redeemed_amount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'rp is the short form of reward points',
  `shipping_details` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address` text COLLATE utf8mb4_unicode_ci,
  `delivery_date` datetime DEFAULT NULL,
  `shipping_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivered_to` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_charges` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `shipping_custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_custom_field_5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_notes` text COLLATE utf8mb4_unicode_ci,
  `staff_note` text COLLATE utf8mb4_unicode_ci,
  `is_export` tinyint(1) NOT NULL DEFAULT '0',
  `export_custom_fields_info` longtext COLLATE utf8mb4_unicode_ci,
  `round_off_amount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Difference of rounded total and actual total',
  `additional_expense_key_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_1` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `additional_expense_key_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_2` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `additional_expense_key_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_3` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `additional_expense_key_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_expense_value_4` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `final_total` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_sub_category_id` int(11) DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT '0',
  `is_suspend` tinyint(1) NOT NULL DEFAULT '0',
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `total_amount_recovered` decimal(22,4) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `return_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `prefer_payment_method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefer_payment_account` int(11) DEFAULT NULL,
  `sales_order_ids` text COLLATE utf8mb4_unicode_ci,
  `purchase_order_ids` text COLLATE utf8mb4_unicode_ci,
  `custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `import_batch` int(11) DEFAULT NULL,
  `import_time` datetime DEFAULT NULL,
  `types_of_service_id` int(11) DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_custom_field_1` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_2` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_3` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_4` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_5` text COLLATE utf8mb4_unicode_ci,
  `service_custom_field_6` text COLLATE utf8mb4_unicode_ci,
  `is_created_from_api` tinyint(1) NOT NULL DEFAULT '0',
  `rp_earned` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `order_addresses` text COLLATE utf8mb4_unicode_ci,
  `is_recurring` tinyint(1) NOT NULL DEFAULT '0',
  `recur_interval` double(22,4) DEFAULT NULL,
  `recur_interval_type` enum('days','months','years') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recur_repetitions` int(11) DEFAULT NULL,
  `recur_stopped_on` datetime DEFAULT NULL,
  `recur_parent_id` int(11) DEFAULT NULL,
  `invoice_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  KEY `transactions_sub_type_index` (`sub_type`),
  KEY `transactions_return_parent_id_index` (`return_parent_id`),
  KEY `type` (`type`),
  KEY `transactions_status_index` (`status`),
  KEY `transactions_sub_status_index` (`sub_status`),
  KEY `transactions_res_table_id_index` (`res_table_id`),
  KEY `transactions_res_waiter_id_index` (`res_waiter_id`),
  KEY `transactions_res_order_status_index` (`res_order_status`),
  KEY `transactions_payment_status_index` (`payment_status`),
  KEY `transactions_discount_type_index` (`discount_type`),
  KEY `transactions_commission_agent_index` (`commission_agent`),
  KEY `transactions_transfer_parent_id_index` (`transfer_parent_id`),
  KEY `transactions_types_of_service_id_index` (`types_of_service_id`),
  KEY `transactions_packing_charge_type_index` (`packing_charge_type`),
  KEY `transactions_recur_parent_id_index` (`recur_parent_id`),
  KEY `transactions_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `transactions_delivery_date_index` (`delivery_date`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=232 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:01',270.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,270.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(2,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',360.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,360.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(3,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',432.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,432.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(4,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',504.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,504.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(5,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',720.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,720.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(6,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',1200.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(7,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',890.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,890.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,7,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(8,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',1800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,8,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(9,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',240.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,240.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,9,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(10,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',576.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,576.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,10,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(11,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',320.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,320.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,11,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(12,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',540.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,540.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,12,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(13,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',480.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,480.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,13,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(14,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',216.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,216.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,14,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(15,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',216.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,216.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,15,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(16,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',324.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,324.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,16,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(17,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',216.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,216.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,17,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(18,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',240.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,240.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,18,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(19,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:27:02',240.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,240.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,19,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(20,1,1,NULL,NULL,NULL,'sell',NULL,'draft','quotation',1,NULL,NULL,1,NULL,'2025/0001','',NULL,NULL,NULL,'2025-01-29 20:06:17',45.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,45.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'a692768b380bff9667e45bd55d6b35b5',NULL,NULL,0,'2025-01-29 14:36:17','2025-01-29 14:36:17'),(21,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,20,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(22,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,21,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(23,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,22,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(24,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,23,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(25,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,24,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(26,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,25,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(27,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,26,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(28,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,27,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(29,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,28,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(30,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,29,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(31,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,30,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(32,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,31,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(33,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(34,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,33,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(35,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,34,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(36,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,35,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(37,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,36,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(38,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,37,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(39,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,38,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(40,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,39,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(41,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,40,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(42,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,41,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(43,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,42,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(44,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,43,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(45,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,44,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(46,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,45,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(47,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,46,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(48,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,47,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(49,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,48,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(50,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,49,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(51,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,50,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(52,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,51,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(53,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,52,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(54,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,53,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(55,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,54,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(56,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,55,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(57,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,56,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(58,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,57,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(59,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,58,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(60,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,59,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(61,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,60,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(62,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,61,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(63,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,62,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(64,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,63,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(65,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 14:02:13',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,64,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(66,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:45:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,65,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 10:15:15','2025-01-31 10:17:39'),(67,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:45:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,66,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 10:15:58','2025-01-31 10:18:07'),(68,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 17:50:25',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,67,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 12:20:25','2025-01-31 12:20:25'),(69,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 17:51:28',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,68,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 12:21:28','2025-01-31 12:21:28'),(70,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 17:52:04',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,69,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 12:22:04','2025-01-31 12:22:04'),(71,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 18:49:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,70,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 13:19:53','2025-01-31 18:08:29'),(72,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 18:51:03',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,71,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 13:21:03','2025-01-31 13:21:03'),(73,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 18:54:04',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,72,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 13:24:04','2025-01-31 13:24:04'),(74,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:23:47',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,73,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 13:53:47','2025-01-31 13:53:47'),(75,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:24:27',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,74,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 13:54:27','2025-01-31 13:54:27'),(76,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:26:25',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,75,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 13:56:25','2025-01-31 13:56:25'),(77,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:26:58',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,76,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 13:56:58','2025-01-31 13:56:58'),(78,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:29:03',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,77,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 13:59:03','2025-01-31 13:59:03'),(79,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:29:32',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,78,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 13:59:32','2025-01-31 13:59:32'),(80,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:33:17',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,79,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 14:03:17','2025-01-31 14:03:17'),(81,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:33:57',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,80,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 14:03:57','2025-01-31 14:03:57'),(82,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:36:36',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,81,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 14:06:36','2025-01-31 14:06:36'),(83,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 19:37:27',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,82,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-31 14:07:27','2025-01-31 14:07:27'),(84,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 12:28:56',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,83,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 06:58:56','2025-02-01 06:58:56'),(85,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 12:29:46',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,84,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 06:59:46','2025-02-01 06:59:46'),(86,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 12:30:16',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,85,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 07:00:16','2025-02-01 07:00:16'),(87,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 12:30:40',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,86,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 07:00:40','2025-02-01 07:00:40'),(88,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 12:31:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,87,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 07:01:00','2025-02-01 07:01:00'),(89,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 12:31:20',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,88,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 07:01:20','2025-02-01 07:01:20'),(90,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,89,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(91,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,90,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(92,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,91,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(93,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1090.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1090.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,92,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(94,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',480.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,480.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,93,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(95,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',780.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,780.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,94,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(96,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',750.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,750.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,95,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(97,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',768.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,768.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,96,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(98,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',700.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,700.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,97,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(99,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,98,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(100,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1225.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1225.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,99,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(101,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1210.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1210.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,100,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(102,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1080.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1080.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,101,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(103,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,102,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(104,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,103,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(105,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,104,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(106,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',616.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,616.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,105,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(107,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1540.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1540.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,106,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(108,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1525.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1525.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,107,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(109,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1530.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1530.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,108,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(110,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',920.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,920.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,109,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(111,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',900.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,900.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,110,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(112,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',780.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,780.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,111,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(113,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1350.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1350.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,112,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(114,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,113,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(115,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1353.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1353.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,114,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(116,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1140.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1140.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,115,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(117,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1850.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1850.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,116,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(118,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1480.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1480.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,117,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(119,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',1110.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1110.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,118,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(120,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',900.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,900.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,119,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(121,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',836.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,836.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,120,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(122,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',240.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,240.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,121,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(123,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',640.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,640.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,122,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(124,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',760.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,760.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,123,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(125,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',420.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,420.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,124,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(126,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',170.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,170.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,125,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(127,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',220.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,220.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,126,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(128,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,127,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(129,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,128,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(130,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',110.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,110.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,129,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(131,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',420.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,420.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,130,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(132,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',682.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,682.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,131,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(133,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',340.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,340.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,132,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(134,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',2400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,133,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(135,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',960.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,960.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,134,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(136,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',440.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,440.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,135,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(137,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',320.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,320.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,136,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(138,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',675.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,675.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,137,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(139,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',660.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,660.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,138,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(140,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 15:38:24',380.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,380.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,139,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 10:08:24','2025-02-01 10:08:24'),(141,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,140,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(142,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,141,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(143,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,142,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(144,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1090.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1090.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,143,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(145,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',480.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,480.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,144,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(146,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,145,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(147,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',775.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,775.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,146,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(148,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',770.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,770.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,147,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(149,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',720.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,720.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,148,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(150,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,149,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(151,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1225.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1225.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,150,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(152,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1210.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1210.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,151,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(153,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1080.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1080.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,152,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(154,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,153,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(155,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,154,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(156,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1800.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1800.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,155,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(157,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,156,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(158,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1550.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1550.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,157,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(159,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1525.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1525.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,158,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(160,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1530.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1530.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,159,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(161,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',920.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,920.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,160,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(162,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',900.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,900.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,161,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(163,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',780.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,780.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,162,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(164,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1350.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1350.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,163,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(165,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1080.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1080.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,164,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(166,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1360.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1360.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,165,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(167,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1140.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1140.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,166,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(168,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1850.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1850.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,167,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(169,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1480.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1480.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,168,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(170,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',1110.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1110.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,169,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(171,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',900.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,900.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,170,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(172,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',840.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,840.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,171,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(173,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',240.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,240.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,172,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(174,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',640.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,640.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,173,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(175,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',760.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,760.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,174,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(176,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',420.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,420.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,175,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(177,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',170.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,170.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,176,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(178,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',220.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,220.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,177,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(179,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',250.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,178,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(180,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,179,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(181,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',110.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,110.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,180,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(182,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',420.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,420.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,181,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(183,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',680.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,680.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,182,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(184,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',340.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,340.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,183,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(185,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',2400.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,184,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(186,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',960.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,960.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,185,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(187,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',440.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,440.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,186,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(188,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',320.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,320.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,187,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(189,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',675.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,675.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,188,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(190,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',660.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,660.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,189,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(191,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:31:15',380.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,380.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,190,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(192,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',960.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,960.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,191,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(193,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,192,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(194,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',192.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,192.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,193,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(195,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,194,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(196,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',240.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,240.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,195,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(197,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',240.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,240.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,196,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(198,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',240.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,240.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,197,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(199,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,198,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(200,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',480.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,480.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,199,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(201,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',960.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,960.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,200,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(202,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',324.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,324.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,201,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(203,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,202,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(204,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',270.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,270.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,203,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(205,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,204,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(206,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',378.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,378.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,205,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(207,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',414.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,414.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,206,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(208,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',942.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,942.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,207,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(209,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',1074.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1074.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,208,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(210,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',108.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,108.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,209,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(211,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',336.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,336.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,210,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(212,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',636.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,636.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,211,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(213,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',210.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,210.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,212,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(214,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',426.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,426.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,213,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(215,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',270.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,270.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,214,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(216,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',270.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,270.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,215,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(217,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',654.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,654.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,216,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(218,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,217,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(219,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',342.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,342.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,218,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(220,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',618.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,618.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,219,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(221,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',372.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,372.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,220,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(222,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',666.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,666.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,221,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(223,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',288.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,288.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,222,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(224,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',288.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,288.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,223,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(225,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',552.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,552.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,224,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(226,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',552.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,552.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,225,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(227,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',396.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,396.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,226,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(228,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',416.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,416.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,227,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(229,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 16:45:56',600.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,600.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,228,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(230,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 18:06:29',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,229,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 12:36:29','2025-02-01 12:36:29'),(231,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-01 18:07:32',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,230,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-01 12:37:32','2025-02-01 12:37:32');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `types_of_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `types_of_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `business_id` int(11) NOT NULL,
  `location_price_group` text COLLATE utf8mb4_unicode_ci,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_custom_fields` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `types_of_services_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `types_of_services` WRITE;
/*!40000 ALTER TABLE `types_of_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `types_of_services` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `base_unit_id` int(11) DEFAULT NULL,
  `base_unit_multiplier` decimal(20,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  KEY `units_base_unit_id_index` (`base_unit_id`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'Pieces','Pcs',0,NULL,NULL,1,NULL,'2022-10-20 06:14:39','2025-01-29 13:45:47'),(2,1,'Kilogram','Kg',1,NULL,NULL,1,NULL,'2025-01-24 14:14:51','2025-01-24 15:41:39'),(3,1,'50 KG','50 Kg',0,2,50.0000,1,NULL,'2025-01-24 14:16:40','2025-01-24 14:16:40'),(4,1,'Each','Ea',1,NULL,NULL,1,NULL,'2025-01-24 15:23:38','2025-01-24 15:41:20'),(5,1,'Gram','g',1,NULL,NULL,1,NULL,'2025-01-24 15:40:36','2025-01-24 15:40:36');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_contact_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_contact_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_contact_access_user_id_index` (`user_id`),
  KEY `user_contact_access_contact_id_index` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_contact_access` WRITE;
/*!40000 ALTER TABLE `user_contact_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_contact_access` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'user',
  `surname` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `contact_no` char(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `max_sales_discount_percent` decimal(5,2) DEFAULT NULL,
  `allow_login` tinyint(1) NOT NULL DEFAULT '1',
  `status` enum('active','inactive','terminated') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `crm_contact_id` int(10) unsigned DEFAULT NULL,
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT '0',
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `selected_contacts` tinyint(1) NOT NULL DEFAULT '0',
  `dob` date DEFAULT NULL,
  `gender` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marital_status` enum('married','unmarried','divorced') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blood_group` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_number` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `family_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fb_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `social_media_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `social_media_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permanent_address` text COLLATE utf8mb4_unicode_ci,
  `current_address` text COLLATE utf8mb4_unicode_ci,
  `guardian_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_details` longtext COLLATE utf8mb4_unicode_ci,
  `id_proof_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_proof_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  KEY `users_user_type_index` (`user_type`),
  KEY `users_crm_contact_id_foreign` (`crm_contact_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `users_crm_contact_id_foreign` FOREIGN KEY (`crm_contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'user',NULL,'Admin',NULL,'admin',NULL,'$2y$12$VDvFuNChrMvlRyBMEF8pxe6UH8woK2nqN8L0A8FFPxlb.eofof9wW','en',NULL,NULL,'RVfjF722SDNhcbNdKhHxNMdQoiiOjJPMcd5MglRbtVBOaoKJgcl4YAD68jzt',1,NULL,1,'active',NULL,0,0.00,0,NULL,'male','married',NULL,'9944357786',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,'2022-10-20 06:14:39','2025-01-24 13:54:17');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_group_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_group_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_id` int(10) unsigned NOT NULL,
  `price_group_id` int(10) unsigned NOT NULL,
  `price_inc_tax` decimal(22,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_group_prices_variation_id_foreign` (`variation_id`),
  KEY `variation_group_prices_price_group_id_foreign` (`price_group_id`),
  CONSTRAINT `variation_group_prices_price_group_id_foreign` FOREIGN KEY (`price_group_id`) REFERENCES `selling_price_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variation_group_prices_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_group_prices` WRITE;
/*!40000 ALTER TABLE `variation_group_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_group_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_location_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `product_variation_id` int(10) unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `qty_available` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES (1,1,1,1,1,54.0000,'2025-01-29 13:57:01','2025-01-29 13:57:01'),(2,2,2,2,1,40.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(3,3,3,3,1,24.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(4,4,4,4,1,56.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(5,5,5,5,1,40.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(6,6,6,6,1,30.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(7,7,7,7,1,10.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(8,8,8,8,1,40.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(9,9,9,9,1,48.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(10,10,10,10,1,64.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(11,11,11,11,1,64.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(12,12,12,12,1,12.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(13,13,13,13,1,12.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(14,14,14,14,1,24.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(15,15,15,15,1,12.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(16,16,16,16,1,12.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(17,17,17,17,1,6.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(18,18,18,18,1,6.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(19,19,19,19,1,6.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02'),(20,20,20,20,1,39.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(21,21,21,21,1,21.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(22,22,22,22,1,16.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(23,23,23,23,1,25.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(24,24,24,24,1,30.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(25,25,25,25,1,10.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(26,26,26,26,1,40.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(27,27,27,27,1,29.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(28,28,28,28,1,20.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(29,29,29,29,1,10.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(30,30,30,30,1,14.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(31,31,31,31,1,13.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(32,32,32,32,1,2.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(33,33,33,33,1,38.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(34,34,34,34,1,40.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(35,35,35,35,1,20.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(36,36,36,36,1,40.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(37,37,37,37,1,40.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(38,38,38,38,1,19.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(39,39,39,39,1,18.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(40,40,40,40,1,16.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(41,41,41,41,1,20.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(42,42,42,42,1,10.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(43,43,43,43,1,10.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(44,44,44,44,1,18.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(45,45,45,45,1,5.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(46,46,46,46,1,25.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(47,47,47,47,1,10.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(48,48,48,48,1,20.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(49,49,49,49,1,54.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(50,50,50,50,1,32.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(51,51,51,51,1,31.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(52,52,52,52,1,14.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(53,53,53,53,1,13.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(54,54,54,54,1,20.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(55,55,55,55,1,30.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(56,56,56,56,1,10.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(57,57,57,57,1,14.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(58,58,58,58,1,19.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(59,59,59,59,1,10.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(60,60,60,60,1,10.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(61,61,61,61,1,5.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(62,62,62,62,1,34.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(63,63,63,63,1,20.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(64,64,64,64,1,11.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13'),(65,65,65,65,1,31.0000,'2025-01-31 10:15:15','2025-01-31 10:15:15'),(66,66,66,66,1,43.0000,'2025-01-31 10:15:58','2025-01-31 10:15:58'),(67,67,67,67,1,21.0000,'2025-01-31 12:20:25','2025-01-31 12:20:25'),(68,68,68,68,1,31.0000,'2025-01-31 12:21:28','2025-01-31 12:21:28'),(69,69,69,69,1,9.0000,'2025-01-31 12:22:04','2025-01-31 12:22:04'),(70,70,70,70,1,12.0000,'2025-01-31 13:19:53','2025-01-31 13:19:53'),(71,71,71,71,1,21.0000,'2025-01-31 13:21:03','2025-01-31 13:21:03'),(72,72,72,72,1,30.0000,'2025-01-31 13:24:04','2025-01-31 13:24:04'),(73,73,73,73,1,8.0000,'2025-01-31 13:53:47','2025-01-31 13:53:47'),(74,74,74,74,1,6.0000,'2025-01-31 13:54:27','2025-01-31 13:54:27'),(75,75,75,75,1,8.0000,'2025-01-31 13:56:25','2025-01-31 13:56:25'),(76,76,76,76,1,6.0000,'2025-01-31 13:56:58','2025-01-31 13:56:58'),(77,77,77,77,1,10.0000,'2025-01-31 13:59:03','2025-01-31 13:59:03'),(78,78,78,78,1,5.0000,'2025-01-31 13:59:32','2025-01-31 13:59:32'),(79,79,79,79,1,8.0000,'2025-01-31 14:03:17','2025-01-31 14:03:17'),(80,80,80,80,1,6.0000,'2025-01-31 14:03:57','2025-01-31 14:03:57'),(81,81,81,81,1,6.0000,'2025-01-31 14:06:36','2025-01-31 14:06:36'),(82,82,82,82,1,8.0000,'2025-01-31 14:07:27','2025-01-31 14:07:27'),(83,83,83,83,1,10.0000,'2025-02-01 06:58:56','2025-02-01 06:58:56'),(84,84,84,84,1,10.0000,'2025-02-01 06:59:46','2025-02-01 06:59:46'),(85,85,85,85,1,30.0000,'2025-02-01 07:00:16','2025-02-01 07:00:16'),(86,86,86,86,1,30.0000,'2025-02-01 07:00:40','2025-02-01 07:00:40'),(87,87,87,87,1,10.0000,'2025-02-01 07:01:00','2025-02-01 07:01:00'),(88,88,88,88,1,10.0000,'2025-02-01 07:01:20','2025-02-01 07:01:20'),(140,140,140,140,1,100.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(141,141,141,141,1,50.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(142,142,142,142,1,25.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(143,143,143,143,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(144,144,144,144,1,60.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(145,145,145,145,1,50.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(146,146,146,146,1,25.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(147,147,147,147,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(148,148,148,148,1,60.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(149,149,149,149,1,50.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(150,150,150,150,1,25.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(151,151,151,151,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(152,152,152,152,1,60.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(153,153,153,153,1,50.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(154,154,154,154,1,25.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(155,155,155,155,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(156,156,156,156,1,40.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(157,157,157,157,1,50.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(158,158,158,158,1,25.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(159,159,159,159,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(160,160,160,160,1,40.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(161,161,161,161,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(162,162,162,162,1,60.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(163,163,163,163,1,50.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(164,164,164,164,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(165,165,165,165,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(166,166,166,166,1,60.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(167,167,167,167,1,50.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(168,168,168,168,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(169,169,169,169,1,6.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(170,170,170,170,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(171,171,171,171,1,40.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(172,172,172,172,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(173,173,173,173,1,40.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(174,174,174,174,1,40.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(175,175,175,175,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(176,176,176,176,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(177,177,177,177,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(178,178,178,178,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(179,179,179,179,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(180,180,180,180,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(181,181,181,181,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(182,182,182,182,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(183,183,183,183,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(184,184,184,184,1,100.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(185,185,185,185,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(186,186,186,186,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(187,187,187,187,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(188,188,188,188,1,25.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(189,189,189,189,1,10.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(190,190,190,190,1,20.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15'),(191,191,191,191,1,960.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(192,193,193,193,1,192.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(193,195,195,195,1,240.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(194,196,196,196,1,240.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(195,197,197,197,1,240.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(196,198,198,198,1,150.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(197,199,199,199,1,240.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(198,200,200,200,1,480.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(199,201,201,201,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(200,202,202,202,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(201,203,203,203,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(202,204,204,204,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(203,205,205,205,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(204,206,206,206,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(205,207,207,207,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(206,208,208,208,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(207,209,209,209,1,12.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(208,210,210,210,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(209,211,211,211,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(210,212,212,212,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(211,213,213,213,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(212,214,214,214,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(213,215,215,215,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(214,216,216,216,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(215,217,217,217,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(216,218,218,218,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(217,219,219,219,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(218,220,220,220,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(219,221,221,221,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(220,222,222,222,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(221,223,223,223,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(222,224,224,224,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(223,225,225,225,1,6.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(224,226,226,226,1,22.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(225,227,227,227,1,32.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(226,228,228,228,1,24.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56'),(227,229,229,229,1,20.0000,'2025-02-01 12:36:29','2025-02-01 12:36:29'),(228,230,230,230,1,10.0000,'2025-02-01 12:37:32','2025-02-01 12:37:32');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_value_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variation_template_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `sub_sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_variation_id` int(10) unsigned NOT NULL,
  `variation_value_id` int(11) DEFAULT NULL,
  `default_purchase_price` decimal(22,4) DEFAULT NULL,
  `dpp_inc_tax` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `profit_percent` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `default_sell_price` decimal(22,4) DEFAULT NULL,
  `sell_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `combo_variations` text COLLATE utf8mb4_unicode_ci COMMENT 'Contains the combo variation details',
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  KEY `variations_variation_value_id_index` (`variation_value_id`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES (1,'DUMMY',1,'7622202238826',1,NULL,4.0000,5.0000,0.0000,5.0000,5.0000,'2025-01-29 13:57:01','2025-01-29 13:57:01',NULL,'[]'),(2,'DUMMY',2,'7622202216145',2,NULL,9.0000,9.0000,0.0000,10.0000,10.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(3,'DUMMY',3,'7622201808037',3,NULL,17.0000,18.0000,0.0000,19.0000,20.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(4,'DUMMY',4,'7622202272592',4,NULL,9.0000,9.0000,0.0000,10.0000,10.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(5,'DUMMY',5,'7622202272622',5,NULL,17.0000,18.0000,0.0000,19.0000,20.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(6,'DUMMY',6,'7622202245541',6,NULL,38.0000,40.0000,0.0000,43.0000,45.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(7,'DUMMY',7,'7622201762056',7,NULL,85.0000,89.0000,0.0000,95.0000,100.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(8,'DUMMY',8,'7622201150143',8,NULL,43.0000,45.0000,0.0000,48.0000,50.0000,'2025-01-29 13:57:02','2025-01-29 14:35:38',NULL,'[]'),(9,'DUMMY',9,'7622201463434',9,NULL,4.0000,5.0000,0.0000,5.0000,5.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(10,'DUMMY',10,'7622202216718',10,NULL,9.0000,9.0000,0.0000,10.0000,10.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(11,'DUMMY',11,'7622202250521',11,NULL,4.0000,5.0000,0.0000,5.0000,5.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(12,'DUMMY',12,'7622201726218',12,NULL,43.0000,45.0000,0.0000,48.0000,50.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(13,'DUMMY',13,'7622202020650',13,NULL,38.0000,40.0000,0.0000,43.0000,45.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(14,'DUMMY',14,'7622202225512',14,NULL,9.0000,9.0000,0.0000,10.0000,10.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(15,'DUMMY',15,'7622202252518',15,NULL,17.0000,18.0000,0.0000,19.0000,20.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(16,'DUMMY',16,'7622201757212',16,NULL,26.0000,27.0000,0.0000,29.0000,30.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(17,'DUMMY',17,'7622201385088',17,NULL,34.0000,36.0000,0.0000,38.0000,40.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(18,'DUMMY',18,'8996001312490',18,NULL,38.0000,40.0000,0.0000,48.0000,50.0000,'2025-01-29 13:57:02','2025-01-29 13:57:02',NULL,'[]'),(19,'DUMMY',19,'8996001312506',19,NULL,38.0000,40.0000,0.0000,48.0000,50.0000,'2025-01-29 13:57:02','2025-01-29 13:57:37',NULL,'[]'),(20,'DUMMY',20,'2025000020',20,NULL,0.0000,0.0000,0.0000,22.0000,22.0000,'2025-01-31 08:32:13','2025-02-01 09:52:56',NULL,'[]'),(21,'DUMMY',21,'2025000021',21,NULL,0.0000,0.0000,0.0000,44.0000,44.0000,'2025-01-31 08:32:13','2025-02-01 09:52:12',NULL,'[]'),(22,'DUMMY',22,'2025000022',22,NULL,0.0000,0.0000,0.0000,86.0000,86.0000,'2025-01-31 08:32:13','2025-02-01 09:52:35',NULL,'[]'),(23,'DUMMY',23,'2025000023',23,NULL,0.0000,0.0000,0.0000,34.0000,34.0000,'2025-01-31 08:32:13','2025-01-31 10:52:33',NULL,'[]'),(24,'DUMMY',24,'2025000024',24,NULL,0.0000,0.0000,0.0000,85.0000,85.0000,'2025-01-31 08:32:13','2025-01-31 10:53:10',NULL,'[]'),(25,'DUMMY',25,'2025000025',25,NULL,0.0000,0.0000,0.0000,170.0000,170.0000,'2025-01-31 08:32:13','2025-01-31 10:51:40',NULL,'[]'),(26,'DUMMY',26,'2025000026',26,NULL,0.0000,0.0000,0.0000,26.0000,26.0000,'2025-01-31 08:32:13','2025-02-01 09:54:00',NULL,'[]'),(27,'DUMMY',27,'2025000027',27,NULL,0.0000,0.0000,0.0000,51.0000,51.0000,'2025-01-31 08:32:13','2025-02-01 09:54:25',NULL,'[]'),(28,'DUMMY',28,'2025000028',28,NULL,0.0000,0.0000,0.0000,126.0000,126.0000,'2025-01-31 08:32:13','2025-02-01 09:54:50',NULL,'[]'),(29,'DUMMY',29,'2025000029',29,NULL,0.0000,0.0000,0.0000,252.0000,252.0000,'2025-01-31 08:32:13','2025-02-01 09:53:27',NULL,'[]'),(30,'DUMMY',30,'2025000030',30,NULL,0.0000,0.0000,0.0000,17.0000,17.0000,'2025-01-31 08:32:13','2025-01-31 15:19:46',NULL,'[]'),(31,'DUMMY',31,'2025000031',31,NULL,0.0000,0.0000,0.0000,34.0000,34.0000,'2025-01-31 08:32:13','2025-01-31 15:19:29',NULL,'[]'),(32,'DUMMY',32,'2025000032',32,NULL,0.0000,0.0000,0.0000,18.0000,18.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(33,'DUMMY',33,'2025000033',33,NULL,0.0000,0.0000,0.0000,38.0000,38.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(34,'DUMMY',34,'2025000034',34,NULL,0.0000,0.0000,0.0000,75.0000,75.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(35,'DUMMY',35,'2025000035',35,NULL,0.0000,0.0000,0.0000,150.0000,150.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(36,'DUMMY',36,'2025000036',36,NULL,0.0000,0.0000,0.0000,40.0000,40.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(37,'DUMMY',37,'2025000037',37,NULL,0.0000,0.0000,0.0000,80.0000,80.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(38,'DUMMY',38,'2025000038',38,NULL,0.0000,0.0000,0.0000,160.0000,160.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(39,'DUMMY',39,'2025000039',39,NULL,0.0000,0.0000,0.0000,15.0000,15.0000,'2025-01-31 08:32:13','2025-01-31 14:57:59',NULL,'[]'),(40,'DUMMY',40,'2025000040',40,NULL,0.0000,0.0000,0.0000,27.0000,27.0000,'2025-01-31 08:32:13','2025-01-31 14:58:23',NULL,'[]'),(41,'DUMMY',41,'2025000041',41,NULL,0.0000,0.0000,0.0000,33.0000,33.0000,'2025-01-31 08:32:13','2025-01-31 14:58:50',NULL,'[]'),(42,'DUMMY',42,'2025000042',42,NULL,0.0000,0.0000,0.0000,18.0000,18.0000,'2025-01-31 08:32:13','2025-01-31 15:07:14',NULL,'[]'),(43,'DUMMY',43,'2025000043',43,NULL,0.0000,0.0000,0.0000,36.0000,36.0000,'2025-01-31 08:32:13','2025-01-31 15:07:36',NULL,'[]'),(44,'DUMMY',44,'2025000044',44,NULL,0.0000,0.0000,0.0000,44.0000,44.0000,'2025-01-31 08:32:13','2025-01-31 15:08:19',NULL,'[]'),(45,'DUMMY',45,'2025000045',45,NULL,0.0000,0.0000,0.0000,88.0000,88.0000,'2025-01-31 08:32:13','2025-01-31 15:09:12',NULL,'[]'),(46,'DUMMY',46,'2025000046',46,NULL,0.0000,0.0000,0.0000,30.0000,30.0000,'2025-01-31 08:32:13','2025-01-31 15:21:36',NULL,'[]'),(47,'DUMMY',47,'2025000047',47,NULL,0.0000,0.0000,0.0000,73.0000,73.0000,'2025-01-31 08:32:13','2025-01-31 15:22:10',NULL,'[]'),(48,'DUMMY',48,'2025000048',48,NULL,0.0000,0.0000,0.0000,7.0000,7.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(49,'DUMMY',49,'2025000049',49,NULL,0.0000,0.0000,0.0000,12.0000,12.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(50,'DUMMY',50,'2025000050',50,NULL,0.0000,0.0000,0.0000,23.0000,23.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(51,'DUMMY',51,'2025000051',51,NULL,0.0000,0.0000,0.0000,28.0000,28.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(52,'DUMMY',52,'2025000052',52,NULL,0.0000,0.0000,0.0000,54.0000,54.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(53,'DUMMY',53,'2025000053',53,NULL,0.0000,0.0000,0.0000,108.0000,108.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(54,'DUMMY',54,'2025000054',54,NULL,0.0000,0.0000,0.0000,28.0000,28.0000,'2025-01-31 08:32:13','2025-01-31 14:51:53',NULL,'[]'),(55,'DUMMY',55,'2025000055',55,NULL,0.0000,0.0000,0.0000,55.0000,55.0000,'2025-01-31 08:32:13','2025-01-31 14:52:43',NULL,'[]'),(56,'DUMMY',56,'2025000056',56,NULL,0.0000,0.0000,0.0000,110.0000,110.0000,'2025-01-31 08:32:13','2025-01-31 14:51:28',NULL,'[]'),(57,'DUMMY',57,'2025000057',57,NULL,0.0000,0.0000,0.0000,7.0000,7.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(58,'DUMMY',58,'2025000058',58,NULL,0.0000,0.0000,0.0000,12.0000,12.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(59,'DUMMY',59,'2025000059',59,NULL,0.0000,0.0000,0.0000,27.0000,27.0000,'2025-01-31 08:32:13','2025-01-31 08:32:13',NULL,'[]'),(60,'DUMMY',60,'2025000060',60,NULL,0.0000,0.0000,0.0000,65.0000,65.0000,'2025-01-31 08:32:13','2025-01-31 10:44:49',NULL,'[]'),(61,'DUMMY',61,'2025000061',61,NULL,0.0000,0.0000,0.0000,130.0000,130.0000,'2025-01-31 08:32:13','2025-01-31 10:45:15',NULL,'[]'),(62,'DUMMY',62,'2025000062',62,NULL,0.0000,0.0000,0.0000,30.0000,30.0000,'2025-01-31 08:32:13','2025-01-31 10:47:47',NULL,'[]'),(63,'DUMMY',63,'2025000063',63,NULL,0.0000,0.0000,0.0000,60.0000,60.0000,'2025-01-31 08:32:13','2025-01-31 10:48:16',NULL,'[]'),(64,'DUMMY',64,'2025000064',64,NULL,0.0000,0.0000,0.0000,120.0000,120.0000,'2025-01-31 08:32:13','2025-01-31 10:47:22',NULL,'[]'),(65,'DUMMY',65,'2025000065',65,NULL,0.0000,0.0000,0.0000,30.0000,30.0000,'2025-01-31 10:15:01','2025-01-31 10:17:37',NULL,'[]'),(66,'DUMMY',66,'2025000066',66,NULL,0.0000,0.0000,0.0000,60.0000,60.0000,'2025-01-31 10:15:53','2025-01-31 10:18:04',NULL,'[]'),(67,'DUMMY',67,'2025000067',67,NULL,0.0000,0.0000,0.0000,34.0000,34.0000,'2025-01-31 12:20:16','2025-01-31 12:20:16',NULL,'[]'),(68,'DUMMY',68,'2025000068',68,NULL,0.0000,0.0000,0.0000,67.0000,67.0000,'2025-01-31 12:21:22','2025-01-31 12:21:22',NULL,'[]'),(69,'DUMMY',69,'2025000069',69,NULL,0.0000,0.0000,0.0000,132.0000,132.0000,'2025-01-31 12:22:00','2025-01-31 12:22:00',NULL,'[]'),(70,'DUMMY',70,'2025000070',70,NULL,0.0000,0.0000,0.0000,120.0000,120.0000,'2025-01-31 13:19:44','2025-01-31 18:08:25',NULL,'[]'),(71,'DUMMY',71,'2025000071',71,NULL,0.0000,0.0000,0.0000,62.0000,62.0000,'2025-01-31 13:20:58','2025-01-31 18:09:36',NULL,'[]'),(72,'DUMMY',72,'2025000072',72,NULL,0.0000,0.0000,0.0000,32.0000,32.0000,'2025-01-31 13:23:57','2025-01-31 18:09:01',NULL,'[]'),(73,'DUMMY',73,'2025000073',73,NULL,0.0000,0.0000,0.0000,28.0000,28.0000,'2025-01-31 13:53:28','2025-01-31 13:53:28',NULL,'[]'),(74,'DUMMY',74,'2025000074',74,NULL,0.0000,0.0000,0.0000,55.0000,55.0000,'2025-01-31 13:54:22','2025-01-31 13:54:22',NULL,'[]'),(75,'DUMMY',75,'2025000075',75,NULL,0.0000,0.0000,0.0000,25.0000,25.0000,'2025-01-31 13:56:19','2025-01-31 13:56:19',NULL,'[]'),(76,'DUMMY',76,'2025000076',76,NULL,0.0000,0.0000,0.0000,50.0000,50.0000,'2025-01-31 13:56:53','2025-01-31 13:56:53',NULL,'[]'),(77,'DUMMY',77,'2025000077',77,NULL,0.0000,0.0000,0.0000,28.0000,28.0000,'2025-01-31 13:58:58','2025-01-31 13:58:58',NULL,'[]'),(78,'DUMMY',78,'2025000078',78,NULL,0.0000,0.0000,0.0000,55.0000,55.0000,'2025-01-31 13:59:27','2025-01-31 13:59:27',NULL,'[]'),(79,'DUMMY',79,'2025000079',79,NULL,0.0000,0.0000,0.0000,23.0000,23.0000,'2025-01-31 14:03:12','2025-01-31 14:03:12',NULL,'[]'),(80,'DUMMY',80,'2025000080',80,NULL,0.0000,0.0000,0.0000,45.0000,45.0000,'2025-01-31 14:03:52','2025-01-31 14:03:52',NULL,'[]'),(81,'DUMMY',81,'2025000081',81,NULL,0.0000,0.0000,0.0000,35.0000,35.0000,'2025-01-31 14:06:31','2025-01-31 14:06:31',NULL,'[]'),(82,'DUMMY',82,'2025000082',82,NULL,0.0000,0.0000,0.0000,18.0000,18.0000,'2025-01-31 14:07:21','2025-01-31 14:07:21',NULL,'[]'),(83,'DUMMY',83,'2025000083',83,NULL,25.0000,25.0000,40.0000,35.0000,35.0000,'2025-02-01 06:58:51','2025-02-01 09:46:43',NULL,'[]'),(84,'DUMMY',84,'2025000084',84,NULL,25.0000,25.0000,40.0000,35.0000,35.0000,'2025-02-01 06:59:23','2025-02-01 09:48:58',NULL,'[]'),(85,'DUMMY',85,'2025000085',85,NULL,25.0000,25.0000,40.0000,35.0000,35.0000,'2025-02-01 07:00:12','2025-02-01 09:47:50',NULL,'[]'),(86,'DUMMY',86,'2025000086',86,NULL,25.0000,25.0000,40.0000,35.0000,35.0000,'2025-02-01 07:00:36','2025-02-01 09:48:22',NULL,'[]'),(87,'DUMMY',87,'2025000087',87,NULL,25.0000,25.0000,40.0000,35.0000,35.0000,'2025-02-01 07:00:56','2025-02-01 09:47:11',NULL,'[]'),(88,'DUMMY',88,'2025000088',88,NULL,25.0000,25.0000,40.0000,35.0000,35.0000,'2025-02-01 07:01:16','2025-02-01 09:49:29',NULL,'[]'),(140,'DUMMY',140,'8906002080014',140,NULL,10.0000,11.0000,0.0000,22.0000,23.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(141,'DUMMY',141,'8906002080021',141,NULL,21.0000,22.0000,0.0000,43.0000,45.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(142,'DUMMY',142,'8906002080038',142,NULL,42.0000,44.0000,0.0000,77.0000,81.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(143,'DUMMY',143,'8906002080045',143,NULL,104.0000,109.0000,0.0000,193.0000,203.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(144,'DUMMY',144,'8906002080212',144,NULL,7.0000,8.0000,0.0000,15.0000,16.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(145,'DUMMY',145,'8906002080229',145,NULL,15.0000,16.0000,0.0000,30.0000,31.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(146,'DUMMY',146,'8906002080236',146,NULL,29.0000,31.0000,0.0000,60.0000,63.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(147,'DUMMY',147,'8906002080243',147,NULL,73.0000,77.0000,0.0000,150.0000,157.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(148,'DUMMY',148,'8906002080113',148,NULL,11.0000,12.0000,0.0000,29.0000,30.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(149,'DUMMY',149,'8906002080120',149,NULL,23.0000,25.0000,0.0000,58.0000,61.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(150,'DUMMY',150,'8906002080137',150,NULL,46.0000,49.0000,0.0000,113.0000,119.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(151,'DUMMY',151,'8906002080144',151,NULL,115.0000,121.0000,0.0000,262.0000,275.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(152,'DUMMY',152,'8906002080410',152,NULL,17.0000,18.0000,0.0000,33.0000,35.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(153,'DUMMY',153,'8906002080427',153,NULL,35.0000,36.0000,0.0000,67.0000,70.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(154,'DUMMY',154,'8906002080434',154,NULL,69.0000,72.0000,0.0000,132.0000,139.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(155,'DUMMY',155,'8906002080441',155,NULL,171.0000,180.0000,0.0000,304.0000,319.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(156,'DUMMY',156,'8906002080311',156,NULL,14.0000,15.0000,0.0000,28.0000,29.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(157,'DUMMY',157,'8906002080328',157,NULL,29.0000,31.0000,0.0000,56.0000,59.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(158,'DUMMY',158,'8906002080335',158,NULL,58.0000,61.0000,0.0000,110.0000,116.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(159,'DUMMY',159,'8906002080342',159,NULL,146.0000,153.0000,0.0000,275.0000,289.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(160,'DUMMY',160,'8906002080618',160,NULL,21.0000,23.0000,0.0000,40.0000,42.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(161,'DUMMY',161,'8906002080625',161,NULL,43.0000,45.0000,0.0000,80.0000,84.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(162,'DUMMY',162,'8906002081516',162,NULL,13.0000,13.0000,0.0000,25.0000,26.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(163,'DUMMY',163,'8906002081523',163,NULL,26.0000,27.0000,0.0000,50.0000,52.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(164,'DUMMY',164,'8906002081561',164,NULL,52.0000,54.0000,0.0000,90.0000,94.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(165,'DUMMY',165,'8906002081585',165,NULL,129.0000,136.0000,0.0000,224.0000,235.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(166,'DUMMY',166,'8906002081417',166,NULL,18.0000,19.0000,0.0000,33.0000,35.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(167,'DUMMY',167,'8906002081424',167,NULL,35.0000,37.0000,0.0000,66.0000,69.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(168,'DUMMY',168,'8906002081486',168,NULL,71.0000,74.0000,0.0000,120.0000,126.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(169,'DUMMY',169,'8906002081462',169,NULL,176.0000,185.0000,0.0000,300.0000,315.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(170,'DUMMY',170,'8906002082117',170,NULL,42.0000,45.0000,0.0000,76.0000,80.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(171,'DUMMY',171,'8906002081813',171,NULL,20.0000,21.0000,0.0000,38.0000,40.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(172,'DUMMY',172,'8906002080519',172,NULL,11.0000,12.0000,0.0000,20.0000,21.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(173,'DUMMY',173,'8906002081776',173,NULL,15.0000,16.0000,0.0000,29.0000,30.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(174,'DUMMY',174,'8906002081714',174,NULL,18.0000,19.0000,0.0000,35.0000,37.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(175,'DUMMY',175,'8906002082018',175,NULL,20.0000,21.0000,0.0000,36.0000,38.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(176,'DUMMY',176,'8906002082711',176,NULL,16.0000,17.0000,0.0000,29.0000,30.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(177,'DUMMY',177,'8906002080816',177,NULL,21.0000,22.0000,0.0000,42.0000,44.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(178,'DUMMY',178,'8906002080915',178,NULL,23.0000,25.0000,0.0000,43.0000,45.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(179,'DUMMY',179,'8906002081011',179,NULL,14.0000,15.0000,0.0000,26.0000,27.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(180,'DUMMY',180,'8906002082612',180,NULL,11.0000,11.0000,0.0000,20.0000,21.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(181,'DUMMY',181,'8906002081912',181,NULL,20.0000,21.0000,0.0000,39.0000,41.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(182,'DUMMY',182,'8906002083725',182,NULL,33.0000,34.0000,0.0000,67.0000,70.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(183,'DUMMY',183,'8906002081318',183,NULL,16.0000,17.0000,0.0000,30.0000,31.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(184,'DUMMY',184,'8906002081615',184,NULL,23.0000,24.0000,0.0000,42.0000,44.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(185,'DUMMY',185,'8906002081684',185,NULL,91.0000,96.0000,0.0000,150.0000,158.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(186,'DUMMY',186,'8906002082216',186,NULL,21.0000,22.0000,0.0000,48.0000,50.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(187,'DUMMY',187,'8906002082506',187,NULL,30.0000,32.0000,0.0000,47.0000,49.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(188,'DUMMY',188,'8906002082445',188,NULL,23.0000,27.0000,0.0000,36.0000,42.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(189,'DUMMY',189,'8906002082452',189,NULL,56.0000,66.0000,0.0000,88.0000,104.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(190,'DUMMY',190,'8906002082957',190,NULL,18.0000,19.0000,0.0000,34.0000,36.0000,'2025-02-01 11:01:15','2025-02-01 11:01:15',NULL,'[]'),(191,'DUMMY',191,'8902979002035',191,NULL,1.0000,1.0000,0.0000,1.0000,1.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(192,'DUMMY',192,'8902979025836',192,NULL,1.0000,1.0000,0.0000,1.0000,1.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(193,'DUMMY',193,'8902979002080',193,NULL,1.0000,1.0000,0.0000,1.0000,1.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(194,'DUMMY',194,'8902979000444',194,NULL,2.0000,2.0000,0.0000,2.0000,2.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(195,'DUMMY',195,'8902979032865',195,NULL,1.0000,1.0000,0.0000,1.0000,1.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(196,'DUMMY',196,'8902979000826',196,NULL,1.0000,1.0000,0.0000,1.0000,1.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(197,'DUMMY',197,'8902979027069',197,NULL,1.0000,1.0000,0.0000,1.0000,1.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(198,'DUMMY',198,'8902979023146',198,NULL,3.0000,4.0000,0.0000,3.0000,4.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(199,'DUMMY',199,'8902979022682',199,NULL,1.0000,2.0000,0.0000,2.0000,2.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(200,'DUMMY',200,'8902979029025',200,NULL,1.0000,2.0000,0.0000,2.0000,2.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(201,'DUMMY',201,'8902979002059',201,NULL,46.0000,54.0000,0.0000,53.0000,62.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(202,'DUMMY',202,'8902979002066',202,NULL,85.0000,100.0000,0.0000,97.0000,115.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(203,'DUMMY',203,'8902979000833',203,NULL,38.0000,45.0000,0.0000,44.0000,52.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(204,'DUMMY',204,'8902979026727',204,NULL,85.0000,100.0000,0.0000,97.0000,115.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(205,'DUMMY',205,'2025000205',205,NULL,53.0000,63.0000,0.0000,61.0000,72.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(206,'DUMMY',206,'8902979029032',206,NULL,58.0000,69.0000,0.0000,67.0000,79.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(207,'DUMMY',207,'8902979022798',207,NULL,133.0000,157.0000,0.0000,153.0000,180.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(208,'DUMMY',208,'8902979029049',208,NULL,152.0000,179.0000,0.0000,174.0000,205.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(209,'DUMMY',209,'8902979026703',209,NULL,8.0000,9.0000,0.0000,9.0000,10.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(210,'DUMMY',210,'8902979026710',210,NULL,50.0000,56.0000,0.0000,58.0000,65.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(211,'DUMMY',211,'8902979023177',211,NULL,90.0000,106.0000,0.0000,102.0000,120.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(212,'DUMMY',212,'8902979023153',212,NULL,29.0000,35.0000,0.0000,33.0000,39.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(213,'DUMMY',213,'8902979023160',213,NULL,60.0000,71.0000,0.0000,68.0000,80.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(214,'DUMMY',214,'8902979053877',214,NULL,38.0000,45.0000,0.0000,44.0000,52.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(215,'DUMMY',215,'8902979053884',215,NULL,38.0000,45.0000,0.0000,44.0000,52.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(216,'DUMMY',216,'8902979053938',216,NULL,92.0000,109.0000,0.0000,106.0000,125.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(217,'DUMMY',217,'8902979053945',217,NULL,85.0000,100.0000,0.0000,97.0000,115.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(218,'DUMMY',218,'8902979026871',218,NULL,48.0000,57.0000,0.0000,55.0000,65.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(219,'DUMMY',219,'8902979026888',219,NULL,87.0000,103.0000,0.0000,102.0000,120.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(220,'DUMMY',220,'8902979005906',220,NULL,52.0000,62.0000,0.0000,61.0000,72.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(221,'DUMMY',221,'8902979005937',221,NULL,94.0000,111.0000,0.0000,110.0000,130.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(222,'DUMMY',222,'8902979020022',222,NULL,41.0000,48.0000,0.0000,47.0000,55.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(223,'DUMMY',223,'8902979020060',223,NULL,41.0000,48.0000,0.0000,47.0000,55.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(224,'DUMMY',224,'8902979020039',224,NULL,78.0000,92.0000,0.0000,89.0000,105.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(225,'DUMMY',225,'8902979020077',225,NULL,78.0000,92.0000,0.0000,89.0000,105.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(226,'DUMMY',226,'8902979001953',226,NULL,15.0000,18.0000,0.0000,18.0000,21.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(227,'DUMMY',227,'8902979011136',227,NULL,11.0000,13.0000,0.0000,13.0000,15.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(228,'DUMMY',228,'8902979027137',228,NULL,21.0000,25.0000,0.0000,25.0000,30.0000,'2025-02-01 11:15:56','2025-02-01 11:15:56',NULL,'[]'),(229,'DUMMY',229,'2025000229',229,NULL,0.0000,0.0000,0.0000,24.0000,24.0000,'2025-02-01 12:36:21','2025-02-01 12:36:21',NULL,'[]'),(230,'DUMMY',230,'2025000230',230,NULL,0.0000,0.0000,0.0000,45.0000,45.0000,'2025-02-01 12:37:28','2025-02-01 12:37:28',NULL,'[]');
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warranties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `duration` int(11) NOT NULL,
  `duration_type` enum('days','months','years') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warranties_business_id_index` (`business_id`),
  KEY `warranties_duration_type_index` (`duration_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warranties` WRITE;
/*!40000 ALTER TABLE `warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `warranties` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

