@if(!session('business.enable_price_tax')) 
  @php
    $default = 0;
    $class = 'hide';
  @endphp
@else
  @php
    $default = null;
    $class = '';
  @endphp
@endif

<div class="table-responsive">
    <table class="table table-bordered add-product-price-table table-condensed {{$class}}">
        <tr>
          <th>@lang('product.default_purchase_price')</th>
          <th>@lang('product.profit_percent') @show_tooltip(__('tooltip.profit_percent'))</th>
          <th>@lang('product.default_selling_price') (MRP)</th>
          <th>Discount</th>
          <th>Final Sell Price</th>
          @if(empty($quick_add))
            <th hidden>@lang('lang_v1.product_image')</th>
          @endif
        </tr>
        <tr>
          <td>
            <div class="col-sm-6">
              {!! Form::label('single_dpp', trans('product.exc_of_tax') . ':*') !!}
<?php if($default==''){$default=0;} ?>
              {!! Form::text('single_dpp', $default, ['class' => 'form-control input-sm dpp input_number','id' => 'single_dpp', 'placeholder' => __('product.exc_of_tax'), 'required']); !!}
            </div>

            <div class="col-sm-6">
              {!! Form::label('single_dpp_inc_tax', trans('product.inc_of_tax') . ':*') !!}
            
              {!! Form::text('single_dpp_inc_tax', $default, ['class' => 'form-control input-sm dpp_inc_tax input_number','id' => 'single_dpp_inc_tax', 'placeholder' => __('product.inc_of_tax'), 'required']); !!}
            </div>
          </td>

          <td>
            <br/>
            {!! Form::text('profit_percent', @num_format($profit_percent), ['class' => 'form-control input-sm input_number', 'id' => 'profit_percent', 'required']); !!}
          </td>

          <td>
            <label><span class="dsp_labels"><!--@lang('product.exc_of_tax')--></span></label>
            {!! Form::text('single_dsp', $default, ['class' => 'form-control input-sm dsp input_number', 'placeholder' => __('product.exc_of_tax'), 'id' => 'single_dsp', 'required']); !!}

            {!! Form::text('single_dsp_inc_tax', $default, ['class' => 'form-control input-sm hide input_number', 'placeholder' => __('product.inc_of_tax'), 'id' => 'single_dsp_inc_tax', 'required']); !!}
          </td>
          <td>
            <select class="form-control input-sm" name="weight" id="weight">
                <?php 
                    $s=!empty($duplicate_product->weight) ? $duplicate_product->weight : '';
                ?>
                <option value="fixed" <?php if($s=="fixed"){ echo "selected";} ?>>Fixed</option><option <?php if($s=="percentage"){ echo "selected";} ?> value="percentage">Percentage</option>
            </select>
          {!! Form::number('product_custom_field1', !empty($duplicate_product->product_custom_field1) ? $duplicate_product->product_custom_field1 : null, ['class' => 'form-control input-sm', 'placeholder' => $product_custom_field1]); !!}
          </td>
          <td>
              <input class="form-control input-sm input_number valid" placeholder="Sell Net Rate" id="sell_net_rate" required="" name="sell_net_rate" type="text" value="0" >
          </td>
          
          @if(empty($quick_add))
          <td hidden>
              <div class="form-group">
                {!! Form::label('variation_images', __('lang_v1.product_image') . ':') !!}
                {!! Form::file('variation_images[]', ['class' => 'variation_images', 'accept' => 'image/*', 'multiple']); !!}
                <small><p class="help-block">@lang('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)]) <br> @lang('lang_v1.aspect_ratio_should_be_1_1')</p></small>
              </div>
          </td>
          @endif
        </tr>
    </table>
</div>